/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.dsls;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.dsls.Activator;
import org.eclipse.m2m.atl.dsls.Messages;
import org.eclipse.m2m.atl.dsls.Resource;
import org.eclipse.m2m.atl.dsls.textsource.TextSource;
import org.eclipse.m2m.atl.dsls.textsource.URLTextSource;
import org.osgi.framework.Bundle;

public class DSLResourceProvider {
    private static DSLResourceProvider instance;
    private static String resourcesRoot;
    private static Map resourcesById;

    static {
        resourcesRoot = "resources/";
        resourcesById = new HashMap();
    }

    public static DSLResourceProvider getDefault() {
        if (instance == null) {
            instance = new DSLResourceProvider();
            instance.initResources();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry == null) {
                ATLLogger.log((Level)Level.SEVERE, (String)Messages.getString("DSLResourceProvider.EXTENSIONREGISTRYNOTFOUND"), null);
                return null;
            }
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.dsls.dslresourceprovider");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            block2: while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        DSLResourceProvider resourceProvider = (DSLResourceProvider)elements[j].createExecutableExtension("class");
                        resourceProvider.initResources();
                        break block2;
                    }
                    catch (CoreException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return instance;
    }

    public Resource getResource(String id) {
        return (Resource)resourcesById.get(id);
    }

    private void initResources() {
        try {
            String line;
            BufferedReader in = new URLTextSource(this.getURL("contents.list")).openBufferedReader();
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                final URL url = this.getURL(line);
                resourcesById.put(line.intern(), new Resource(){

                    public TextSource asTextSource() {
                        return new URLTextSource(url);
                    }

                    public URL asURL() {
                        return url;
                    }

                    public URI asEMFURI() {
                        try {
                            return URI.createURI((String)FileLocator.resolve((URL)url).toString());
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)Messages.getString("DSLResourceProvider.LOADINGERROR"), (Throwable)e);
        }
    }

    private URL getURL(String path) {
        Bundle bundle = this.getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(resourcesRoot) + path), (Map)Collections.EMPTY_MAP);
        if (url != null) {
            return url;
        }
        ATLLogger.log((Level)Level.SEVERE, (String)Messages.getString("DSLResourceProvider.COULDNOTLOAD", new Object[]{path}), null);
        return null;
    }

    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected String getPluginId() {
        return "org.eclipse.m2m.atl.dsls";
    }
}

