/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.uml2.diagram.sequence.figures.LifelineBracketContainerShape;

public class CrossFigure
extends Shape {
    private final IFigure myExecutionFigure;
    private final Locator myLocator;
    private static final int OFFSET = 3;

    CrossFigure(LifelineBracketContainerShape execution) {
        this.myLocator = new CrossLocator(execution);
        this.myExecutionFigure = execution;
        this.setLineWidth(4);
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
        graphics.drawLine(this.getBounds().getTopLeft().translate(3, 3), this.getBounds().getBottomRight().translate(-3, -3));
        graphics.drawLine(this.getBounds().getBottomLeft().translate(3, -3), this.getBounds().getTopRight().translate(-3, 3));
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.myLocator.relocate((IFigure)this);
        super.validate();
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        if (search.prune(this.myExecutionFigure)) {
            return null;
        }
        if (!search.accept(this.myExecutionFigure)) {
            return null;
        }
        return this.myExecutionFigure;
    }

    private static class CrossLocator
    implements Locator {
        private final LifelineBracketContainerShape myExecution;

        CrossLocator(LifelineBracketContainerShape bracketContainerShape) {
            this.myExecution = bracketContainerShape;
        }

        public void relocate(IFigure cross) {
            Point center = this.myExecution.getPaintableArea().getBottom();
            Rectangle newBounds = new Rectangle(center.x, center.y, 0, 0);
            newBounds.expand(10, 10);
            cross.setBounds(newBounds);
            LayoutManager layoutManager = cross.getParent().getLayoutManager();
            if (layoutManager instanceof XYLayout) {
                Point origin = ((XYLayout)layoutManager).getOrigin(cross.getParent());
                ((XYLayout)layoutManager).setConstraint(cross, (Object)newBounds.getTranslated(origin.getNegated()));
            } else assert (false) : "Parent figure is expected to be ChildrenContainerFigure with AbsoluteXYLayout layout";
        }
    }
}

