/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.uml2.diagram.sequence.draw2d.LifeLineTailShape;

public class LifeLineLayout
extends AbstractLayout {
    private IFigure myHead;
    private LifeLineTailShape myTail;
    private int myCenterRelativePos;
    private int myHeadHalfWidth;

    public int getHeadPreferredWidth() {
        return this.myHead.getPreferredSize().width;
    }

    public int getHeadPreferredHeight() {
        return this.myHead.getPreferredSize().height;
    }

    public int getHeadTopPos() {
        return this.myHead.getBounds().y;
    }

    public void setHorizontalPositions(int centerRelativePos, int headHalfWidth) {
        this.myCenterRelativePos = centerRelativePos;
        this.myHeadHalfWidth = headHalfWidth;
        this.myHead.revalidate();
        this.myTail.setLineRelativeX(centerRelativePos);
        this.myTail.revalidate();
    }

    public int getCenterRelativePos() {
        return this.myCenterRelativePos;
    }

    public int getHeadHalfWidth() {
        return this.myHeadHalfWidth;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int minWHint = 0;
        int minHHint = 0;
        if (wHint < 0) {
            minWHint = -1;
        }
        if (hHint < 0) {
            minHHint = -1;
        }
        Insets border = container.getInsets();
        wHint = Math.max(minWHint, wHint - border.getWidth());
        hHint = Math.max(minHHint, hHint - border.getHeight());
        Dimension prefSize = new Dimension();
        Dimension headSize = this.myHead.getPreferredSize(wHint, hHint);
        hHint = Math.max(minHHint, hHint - headSize.height);
        prefSize.setSize(headSize);
        Dimension tailSize = this.myTail.getPreferredSize(wHint, hHint);
        prefSize.height += tailSize.height;
        prefSize.width = Math.max(prefSize.width, tailSize.width);
        return prefSize.expand(border.getWidth(), border.getHeight());
    }

    public void layout(IFigure container) {
        Rectangle area = container.getClientArea();
        Rectangle headBounds = new Rectangle(area);
        headBounds.translate(this.myCenterRelativePos - this.myHeadHalfWidth, 0);
        headBounds.width = 2 * this.myHeadHalfWidth;
        Dimension headPreferredSize = this.myHead.getPreferredSize(headBounds.width, -1);
        headBounds.height = headPreferredSize.height;
        this.myHead.setBounds(headBounds);
        area.y += headBounds.height;
        area.height -= headBounds.height;
        this.myTail.setBounds(area);
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (child instanceof LifeLineTailShape) {
            this.myTail = (LifeLineTailShape)child;
        } else if (this.myHead == null) {
            this.myHead = child;
        } else {
            throw new IllegalArgumentException();
        }
        super.setConstraint(child, constraint);
    }
}

