/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;

public class InterfaceRealizationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public InterfaceRealizationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof InterfaceRealization)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof BehavioredClassifier) || !(this.newEnd instanceof BehavioredClassifier)) {
            return false;
        }
        Interface target = this.getLink().getContract();
        if (!(this.getLink().eContainer() instanceof BehavioredClassifier)) {
            return false;
        }
        BehavioredClassifier container = (BehavioredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistInterfaceRealization_4001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        BehavioredClassifier source = this.getLink().getImplementingClassifier();
        if (!(this.getLink().eContainer() instanceof BehavioredClassifier)) {
            return false;
        }
        BehavioredClassifier container = (BehavioredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistInterfaceRealization_4001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setImplementingClassifier(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setContract(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected InterfaceRealization getLink() {
        return (InterfaceRealization)this.getElementToEdit();
    }

    protected BehavioredClassifier getOldSource() {
        return (BehavioredClassifier)this.oldEnd;
    }

    protected BehavioredClassifier getNewSource() {
        return (BehavioredClassifier)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }
}

