/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.UtilitiesPackage;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
implements Visitor<Boolean, C, O, P, EL, PM, S, COA, SSA, CT> {
    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = null;
    private UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = null;

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Visitor<Boolean, C, O, P, EL, PM, S, COA, SSA, CT> getInstance(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment) {
        if (environment == null) {
            throw new NullPointerException();
        }
        return new ValidationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(environment);
    }

    protected ValidationVisitor(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment) {
        this.env = environment;
        this.uml = environment.getUMLReflection();
    }

    protected Boolean validatorError(Object problemObject, String problemMessage, String problemContext) {
        OCLUtil.getAdapter(this.env, BasicEnvironment.class).validatorError(problemMessage, problemContext, problemObject);
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOperationCallExp(OperationCallExp<C, O> oc) {
        C resultType;
        String message;
        OCLExpression source = oc.getSource();
        O oper = oc.getReferredOperation();
        int opcode = oc.getOperationCode();
        EList<OCLExpression<C>> args = oc.getArgument();
        if (oper == null) {
            String message2 = OCLMessages.bind(OCLMessages.NullOperation_ERROR_, oc.toString());
            return this.validatorError(oc, message2, "visitOperationCallExp");
        }
        if (source == null) {
            String message3 = OCLMessages.bind(OCLMessages.NullSourceOperation_ERROR_, oc.toString());
            return this.validatorError(oc, message3, "visitOperationCallExp");
        }
        Object sourceType = source.getType();
        String operName = this.getName(oper);
        for (OCLExpression expr : args) {
            expr.accept(this);
        }
        if (this.visitFeatureCallExp(oc).booleanValue()) {
            return Boolean.TRUE;
        }
        if (opcode == 71 && !this.env.isInPostcondition(oc)) {
            return this.validatorError(oc, OCLMessages.OCLIsNewInPostcondition_ERROR_, "visitOperationCallExp");
        }
        source.accept(this);
        O oper1 = this.env.lookupOperation(sourceType, operName, args);
        if (oper1 != oper) {
            message = OCLMessages.bind(OCLMessages.IllegalOperation_ERROR_, oc.toString());
            return this.validatorError(oc, message, "visitOperationCallExp");
        }
        if (!this.uml.isQuery(oper)) {
            message = OCLMessages.bind(OCLMessages.NonQueryOperation_ERROR_, this.getName(oper));
            return this.validatorError(oc, message, "visitOperationCallExp");
        }
        if (TypeUtil.isStandardLibraryFeature(this.env, sourceType, oper)) {
            if (opcode != OCLStandardLibraryUtil.getOperationCode(operName)) {
                String message4 = OCLMessages.bind(OCLMessages.IllegalOpcode_ERROR_, operName);
                return this.validatorError(oc, message4, "visitOperationCallExp");
            }
            resultType = TypeUtil.getResultType(oc, this.env, sourceType, oper, args);
            if (resultType == null) {
                resultType = this.getOCLType(oper);
            }
        } else if (TypeUtil.isOclAnyOperation(this.env, oper)) {
            if (opcode != OCLStandardLibraryUtil.getOclAnyOperationCode(operName)) {
                String message5 = OCLMessages.bind(OCLMessages.IllegalOpcode_ERROR_, operName);
                return this.validatorError(oc, message5, "visitOperationCallExp");
            }
            resultType = TypeUtil.getResultType(oc, this.env, sourceType, oper, args);
            if (resultType == null) {
                resultType = this.getOCLType(oper);
            }
        } else {
            resultType = TypeUtil.getResultType(oc, this.env, sourceType, oper, args);
        }
        if (!TypeUtil.exactTypeMatch(this.env, resultType, oc.getType())) {
            String message6 = OCLMessages.bind(OCLMessages.TypeConformanceOperation_ERROR_, oc.getType().toString());
            return this.validatorError(oc, message6, "visitOperationCallExp");
        }
        if (opcode == 28 || opcode == 29) {
            ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
            BasicEnvironment benv = OCLUtil.getAdapter(this.env, BasicEnvironment.class);
            if (benv != null) {
                sev = benv.getValue(ProblemOption.STRING_CASE_CONVERSION);
            }
            if (sev != null && sev != ProblemHandler.Severity.OK) {
                benv.problem(sev, ProblemHandler.Phase.VALIDATOR, OCLMessages.bind(OCLMessages.NonStd_Operation_, opcode == 28 ? "String::toLower()" : "String::toUpper()"), "operationCallExp", oc);
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitEnumLiteralExp(EnumLiteralExp<C, EL> el) {
        EL l = el.getReferredEnumLiteral();
        Object type = el.getType();
        if (!this.uml.isEnumeration(type) || this.uml.getEnumeration(l) != type) {
            String message = OCLMessages.bind(OCLMessages.IllegalEnumLiteral_ERROR_, el.toString());
            return this.validatorError(el, message, "visitEnumLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitVariableExp(VariableExp<C, PM> v) {
        Variable<C, PM> vd = v.getReferredVariable();
        if (vd == null || v.getType() == null || vd.getName() == null || vd.getType() == null) {
            String message = OCLMessages.bind(OCLMessages.IncompleteVariableExp_ERROR_, v.toString());
            return this.validatorError(v, message, "visitVariableExp");
        }
        vd.accept(this);
        if (!TypeUtil.exactTypeMatch(this.env, vd.getType(), v.getType())) {
            String message = OCLMessages.bind(OCLMessages.VariableTypeMismatch_ERROR_, vd.getName());
            return this.validatorError(v, message, "visitVariableExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitPropertyCallExp(PropertyCallExp<C, P> pc) {
        P property = pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        Object type = pc.getType();
        if (property == null) {
            String message = OCLMessages.bind(OCLMessages.NullProperty_ERROR_, pc.toString());
            return this.validatorError(pc, message, "visitPropertyCallExp");
        }
        if (source == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationSource_ERROR_, pc.toString());
            return this.validatorError(pc, message, "visitPropertyCallExp");
        }
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationType_ERROR_, pc.toString());
            return this.validatorError(pc, message, "visitPropertyCallExp");
        }
        EList qualifiers = pc.getQualifier();
        if (!qualifiers.isEmpty()) {
            List<P> expectedQualifierTypes = this.uml.getQualifiers(property);
            if (expectedQualifierTypes.size() != qualifiers.size()) {
                String message = OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, pc.toString());
                return this.validatorError(pc, message, "visitPropertyCallExp");
            }
            Iterator<P> eiter = expectedQualifierTypes.iterator();
            Iterator qiter = qualifiers.iterator();
            while (eiter.hasNext()) {
                C expectedType = this.getOCLType(eiter.next());
                OCLExpression qualifier = (OCLExpression)qiter.next();
                Object qualifierType = qualifier.getType();
                if ((TypeUtil.getRelationship(this.env, qualifierType, expectedType) & 3) != 0) continue;
                String message = OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, pc.toString());
                return this.validatorError(pc, message, "visitPropertyCallExp");
            }
        }
        if (this.visitFeatureCallExp(pc).booleanValue()) {
            return Boolean.TRUE;
        }
        source.accept(this);
        C refType = TypeUtil.getPropertyType(this.env, source.getType(), property);
        if (!pc.getQualifier().isEmpty() && refType instanceof CollectionType) {
            CollectionType ct = (CollectionType)refType;
            refType = ct.getElementType();
        }
        return TypeUtil.exactTypeMatch(this.env, refType, type);
    }

    @Override
    public Boolean visitAssociationClassCallExp(AssociationClassCallExp<C, P> ae) {
        Object end;
        C ref = ae.getReferredAssociationClass();
        OCLExpression source = ae.getSource();
        Object type = ae.getType();
        if (ref == null) {
            String message = OCLMessages.bind(OCLMessages.MissingAssociationClass_ERROR_, ae.toString());
            return this.validatorError(ae, message, "visitAssociationClassCallExp");
        }
        if (source == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationSource_ERROR_, ae.toString());
            return this.validatorError(ae, message, "visitAssociationClassCallExp");
        }
        Object sourceType = source.getType();
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationType_ERROR_, ae.toString());
            return this.validatorError(ae, message, "visitAssociationClassCallExp");
        }
        if (type instanceof CollectionType) {
            Object elementType = ((CollectionType)type).getElementType();
            type = elementType;
        }
        if (ae.getNavigationSource() != null && (ref != this.uml.getAssociationClass(end = ae.getNavigationSource()) || end != this.env.lookupProperty(sourceType, this.getName(end)))) {
            String message = OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, ae.toString());
            return this.validatorError(ae, message, "visitAssociationClassCallExp");
        }
        if (this.visitFeatureCallExp(ae).booleanValue()) {
            return Boolean.TRUE;
        }
        source.accept(this);
        return TypeUtil.exactTypeMatch(this.env, ref, type);
    }

    @Override
    public Boolean visitVariable(Variable<C, PM> vd) {
        String varName = vd.getName();
        if (varName == null) {
            return this.validatorError(vd, OCLMessages.MissingNameInVariableDeclaration_ERROR_, "visitVariableDeclaration");
        }
        Object type = vd.getType();
        OCLExpression<C> init = vd.getInitExpression();
        if (init != null) {
            init.accept(this);
            if (!TypeUtil.compatibleTypeMatch(this.env, init.getType(), type)) {
                String message = OCLMessages.bind(OCLMessages.TypeConformanceInit_ERROR_, varName);
                return this.validatorError(vd, message, "visitVariableDeclaration");
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIfExp(IfExp<C> i) {
        OCLExpression<C> cond = i.getCondition();
        OCLExpression<C> thenexp = i.getThenExpression();
        OCLExpression<C> elseexp = i.getElseExpression();
        if (cond == null || thenexp == null || elseexp == null) {
            String message = OCLMessages.bind(OCLMessages.IncompleteIfExp_ERROR_, i.toString());
            return this.validatorError(i, message, "visitIfExp");
        }
        cond.accept(this);
        thenexp.accept(this);
        elseexp.accept(this);
        if (cond.getType() != this.getStandardLibrary().getBoolean()) {
            String message = OCLMessages.bind(OCLMessages.NonBooleanIfExp_ERROR_, cond.toString());
            return this.validatorError(i, message, "visitIfExp");
        }
        C thenelsetype = TypeUtil.commonSuperType(null, this.env, thenexp.getType(), elseexp.getType());
        if (thenelsetype == null) {
            return Boolean.TRUE;
        }
        if (!TypeUtil.exactTypeMatch(this.env, i.getType(), thenelsetype)) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIfExp_ERROR_, i.toString());
            return this.validatorError(i, message, "visitIfExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitMessageExp(MessageExp<C, COA, SSA> m) {
        List<Object> parameters;
        if (m.getTarget() == null) {
            String message = OCLMessages.bind(OCLMessages.MissingMessageTarget_ERROR_, m.toString());
            return this.validatorError(m, message, "visitMessageExp");
        }
        m.getTarget().accept(this);
        if (m.getCalledOperation() == null && m.getSentSignal() == null) {
            String message = OCLMessages.UnrecognizedMessageType_ERROR_;
            return this.validatorError(m, message, "visitMessageExp");
        }
        if (m.getCalledOperation() != null && m.getSentSignal() != null) {
            String message = OCLMessages.AmbiguousMessageType_ERROR_;
            return this.validatorError(m, message, "visitMessageExp");
        }
        if (m.getCalledOperation() != null) {
            O operation = this.uml.getOperation(m.getCalledOperation());
            if (operation == null) {
                String message = OCLMessages.bind(OCLMessages.MissingOperationInCallAction_ERROR_, m.toString());
                return this.validatorError(m, message, "visitMessageExp");
            }
            parameters = this.uml.getParameters(operation);
        } else {
            C signal = this.uml.getSignal(m.getSentSignal());
            if (signal == null) {
                String message = OCLMessages.bind(OCLMessages.MissingSignalInCallAction_ERROR_, m.toString());
                return this.validatorError(m, message, "visitMessageExp");
            }
            parameters = this.uml.getAttributes(signal);
        }
        EList<OCLExpression<C>> arguments = m.getArgument();
        if (arguments.size() != parameters.size()) {
            String message = OCLMessages.bind(OCLMessages.MessageArgumentCount_ERROR_, this.getName(m.getType()));
            return this.validatorError(m, message, "visitMessageExp");
        }
        Iterator<Object> paramsIter = parameters.iterator();
        Iterator argsIter = arguments.iterator();
        while (paramsIter.hasNext()) {
            Object param = paramsIter.next();
            OCLExpression arg = (OCLExpression)argsIter.next();
            if (!TypeUtil.compatibleTypeMatch(this.env, arg.getType(), this.getOCLType(param))) {
                String message = OCLMessages.bind(OCLMessages.MessageArgConformance_ERROR_, this.getName(param), arg.toString());
                return this.validatorError(m, message, "visitMessageExp");
            }
            arg.accept(this);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitUnspecifiedValueExp(UnspecifiedValueExp<C> uv) {
        if (!(uv.eContainer() instanceof MessageExp)) {
            String message = OCLMessages.bind(OCLMessages.IllegalUnspecifiedValueExp_ERROR_, uv.toString());
            return this.validatorError(uv, message, "visitUnspecifiedValueExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitTypeExp(TypeExp<C> t) {
        if (!(t.getType() instanceof TypeType)) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceTypeExp_ERROR_, this.getName(t.getType()));
            return this.validatorError(t, message, "visitTypeExp");
        }
        if (t.getReferredType() == null) {
            String message = OCLMessages.bind(OCLMessages.TypeExpMissingType_ERROR_, t.toString());
            return this.validatorError(t, message, "visitTypeExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIntegerLiteralExp(IntegerLiteralExp<C> il) {
        if (il.getType() != this.getStandardLibrary().getInteger()) {
            String message = OCLMessages.TypeConformanceIntegerLiteral_ERROR_;
            return this.validatorError(il, message, "visitIntegerLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> unl) {
        if (unl.getType() != this.getStandardLibrary().getUnlimitedNatural()) {
            String message = OCLMessages.TypeConformanceUnlimitedNaturalLiteral_ERROR_;
            return this.validatorError(unl, message, "visitUnlimitedNaturalLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitRealLiteralExp(RealLiteralExp<C> rl) {
        if (rl.getType() != this.getStandardLibrary().getReal()) {
            String message = OCLMessages.TypeConformanceRealLiteral_ERROR_;
            return this.validatorError(rl, message, "visitRealLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitStringLiteralExp(StringLiteralExp<C> sl) {
        if (sl.getType() != this.getStandardLibrary().getString()) {
            String message = OCLMessages.TypeConformanceStringLiteral_ERROR_;
            return this.validatorError(sl, message, "visitStringLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitBooleanLiteralExp(BooleanLiteralExp<C> bl) {
        if (bl.getType() != this.getStandardLibrary().getBoolean()) {
            String message = OCLMessages.TypeConformanceBooleanLiteral_ERROR_;
            return this.validatorError(bl, message, "visitBooleanLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitLetExp(LetExp<C, PM> l) {
        Variable<C, PM> vd = l.getVariable();
        OCLExpression<C> in = l.getIn();
        Object type = l.getType();
        if (vd == null || in == null || type == null) {
            String message = OCLMessages.bind(OCLMessages.IncompleteLetExp_ERROR_, l.toString());
            return this.validatorError(l, message, "visitLetExp");
        }
        vd.accept(this);
        in.accept(this);
        if (!TypeUtil.exactTypeMatch(this.env, type, in.getType())) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceLetExp_ERROR_, type, in.getType());
            return this.validatorError(l, message, "visitLetExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIterateExp(IterateExp<C, PM> ie) {
        Variable<C, PM> vd = ie.getResult();
        Object type = ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        EList iterators = ie.getIterator();
        if (vd == null || type == null || source == null || body == null || iterators.isEmpty()) {
            String message = OCLMessages.bind(OCLMessages.IncompleteIterateExp_ERROR_, ie.toString());
            return this.validatorError(ie, message, "visitIterateExp");
        }
        source.accept(this);
        vd.accept(this);
        body.accept(this);
        if (vd.getInitExpression() == null) {
            String message = OCLMessages.bind(OCLMessages.MissingInitIterateExp_ERROR_, ie.toString());
            return this.validatorError(ie, message, "visitIterateExp");
        }
        if (!TypeUtil.exactTypeMatch(this.env, type, vd.getType())) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExp_ERROR_, ie.toString());
            return this.validatorError(ie, message, "visitIterateExp");
        }
        if (!TypeUtil.compatibleTypeMatch(this.env, body.getType(), vd.getType())) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExpBody_ERROR_, ie.toString());
            return this.validatorError(ie, message, "visitIterateExp");
        }
        Object sourceType = source.getType();
        if (!(sourceType instanceof CollectionType)) {
            String message = OCLMessages.bind(OCLMessages.IteratorSource_ERROR_, ie.toString());
            return this.validatorError(ie, message, "visitIterateExp");
        }
        if (iterators.size() > 1) {
            String message = OCLMessages.bind(OCLMessages.TooManyIteratorVariables_ERROR_, ie.getName());
            return this.validatorError(ie, message, "visitIteratorExp");
        }
        for (Variable loopiter : iterators) {
            loopiter.accept(this);
            if (loopiter.getInitExpression() != null) {
                String message = OCLMessages.bind(OCLMessages.IterateExpLoopVarInit_ERROR_, ie.toString());
                return this.validatorError(ie, message, "visitIterateExp");
            }
            CollectionType ct = (CollectionType)sourceType;
            if (TypeUtil.exactTypeMatch(this.env, loopiter.getType(), ct.getElementType())) continue;
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExpLoopVar_ERROR_, ie.toString());
            return this.validatorError(ie, message, "visitIterateExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIteratorExp(IteratorExp<C, PM> ie) {
        String message;
        Object type = ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        EList iterators = ie.getIterator();
        String name = ie.getName();
        if (type == null || name == null || source == null || body == null || iterators.isEmpty()) {
            String message2 = OCLMessages.bind(OCLMessages.IncompleteIteratorExp_ERROR_, ie.toString());
            return this.validatorError(ie, message2, "visitIteratorExp");
        }
        int opcode = 0;
        if (source.getType() instanceof PredefinedType) {
            opcode = OCLStandardLibraryUtil.getOperationCode(name);
        }
        source.accept(this);
        body.accept(this);
        switch (opcode) {
            case 201: 
            case 202: 
            case 203: {
                if (type == this.getStandardLibrary().getBoolean()) break;
                String message3 = OCLMessages.bind(OCLMessages.TypeConformanceIteratorResult_ERROR_, ie.toString());
                return this.validatorError(ie, message3, "visitIteratorExp");
            }
        }
        if (opcode == 206) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                if (!(type instanceof SequenceType)) {
                    String message4 = OCLMessages.bind(OCLMessages.TypeConformanceCollectSequence_ERROR_, ie.toString());
                    return this.validatorError(ie, message4, "visitIteratorExp");
                }
            } else if (!(type instanceof BagType)) {
                String message5 = OCLMessages.bind(OCLMessages.TypeConformanceCollectBag_ERROR_, ie.toString());
                return this.validatorError(ie, message5, "visitIteratorExp");
            }
        }
        switch (opcode) {
            case 209: 
            case 210: {
                if (TypeUtil.exactTypeMatch(this.env, type, source.getType())) break;
                String message6 = OCLMessages.bind(OCLMessages.TypeConformanceSelectReject_ERROR_, ie.toString());
                return this.validatorError(ie, message6, "visitIteratorExp");
            }
        }
        switch (opcode) {
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 209: 
            case 210: {
                if (body.getType() == this.getStandardLibrary().getBoolean()) break;
                String message7 = OCLMessages.bind(OCLMessages.TypeConformanceIteratorBodyBoolean_ERROR_, ie.toString());
                return this.validatorError(ie, message7, "visitIteratorExp");
            }
        }
        Object sourceType = source.getType();
        if (!(sourceType instanceof CollectionType)) {
            String message8 = OCLMessages.bind(OCLMessages.IteratorSource_ERROR_, ie.toString());
            return this.validatorError(ie, message8, "visitIteratorExp");
        }
        if (opcode == 208) {
            ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
            BasicEnvironment benv = OCLUtil.getAdapter(this.env, BasicEnvironment.class);
            if (benv != null) {
                sev = benv.getValue(ProblemOption.CLOSURE_ITERATOR);
            }
            if (sev != null && sev != ProblemHandler.Severity.OK) {
                benv.problem(sev, ProblemHandler.Phase.VALIDATOR, OCLMessages.bind(OCLMessages.NonStd_Iterator_, "closure"), "iteratorExp", ie);
            }
            if (!(type instanceof SetType)) {
                String message9 = OCLMessages.bind(OCLMessages.TypeConformanceClosure_ERROR_, ie.toString());
                return this.validatorError(ie, message9, "visitIteratorExp");
            }
            CollectionType sourceCT = (CollectionType)source.getType();
            CollectionType bodyCT = (CollectionType)type;
            Object sourceElementType = sourceCT.getElementType();
            Object bodyType = bodyCT.getElementType();
            if (!TypeUtil.compatibleTypeMatch(this.env, bodyType, sourceElementType)) {
                String message10 = OCLMessages.bind(OCLMessages.ElementTypeConformanceClosure_ERROR_, this.getName(bodyType), this.getName(sourceElementType));
                return this.validatorError(ie, message10, "visitIteratorExp");
            }
        }
        if (opcode == 211 && !this.uml.isComparable(body.getType())) {
            message = OCLMessages.bind(OCLMessages.OperationNotFound_ERROR_, "<", this.getName(body.getType()));
            return this.validatorError(ie, message, "visitIteratorExp");
        }
        switch (opcode) {
            case 201: 
            case 202: {
                if (iterators.size() <= 2) break;
                message = OCLMessages.bind(OCLMessages.TooManyIteratorVariables_ERROR_, ie.getName());
                return this.validatorError(ie, message, "visitIteratorExp");
            }
            default: {
                if (iterators.size() <= 1) break;
                message = OCLMessages.bind(OCLMessages.TooManyIteratorVariables_ERROR_, ie.getName());
                return this.validatorError(ie, message, "visitIteratorExp");
            }
        }
        for (Variable loopiter : iterators) {
            loopiter.accept(this);
            if (loopiter.getInitExpression() != null) {
                String message11 = OCLMessages.bind(OCLMessages.IterateExpLoopVarInit_ERROR_, ie.toString());
                return this.validatorError(ie, message11, "visitIteratorExp");
            }
            CollectionType ct = (CollectionType)sourceType;
            if (TypeUtil.exactTypeMatch(this.env, loopiter.getType(), ct.getElementType())) continue;
            String message12 = OCLMessages.bind(OCLMessages.TypeConformanceIteratorExpLoopVar_ERROR_, ie.toString());
            return this.validatorError(ie, message12, "visitIteratorExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitCollectionLiteralExp(CollectionLiteralExp<C> cl) {
        CollectionKind kind = cl.getKind();
        Object type = cl.getType();
        if (!(type instanceof CollectionType)) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceCollectionLiteralExp_ERROR_, cl.toString());
            return this.validatorError(cl, message, "visitCollectionLiteralExp");
        }
        switch (kind) {
            case SET_LITERAL: {
                if (type instanceof SetType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceSetLiteral_ERROR_, cl.toString());
                return this.validatorError(cl, message, "visitCollectionLiteralExp");
            }
            case ORDERED_SET_LITERAL: {
                if (type instanceof OrderedSetType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceOrderedSetLiteral_ERROR_, cl.toString());
                return this.validatorError(cl, message, "visitCollectionLiteralExp");
            }
            case BAG_LITERAL: {
                if (type instanceof BagType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceBagLiteral_ERROR_, cl.toString());
                return this.validatorError(cl, message, "visitCollectionLiteralExp");
            }
            default: {
                if (kind == CollectionKind.SEQUENCE_LITERAL && type instanceof SequenceType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceSequenceLiteral_ERROR_, cl.toString());
                return this.validatorError(cl, message, "visitCollectionLiteralExp");
            }
        }
        EList<CollectionLiteralPart<C>> parts = cl.getPart();
        CollectionType collectionType = (CollectionType)type;
        if (parts.isEmpty()) {
            if (!(collectionType.getElementType() instanceof VoidType)) {
                String message = OCLMessages.bind(OCLMessages.TypeConformanceEmptyCollection_ERROR_, cl.toString());
                return this.validatorError(cl, message, "visitCollectionLiteralExp");
            }
            return Boolean.TRUE;
        }
        Object partsType = ((CollectionLiteralPart)parts.get(0)).getType();
        for (CollectionLiteralPart part : parts) {
            part.accept(this);
            partsType = TypeUtil.commonSuperType(null, this.env, partsType, part.getType());
            if (partsType != null) continue;
            return Boolean.TRUE;
        }
        if (!TypeUtil.exactTypeMatch(this.env, partsType, collectionType.getElementType())) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceCollectionElementType_ERROR_, cl.toString());
            return this.validatorError(cl, message, "visitCollectionLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitCollectionItem(CollectionItem<C> item) {
        return (Boolean)item.getItem().accept(this);
    }

    @Override
    public Boolean visitCollectionRange(CollectionRange<C> range) {
        if (((Boolean)range.getFirst().accept(this)).booleanValue() && ((Boolean)range.getLast().accept(this)).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitTupleLiteralExp(TupleLiteralExp<C, P> tl) {
        Object type = tl.getType();
        if (!(type instanceof TupleType)) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceTupleLiteralExp_ERROR_, tl.toString());
            return this.validatorError(tl, message, "visitTupleLiteralExp");
        }
        EList<TupleLiteralPart<C, P>> tp = tl.getPart();
        if (tp.size() != this.uml.getAttributes(type).size()) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceTupleLiteralExpParts_ERROR_, tl.toString());
            return this.validatorError(tl, message, "visitTupleLiteralExp");
        }
        HashSet<String> names = new HashSet<String>();
        for (TupleLiteralPart part : tl.getPart()) {
            String name = part.getName();
            P property = this.env.lookupProperty(type, name);
            if (property == null) {
                String message = OCLMessages.bind(OCLMessages.TupleLiteralExpressionPart_ERROR_, name, tl.toString());
                return this.validatorError(tl, message, "visitTupleLiteralExp");
            }
            if (!names.add(name)) {
                String message = OCLMessages.bind(OCLMessages.TupleDuplicateName_ERROR_, name, tl.toString());
                return this.validatorError(tl, message, "visitTupleLiteralExp");
            }
            part.accept(this);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitTupleLiteralPart(TupleLiteralPart<C, P> tp) {
        P property = tp.getAttribute();
        if (property == null) {
            String message = OCLMessages.bind(OCLMessages.MissingPropertyInTupleLiteralPart_ERROR_, tp.getName(), tp.eContainer().toString());
            return this.validatorError(tp, message, "visitTupleLiteralPart");
        }
        Object type = tp.getType();
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.MissingTypeInTupleLiteralPart_ERROR_, tp.getName(), tp.eContainer().toString());
            return this.validatorError(tp, message, "visitTupleLiteralPart");
        }
        if (!TypeUtil.exactTypeMatch(this.env, this.getOCLType(property), type)) {
            String message = OCLMessages.bind(OCLMessages.TuplePartType_ERROR_, tp.getName(), tp.eContainer().toString());
            return this.validatorError(tp, message, "visitTupleLiteralPart");
        }
        OCLExpression<C> value = tp.getValue();
        if (value != null) {
            value.accept(this);
            if (!TypeUtil.compatibleTypeMatch(this.env, value.getType(), type)) {
                String message = OCLMessages.TypeConformanceTuplePartValue_ERROR_;
                return this.validatorError(tp, message, "visitTupleLiteralPart");
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitStateExp(StateExp<C, S> s) {
        S state = s.getReferredState();
        if (state == null) {
            String message = OCLMessages.bind(OCLMessages.MissingStateInStateExp_ERROR_, s.toString());
            return this.validatorError(s, message, "visitStateExp");
        }
        return Boolean.TRUE;
    }

    private Boolean visitFeatureCallExp(FeatureCallExp<C> exp) {
        OCLExpression source;
        if (exp.isMarkedPre() && !this.env.isInPostcondition(exp)) {
            String message = OCLMessages.AtPreInPostcondition_ERROR_;
            return this.validatorError(exp, message, "visitFeatureCallExp");
        }
        if (exp.getSource() != null && (source = exp.getSource()).getType() instanceof TypeType) {
            TypeType typeType = (TypeType)source.getType();
            Object feature = null;
            if (exp instanceof OperationCallExp) {
                feature = ((OperationCallExp)exp).getReferredOperation();
                if (!typeType.oclOperations().contains(feature) && !this.isStatic(feature)) {
                    String message = OCLMessages.bind(OCLMessages.NonStaticOperation_ERROR_, this.getName(feature));
                    return this.validatorError(exp, message, "visitFeatureCallExp");
                }
            } else if (exp instanceof PropertyCallExp && !this.isStatic(feature = ((PropertyCallExp)exp).getReferredProperty())) {
                String message = OCLMessages.bind(OCLMessages.NonStaticAttribute_ERROR_, this.getName(feature));
                return this.validatorError(exp, message, "visitFeatureCallExp");
            }
        }
        return Boolean.FALSE;
    }

    private boolean isStatic(Object feature) {
        return this.uml != null && this.uml.isStatic(feature);
    }

    @Override
    public Boolean visitInvalidLiteralExp(InvalidLiteralExp<C> il) {
        if (!(il.getType() instanceof InvalidType)) {
            String message = OCLMessages.TypeConformanceInvalidLiteral_ERROR_;
            return this.validatorError(il, message, "visitInvalidLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitNullLiteralExp(NullLiteralExp<C> il) {
        if (!(il.getType() instanceof VoidType)) {
            String message = OCLMessages.TypeConformanceNullLiteral_ERROR_;
            return this.validatorError(il, message, "visitNullLiteralExp");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitExpressionInOCL(ExpressionInOCL<C, PM> expression) {
        if (expression.getContextVariable() == null) {
            String message = OCLMessages.MissingContextVariable_ERROR_;
            return this.validatorError(expression, message, "visitExpressionInOCL");
        }
        OCLExpression<C> body = expression.getBodyExpression();
        if (body == null) {
            String message = OCLMessages.MissingBodyExpression_ERROR_;
            return this.validatorError(expression, message, "visitExpressionInOCL");
        }
        CT constraint = this.uml.getConstraint(expression);
        if (constraint != null) {
            O operation = this.getConstrainedOperation(this.uml.getConstrainedElements(constraint));
            if (operation == null) {
                if (!"definition".equals(this.uml.getStereotype(constraint))) {
                    if (!expression.getParameterVariable().isEmpty()) {
                        String message = OCLMessages.ExtraneousParameterVariables_ERROR_;
                        return this.validatorError(constraint, message, "visitExpressionInOCL");
                    }
                    if (expression.getResultVariable() != null) {
                        String message = OCLMessages.ExtraneousResultVariable_ERROR_;
                        return this.validatorError(constraint, message, "visitExpressionInOCL");
                    }
                }
            } else {
                String message;
                List<PM> parameters = this.uml.getParameters(operation);
                EList<Variable<C, PM>> variables = expression.getParameterVariable();
                if (parameters.size() != variables.size()) {
                    String message2 = OCLMessages.MismatchedParameterVariables_ERROR_;
                    return this.validatorError(constraint, message2, "visitExpressionInOCL");
                }
                Iterator<PM> iter = parameters.iterator();
                for (Variable var : expression.getParameterVariable()) {
                    PM param = iter.next();
                    var.accept(this);
                    C paramType = this.getOCLType(param);
                    if (paramType == null || TypeUtil.exactTypeMatch(this.env, paramType, var.getType())) continue;
                    String message3 = OCLMessages.MismatchedParameterVariables_ERROR_;
                    return this.validatorError(constraint, message3, "visitExpressionInOCL");
                }
                Variable<C, PM> resultVar = expression.getResultVariable();
                Object operType = null;
                String stereotype = this.uml.getStereotype(constraint);
                if (("body".equals(stereotype) || "postcondition".equals(stereotype)) && (operType = (Object)this.getOCLType(operation)) instanceof VoidType) {
                    operType = null;
                }
                if (operType == null != (resultVar == null) && !"body".equals(stereotype)) {
                    message = resultVar == null ? OCLMessages.MissingResultVariable_ERROR_ : OCLMessages.ExtraneousResultVariable_ERROR_;
                    return this.validatorError(constraint, message, "visitExpressionInOCL");
                }
                if (resultVar != null) {
                    if (!TypeUtil.exactTypeMatch(this.env, operType, resultVar.getType())) {
                        message = OCLMessages.MissingResultVariable_ERROR_;
                        return this.validatorError(constraint, message, "visitExpressionInOCL");
                    }
                    expression.getResultVariable().accept(this);
                }
            }
        }
        Boolean wellFormed = this.checkExpressionInOCL(expression, constraint, body);
        if (Boolean.TRUE.equals(body.accept(this)) && Boolean.TRUE.equals(wellFormed)) {
            return true;
        }
        return false;
    }

    Boolean checkExpressionInOCL(ExpressionInOCL<C, PM> expression, CT constraint, OCLExpression<C> body) {
        String stereotype = this.uml.getStereotype(constraint);
        List<EObject> constrainedElement = this.uml.getConstrainedElements(constraint);
        Object bodyType = body.getType();
        C oclBoolean = this.getStandardLibrary().getBoolean();
        if ("invariant".equals(stereotype)) {
            C constrainedClassifier = this.getConstrainedClassifier(constrainedElement);
            if (!Boolean.TRUE.equals(this.checkContextClassifier(expression, constrainedClassifier, constrainedElement))) {
                return Boolean.FALSE;
            }
            if (bodyType != oclBoolean) {
                String message = OCLMessages.bind(OCLMessages.InvariantConstraintBoolean_ERROR_, this.getName(constrainedClassifier));
                return this.validatorError(constraint, message, "checkExpressionInOCL");
            }
        } else if ("postcondition".equals(stereotype) || "precondition".equals(stereotype)) {
            O constrainedOperation = this.getConstrainedOperation(constrainedElement);
            if (!Boolean.TRUE.equals(this.checkContextFeatureClassifier(expression, constrainedOperation, constrainedElement))) {
                return Boolean.FALSE;
            }
            if (bodyType != oclBoolean) {
                String message = OCLMessages.bind(OCLMessages.OperationConstraintBoolean_ERROR_, this.getName(constrainedOperation));
                return this.validatorError(constraint, message, "checkExpressionInOCL");
            }
        } else if ("definition".equals(stereotype)) {
            C constrainedClassifier = this.getConstrainedClassifier(constrainedElement);
            if (!Boolean.TRUE.equals(this.checkContextClassifier(expression, constrainedClassifier, constrainedElement))) {
                return Boolean.FALSE;
            }
        } else if ("initial".equals(stereotype) || "derivation".equals(stereotype)) {
            C propertyType;
            P constrainedProperty = this.getConstrainedProperty(constrainedElement);
            if (!Boolean.TRUE.equals(this.checkContextFeatureClassifier(expression, constrainedProperty, constrainedElement))) {
                return Boolean.FALSE;
            }
            C c = propertyType = constrainedProperty != null ? this.getOCLType(constrainedProperty) : this.getStandardLibrary().getOclVoid();
            if (!TypeUtil.compatibleTypeMatch(this.env, bodyType, propertyType)) {
                String message = OCLMessages.bind(OCLMessages.InitOrDerConstraintConformance_ERROR_, new Object[]{this.getName(bodyType), this.getName(constrainedProperty), this.getName(propertyType)});
                return this.validatorError(constraint, message, "checkExpressionInOCL");
            }
        } else if ("body".equals(stereotype)) {
            O constrainedOperation = this.getConstrainedOperation(constrainedElement);
            if (!Boolean.TRUE.equals(this.checkContextFeatureClassifier(expression, constrainedOperation, constrainedElement))) {
                return Boolean.FALSE;
            }
            C operationType = constrainedOperation != null ? this.getOCLType(constrainedOperation) : this.getStandardLibrary().getOclVoid();
            String operationName = this.getName(constrainedOperation);
            if (operationType instanceof VoidType) {
                String message = OCLMessages.bind(OCLMessages.BodyConditionNotAllowed_ERROR_, operationName);
                return this.validatorError(constraint, message, "checkExpressionInOCL");
            }
            if (bodyType == oclBoolean && operationType != oclBoolean) {
                if (this.visitBodyConditionConstraint(constraint, operationType, operationName).booleanValue()) {
                    return Boolean.TRUE;
                }
            } else {
                if (!TypeUtil.compatibleTypeMatch(this.env, bodyType, operationType)) {
                    String message = OCLMessages.bind(OCLMessages.BodyConditionConformance_ERROR_, new Object[]{operationName, this.getName(bodyType), this.getName(operationType)});
                    return this.validatorError(constraint, message, "checkExpressionInOCL");
                }
                if (this.findResultVariable(expression.getBodyExpression(), operationType)) {
                    String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
                    return this.validatorError(constraint, message, "checkExpressionInOCL");
                }
            }
        }
        return Boolean.TRUE;
    }

    private Boolean checkContextClassifier(ExpressionInOCL<C, PM> expression, C constrainedClassifier, List<EObject> constrainedElement) {
        C contextualClassifier = this.getContextualClassifier(expression);
        if (constrainedElement.size() == 1 && constrainedClassifier != contextualClassifier) {
            String message = OCLMessages.bind(OCLMessages.WrongContextClassifier_ERROR_, this.getName(contextualClassifier), this.getName(constrainedClassifier));
            return this.validatorError(expression, message, "checkExpressionInOCL");
        }
        return Boolean.TRUE;
    }

    private Boolean checkContextFeatureClassifier(ExpressionInOCL<C, PM> expression, Object constrainedFeature, List<EObject> constrainedElement) {
        C owner;
        C constrainedClassifier;
        C contextualClassifier = this.getContextualClassifier(expression);
        if (constrainedElement.size() == 1 && constrainedFeature != null) {
            C owner2 = this.uml.getOwningClassifier(constrainedFeature);
            if (owner2 != contextualClassifier) {
                String message = OCLMessages.bind(OCLMessages.WrongContextClassifier_ERROR_, this.getName(contextualClassifier), this.getName(owner2));
                return this.validatorError(expression, message, "checkExpressionInOCL");
            }
        } else if (constrainedElement.size() > 1 && (constrainedClassifier = this.getConstrainedClassifier(constrainedElement)) != null && constrainedFeature != null && !TypeUtil.compatibleTypeMatch(this.env, constrainedClassifier, owner = this.uml.getOwningClassifier(constrainedFeature))) {
            String message = OCLMessages.bind(OCLMessages.WrongContextClassifier_ERROR_, this.getName(contextualClassifier), this.getName(owner));
            return this.validatorError(expression, message, "checkExpressionInOCL");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitConstraint(CT constraint) {
        ExpressionInOCL<C, PM> specification = this.uml.getSpecification(constraint);
        Boolean specificationResult = (Boolean)specification.accept(this);
        if (!Boolean.TRUE.equals(specificationResult)) {
            return specificationResult;
        }
        return Boolean.TRUE;
    }

    private Boolean visitBodyConditionConstraint(CT constraint, C operationType, String operationName) {
        OCLExpression bodyExpr;
        OCLExpression<C> exp = this.uml.getSpecification(constraint).getBodyExpression();
        while (exp instanceof LetExp) {
            LetExp letExp = (LetExp)exp;
            exp = letExp.getIn();
        }
        OperationCallExp body = null;
        if (exp instanceof OperationCallExp) {
            OperationCallExp callExp;
            body = callExp = (OperationCallExp)exp;
        }
        if (body == null || body.getOperationCode() != 60 || body.getArgument().size() != 1) {
            String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
            return this.validatorError(constraint, message, "visitBodyConditionConstraint");
        }
        if (this.isResultVariable(body.getSource(), operationType)) {
            bodyExpr = (OCLExpression)body.getArgument().get(0);
        } else if (this.isResultVariable((OCLExpression)body.getArgument().get(0), operationType)) {
            bodyExpr = body.getSource();
        } else {
            String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
            return this.validatorError(constraint, message, "visitBodyConditionConstraint");
        }
        Object bodyType = bodyExpr.getType();
        if ((TypeUtil.getRelationship(this.env, bodyType, operationType) & 3) == 0) {
            String message = OCLMessages.bind(OCLMessages.BodyConditionConformance_ERROR_, new Object[]{operationName, this.getName(bodyType), this.getName(operationType)});
            return this.validatorError(constraint, message, "visitBodyConditionConstraint");
        }
        if (this.findResultVariable(bodyExpr, operationType)) {
            String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
            return this.validatorError(constraint, message, "visitBodyConditionConstraint");
        }
        return Boolean.FALSE;
    }

    private O getConstrainedOperation(List<?> constrainedElement) {
        for (Object constrained : constrainedElement) {
            if (!this.uml.isOperation(constrained)) continue;
            return (O)constrained;
        }
        return null;
    }

    private P getConstrainedProperty(List<?> constrainedElement) {
        for (Object constrained : constrainedElement) {
            if (!this.uml.isProperty(constrained)) continue;
            return (P)constrained;
        }
        return null;
    }

    private C getConstrainedClassifier(List<?> constrainedElement) {
        for (Object constrained : constrainedElement) {
            if (!this.uml.isClassifier(constrained)) continue;
            return (C)constrained;
        }
        return null;
    }

    private C getContextualClassifier(ExpressionInOCL<C, PM> expression) {
        Variable<C, PM> selfVar = expression.getContextVariable();
        return selfVar == null ? null : (C)selfVar.getType();
    }

    String getName(Object element) {
        return element == null ? null : this.uml.getName(element);
    }

    protected C getOCLType(Object metaElement) {
        return TypeUtil.resolveType(this.env, this.uml.getOCLType(metaElement));
    }

    private OCLStandardLibrary<C> getStandardLibrary() {
        return this.env.getOCLStandardLibrary();
    }

    private boolean isResultVariable(OCLExpression<C> expr, C expectedType) {
        boolean result = expr instanceof VariableExp;
        if (result) {
            result = TypeUtil.exactTypeMatch(this.env, expr.getType(), expectedType);
        }
        if (result) {
            Variable var = ((VariableExp)expr).getReferredVariable();
            result = var != null && "result".equals(var.getName()) && var.eContainmentFeature() == UtilitiesPackage.Literals.EXPRESSION_IN_OCL__RESULT_VARIABLE;
        }
        return result;
    }

    private boolean findResultVariable(OCLExpression<C> expr, C expectedType) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ResultFinder
        extends AbstractVisitor<Variable<C, PM>, C, O, P, EL, PM, S, COA, SSA, CT> {
            boolean found = false;
            private final /* synthetic */ Object val$expectedType;

            ResultFinder(Object object) {
                this.val$expectedType = object;
            }

            @Override
            public Variable<C, PM> visitVariableExp(VariableExp<C, PM> v) {
                if (ValidationVisitor.this.isResultVariable(v, this.val$expectedType)) {
                    this.found = true;
                    return v.getReferredVariable();
                }
                return null;
            }
        }
        ResultFinder finder = new ResultFinder(expectedType);
        expr.accept(finder);
        return finder.found;
    }
}

