/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.util.ArrayList;
import lpg.lpgjavaruntime.ErrorToken;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ProblemOption;

public abstract class AbstractParser
extends PrsStream {
    private final BasicEnvironment environment;
    private int defaultRepairCount = 0;

    public AbstractParser(BasicEnvironment environment) {
        this.environment = environment;
        environment.setParser(this);
    }

    public AbstractParser(AbstractLexer lexer) {
        super((LexStream)lexer);
        this.environment = lexer.getEnvironment();
        this.environment.setParser(this);
    }

    public String computeInputString(int left, int right) {
        StringBuffer result = new StringBuffer(right - left + 1);
        char[] chars = this.getInputChars();
        if (chars.length > 0) {
            int i = left;
            while (i <= right) {
                if (chars[i] == '\t') {
                    result.append(' ');
                } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                    if (i > 0 && !Character.isWhitespace(chars[i - 1])) {
                        result.append(' ');
                    }
                } else {
                    result.append(chars[i]);
                }
                ++i;
            }
        }
        return result.toString();
    }

    public BasicEnvironment getEnvironment() {
        return this.environment;
    }

    public ErrorToken getErrorTokenAtCharacter(int offset) {
        ErrorToken bestToken = null;
        int i = this.getSize();
        while (--i >= 0) {
            IToken token = this.getTokenAt(i);
            if (!(token instanceof ErrorToken)) break;
            IToken errorToken = ((ErrorToken)token).getErrorToken();
            if (offset < errorToken.getStartOffset() || offset > errorToken.getEndOffset() || bestToken != null && (bestToken.getStartOffset() > errorToken.getStartOffset() || token.getEndOffset() > errorToken.getEndOffset())) continue;
            bestToken = (ErrorToken)token;
        }
        return bestToken;
    }

    public int getDefaultRepairCount() {
        return this.defaultRepairCount;
    }

    public int getErrorTokens() {
        return this.getTokens().size() - this.getStreamLength();
    }

    public AbstractLexer getLexer() {
        return (AbstractLexer)super.getLexStream();
    }

    public int getTokenIndexAtCharacter(int offset) {
        int low = 0;
        int high = this.getSize();
        while (high > low) {
            IToken highToken = this.getTokenAt(high - 1);
            if (!(highToken instanceof ErrorToken)) break;
            --high;
        }
        while (high > low) {
            int mid = (high + low) / 2;
            IToken mid_element = this.getTokenAt(mid);
            if (offset >= mid_element.getStartOffset() && offset <= mid_element.getEndOffset()) {
                return mid;
            }
            if (offset < mid_element.getStartOffset()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -(low - 1);
    }

    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        ArrayList tokens = this.getTokens();
        int index = tokens.size();
        ErrorToken token = new ErrorToken(this.getIToken(firsttok), this.getIToken(lasttok), this.getIToken(errortok), this.getStartOffset(firsttok), this.getEndOffset(lasttok), kind){

            public String toString() {
                if (this.getPrsStream() == null) {
                    return "<toString>";
                }
                int startOffset = this.getStartOffset();
                int length = this.getEndOffset() - startOffset;
                if (length < 0) {
                    length = -length - 1;
                    startOffset = this.getEndOffset();
                }
                if (startOffset + length > this.getPrsStream().getInputChars().length) {
                    return String.valueOf('\uffff');
                }
                return new String(this.getPrsStream().getInputChars(), startOffset, length);
            }
        };
        token.setTokenIndex(index);
        tokens.add(token);
        token.setAdjunctIndex(this.getAdjuncts().size());
        return index;
    }

    public CSTNode parseTokensToCST() {
        return this.parseTokensToCST(null, this.defaultRepairCount);
    }

    public abstract CSTNode parseTokensToCST(Monitor var1, int var2);

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        BasicEnvironment environment = this.getEnvironment();
        if (environment == null) {
            super.reportError(errorCode, locationInfo, leftToken, rightToken, tokenText);
        } else {
            if (errorCode == 6 || errorCode == 8) {
                tokenText = "";
            }
            environment.parserError(errorCode, leftToken, rightToken, tokenText);
        }
    }

    public final void reportErrorTokenMessage(int error_token, String msg) {
        int lasttok;
        int firsttok = super.getFirstRealToken(error_token);
        if (firsttok > (lasttok = super.getLastRealToken(error_token))) {
            String location = String.valueOf(super.getFileName()) + ':' + super.getEndLine(lasttok) + ':' + super.getEndColumn(lasttok) + ": ";
            this.reportError(3, location, lasttok, lasttok, msg);
        } else {
            String location = String.valueOf(super.getFileName()) + ':' + super.getLine(error_token) + ':' + super.getColumn(error_token) + ':' + super.getEndLine(error_token) + ':' + super.getEndColumn(error_token) + ": ";
            this.reportError(5, location, firsttok, lasttok, msg);
        }
    }

    public void resetLexStream(LexStream lexStream) {
        this.setLexStream((AbstractLexer)lexStream);
    }

    public void setDefaultRepairCount(int defaultRepairCount) {
        if (defaultRepairCount < 0) {
            throw new IllegalArgumentException("negative default repair count");
        }
        this.defaultRepairCount = defaultRepairCount;
    }

    public void setLexStream(AbstractLexer lexStream) {
        super.resetLexStream((LexStream)lexStream);
    }

    protected void setOffsets(CSTNode cstNode, IToken startEnd) {
        cstNode.setStartToken(startEnd);
        cstNode.setEndToken(startEnd);
        int startOffset = startEnd.getStartOffset();
        int endOffset = startEnd.getEndOffset();
        if (endOffset < startOffset) {
            cstNode.setStartOffset(endOffset);
            cstNode.setEndOffset(startOffset);
        } else {
            cstNode.setStartOffset(startOffset);
            cstNode.setEndOffset(endOffset);
        }
    }

    protected void setOffsets(CSTNode cstNode, CSTNode startEnd) {
        cstNode.setStartToken(startEnd.getStartToken());
        cstNode.setEndToken(startEnd.getEndToken());
        cstNode.setStartOffset(startEnd.getStartOffset());
        cstNode.setEndOffset(startEnd.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode start, CSTNode end) {
        cstNode.setStartToken(start.getStartToken());
        cstNode.setEndToken(end.getEndToken());
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode start, IToken end) {
        cstNode.setStartToken(start.getStartToken());
        cstNode.setEndToken(end);
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, IToken start, CSTNode end) {
        cstNode.setStartToken(start);
        cstNode.setEndToken(end.getEndToken());
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, IToken start, IToken end) {
        cstNode.setStartToken(start);
        cstNode.setEndToken(end);
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected String unquote(String quoted) {
        String result = quoted;
        if (result != null && result.length() > 1) {
            int max = result.length() - 1;
            if (result.charAt(0) == '\"' && quoted.charAt(max) == '\"') {
                result = result.substring(1, max);
            }
            if (!(result = result.replaceAll("\\\\\"", "\"")).equals(quoted)) {
                ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
                BasicEnvironment benv = this.getEnvironment();
                if (benv != null) {
                    sev = benv.getValue(ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE);
                }
                if (sev != null && sev != ProblemHandler.Severity.OK) {
                    benv.problem(sev, ProblemHandler.Phase.PARSER, OCLMessages.bind(OCLMessages.NonStd_DQuote_Escape_, quoted), "unquote", null);
                }
            }
        }
        return result;
    }
}

