/**
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation, Zeligsoft Inc., and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 225493, 243976, 259818
*   Zeligsoft - Bug 243976
*
* </copyright>
*
* $Id: OCLBacktrackingParserprs.java,v 1.1 2009/01/13 20:31:30 cdamus Exp $
*/

package org.eclipse.ocl.parser.backtracking;

/**
 * The backtracking variant of the OCL parser parse table.
 * 
 * @noextend This class is not intended to be subclassed by clients.
 * 
 * @since 1.3
 */
@SuppressWarnings("nls")
public class OCLBacktrackingParserprs implements lpg.lpgjavaruntime.ParseTable, OCLBacktrackingParsersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,1,0,0,0,0,
            0,0,0,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,0,0,1,
            0,1,1,1,1,1,0,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            0,0,0,0,1,1,1,1,1,0,
            1,1,0,0,0,1,1,1,0,0,
            0,1,1,1,0,0,0,0,0,1,
            1,1,0,0,0,1,0,1,1
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,6,8,0,1,1,3,
            0,1,1,1,1,1,3,3,1,1,
            3,3,3,3,3,3,1,1,3,3,
            3,3,1,1,3,3,3,3,3,3,
            3,3,1,1,1,1,3,3,3,3,
            1,1,3,3,3,3,1,1,2,2,
            1,2,2,4,6,1,1,1,1,3,
            2,2,5,5,1,1,1,1,1,1,
            1,1,1,1,1,1,1,3,0,1,
            1,1,1,1,1,1,3,3,4,1,
            1,1,1,1,0,1,1,3,1,1,
            3,2,3,1,1,1,1,1,4,1,
            1,1,1,1,1,1,1,2,2,2,
            2,1,1,4,6,8,6,8,1,3,
            1,5,3,0,1,1,1,1,1,4,
            4,0,1,1,3,1,1,3,3,1,
            1,5,5,5,1,5,2,2,5,0,
            1,0,1,1,3,4,7,5,5,0,
            1,1,3,1,1,3,1,1,1,1,
            1,1,0,1,2,4,1,0,1,1,
            2,1,1,1,7,4,4,0,1,3,
            1,2,4,4,3,3,3,1,2,4,
            4,4,1,1,1,1,1,4,4,2,
            6,3,5,5,5,5,7,5,3,3,
            3,3,2,2,1,3,5,4,2,1,
            7,6,4,3,1,3,1,1,2,2,
            4,4,1,1,3,2,2,3,3,3,
            3,5,4,2,3,3,3,4,-101,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-11,-43,-2,
            0,0,-3,-4,-13,-75,-5,0,0,-44,
            0,0,-18,-176,-20,-22,-12,-24,-26,-28,
            -32,-33,0,0,-34,-108,0,0,-35,-59,
            -60,0,0,0,0,0,0,0,0,-46,
            -61,-48,0,0,-201,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-62,-63,0,0,0,0,-64,0,
            -65,-66,-67,0,0,-14,-68,-138,-69,-45,
            0,0,0,0,0,0,0,-202,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-70,-73,-74,-76,-78,-79,
            0,-80,0,-81,-82,-83,-84,0,-86,-87,
            -88,-89,-90,-91,-6,0,0,-16,0,0,
            -106,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-92,0,0,0,-136,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-7,0,0,0,-17,0,
            -137,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -93,0,0,0,0,-140,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-8,0,0,0,-19,0,
            -141,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -94,0,0,0,0,-187,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-95,-96,-97,-98,-99,-100,
            -113,-114,-131,-142,-143,-146,-147,-148,-149,-150,
            -151,-152,-153,-154,-159,-9,0,0,-21,0,
            0,-193,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-23,0,0,0,-194,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-160,-161,0,-162,
            0,-200,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-210,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-10,0,0,0,-25,0,-211,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-163,0,0,
            0,0,-103,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-47,0,0,0,-104,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-164,-166,0,0,-198,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-109,0,0,
            0,-232,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -167,-168,0,-169,-170,-171,-172,-173,-174,-175,
            -177,-178,-179,-180,-181,-182,0,-36,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-37,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-38,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-39,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-40,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-42,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-49,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -55,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-77,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-127,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-128,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-135,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-144,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-165,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-185,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-186,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-189,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -190,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-221,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-228,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-230,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-238,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-239,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-123,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -124,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-125,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-126,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-117,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-118,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-119,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-120,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-121,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-122,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-115,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-116,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-111,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-112,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-53,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-54,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -145,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-1,-107,0,0,-110,0,0,0,
            0,0,0,0,0,0,0,0,-183,-222,
            0,-27,0,0,0,-105,0,0,-184,-195,
            -71,0,0,0,0,-223,0,-196,0,0,
            0,-15,0,-197,0,0,0,-41,-203,-206,
            -72,0,0,-50,0,-85,0,0,0,-30,
            -208,0,-209,0,0,0,0,-204,0,0,
            -29,0,0,-212,0,0,0,0,-213,0,
            0,0,0,-214,-157,0,0,0,0,0,
            0,0,0,0,-51,-31,0,0,0,0,
            -102,0,-56,0,0,-207,0,-52,0,0,
            0,0,-129,0,-130,0,0,0,-132,0,
            0,0,0,0,-231,0,0,0,0,0,
            -215,0,0,0,0,0,-139,0,-133,0,
            0,-188,-57,0,0,-216,-58,-155,-217,0,
            0,-134,0,0,-156,0,0,0,0,-218,
            -158,0,0,0,0,0,-191,-219,0,0,
            0,-199,0,0,0,0,0,0,-205,-192,
            0,0,0,-227,0,0,0,0,0,-229,
            0,0,-226,0,0,-220,0,0,0,0,
            0,0,0,-224,-225,0,0,0,0,0,
            0,0,-233,-234,0,-235,0,0,0,-236,
            0,0,-237,-240,-241,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            87,10,10,10,10,10,10,10,10,10,
            10,10,10,10,10,10,10,10,10,68,
            68,6,6,6,6,6,6,6,6,6,
            6,6,7,7,7,7,7,7,7,7,
            7,7,7,8,8,11,11,9,15,69,
            88,89,12,109,109,90,91,70,70,72,
            72,59,59,46,46,47,48,47,48,44,
            45,44,44,44,45,45,45,42,43,42,
            43,42,43,40,41,40,41,40,41,40,
            41,40,41,36,36,38,37,38,37,38,
            37,34,35,34,35,34,35,16,32,16,
            16,17,17,17,17,17,18,18,18,18,
            18,19,19,19,19,2,2,2,1,1,
            1,1,1,1,1,1,1,3,3,73,
            73,20,20,20,20,20,20,21,21,22,
            5,5,5,5,5,94,94,95,95,74,
            74,75,75,75,24,24,24,24,24,23,
            27,28,29,30,31,31,25,26,92,92,
            92,92,97,97,98,98,98,99,99,50,
            49,50,50,77,71,71,56,56,56,56,
            58,57,100,100,78,78,96,96,96,96,
            76,76,76,13,14,80,13,79,79,79,
            51,51,54,54,52,52,33,39,93,93,
            81,81,82,82,65,65,65,87,87,87,
            87,87,87,87,102,102,84,101,103,103,
            85,85,61,61,61,64,83,83,86,86,
            62,104,104,66,66,105,105,63,106,106,
            67,67,67,53,107,60,4,55,79,58,
            58,17,21,76,14,13,13,39,39,39,
            39,93,93,93,93,18,18,90,90,90,
            90,91,91,91,91,72,72,3,59,23,
            50,19,19,78,96,62,105,105,83,83,
            66,66,84,84,84,67,67,67,64,1,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,101,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,568,96,83,84,569,94,572,
            78,570,70,575,66,925,574,64,73,1102,
            1482,3291,400,2477,1650,73,92,711,3316,307,
            2465,125,138,1988,4,2126,2149,136,2151,2201,
            1726,179,1992,157,159,78,1613,125,3305,720,
            2150,1725,1048,43,47,3381,46,3367,3363,211,
            1950,90,1022,924,926,99,125,3271,566,307,
            411,33,491,47,3323,46,3367,3363,118,119,
            3251,101,386,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,568,
            96,83,84,569,94,572,78,570,70,575,
            66,234,574,64,49,3368,3280,3270,112,113,
            387,245,178,1833,1926,210,579,269,262,2203,
            232,1674,1913,1962,1047,1050,1900,2120,275,2189,
            1994,1435,307,179,182,183,3369,3388,195,125,
            3271,566,307,411,33,491,47,3323,46,3367,
            3363,118,119,3251,101,386,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,568,96,83,84,569,94,572,78,
            570,70,575,66,234,574,64,251,252,253,
            254,251,252,253,254,2205,2204,1095,719,1837,
            730,215,71,232,1056,1589,267,731,1434,2020,
            2101,2075,93,1089,1101,2315,125,809,733,3416,
            3388,291,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,101,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,568,96,83,84,569,
            94,572,78,570,70,575,66,224,574,64,
            308,319,1870,934,393,933,361,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,224,574,64,2340,125,939,934,1105,
            1432,431,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,101,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,568,96,83,84,569,
            94,572,78,570,70,575,66,224,574,64,
            308,1786,318,934,395,1433,501,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,224,574,64,2365,125,993,934,1942,
            3239,571,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,101,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,568,96,83,84,569,
            94,572,78,570,70,575,66,224,574,64,
            308,1093,327,934,396,3249,641,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,925,574,64,1740,2231,2235,2239,2240,
            2265,1464,1393,277,1604,2243,2074,1949,1693,1774,
            1823,2279,1771,2256,2317,2293,2390,125,1156,1944,
            158,159,739,125,3271,566,307,411,33,491,
            47,3323,46,3367,3363,118,119,3251,101,386,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,568,96,83,84,
            569,94,572,78,570,70,575,66,224,574,
            64,308,326,1990,934,398,3281,809,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,83,84,569,94,572,78,570,
            70,575,66,224,574,64,325,2301,2302,934,
            2318,3283,1251,125,3271,566,307,411,33,491,
            47,3323,46,3367,3363,118,119,3251,101,386,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,568,96,83,84,
            569,94,572,78,570,70,575,66,3351,574,
            64,191,3304,879,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,101,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,568,96,83,
            84,569,94,572,78,570,70,575,66,224,
            574,64,2415,125,3242,934,2067,3424,949,125,
            3271,566,307,411,33,491,47,3323,46,3367,
            3363,118,119,3251,101,386,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,568,96,83,84,569,94,572,78,
            570,70,575,66,224,574,64,308,1107,321,
            934,399,3425,1111,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,101,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,568,96,83,
            84,569,94,572,78,570,70,575,66,224,
            574,64,2440,125,582,929,1111,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,224,574,64,1466,1461,581,930,1111,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,101,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,568,96,83,84,569,94,572,
            78,570,70,575,66,224,574,64,2440,125,
            1208,3294,1019,125,3271,566,307,411,33,491,
            47,3323,46,3367,3363,118,119,3251,101,386,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,568,96,83,84,
            569,94,572,78,570,70,575,66,234,574,
            64,1463,76,294,175,1665,1476,1722,2019,1849,
            2343,1975,2346,2347,2351,2321,2368,233,1111,125,
            3271,566,307,411,33,491,47,3323,46,3367,
            3363,118,119,3251,101,386,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,568,96,83,84,569,94,572,78,
            570,70,575,66,257,574,64,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,83,84,569,94,572,78,570,
            70,575,66,256,574,64,1111,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,272,574,64,1111,125,3271,566,307,
            411,33,491,47,3323,46,3367,3363,118,119,
            3251,101,386,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,568,
            96,83,84,569,94,572,78,570,70,575,
            66,271,574,64,1111,125,3271,566,307,411,
            33,491,47,3323,46,3367,3363,118,119,3251,
            101,386,111,116,117,141,142,143,144,145,
            146,164,165,166,167,168,102,108,568,96,
            83,84,569,94,572,78,570,70,575,66,
            270,574,64,1111,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,101,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,568,96,83,
            84,569,94,572,78,570,70,575,66,263,
            574,64,1111,125,3271,566,307,411,33,491,
            47,3323,46,3367,3363,118,119,3251,101,386,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,568,96,83,84,
            569,94,572,78,570,70,575,66,192,574,
            64,1111,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,101,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,568,96,83,84,569,
            94,572,78,570,70,575,66,861,574,64,
            1181,125,3271,566,307,411,33,491,47,3323,
            46,3367,3363,118,119,3251,101,386,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,102,108,568,96,83,84,569,94,
            572,78,570,70,575,66,921,574,64,1111,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,101,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,568,96,83,84,569,94,572,
            78,570,70,575,66,266,574,64,1111,125,
            3271,566,307,411,33,491,47,3323,46,3367,
            3363,118,119,3251,101,386,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,568,96,83,84,569,94,572,78,
            570,70,575,66,265,574,64,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,83,84,569,94,572,78,570,
            70,575,66,226,574,64,1111,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,162,574,64,1111,125,3271,566,307,
            411,33,491,47,3323,46,3367,3363,118,119,
            3251,101,386,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,568,
            96,83,84,569,94,572,78,570,70,575,
            66,3269,574,64,1111,125,3271,566,307,411,
            33,491,47,3323,46,3367,3363,118,119,3251,
            101,386,111,116,117,141,142,143,144,145,
            146,164,165,166,167,168,102,108,568,96,
            83,84,569,94,572,78,570,70,575,66,
            163,574,64,1111,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,101,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,568,96,83,
            84,569,94,572,78,570,70,575,66,161,
            574,64,1111,125,3271,566,307,411,33,491,
            47,3323,46,3367,3363,118,119,3251,101,386,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,568,96,83,84,
            569,94,572,78,570,70,575,66,193,574,
            64,1111,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,101,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,568,96,83,84,569,
            94,572,78,570,70,575,66,225,574,64,
            1111,125,3271,566,307,411,33,491,47,3323,
            46,3367,3363,118,119,3251,101,386,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,102,108,568,96,83,84,569,94,
            572,78,570,70,575,66,3433,574,64,1111,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,101,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,568,96,83,84,569,94,572,
            78,570,70,575,66,3436,574,64,1111,125,
            3271,566,307,411,33,491,47,3323,46,3367,
            3363,118,119,3251,101,386,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,568,96,83,84,569,94,572,78,
            570,70,575,66,3443,574,64,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,83,84,569,94,572,78,570,
            70,575,66,3444,574,64,1111,125,3271,566,
            307,411,33,491,47,3323,46,3367,3363,118,
            119,3251,101,386,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            568,96,83,84,569,94,572,78,570,70,
            575,66,3445,574,64,1111,125,3271,566,307,
            411,33,491,47,3323,46,3367,3363,118,119,
            3251,101,386,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,568,
            96,83,84,569,94,572,78,570,70,1425,
            68,1111,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,101,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,568,96,83,84,569,
            94,572,78,1426,76,1111,125,3271,566,307,
            411,33,491,47,3323,46,3367,3363,118,119,
            3251,101,386,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,568,
            96,83,84,569,94,572,78,1427,75,1111,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,101,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,568,96,83,84,569,94,572,
            78,1428,74,1111,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,101,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,568,96,83,
            84,569,94,1422,82,1111,125,3271,566,307,
            411,33,491,47,3323,46,3367,3363,118,119,
            3251,101,386,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,568,
            96,83,84,569,94,1424,80,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,91,92,569,94,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,89,90,569,94,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,87,88,569,94,1111,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,568,96,85,86,569,94,1321,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,101,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,1316,100,1321,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,101,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,1421,98,1321,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,105,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,106,108,1321,125,3271,566,307,411,33,
            491,47,3323,46,3367,3363,118,119,3251,103,
            386,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,104,108,1484,125,3271,
            566,307,411,33,491,47,3323,46,3367,3363,
            118,119,3251,110,386,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,1484,
            125,3271,566,307,411,33,491,47,3323,46,
            3367,3363,118,119,3251,109,386,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,1390,125,3271,566,307,411,33,491,47,
            3323,46,3367,3363,118,119,3251,109,386,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,2467,1552,125,3305,2440,125,1315,
            33,43,47,3375,46,3367,3363,211,180,2372,
            2253,196,2069,402,307,405,2176,125,932,2373,
            2327,1899,33,43,47,147,2228,196,2353,402,
            307,405,2290,196,2378,402,307,405,712,1947,
            1460,1706,191,242,2290,196,285,402,307,405,
            1825,2397,293,2418,250,252,253,254,2115,239,
            240,644,49,3368,1867,320,195,197,198,2185,
            181,931,122,210,2117,1801,384,244,496,387,
            380,55,195,197,198,189,96,577,401,197,
            198,1458,121,1478,237,397,2144,56,714,317,
            583,197,198,2290,196,265,402,307,405,2290,
            196,297,402,307,405,2290,196,268,402,307,
            405,2422,250,252,253,254,217,280,576,270,
            1435,307,2392,1695,191,204,2491,1819,1855,2423,
            191,207,2292,264,916,1958,500,191,204,301,
            2393,1352,261,915,191,59,420,1352,2398,190,
            197,198,2292,642,379,394,197,198,206,2099,
            1352,236,197,198,2292,1429,751,1430,191,59,
            2292,191,209,1352,918,584,2443,927,920,3258,
            422,191,205,917,2447,2472,3264,919,3250,1431,
            215,1430,218,2118,328,915,2497,1436,124,208,
            392,191,3299,2498,2502,2503,3467,3467,191,60,
            3467,123,3467,191,3434,3467,3467,3467,3467,191,
            3440,3467,3467,3467,219,3467,0
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,0,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,0,0,1,74,0,4,0,1,2,
            10,11,12,13,0,10,11,12,13,0,
            1,0,0,1,2,0,1,97,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,37,
            32,33,34,35,36,0,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,76,0,
            78,76,80,78,0,80,85,86,0,88,
            89,0,93,5,10,11,12,13,0,1,
            0,3,4,95,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,0,32,33,34,35,
            36,96,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,0,1,0,3,4,0,
            1,5,3,4,0,1,0,3,4,0,
            1,5,3,4,0,1,2,0,0,95,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,37,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,70,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,70,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,0,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,0,1,0,1,4,0,4,0,0,
            77,2,0,80,14,15,8,9,0,0,
            0,1,0,1,5,5,7,97,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,37,
            32,33,34,35,36,0,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,0,
            32,33,34,35,36,0,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,0,
            32,33,34,35,36,0,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,0,
            32,33,34,35,36,0,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,0,1,
            2,0,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,0,
            32,33,34,35,36,0,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,0,1,
            0,3,0,1,0,3,2,76,0,78,
            0,0,1,3,0,1,0,1,2,0,
            0,1,2,95,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,37,32,33,34,35,36,92,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,82,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,0,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            0,1,2,0,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,32,33,34,35,36,0,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,0,
            1,2,0,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            0,32,33,34,35,36,75,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,0,1,0,
            0,4,0,0,1,0,1,2,8,9,
            8,9,80,14,15,0,84,0,1,2,
            5,0,7,0,1,2,97,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,0,32,33,34,35,36,
            0,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,0,75,90,73,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,0,32,33,34,35,36,0,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,0,53,54,55,56,57,58,
            59,60,0,25,26,27,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,0,32,33,34,35,36,0,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,0,53,54,55,56,57,
            58,59,60,0,1,2,3,74,5,6,
            7,8,9,10,11,12,13,14,15,25,
            26,27,0,1,0,1,2,5,25,26,
            27,28,29,0,31,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,0,73,31,0,0,5,0,7,37,
            25,26,27,28,29,0,31,0,1,0,
            3,2,5,70,71,72,73,74,75,76,
            77,78,79,0,81,82,83,84,85,86,
            87,88,89,90,91,92,74,94,31,75,
            0,0,2,0,1,70,71,72,73,74,
            75,76,77,78,79,0,81,82,83,84,
            85,86,87,88,89,90,91,92,73,94,
            0,1,2,3,31,5,6,7,8,9,
            10,11,12,13,14,15,31,93,0,1,
            2,96,0,1,0,25,26,27,28,29,
            6,31,0,1,2,3,0,5,6,7,
            8,9,10,11,12,13,14,15,0,1,
            80,3,79,31,0,1,2,25,26,27,
            28,29,0,31,28,29,0,1,83,0,
            70,71,72,73,74,75,76,77,78,79,
            0,81,82,83,84,85,86,87,88,89,
            90,91,92,75,94,71,72,31,0,0,
            31,79,70,71,72,73,74,75,76,77,
            78,79,0,81,82,83,84,85,86,87,
            88,89,90,91,92,0,1,2,3,75,
            5,6,7,8,9,10,11,12,13,14,
            15,0,1,0,1,79,0,1,0,0,
            25,26,27,28,29,6,31,0,1,2,
            3,0,5,6,7,8,9,10,11,12,
            13,14,15,75,0,1,77,3,37,31,
            37,0,25,26,27,28,29,0,31,0,
            1,0,94,0,0,70,71,72,73,74,
            75,76,77,78,79,93,81,82,83,84,
            85,86,87,88,89,90,91,92,0,0,
            71,72,74,5,37,7,37,70,71,72,
            73,74,75,76,77,78,79,91,81,82,
            83,84,85,86,87,88,89,90,91,92,
            0,1,2,3,93,5,6,7,8,9,
            10,11,12,13,14,15,0,1,0,1,
            77,80,0,0,0,25,26,27,28,29,
            6,31,0,1,2,3,0,5,6,7,
            8,9,10,11,12,13,14,15,0,1,
            0,82,4,37,31,37,0,25,26,27,
            28,29,6,31,0,1,0,0,1,0,
            70,71,72,73,74,0,76,77,78,79,
            0,81,82,83,84,85,86,87,88,89,
            90,91,92,0,1,71,72,31,0,0,
            0,37,70,71,72,73,74,0,76,77,
            78,79,37,81,82,83,84,85,86,87,
            88,89,90,91,92,0,1,71,72,4,
            37,6,82,0,0,37,70,37,0,14,
            15,16,17,18,19,20,21,22,23,24,
            0,84,0,0,0,30,0,32,33,34,
            35,36,93,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,0,1,80,
            0,4,2,6,0,0,2,37,0,0,
            2,2,0,16,17,18,19,20,21,22,
            23,24,0,1,70,0,4,5,3,32,
            33,34,35,36,0,81,2,0,16,17,
            18,19,20,21,22,23,24,0,0,52,
            2,93,80,80,32,33,34,35,36,0,
            1,0,0,4,2,4,0,93,71,72,
            0,0,2,2,52,16,17,18,19,20,
            21,22,23,24,0,1,0,0,4,2,
            0,32,33,34,35,36,0,31,2,87,
            16,17,18,19,20,21,22,23,24,0,
            1,52,0,4,30,0,0,31,3,3,
            0,37,0,3,2,16,17,18,19,20,
            21,22,23,24,0,1,70,0,4,30,
            3,0,0,31,3,3,37,0,0,2,
            16,17,18,19,20,21,22,23,24,0,
            1,0,0,4,30,4,0,0,0,3,
            80,37,0,0,2,16,17,18,19,20,
            21,22,23,24,0,1,0,0,4,30,
            3,0,0,0,3,3,37,0,31,37,
            16,17,18,19,20,21,22,23,24,0,
            1,0,0,4,30,3,0,0,1,3,
            3,37,5,6,0,16,17,18,19,20,
            21,22,23,24,0,0,0,2,4,30,
            4,0,6,0,3,2,0,1,31,3,
            16,17,18,19,20,21,22,23,24,0,
            0,1,0,1,30,3,0,0,6,3,
            3,0,0,0,3,3,0,31,2,0,
            0,2,0,37,0,0,0,70,71,72,
            73,31,0,31,0,0,0,37,81,0,
            83,0,0,0,0,0,0,71,72,73,
            0,0,76,77,78,0,70,0,0,73,
            0,0,0,0,0,0,0,81,0,83,
            70,0,96,71,72,0,0,0,0,0,
            80,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            3467,410,1781,258,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3191,
            3593,3467,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            77,3467,3467,3743,155,81,3604,3467,3747,3274,
            2947,2907,2867,2827,3467,2947,2907,2867,2827,3467,
            3776,107,3467,5902,3359,3467,3782,2026,3467,410,
            1781,230,489,3474,3502,3475,483,3478,3479,3480,
            3481,3482,3503,3504,3597,3595,3596,3598,3599,3600,
            3601,3602,3603,3483,3484,3485,3476,3159,3593,3339,
            565,499,497,493,492,238,484,3499,3488,3489,
            3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,
            421,3127,3472,3473,3471,3470,3468,3469,3519,567,
            3640,3637,3639,3641,3642,3644,3328,1830,138,3467,
            138,1152,138,936,79,1262,406,3224,190,3227,
            1368,3467,3321,1732,2947,2907,2867,2827,3467,3780,
            3467,202,383,3380,3467,410,1781,230,489,3474,
            3502,3475,483,3478,3479,3480,3481,3482,3503,3504,
            3597,3595,3596,3598,3599,3600,3601,3602,3603,3483,
            3484,3485,3476,3159,3593,3467,565,499,497,493,
            492,378,484,3499,3488,3489,3490,3491,3492,3493,
            3494,3495,3496,3497,3498,3501,421,3127,3472,3473,
            3471,3470,3468,3469,3519,567,3640,3637,3639,3641,
            3642,3644,3328,1830,3467,5533,3467,57,383,3467,
            6288,1879,57,383,3467,3743,273,139,3604,3467,
            3743,299,139,3604,3467,923,3335,3467,3467,3380,
            3467,410,1781,222,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,3333,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,222,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,3467,565,499,497,493,492,2467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,222,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,2516,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,222,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,3467,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,222,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,3467,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,248,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3191,
            3593,3467,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,3467,3767,3467,3780,3276,3467,383,95,3467,
            385,3315,3467,390,588,699,3093,3059,3467,69,
            3467,3783,3467,3740,2785,1928,2743,2026,3467,410,
            1781,222,489,3474,3502,3475,483,3478,3479,3480,
            3481,3482,3503,3504,3597,3595,3596,3598,3599,3600,
            3601,3602,3603,3483,3484,3485,3476,3159,3593,1438,
            565,499,497,493,492,3467,484,3499,3488,3489,
            3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,
            421,3127,3472,3473,3471,3470,3468,3469,3519,567,
            3640,3637,3639,3641,3642,3644,3328,1830,3467,410,
            1781,222,489,3474,3502,3475,483,3478,3479,3480,
            3481,3482,3503,3504,3597,3595,3596,3598,3599,3600,
            3601,3602,3603,3483,3484,3485,3476,3159,3593,3467,
            565,499,497,493,492,3467,484,3499,3488,3489,
            3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,
            421,3127,3472,3473,3471,3470,3468,3469,3519,567,
            3640,3637,3639,3641,3642,3644,3328,1830,3467,410,
            1781,222,489,3474,3502,3475,483,3478,3479,3480,
            3481,3482,3503,3504,3597,3595,3596,3598,3599,3600,
            3601,3602,3603,3483,3484,3485,3476,3159,3593,3467,
            565,499,497,493,492,3467,484,3499,3488,3489,
            3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,
            421,3127,3472,3473,3471,3470,3468,3469,3519,567,
            3640,3637,3639,3641,3642,3644,3328,1830,3467,410,
            1781,222,489,3474,3502,3475,483,3478,3479,3480,
            3481,3482,3503,3504,3597,3595,3596,3598,3599,3600,
            3601,3602,3603,3483,3484,3485,3476,3159,3593,3467,
            565,499,497,493,492,3467,484,3499,3488,3489,
            3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,
            421,3127,3472,3473,3471,3470,3468,3469,3519,567,
            3640,3637,3639,3641,3642,3644,3328,1830,3467,410,
            1781,260,489,3474,3502,3475,483,3478,3479,3480,
            3481,3482,3503,3504,3597,3595,3596,3598,3599,3600,
            3601,3602,3603,3483,3484,3485,3476,3159,3593,3467,
            565,499,497,493,492,63,484,3499,3488,3489,
            3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,
            421,3127,3472,3473,3471,3470,3468,3469,3519,567,
            3640,3637,3639,3641,3642,3644,3328,1830,3467,3746,
            3467,3667,3467,3763,3467,3587,591,1152,3467,936,
            3467,3467,580,3668,3467,3740,3467,3759,425,3467,
            3467,410,1781,3380,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,1487,565,499,497,493,492,2565,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,922,1781,3713,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,3467,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,3467,3366,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,3467,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,1830,
            3467,410,1781,3467,489,3474,3502,3475,483,3478,
            3479,3480,3481,3482,3503,3504,3597,3595,3596,3598,
            3599,3600,3601,3602,3603,3483,3484,3485,3476,3159,
            3593,220,565,499,497,493,492,3467,484,3499,
            3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,
            3498,3501,421,3127,3472,3473,3471,3470,3468,3469,
            3519,567,3640,3637,3639,3641,3642,3644,3328,3467,
            410,1781,295,489,3474,3502,3475,483,3478,3479,
            3480,3481,3482,3503,3504,3597,3595,3596,3598,3599,
            3600,3601,3602,3603,3483,3484,3485,3476,3159,3593,
            3467,565,499,497,493,492,3688,484,3499,3488,
            3489,3490,3491,3492,3493,3494,3495,3496,3497,3498,
            3501,421,3127,3472,3473,3471,3470,3468,3469,3519,
            567,3640,3637,3639,3641,3642,3644,3467,3781,255,
            99,928,97,3467,3756,3467,3758,508,3093,3059,
            3093,3059,276,259,259,73,3757,3467,3742,220,
            2785,3467,2743,3467,410,1781,2173,489,3474,3502,
            3475,483,3478,3479,3480,3481,3482,3503,3504,3597,
            3595,3596,3598,3599,3600,3601,3602,3603,3483,3484,
            3485,3476,3159,3593,3467,565,499,497,493,492,
            3467,484,3499,3488,3489,3490,3491,3492,3493,3494,
            3495,3496,3497,3498,3501,421,3127,3472,3473,3471,
            3470,3468,3469,3519,567,3640,3637,3639,3641,3642,
            3644,3467,3688,2075,3466,3594,3474,3502,3475,3477,
            3478,3479,3480,3481,3482,3503,3504,3597,3595,3596,
            3598,3599,3600,3601,3602,3603,3483,3484,3485,3476,
            3486,3593,3467,3505,3506,3507,3508,3509,65,3511,
            3499,3488,3489,3490,3491,3492,3493,3494,3495,3496,
            3497,3498,3501,3467,3487,3472,3473,3471,3470,3468,
            3469,3519,3467,2699,2655,2611,3594,3474,3502,3475,
            3477,3478,3479,3480,3481,3482,3503,3504,3597,3595,
            3596,3598,3599,3600,3601,3602,3603,3483,3484,3485,
            3476,3486,3593,3467,3505,3506,3507,3508,3509,259,
            3511,935,3488,3489,3490,3491,3492,3493,3494,3495,
            3496,3497,3498,3501,67,3487,3472,3473,3471,3470,
            3468,3469,3519,3467,6269,43,48,3616,48,48,
            48,48,48,48,48,48,48,48,48,2699,
            2655,2611,3467,3777,3467,3742,220,2222,48,48,
            48,48,48,3467,48,3467,6302,45,220,3467,
            220,220,220,220,220,220,220,220,220,220,
            220,72,241,189,3467,307,2785,3467,2743,3262,
            220,220,220,220,220,3467,220,3467,3772,3467,
            3772,646,57,48,48,48,48,48,6269,48,
            48,48,48,3467,48,48,48,48,48,48,
            48,48,48,48,48,48,189,48,3772,3688,
            148,3467,997,3467,3779,220,220,220,220,220,
            5846,220,220,220,220,3467,220,220,220,220,
            220,220,220,220,220,220,220,220,324,1266,
            3467,6302,45,220,2271,220,220,220,220,220,
            220,220,220,220,220,220,3372,329,3467,3742,
            220,324,3467,3778,3467,220,220,220,220,220,
            585,220,3467,6198,10,171,93,171,171,171,
            171,171,171,171,171,171,171,171,3467,3765,
            138,3288,3387,2271,3467,3742,220,171,171,171,
            171,171,3467,171,3023,2987,3467,3745,1977,203,
            220,220,220,220,220,5878,220,220,220,220,
            3467,220,220,220,220,220,220,220,220,220,
            220,220,220,3688,1319,805,695,2271,220,247,
            3372,3400,171,171,171,171,171,10,171,171,
            171,171,42,171,171,171,171,171,171,171,
            171,171,171,171,171,3467,6261,44,176,3688,
            176,176,176,176,176,176,176,176,176,176,
            176,3467,3740,3467,3740,3413,3467,3755,3467,267,
            176,176,176,176,176,585,176,3467,6305,220,
            220,41,220,220,220,220,220,220,220,220,
            220,220,220,3688,3467,3769,385,3326,62,3362,
            62,3467,220,220,220,220,220,3467,220,3467,
            3740,199,1213,249,3467,176,176,176,176,176,
            44,176,176,176,176,154,176,176,176,176,
            176,176,176,176,176,176,176,176,71,3467,
            805,695,3636,2785,1536,2743,62,220,220,220,
            220,220,3688,220,220,220,220,2320,220,220,
            220,220,220,220,220,220,220,220,220,220,
            3467,3688,45,3688,153,3688,3688,3688,3688,3688,
            3688,3688,3688,3688,3688,3688,3467,3740,3467,3740,
            385,390,3467,156,328,3688,3688,3688,3688,3688,
            304,3688,3467,3688,45,3688,3467,3688,3688,3688,
            3688,3688,3688,3688,3688,3688,3688,3688,3467,3773,
            323,3789,383,62,866,62,138,3688,3688,3688,
            3688,3688,3770,3688,3467,3740,3467,3467,3754,40,
            3688,3688,3688,3688,3688,3467,3688,3688,3688,3688,
            3467,3688,3688,3688,3688,3688,3688,3688,3688,3688,
            3688,3688,3688,3467,3740,304,304,3410,3467,295,
            3467,3240,3688,3688,3688,3688,3688,3467,3688,3688,
            3688,3688,1585,3688,3688,3688,3688,3688,3688,3688,
            3688,3688,3688,3688,3688,3467,3744,3770,3770,3594,
            3256,3502,274,3467,3467,1634,2418,3268,39,3503,
            3504,3597,3595,3596,3598,3599,3600,3601,3602,3603,
            3467,3694,127,3467,38,3593,3467,3505,3506,3507,
            3508,3509,152,3511,3499,3488,3489,3490,3491,3492,
            3493,3494,3495,3496,3497,3498,3501,3467,3743,276,
            3467,3604,701,194,3467,3467,498,1683,3467,3467,
            3357,756,160,3597,3595,3596,3598,3599,3600,3601,
            3602,3603,3467,3743,2369,3467,3604,194,3581,3617,
            3618,3619,3620,3621,3467,3404,811,3467,3597,3595,
            3596,3598,3599,3600,3601,3602,3603,3467,282,409,
            942,151,137,3246,3617,3618,3619,3620,3621,3467,
            3743,3467,32,3604,50,383,127,150,194,194,
            3467,33,3392,51,409,3597,3595,3596,3598,3599,
            3600,3601,3602,3603,3467,3744,223,3467,3594,1052,
            140,3617,3618,3619,3620,3621,3467,3777,1103,2124,
            3597,3595,3596,3598,3599,3600,3601,3602,3603,3467,
            3744,409,58,3594,3593,3467,3467,2271,3751,3681,
            3467,61,3467,3753,1158,3597,3595,3596,3598,3599,
            3600,3601,3602,3603,3467,3744,3777,3467,3594,3593,
            3683,3467,3467,3399,3752,3680,61,218,3467,701,
            3597,3595,3596,3598,3599,3600,3601,3602,3603,3467,
            3744,3467,235,3594,3593,928,3467,231,3467,3748,
            390,61,171,3467,10,3597,3595,3596,3598,3599,
            3600,3601,3602,3603,3467,3744,3467,3467,3594,3593,
            3582,3467,3467,3467,3651,3696,61,3467,1372,3345,
            3597,3595,3596,3598,3599,3600,3601,3602,3603,3467,
            3744,3467,3467,3594,3593,3695,3467,3467,3777,3750,
            3777,61,189,189,3467,3597,3595,3596,3598,3599,
            3600,3601,3602,3603,3467,176,258,44,3594,3593,
            383,3467,585,48,3679,43,3467,6243,3777,189,
            3597,3595,3596,3598,3599,3600,3601,3602,3603,3467,
            127,6092,3467,3772,3593,3772,3467,3467,57,3654,
            3652,3467,3467,3467,3655,3653,220,189,45,220,
            3467,3742,3467,3262,3467,3467,3467,3777,189,189,
            3777,189,3467,3772,3467,3467,3467,3262,3777,3467,
            3777,3467,3467,3467,3467,3467,3467,805,695,243,
            3467,3467,1152,385,936,3467,189,3467,3467,189,
            3467,3467,3467,3467,3467,3467,3467,189,3467,189,
            189,3467,378,57,57,3467,3467,3467,3467,3467,
            137
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            468,257,70,98,99,363,363,363,363,363,
            67,477,67,256,427,374,374,552,374,552,
            374,552,374,552,374,552,374,79,81,497,
            358,294,86,512,513,149,149,149,149,149,
            67,149,346,204,345,341,57,252,149,427,
            518,67,151,151,149,522,522,522,102,145,
            144,216,216,259,305,304,304,304,304,304,
            306,305,361,513,308,312,149,314,320,316,
            325,322,350,349,511,347,352,341,356,519,
            302,301,445,519,513,513,513,513,513,513,
            1,67,149,149,35,377,161,161,57,57,
            150,150,448,121,150,150,149,149,149,149,
            149,149,149,149,149,149,149,149,427,518,
            251,427,518,214,149,377,377,518,518,377,
            377,459,451,149,4,458,458,455,461,461,
            262,261,302,301,522,216,305,307,216,513,
            216,513,512,512,149,312,312,316,316,322,
            320,320,320,519,300,99,519,302,302,302,
            465,302,302,302,149,149,2,214,149,149,
            307,307,377,377,513,513,262,149,214,149,
            147,147,501,374,67,504,374,302,302,377,
            377,461,515,76,302,526,302,550,301,302,
            149,426,480,302,302,307,214,149,214,149,
            427,148,141,77,302,77,302,149,149,302,
            302
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            74,69,68,61,67,63,8,64,62,65,
            66,52,60,58,59,57,56,54,55,5,
            7,28,9,10,11,12,13,25,26,27,
            2,29,53,97,38,40,41,42,43,44,
            45,46,47,48,49,50,39,51,6,14,
            15,32,33,34,35,36,30,17,18,16,
            19,20,21,22,23,24,1,4,0,3,
            81,83,73,37,1,31,70,0,96,73,
            82,1,77,80,0,5,3,74,70,31,
            81,71,72,83,6,1,80,73,15,14,
            0,3,74,79,70,31,81,87,76,71,
            72,77,82,78,91,83,6,14,15,73,
            28,29,8,9,10,11,5,12,13,7,
            85,86,88,89,90,25,26,27,92,80,
            84,1,0,1,93,0,3,95,69,68,
            61,67,63,64,62,65,66,52,1,2,
            60,58,59,57,56,54,55,5,7,28,
            8,9,10,11,12,13,25,26,27,29,
            53,39,51,6,14,15,32,33,34,35,
            36,40,41,42,43,44,45,46,47,48,
            49,50,38,17,18,16,19,20,21,22,
            23,24,30,4,0,28,29,8,9,10,
            11,12,13,7,3,74,79,85,70,31,
            81,86,87,88,89,71,72,90,91,84,
            25,26,27,92,83,6,14,15,2,75,
            5,82,1,76,78,77,73,0,94,75,
            80,28,29,8,9,10,11,12,13,7,
            79,85,86,87,88,89,76,71,72,77,
            82,78,90,91,84,25,26,27,92,6,
            14,15,2,74,70,81,83,73,5,1,
            31,3,0,93,2,94,75,88,89,85,
            86,8,9,28,29,10,11,12,13,5,
            7,25,26,27,3,74,79,70,31,81,
            87,76,78,90,91,84,83,14,15,92,
            73,71,72,6,77,1,82,0,1,5,
            0,96,73,82,0,2,37,76,78,1,
            80,0,30,4,17,18,16,19,20,21,
            22,23,24,1,37,0,3,69,61,39,
            51,6,14,15,40,41,42,43,44,45,
            46,47,48,49,50,30,67,38,63,8,
            64,62,65,66,60,58,59,57,56,54,
            55,7,28,9,10,11,12,13,25,26,
            27,2,29,53,68,5,17,18,16,19,
            20,21,22,23,24,52,32,33,34,35,
            36,4,1,0,31,83,0,90,1,0,
            74,31,87,0,37,5,1,31,74,0,
            79,31,1,0,3,80,0,14,15,77,
            76,78,71,72,6,4,73,96,0,17,
            18,16,19,20,21,22,23,24,52,32,
            33,34,35,36,4,1,71,72,6,0,
            91,1,0,14,15,77,82,73,1,0,
            37,1,2,0,70,81,0,4,3,1,
            0,2,1,75,0,70,80,28,29,8,
            9,10,11,5,12,13,7,2,94,85,
            86,75,88,89,25,26,27,92,1,3,
            31,37,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            77,34,34,34,34,47,47,47,47,47,
            1,11,5,24,32,26,26,34,26,34,
            26,34,26,34,26,34,26,34,97,95,
            101,34,34,34,34,29,29,29,29,29,
            91,29,3,47,24,20,88,22,29,32,
            99,99,29,29,29,105,105,105,34,34,
            34,34,34,34,34,34,34,34,34,34,
            106,106,34,34,8,34,29,34,34,34,
            34,34,34,34,26,34,34,34,34,34,
            34,34,34,34,34,34,34,34,34,34,
            29,103,29,29,87,29,81,13,88,88,
            70,70,34,34,63,63,49,49,56,56,
            56,56,35,42,42,42,29,29,32,108,
            34,32,108,111,29,29,29,33,33,29,
            29,34,34,29,29,34,34,34,34,34,
            34,34,34,34,105,105,106,106,34,34,
            34,34,34,34,29,34,34,34,34,34,
            34,34,34,34,34,79,34,34,34,34,
            34,34,34,34,29,29,29,110,29,29,
            106,106,29,29,34,34,34,29,111,28,
            29,29,34,26,111,34,26,34,34,29,
            29,34,34,34,34,34,34,34,34,34,
            29,32,32,34,34,106,111,29,111,29,
            32,29,34,34,34,34,34,29,29,34,
            34
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            4,0,107,0,3,91,0,92,93,0,
            84,0,6,88,2,12,69,97,0,67,
            0,66,0,61,0,53,0,50,2,7,
            12,5,3,0,3,2,7,5,12,45,
            0,7,12,3,5,43,2,0,3,2,
            7,5,12,41,0,7,2,12,3,5,
            37,0,7,2,12,3,5,35,0,3,
            2,7,5,12,32,0,85,102,83,0,
            2,9,12,69,14,0,9,2,55,0,
            49,90,105,0,106,0,85,0,78,0,
            104,0,96,0,60,51,0,72,0,77,
            50,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            100,11,12,98,7,55,10,3,4,5,
            6,8,9,56,57,86,87,88,89,90,
            92,93,94,95,46,47,48,1,2,34,
            19,61,62,63,64,65,20,58,66,67,
            68,69,70,71,72,73,74,75,76,77,
            85,91,49,78,79,80,81,82,83,84,
            30,31,32,33,53,54,96,51,42,18,
            36,37,97,14,25,35,38,41,16,21,
            22,40,52,45,17,23,24,26,27,43,
            44,50,13,15,28,39,99,59,60
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            0,104,113,161,136,101,102,0,105,0,
            103,110,0,134,106,129,131,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,130,0,127,128,124,125,126,0,122,
            123,120,121,118,119,116,117,0,142,115,
            0,135,158,0,162,143,0,0,0,160,
            154,0,0,0,147,149,150,0,107,0,
            0,114,0,138,0,140,144,145,0,0,
            0,146,151,152,153,0,0,108,109,111,
            112,132,133,0,137,139,141,0,0,0,
            0,148,0,155,156,157,159,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            127,161,26,26,60,155,185,205,135,169,
            17,43,50,55,70,75,101,106,111,17,
            17,1,7,66,7,116,66,191,195,201,
            211,7,120,1,7,145,175,145,175,11,
            14,11,92,14,14,14,215,215,223,223,
            231,231,231,231,245,245,253,253,253
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            48,48,5,80,48,48,48,48,141,141,
            5,48,48,48,48,48,48,48,48,33,
            82,5,5,5,5,48,48,48,199,199,
            48,98,124,98,98,141,141,149,179,5,
            5,48,95,22,37,86,217,220,225,228,
            233,236,239,242,247,250,255,258,261
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            99,98,39,39,17,99,98,17,99,98,
            39,13,14,76,93,93,14,13,76,39,
            39,19,19,58,79,57,58,98,23,22,
            17,79,50,19,19,99,98,99,98,18,
            39,18,33,39,39,39,35,35,37,37,
            41,41,41,41,43,43,45,45,45
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            3,3,1,84,3,3,3,3,70,70,
            1,3,3,3,3,3,3,3,3,91,
            91,1,1,1,1,3,3,3,74,74,
            3,79,5,79,79,70,70,81,31,1,
            1,3,83,90,90,90,9,8,29,28,
            13,12,11,10,7,5,27,26,25
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            2,2,15,15,8,2,2,8,2,2,
            15,6,7,1,4,4,7,6,1,15,
            15,8,8,67,1,67,67,2,8,8,
            8,1,75,8,8,2,2,2,2,8,
            15,8,11,15,15,15,13,13,15,15,
            19,19,19,19,21,21,24,24,24
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            151,94,114,0,100,0,151,94,101,0,
            145,2,0,145,69,0,145,90,145,69,
            0,43,116,100,0,145,91,145,90,145,
            69,0,44,116,100,0,43,116,44,116,
            100,0,153,2,159,110,0,12,0,153,
            2,159,108,0,153,2,159,168,0,153,
            2,154,80,102,0,155,2,104,0,180,
            2,101,89,0,180,2,101,88,0,45,
            0,44,116,45,0,43,116,44,116,45,
            0,177,68,0,52,116,0,16,0,0,
            153,2,150,108,0,153,2,150,110,0,
            153,2,150,168,0,199,2,52,0,155,
            37,4,0,7,116,0,145,70,149,81,
            149,2,187,0,149,81,149,2,187,0,
            18,116,12,0,149,2,187,0,22,115,
            18,116,12,0,145,70,149,2,187,0,
            145,70,149,31,149,2,188,0,149,31,
            149,2,188,0,149,2,188,0,19,115,
            18,116,12,0,145,70,149,2,188,0,
            145,2,188,0,195,93,52,0,14,0,
            193,93,104,0,153,2,101,80,102,0,
            153,2,61,0,133,0,4,130,0,3,
            130,0,137,0,2,128,0,1,128,0,
            139,0,9,125,0,8,125,0,6,125,
            0,5,125,0,141,0,10,123,0,7,
            123,0,143,0,48,121,0,47,121,0,
            46,121,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            3224,406,0,386,0,406,3224,3191,3159,3127,
            3093,3059,3023,2987,2947,2907,2867,2827,2785,2743,
            2699,2655,2611,2516,2467,1372,2418,2369,2320,1158,
            1103,508,425,1052,1319,997,942,2271,2222,866,
            2173,2124,2075,2026,811,756,701,646,1977,1928,
            1879,2565,591,1266,1213,329,1830,1781,1732,1683,
            1634,1585,1536,1487,1438,0,3345,3256,3240,3339,
            3333,3274,3262,0,3410,3404,3399,1052,3392,3362,
            3372,3359,3335,3321,3328,3315,3223,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,186,4,182,185,6,72,71,78,76,
            96,201,77,184,37,14,15,158,101,158,
            101,158,101,158,101,158,101,103,102,190,
            102,155,102,104,52,37,37,37,37,37,
            37,37,202,80,184,205,80,203,5,2,
            2,68,53,29,2,108,111,110,1,104,
            52,8,38,4,106,36,35,34,33,32,
            114,101,102,61,116,133,69,137,141,139,
            146,143,189,148,4,206,1,154,101,155,
            199,177,177,145,159,150,159,150,159,150,
            93,93,94,94,80,2,86,85,89,88,
            9,8,145,1,29,28,7,5,13,12,
            11,10,92,27,26,25,5,5,37,2,
            1,37,2,31,83,2,2,2,2,2,
            2,193,145,97,29,194,195,4,151,151,
            154,101,153,151,168,108,101,108,39,187,
            105,188,101,101,90,133,133,139,139,143,
            141,141,141,169,171,155,169,153,153,179,
            102,179,153,153,87,97,31,31,5,31,
            79,79,2,2,159,150,150,94,2,2,
            2,2,145,3,31,182,3,153,153,2,
            2,151,149,149,145,4,180,95,181,180,
            91,37,37,153,153,79,81,70,31,70,
            37,31,145,149,145,149,145,70,70,145,
            145
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@pre",
            "^",
            "^^",
            "?",
            "$empty",
            "NUMERIC_OPERATION",
            "STRING_LITERAL",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "self",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "body",
            "derive",
            "init",
            "null",
            "attr",
            "oper",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "iterate",
            "forAll",
            "exists",
            "isUnique",
            "any",
            "one",
            "collect",
            "select",
            "reject",
            "collectNested",
            "sortedBy",
            "closure",
            "oclIsKindOf",
            "oclIsTypeOf",
            "oclAsType",
            "oclIsNew",
            "oclIsUndefined",
            "oclIsInvalid",
            "oclIsInState",
            "allInstances",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "Invalid",
            "OclMessage",
            "OclInvalid",
            "EOF_TOKEN",
            "IDENTIFIER",
            "INTEGER_RANGE_START",
            "ERROR_TOKEN",
            "iteratorIdentifier",
            "keywordAsIdentifier1",
            "binaryName",
            "simpleNameCS",
            "keywordAsName",
            "keywordAsName1",
            "unaryName",
            "iterateName",
            "iteratorName",
            "oclIsInStateName",
            "operationCS1",
            "operationCS2",
            "pathNameCS",
            "parametersCS",
            "variableCS",
            "oclExpressionCS",
            "impliesExpCS",
            "andOrXorExpCS",
            "andOrXorWithLet",
            "equalityExpCS",
            "equalityWithLet",
            "relationalExpCS",
            "relationalWithLet",
            "ifExpCSPrec",
            "additiveWithLet",
            "additiveExpCS",
            "multiplicativeExpCS",
            "multiplicativeWithLet",
            "unaryExpCS",
            "unaryWithLet",
            "dotArrowExpCS",
            "callExpCS",
            "messageExpCS",
            "keywordOperationCallExpCS",
            "argumentsCS",
            "collectionTypeIdentifierCS",
            "collectionLiteralPartsCS",
            "collectionLiteralPartCS",
            "variableListCS2",
            "featureCallExpCS",
            "loopExpCS",
            "typedVariableCS",
            "typeCS",
            "variableCS2",
            "variableListCS",
            "oclMessageArgumentsCS",
            "oclMessageArgCS",
            "packageDeclarationCSm",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "packageDeclarationCS",
            "contextDeclCSm",
            "contextDeclCS",
            "invOrDefCSm",
            "defExpressionCS",
            "prePostOrBodyDeclCSm",
            "ERROR_Colon",
            "ERROR_Empty",
            "ERROR_IsMarkedPreCS",
            "ERROR_PathNameCS",
            "ERROR_SimpleNameCS"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final static int
           ERROR_SYMBOL      = 1,
           SCOPE_UBOUND      = 58,
           SCOPE_SIZE        = 59,
           MAX_NAME_LENGTH   = 26;

    public final int getErrorSymbol() { return ERROR_SYMBOL; }
    public final int getScopeUbound() { return SCOPE_UBOUND; }
    public final int getScopeSize() { return SCOPE_SIZE; }
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int
           NUM_STATES        = 241,
           NT_OFFSET         = 99,
           LA_STATE_OFFSET   = 3795,
           MAX_LA            = 2,
           NUM_RULES         = 328,
           NUM_NONTERMINALS  = 109,
           NUM_SYMBOLS       = 208,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 3223,
           IDENTIFIER_SYMBOL = 4,
           EOFT_SYMBOL       = 73,
           EOLT_SYMBOL       = 73,
           ACCEPT_ACTION     = 3466,
           ERROR_ACTION      = 3467;

    public final static boolean BACKTRACK = true;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
