/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSLiteralImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>RDFS Literal</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSLiteralImpl#getLexicalForm <em>Lexical Form</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RDFSLiteralImpl extends RDFSResourceImpl implements RDFSLiteral {
	/**
	 * The default value of the '{@link #getLexicalForm() <em>Lexical Form</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLexicalForm()
	 * @generated
	 * @ordered
	 */
	protected static final String LEXICAL_FORM_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getLexicalForm() <em>Lexical Form</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLexicalForm()
	 * @generated
	 * @ordered
	 */
	protected String lexicalForm = LEXICAL_FORM_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RDFSLiteralImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getRDFSLiteral();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLexicalForm() {
		return lexicalForm;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLexicalForm(String newLexicalForm) {
		String oldLexicalForm = lexicalForm;
		lexicalForm = newLexicalForm;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM, oldLexicalForm, lexicalForm));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDFS_LITERAL__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.RDFS_LITERAL__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDFS_LITERAL__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDFS_LITERAL__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDFS_LITERAL__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDFS_LITERAL__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_LITERAL__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFBasePackage.RDFS_LITERAL__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFBasePackage.RDFS_LITERAL__RD_FTYPE:
				return getRDFtype();
			case RDFBasePackage.RDFS_LITERAL__RDF_SMEMBER:
				return getRDFSmember();
			case RDFBasePackage.RDFS_LITERAL__NODE_ID:
				return getNodeID();
			case RDFBasePackage.RDFS_LITERAL__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFBasePackage.RDFS_LITERAL__RDF_SLABEL:
				return getRDFSlabel();
			case RDFBasePackage.RDFS_LITERAL__URI_REF:
				return getUriRef();
			case RDFBasePackage.RDFS_LITERAL__SUBJECT_STATEMENT:
				return getSubjectStatement();
			case RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM:
				return getLexicalForm();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_LITERAL__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM:
				setLexicalForm((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_LITERAL__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__URI_REF:
				getUriRef().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
			case RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM:
				setLexicalForm(LEXICAL_FORM_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_LITERAL__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFBasePackage.RDFS_LITERAL__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
			case RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM:
				return LEXICAL_FORM_EDEFAULT == null ? lexicalForm != null : !LEXICAL_FORM_EDEFAULT.equals(lexicalForm);
		}
		return eDynamicIsSet(eFeature);
	}
    
	public boolean canAsType(Class newType)
    {
    	return newType.isAssignableFrom( this.getClass() ) ;
    }
    
	public RDFSResource asType(Class newType) throws UnsupportedViewTypeException
    {
		if ( ! canAsType(newType) )
			throw new UnsupportedViewTypeException();
    	return this ;
    }
    
	public RDFSResource forceAsType(Class newType) throws UnsupportedViewTypeException
    {
		return asType(newType);
    }
    
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (lexicalForm: ");
		result.append(lexicalForm);
		result.append(')');
		return result.toString();
	}

	public Object clone()
	{
		RDFSLiteral o = null ;
		try {
			o = (RDFSLiteral) super.clone() ;
		} catch (CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return o ;
	}
} //RDFSLiteralImpl
