/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceOperations
extends NamedElementOperations {
    protected NamespaceOperations() {
    }

    public static boolean validateMembersDistinguishable(Namespace namespace, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (!namespace.membersAreDistinguishable()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 7, UMLPlugin.INSTANCE.getString("_UI_Namespace_MembersDistinguishable_diagnostic", NamespaceOperations.getMessageSubstitutions(context, (Object)namespace)), new Object[]{namespace}));
            }
        }
        return result;
    }

    public static ElementImport createElementImport(Namespace namespace, PackageableElement element, VisibilityKind visibility) {
        if (element == null || namespace.getImportedElements().contains((Object)element)) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf((Object)visibility));
        }
        ElementImport elementImport = namespace.createElementImport(element);
        elementImport.setVisibility(visibility);
        return elementImport;
    }

    public static PackageImport createPackageImport(Namespace namespace, Package package_, VisibilityKind visibility) {
        if (package_ == null || namespace.getImportedPackages().contains((Object)package_)) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf((Object)visibility));
        }
        PackageImport packageImport = namespace.createPackageImport(package_);
        packageImport.setVisibility(visibility);
        return packageImport;
    }

    public static EList<PackageableElement> getImportedElements(Namespace namespace) {
        UniqueEList.FastCompare importedElements = new UniqueEList.FastCompare();
        for (ElementImport elementImport : namespace.getElementImports()) {
            PackageableElement importedElement = elementImport.getImportedElement();
            if (importedElement == null) continue;
            importedElements.add((Object)importedElement);
        }
        return ECollections.unmodifiableEList((EList)importedElements);
    }

    public static EList<Package> getImportedPackages(Namespace namespace) {
        UniqueEList.FastCompare importedPackages = new UniqueEList.FastCompare();
        for (PackageImport packageImport : namespace.getPackageImports()) {
            Package importedPackage = packageImport.getImportedPackage();
            if (importedPackage == null) continue;
            importedPackages.add((Object)importedPackage);
        }
        return ECollections.unmodifiableEList((EList)importedPackages);
    }

    public static EList<PackageableElement> getImportedMembers(Namespace namespace) {
        UniqueEList.FastCompare importedMembers = new UniqueEList.FastCompare();
        for (ElementImport elementImport : namespace.getElementImports()) {
            PackageableElement importedElement = elementImport.getImportedElement();
            if (importedElement == null) continue;
            importedMembers.add((Object)importedElement);
        }
        for (PackageImport packageImport : namespace.getPackageImports()) {
            Package importedPackage = packageImport.getImportedPackage();
            if (importedPackage == null) continue;
            importedMembers.addAll(importedPackage.visibleMembers());
        }
        return new UnionEObjectEList((InternalEObject)namespace, (EStructuralFeature)UMLPackage.Literals.NAMESPACE__IMPORTED_MEMBER, importedMembers.size(), importedMembers.toArray());
    }

    protected static EList<String> getNamesOfMember(Namespace namespace, NamedElement element, EList<Namespace> namespaces, EList<String> namesOfMember) {
        if (!namespaces.contains((Object)namespace)) {
            namespaces.add((Object)namespace);
            if (namespace.getOwnedMembers().contains((Object)element)) {
                String name = element.getName();
                if (!NamespaceOperations.isEmpty((String)name)) {
                    namesOfMember.add((Object)name);
                }
            } else {
                UniqueEList elementImportNames = new UniqueEList();
                for (ElementImport elementImport : namespace.getElementImports()) {
                    String name;
                    if (elementImport.getImportedElement() != element || NamespaceOperations.isEmpty((String)(name = elementImport.getName()))) continue;
                    elementImportNames.add((Object)name);
                }
                if (elementImportNames.isEmpty()) {
                    for (PackageImport packageImport : namespace.getPackageImports()) {
                        Package importedPackage = packageImport.getImportedPackage();
                        if (importedPackage == null || !importedPackage.visibleMembers().contains((Object)element)) continue;
                        NamespaceOperations.getNamesOfMember(importedPackage, element, namespaces, namesOfMember);
                    }
                } else {
                    namesOfMember.addAll((Collection)elementImportNames);
                }
            }
        }
        return namesOfMember;
    }

    public static EList<String> getNamesOfMember(Namespace namespace, NamedElement element) {
        return ECollections.unmodifiableEList(NamespaceOperations.getNamesOfMember(namespace, element, (EList<Namespace>)new UniqueEList.FastCompare(), (EList<String>)new UniqueEList()));
    }

    public static boolean membersAreDistinguishable(Namespace namespace) {
        EList<NamedElement> namespaceMembers = namespace.getMembers();
        for (NamedElement member : namespaceMembers) {
            for (NamedElement otherMember : namespaceMembers) {
                if (member == otherMember || member.isDistinguishableFrom(otherMember, namespace)) continue;
                return false;
            }
        }
        return true;
    }

    public static EList<PackageableElement> importMembers(Namespace namespace, EList<PackageableElement> imps) {
        UniqueEList.FastCompare importMembers = new UniqueEList.FastCompare();
        EList<NamedElement> ownedMembers = namespace.getOwnedMembers();
        block0: for (PackageableElement excludeCollision : namespace.excludeCollisions(imps)) {
            for (NamedElement ownedMember : ownedMembers) {
                if (!excludeCollision.isDistinguishableFrom(ownedMember, namespace)) continue block0;
            }
            importMembers.add((Object)excludeCollision);
        }
        return ECollections.unmodifiableEList((EList)importMembers);
    }

    public static EList<PackageableElement> excludeCollisions(Namespace namespace, EList<PackageableElement> imps) {
        UniqueEList.FastCompare excludeCollisions = new UniqueEList.FastCompare();
        block0: for (PackageableElement imp1 : imps) {
            for (PackageableElement imp2 : imps) {
                if (imp1 != imp2 && !imp1.isDistinguishableFrom(imp2, namespace)) continue block0;
            }
            excludeCollisions.add((Object)imp1);
        }
        return ECollections.unmodifiableEList((EList)excludeCollisions);
    }
}

