/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLUtil
extends UML2Util {
    public static final String OPTION__DISCARD = "DISCARD";
    public static final String OPTION__IGNORE = "IGNORE";
    public static final String OPTION__PROCESS = "PROCESS";
    public static final String OPTION__REPORT = "REPORT";
    protected static final String ANNOTATION__DUPLICATES = "duplicates";
    protected static final String ANNOTATION__REDEFINES = "redefines";
    protected static final String ANNOTATION__SUBSETS = "subsets";
    protected static final String ANNOTATION__UNION = "union";
    protected static final String ENUMERATION_LITERAL__ATTRIBUTE = "Attribute";
    protected static final String ENUMERATION_LITERAL__ATTRIBUTE_WILDCARD = "AttributeWilcard";
    protected static final String ENUMERATION_LITERAL__ELEMENT = "Element";
    protected static final String ENUMERATION_LITERAL__ELEMENT_ONLY = "ElementOnly";
    protected static final String ENUMERATION_LITERAL__ELEMENT_WILDCARD = "ElementWildcard";
    protected static final String ENUMERATION_LITERAL__EMPTY = "Empty";
    protected static final String ENUMERATION_LITERAL__GROUP = "Group";
    protected static final String ENUMERATION_LITERAL__MIXED = "Mixed";
    protected static final String ENUMERATION_LITERAL__NONE = "None";
    protected static final String ENUMERATION_LITERAL__SIMPLE = "Simple";
    protected static final String ENUMERATION_LITERAL__READ_ONLY = "ReadOnly";
    protected static final String ENUMERATION_LITERAL__READ_ONLY_UNSETTABLE = "ReadOnlyUnsettable";
    protected static final String ENUMERATION_LITERAL__READ_WRITE = "ReadWrite";
    protected static final String ENUMERATION_LITERAL__READ_WRITE_UNSETTABLE = "ReadWriteUnsettable";
    protected static final String ENUMERATION_LITERAL__UNSPECIFIED = "Unspecified";
    protected static final String ENUMERATION__CONTENT_KIND = "ContentKind";
    protected static final String ENUMERATION__FEATURE_KIND = "FeatureKind";
    protected static final String ENUMERATION__VISIBILITY_KIND = "VisibilityKind";
    public static final String STEREOTYPE__E_ATTRIBUTE = "EAttribute";
    public static final String STEREOTYPE__E_CLASS = "EClass";
    public static final String STEREOTYPE__E_DATA_TYPE = "EDataType";
    public static final String STEREOTYPE__E_ENUM = "EEnum";
    public static final String STEREOTYPE__E_ENUM_LITERAL = "EEnumLiteral";
    public static final String STEREOTYPE__E_OPERATION = "EOperation";
    public static final String STEREOTYPE__E_PACKAGE = "EPackage";
    public static final String STEREOTYPE__E_PARAMETER = "EParameter";
    public static final String STEREOTYPE__E_REFERENCE = "EReference";
    public static final String TAG_DEFINITION__ATTRIBUTE_NAME = "attributeName";
    public static final String TAG_DEFINITION__BASE_PACKAGE = "basePackage";
    public static final String TAG_DEFINITION__CLASS_NAME = "className";
    public static final String TAG_DEFINITION__DATA_TYPE_NAME = "dataTypeName";
    public static final String TAG_DEFINITION__ENUM_NAME = "enumName";
    public static final String TAG_DEFINITION__ENUM_LITERAL_NAME = "enumLiteralName";
    public static final String TAG_DEFINITION__INSTANCE_CLASS_NAME = "instanceClassName";
    public static final String TAG_DEFINITION__IS_ID = "isID";
    public static final String TAG_DEFINITION__IS_RESOLVE_PROXIES = "isResolveProxies";
    public static final String TAG_DEFINITION__IS_TRANSIENT = "isTransient";
    public static final String TAG_DEFINITION__IS_UNSETTABLE = "isUnsettable";
    public static final String TAG_DEFINITION__IS_VOLATILE = "isVolatile";
    public static final String TAG_DEFINITION__NS_PREFIX = "nsPrefix";
    public static final String TAG_DEFINITION__NS_URI = "nsURI";
    public static final String TAG_DEFINITION__OPERATION_NAME = "operationName";
    public static final String TAG_DEFINITION__PACKAGE_NAME = "packageName";
    public static final String TAG_DEFINITION__PARAMETER_NAME = "parameterName";
    public static final String TAG_DEFINITION__PREFIX = "prefix";
    public static final String TAG_DEFINITION__REFERENCE_NAME = "referenceName";
    public static final String TAG_DEFINITION__VISIBILITY = "visibility";
    public static final String TAG_DEFINITION__XML_CONTENT_KIND = "xmlContentKind";
    public static final String TAG_DEFINITION__XML_FEATURE_KIND = "xmlFeatureKind";
    public static final String TAG_DEFINITION__XML_NAME = "xmlName";
    public static final String TAG_DEFINITION__XML_NAMESPACE = "xmlNamespace";

    public static String getQualifiedText(EObject eObject) {
        return UMLUtil.getQualifiedText((EObject)eObject, (UML2Util.QualifiedTextProvider)QualifiedTextProvider.DEFAULT);
    }

    protected static String getQualifiedName(NamedElement namedElement, String separator) {
        String name = namedElement.getName();
        if (UMLUtil.isEmpty((String)name)) {
            return null;
        }
        StringBuffer qualifiedName = new StringBuffer(name);
        Iterator allNamespaces = namedElement.allNamespaces().iterator();
        while (allNamespaces.hasNext()) {
            String namespaceName = ((Namespace)allNamespaces.next()).getName();
            if (UMLUtil.isEmpty((String)namespaceName)) {
                return null;
            }
            qualifiedName.insert(0, separator);
            qualifiedName.insert(0, namespaceName);
        }
        return qualifiedName.toString();
    }

    public static Collection findNamedElements(ResourceSet resourceSet, String qualifiedName) {
        return UMLUtil.findNamedElements(resourceSet, qualifiedName, false);
    }

    public static Collection findNamedElements(ResourceSet resourceSet, String qualifiedName, boolean ignoreCase) {
        return UMLUtil.findNamedElements(resourceSet, qualifiedName, ignoreCase, UMLPackage.Literals.NAMED_ELEMENT);
    }

    public static Collection findNamedElements(ResourceSet resourceSet, String qualifiedName, boolean ignoreCase, EClass eClass) {
        EList resources;
        int size;
        if (!UMLUtil.isEmpty((String)qualifiedName) && UMLPackage.Literals.NAMED_ELEMENT.isSuperTypeOf(eClass) && (size = (resources = resourceSet.getResources()).size()) > 0) {
            UniqueEList.FastCompare namedElements = new UniqueEList.FastCompare();
            int i = 0;
            while (i < size) {
                UMLUtil.findNamedElements((Collection)((Resource)resources.get(i)).getContents(), qualifiedName, ignoreCase, eClass, (Collection)namedElements);
                ++i;
            }
            return ECollections.unmodifiableEList((EList)namedElements);
        }
        return ECollections.EMPTY_ELIST;
    }

    public static Collection findNamedElements(Resource resource, String qualifiedName) {
        return UMLUtil.findNamedElements(resource, qualifiedName, false);
    }

    public static Collection findNamedElements(Resource resource, String qualifiedName, boolean ignoreCase) {
        return UMLUtil.findNamedElements(resource, qualifiedName, ignoreCase, UMLPackage.Literals.NAMED_ELEMENT);
    }

    public static Collection findNamedElements(Resource resource, String qualifiedName, boolean ignoreCase, EClass eClass) {
        EList contents;
        if (!UMLUtil.isEmpty((String)qualifiedName) && UMLPackage.Literals.NAMED_ELEMENT.isSuperTypeOf(eClass) && !(contents = resource.getContents()).isEmpty()) {
            UniqueEList.FastCompare namedElements = new UniqueEList.FastCompare();
            UMLUtil.findNamedElements((Collection)contents, qualifiedName, ignoreCase, eClass, (Collection)namedElements);
            return ECollections.unmodifiableEList((EList)namedElements);
        }
        return ECollections.EMPTY_ELIST;
    }

    protected static Collection findNamedElements(Collection eObjects, String qualifiedName, boolean ignoreCase, EClass eClass, Collection namedElements) {
        int index = qualifiedName.indexOf("::");
        if (index == -1) {
            Iterator members = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)eClass).iterator();
            while (members.hasNext()) {
                NamedElement member = (NamedElement)members.next();
                if (!(ignoreCase ? qualifiedName.equalsIgnoreCase(member.getName()) : qualifiedName.equals(member.getName()))) continue;
                namedElements.add(member);
            }
        } else {
            String name = qualifiedName.substring(0, index);
            qualifiedName = qualifiedName.substring(index + "::".length());
            Iterator namespaces = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)UMLPackage.Literals.NAMESPACE).iterator();
            while (namespaces.hasNext()) {
                Namespace namespace = (Namespace)namespaces.next();
                if (!(ignoreCase ? name.equalsIgnoreCase(namespace.getName()) : name.equals(namespace.getName()))) continue;
                UMLUtil.findNamedElements((Collection)namespace.getMembers(), qualifiedName, ignoreCase, eClass, namedElements);
            }
        }
        return namedElements;
    }

    public static Profile getProfile(EPackage definition) {
        EAnnotation eAnnotation;
        EObject eContainer = definition.eContainer();
        if (eContainer instanceof EAnnotation && UMLUtil.safeEquals((Object)(eAnnotation = (EAnnotation)eContainer).getSource(), (Object)"http://www.eclipse.org/uml2/2.0.0/UML") && (eContainer = eAnnotation.eContainer()) instanceof Profile) {
            return (Profile)eContainer;
        }
        return null;
    }

    protected static EClassifier getEClassifier(Class metaclass) {
        return UMLPackage.eINSTANCE.getEClassifier(metaclass.getName());
    }

    protected static NamedElement getNamedElement(ENamedElement definition) {
        if (definition instanceof EClassifier) {
            Object reference;
            EList references;
            EAnnotation eAnnotation = definition.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
            if (eAnnotation != null && !(references = eAnnotation.getReferences()).isEmpty() && (reference = references.get(0)) instanceof Classifier) {
                return (NamedElement)reference;
            }
            return null;
        }
        if (definition instanceof EStructuralFeature) {
            Class class_ = (Class)UMLUtil.getNamedElement((ENamedElement)((EStructuralFeature)definition).getEContainingClass());
            if (class_ != null) {
                String name = definition.getName();
                Iterator ownedAttributes = class_.getOwnedAttributes().iterator();
                while (ownedAttributes.hasNext()) {
                    Property ownedAttribute = (Property)ownedAttributes.next();
                    if (!UMLUtil.safeEquals((Object)UMLUtil.getValidJavaIdentifier((String)ownedAttribute.getName()), (Object)name)) continue;
                    return ownedAttribute;
                }
            }
            return null;
        }
        if (definition instanceof EEnumLiteral) {
            Enumeration enumeration = (Enumeration)UMLUtil.getNamedElement((ENamedElement)((EEnumLiteral)definition).getEEnum());
            return enumeration == null ? null : enumeration.getOwnedLiteral(definition.getName());
        }
        if (definition instanceof EPackage) {
            return UMLUtil.getProfile((EPackage)definition);
        }
        return null;
    }

    protected static Stereotype getStereotype(EClass definition) {
        NamedElement namedElement = UMLUtil.getNamedElement((ENamedElement)definition);
        return namedElement instanceof Stereotype ? (Stereotype)namedElement : null;
    }

    public static Stereotype getStereotype(EObject stereotypeApplication) {
        return stereotypeApplication == null ? null : UMLUtil.getStereotype(stereotypeApplication.eClass());
    }

    public static Element getBaseElement(EObject stereotypeApplication) {
        EClass eClass;
        if (stereotypeApplication != null && UMLUtil.getStereotype(eClass = stereotypeApplication.eClass()) != null) {
            Iterator eAllStructuralFeatures = eClass.getEAllStructuralFeatures().iterator();
            while (eAllStructuralFeatures.hasNext()) {
                Object value;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eAllStructuralFeatures.next();
                if (!eStructuralFeature.getName().startsWith("base_") || !((value = stereotypeApplication.eGet(eStructuralFeature)) instanceof Element)) continue;
                return (Element)value;
            }
        }
        return null;
    }

    public static void setBaseElement(EObject stereotypeApplication, Element element) {
        EClass eClass;
        if (stereotypeApplication != null && UMLUtil.getStereotype(eClass = stereotypeApplication.eClass()) != null) {
            Iterator eAllStructuralFeatures = eClass.getEAllStructuralFeatures().iterator();
            while (eAllStructuralFeatures.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eAllStructuralFeatures.next();
                if (!eStructuralFeature.getName().startsWith("base_") || element != null && !eStructuralFeature.getEType().isInstance((Object)element)) continue;
                stereotypeApplication.eSet(eStructuralFeature, (Object)element);
            }
        }
    }

    protected static EObject applyStereotype(Element element, EClass definition) {
        EObject stereotypeApplication = EcoreUtil.create((EClass)definition);
        CacheAdapter.INSTANCE.adapt((Notifier)stereotypeApplication);
        Resource eResource = element.eResource();
        if (eResource != null) {
            eResource.getContents().add((Object)stereotypeApplication);
        }
        UMLUtil.setBaseElement(stereotypeApplication, element);
        return stereotypeApplication;
    }

    public static EObject safeApplyStereotype(Element element, Stereotype stereotype) {
        if (stereotype != null) {
            Package nearestPackage;
            EObject stereotypeApplication = element.getStereotypeApplication(stereotype);
            if (stereotypeApplication == null && (nearestPackage = element.getNearestPackage()) != null) {
                Profile profile = stereotype.getProfile();
                if (!nearestPackage.getAllAppliedProfiles().contains((Object)profile)) {
                    EList allOwningPackages = nearestPackage.allOwningPackages();
                    int size = allOwningPackages.size();
                    (size > 0 ? (Package)allOwningPackages.get(size - 1) : nearestPackage).applyProfile(profile);
                }
                stereotypeApplication = element.applyStereotype(stereotype);
            }
            return stereotypeApplication;
        }
        return null;
    }

    protected static Property getTagDefinition(Stereotype stereotype, final String propertyName) {
        return (Property)UMLUtil.findEObject((Collection)stereotype.getAllAttributes(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                return UMLUtil.safeEquals((Object)((Property)eObject).getName(), (Object)propertyName);
            }
        });
    }

    protected static Object getTaggedValue(Element element, String qualifiedStereotypeName, String propertyName) {
        Stereotype stereotype = element.getAppliedStereotype(qualifiedStereotypeName);
        return stereotype == null ? null : element.getValue(stereotype, propertyName);
    }

    public static boolean setTaggedValue(Element element, Stereotype stereotype, String propertyName, Object value) {
        if (UMLUtil.safeApplyStereotype(element, stereotype) != null) {
            element.setValue(stereotype, propertyName, value);
            return true;
        }
        return false;
    }

    protected static EList getOwnedAttributes(Type type) {
        return (EList)new UMLSwitch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.getOwnedAttributes();
            }

            public Object caseDataType(DataType dataType) {
                return dataType.getOwnedAttributes();
            }

            public Object caseInterface(Interface interface_) {
                return interface_.getOwnedAttributes();
            }

            public Object caseSignal(Signal signal) {
                return signal.getOwnedAttributes();
            }

            public Object caseStructuredClassifier(StructuredClassifier structuredClassifier) {
                return structuredClassifier.getOwnedAttributes();
            }

            public Object doSwitch(EObject eObject) {
                return eObject == null ? null : super.doSwitch(eObject);
            }
        }.doSwitch((EObject)type);
    }

    protected static EList getOwnedOperations(Type type) {
        return (EList)new UMLSwitch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.getOwnedOperations();
            }

            public Object caseClass(Class class_) {
                return class_.getOwnedOperations();
            }

            public Object caseDataType(DataType dataType) {
                return dataType.getOwnedOperations();
            }

            public Object caseInterface(Interface interface_) {
                return interface_.getOwnedOperations();
            }

            public Object doSwitch(EObject eObject) {
                return eObject == null ? null : super.doSwitch(eObject);
            }
        }.doSwitch((EObject)type);
    }

    protected static EList getRedefinedFeatures(Feature feature) {
        return (EList)new UMLSwitch(){

            public Object caseOperation(Operation operation) {
                return operation.getRedefinedOperations();
            }

            public Object caseProperty(Property property) {
                return property.getRedefinedProperties();
            }

            public Object defaultCase(EObject eObject) {
                return ECollections.EMPTY_ELIST;
            }
        }.doSwitch((EObject)feature);
    }

    protected static boolean isRedefinitionValid(Feature redefiningFeature, Feature redefinedFeature) {
        return redefinedFeature.isConsistentWith(redefiningFeature);
    }

    protected static Collection findValidRedefinitions(Feature redefiningFeature, String name) {
        UniqueEList.FastCompare redefinedFeatures = new UniqueEList.FastCompare();
        Iterator redefinitionContexts = redefiningFeature.getRedefinitionContexts().iterator();
        while (redefinitionContexts.hasNext()) {
            UMLUtil.findValidRedefinitions((Collection)redefinedFeatures, redefiningFeature, name, (Classifier)redefinitionContexts.next());
        }
        return redefinedFeatures;
    }

    protected static Collection findValidRedefinitions(Collection redefinedFeatures, Feature redefiningFeature, final String name, Classifier redefinitionContext) {
        Feature redefinedFeature = (Feature)UMLUtil.findEObject((Collection)redefinitionContext.getFeatures(), (UML2Util.EObjectMatcher)new UML2Util.EClassMatcher((EObject)redefiningFeature){

            public boolean matches(EObject otherEObject) {
                if (super.matches(otherEObject)) {
                    Feature otherFeature = (Feature)otherEObject;
                    return this.eObject != otherFeature && UMLUtil.safeEquals((Object)otherFeature.getName(), (Object)name) && UMLUtil.isRedefinitionValid((Feature)this.eObject, otherFeature);
                }
                return false;
            }
        });
        if (redefinedFeature == null) {
            Iterator generals = redefinitionContext.getGenerals().iterator();
            while (generals.hasNext()) {
                UMLUtil.findValidRedefinitions(redefinedFeatures, redefiningFeature, name, (Classifier)generals.next());
            }
        } else {
            redefinedFeatures.add(redefinedFeature);
        }
        return redefinedFeatures;
    }

    protected static boolean isSubsetValid(Property subsettingProperty, Property subsettedProperty) {
        Iterator subsettingContexts = subsettingProperty.subsettingContext().iterator();
        while (subsettingContexts.hasNext()) {
            Classifier subsettingContext = (Classifier)subsettingContexts.next();
            Iterator subsettedContexts = subsettedProperty.subsettingContext().iterator();
            while (subsettedContexts.hasNext()) {
                if (subsettingContext.conformsTo((Classifier)subsettedContexts.next())) continue;
                return false;
            }
        }
        return true;
    }

    protected static Collection findValidSubsets(Property subsettingProperty, String name) {
        UniqueEList.FastCompare subsettedProperties = new UniqueEList.FastCompare();
        Iterator subsettingContexts = subsettingProperty.subsettingContext().iterator();
        while (subsettingContexts.hasNext()) {
            UMLUtil.findValidSubsets((Collection)subsettedProperties, subsettingProperty, name, (Classifier)subsettingContexts.next());
        }
        return subsettedProperties;
    }

    protected static Collection findValidSubsets(Collection subsettedProperties, Property subsettingProperty, final String name, Classifier subsettingContext) {
        Property subsettedProperty = (Property)UMLUtil.findEObject((Collection)subsettingContext.getAttributes(), (UML2Util.EObjectMatcher)new UML2Util.EClassMatcher((EObject)subsettingProperty){

            public boolean matches(EObject otherEObject) {
                if (super.matches(otherEObject)) {
                    Property otherProperty = (Property)otherEObject;
                    return this.eObject != otherProperty && UMLUtil.safeEquals((Object)otherProperty.getName(), (Object)name) && UMLUtil.isSubsetValid((Property)this.eObject, otherProperty);
                }
                return false;
            }
        });
        if (subsettedProperty == null) {
            Iterator generals = subsettingContext.getGenerals().iterator();
            while (generals.hasNext()) {
                UMLUtil.findValidSubsets(subsettedProperties, subsettingProperty, name, (Classifier)generals.next());
            }
        } else {
            subsettedProperties.add(subsettedProperty);
        }
        return subsettedProperties;
    }

    public static void merge(Package package_, Map options) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_STATICITY")) {
            options.put("DIFFERENT_PROPERTY_STATICITY", OPTION__IGNORE);
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_UNIQUENESS")) {
            options.put("DIFFERENT_PROPERTY_UNIQUENESS", OPTION__IGNORE);
        }
        if (!options.containsKey("REDUNDANT_GENERALIZATIONS")) {
            options.put("REDUNDANT_GENERALIZATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("IMPLICIT_REDEFINITIONS")) {
            options.put("IMPLICIT_REDEFINITIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("INVALID_REDEFINITIONS")) {
            options.put("INVALID_REDEFINITIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("INVALID_SUBSETS")) {
            options.put("INVALID_SUBSETS", OPTION__IGNORE);
        }
        if (!options.containsKey("EMPTY_UNIONS")) {
            options.put("EMPTY_UNIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("ASSOCIATION_SPECIALIZATIONS")) {
            options.put("ASSOCIATION_SPECIALIZATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("CAPABILITIES")) {
            options.put("CAPABILITIES", OPTION__IGNORE);
        }
        UMLUtil.merge(package_, options, null, null);
    }

    public static void merge(Package package_, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_STATICITY")) {
            options.put("DIFFERENT_PROPERTY_STATICITY", OPTION__REPORT);
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_UNIQUENESS")) {
            options.put("DIFFERENT_PROPERTY_UNIQUENESS", OPTION__REPORT);
        }
        if (!options.containsKey("REDUNDANT_GENERALIZATIONS")) {
            options.put("REDUNDANT_GENERALIZATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("IMPLICIT_REDEFINITIONS")) {
            options.put("IMPLICIT_REDEFINITIONS", OPTION__REPORT);
        }
        if (!options.containsKey("INVALID_REDEFINITIONS")) {
            options.put("INVALID_REDEFINITIONS", OPTION__REPORT);
        }
        if (!options.containsKey("INVALID_SUBSETS")) {
            options.put("INVALID_SUBSETS", OPTION__REPORT);
        }
        if (!options.containsKey("EMPTY_UNIONS")) {
            options.put("EMPTY_UNIONS", OPTION__REPORT);
        }
        if (!options.containsKey("ASSOCIATION_SPECIALIZATIONS")) {
            options.put("ASSOCIATION_SPECIALIZATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("CAPABILITIES")) {
            options.put("CAPABILITIES", OPTION__REPORT);
        }
        new PackageMerger().merge(package_, options, diagnostics, context);
    }

    public static Collection convertToEcore(Package package_, Map options) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("ECORE_TAGGED_VALUES")) {
            options.put("ECORE_TAGGED_VALUES", OPTION__IGNORE);
        }
        if (!options.containsKey("REDEFINING_OPERATIONS")) {
            options.put("REDEFINING_OPERATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("REDEFINING_PROPERTIES")) {
            options.put("REDEFINING_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("SUBSETTING_PROPERTIES")) {
            options.put("SUBSETTING_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("UNION_PROPERTIES")) {
            options.put("UNION_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("DERIVED_FEATURES")) {
            options.put("DERIVED_FEATURES", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_OPERATIONS")) {
            options.put("DUPLICATE_OPERATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_OPERATION_INHERITANCE")) {
            options.put("DUPLICATE_OPERATION_INHERITANCE", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_FEATURES")) {
            options.put("DUPLICATE_FEATURES", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_FEATURE_INHERITANCE")) {
            options.put("DUPLICATE_FEATURE_INHERITANCE", OPTION__IGNORE);
        }
        if (!options.containsKey("SUPER_CLASS_ORDER")) {
            options.put("SUPER_CLASS_ORDER", OPTION__IGNORE);
        }
        if (!options.containsKey("ANNOTATION_DETAILS")) {
            options.put("ANNOTATION_DETAILS", OPTION__IGNORE);
        }
        return UMLUtil.convertToEcore(package_, options, null, null);
    }

    public static Collection convertToEcore(Package package_, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("ECORE_TAGGED_VALUES")) {
            options.put("ECORE_TAGGED_VALUES", OPTION__REPORT);
        }
        if (!options.containsKey("REDEFINING_OPERATIONS")) {
            options.put("REDEFINING_OPERATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("REDEFINING_PROPERTIES")) {
            options.put("REDEFINING_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("SUBSETTING_PROPERTIES")) {
            options.put("SUBSETTING_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("UNION_PROPERTIES")) {
            options.put("UNION_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("DERIVED_FEATURES")) {
            options.put("DERIVED_FEATURES", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_OPERATIONS")) {
            options.put("DUPLICATE_OPERATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_OPERATION_INHERITANCE")) {
            options.put("DUPLICATE_OPERATION_INHERITANCE", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_FEATURES")) {
            options.put("DUPLICATE_FEATURES", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_FEATURE_INHERITANCE")) {
            options.put("DUPLICATE_FEATURE_INHERITANCE", OPTION__REPORT);
        }
        if (!options.containsKey("SUPER_CLASS_ORDER")) {
            options.put("SUPER_CLASS_ORDER", OPTION__REPORT);
        }
        if (!options.containsKey("ANNOTATION_DETAILS")) {
            options.put("ANNOTATION_DETAILS", OPTION__REPORT);
        }
        return new UML2EcoreConverter().convert(Collections.singleton(package_), options, diagnostics, context);
    }

    public static Collection convertToEcore(Profile profile, Map options) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("ECORE_TAGGED_VALUES")) {
            options.put("ECORE_TAGGED_VALUES", OPTION__IGNORE);
        }
        if (!options.containsKey("REDEFINING_OPERATIONS")) {
            options.put("REDEFINING_OPERATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("REDEFINING_PROPERTIES")) {
            options.put("REDEFINING_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("SUBSETTING_PROPERTIES")) {
            options.put("SUBSETTING_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("UNION_PROPERTIES")) {
            options.put("UNION_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("DERIVED_FEATURES")) {
            options.put("DERIVED_FEATURES", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_OPERATIONS")) {
            options.put("DUPLICATE_OPERATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_OPERATION_INHERITANCE")) {
            options.put("DUPLICATE_OPERATION_INHERITANCE", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_FEATURES")) {
            options.put("DUPLICATE_FEATURES", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_FEATURE_INHERITANCE")) {
            options.put("DUPLICATE_FEATURE_INHERITANCE", OPTION__IGNORE);
        }
        if (!options.containsKey("SUPER_CLASS_ORDER")) {
            options.put("SUPER_CLASS_ORDER", OPTION__IGNORE);
        }
        if (!options.containsKey("ANNOTATION_DETAILS")) {
            options.put("ANNOTATION_DETAILS", OPTION__IGNORE);
        }
        return UMLUtil.convertToEcore(profile, options, null, null);
    }

    public static Collection convertToEcore(Profile profile, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("ECORE_TAGGED_VALUES")) {
            options.put("ECORE_TAGGED_VALUES", OPTION__REPORT);
        }
        if (!options.containsKey("REDEFINING_OPERATIONS")) {
            options.put("REDEFINING_OPERATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("REDEFINING_PROPERTIES")) {
            options.put("REDEFINING_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("SUBSETTING_PROPERTIES")) {
            options.put("SUBSETTING_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("UNION_PROPERTIES")) {
            options.put("UNION_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("DERIVED_FEATURES")) {
            options.put("DERIVED_FEATURES", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_OPERATIONS")) {
            options.put("DUPLICATE_OPERATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_OPERATION_INHERITANCE")) {
            options.put("DUPLICATE_OPERATION_INHERITANCE", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_FEATURES")) {
            options.put("DUPLICATE_FEATURES", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_FEATURE_INHERITANCE")) {
            options.put("DUPLICATE_FEATURE_INHERITANCE", OPTION__REPORT);
        }
        if (!options.containsKey("SUPER_CLASS_ORDER")) {
            options.put("SUPER_CLASS_ORDER", OPTION__REPORT);
        }
        if (!options.containsKey("ANNOTATION_DETAILS")) {
            options.put("ANNOTATION_DETAILS", OPTION__REPORT);
        }
        Collection ePackages = new Profile2EPackageConverter().convert(Collections.singleton(profile), options, null, null);
        TreeIterator allContents = EcoreUtil.getAllContents((Collection)ePackages);
        while (allContents.hasNext()) {
            new EcoreSwitch(){

                public Object caseEAttribute(EAttribute eAttribute) {
                    try {
                        eAttribute.getDefaultValue();
                    }
                    catch (Exception exception) {
                        eAttribute.setDefaultValueLiteral(null);
                    }
                    return eAttribute;
                }

                public Object caseEDataType(EDataType eDataType) {
                    try {
                        eDataType.getInstanceClass();
                    }
                    catch (Exception exception) {
                        eDataType.setInstanceClassName(EcorePackage.Literals.ESTRING.getInstanceClassName());
                    }
                    return eDataType;
                }
            }.doSwitch((EObject)allContents.next());
        }
        return ePackages;
    }

    public static Collection convertFromEcore(EPackage ePackage, Map options) {
        if (options == null) {
            options = new HashMap();
        }
        return UMLUtil.convertFromEcore(ePackage, options, null, null);
    }

    public static Collection convertFromEcore(EPackage ePackage, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap();
        }
        return new Ecore2UMLConverter().convert(Collections.singleton(ePackage), options, diagnostics, context);
    }

    static /* synthetic */ StringBuffer access$0(EObject eObject, UML2Util.QualifiedTextProvider qualifiedTextProvider, StringBuffer stringBuffer) {
        return UML2Util.getQualifiedTextSegment((EObject)eObject, (UML2Util.QualifiedTextProvider)qualifiedTextProvider, (StringBuffer)stringBuffer);
    }

    static /* synthetic */ int access$1(int n, int n2) {
        return UML2Util.getLesserLowerBound((int)n, (int)n2);
    }

    static /* synthetic */ int access$2(int n, int n2) {
        return UML2Util.getGreaterUpperBound((int)n, (int)n2);
    }

    static /* synthetic */ Object[] access$3(Map map, Object object, Object object2) {
        return UML2Util.getMessageSubstitutions((Map)map, (Object)object, (Object)object2);
    }

    static /* synthetic */ Object[] access$4(Map map, Object object, Object object2, Object object3) {
        return UML2Util.getMessageSubstitutions((Map)map, (Object)object, (Object)object2, (Object)object3);
    }

    static /* synthetic */ Object[] access$5(Map map, Object object) {
        return UML2Util.getMessageSubstitutions((Map)map, (Object)object);
    }

    static /* synthetic */ void access$6(EModelElement eModelElement, String string) {
        UML2Util.addDocumentation((EModelElement)eModelElement, (String)string);
    }

    static /* synthetic */ boolean access$7(EModelElement eModelElement, String string) {
        return UML2Util.addConstraint((EModelElement)eModelElement, (String)string);
    }

    static /* synthetic */ EClassifier access$8(EClassifier eClassifier, EClassifier eClassifier2) {
        return UML2Util.getCommonEType((EClassifier)eClassifier, (EClassifier)eClassifier2);
    }

    static /* synthetic */ Collection access$9(Collection collection) {
        return UML2Util.getRootContainers((Collection)collection);
    }

    public static class Ecore2UMLConverter
    extends EcoreSwitch
    implements UML2Util.Converter {
        public static final String OPTION__ECORE_TAGGED_VALUES = "ECORE_TAGGED_VALUES";
        public static final String OPTION__REDEFINES_ANNOTATIONS = "REDEFINES_ANNOTATIONS";
        public static final String OPTION__SUBSETS_ANNOTATIONS = "SUBSETS_ANNOTATIONS";
        public static final String OPTION__UNION_ANNOTATIONS = "UNION_ANNOTATIONS";
        public static final String OPTION__ANNOTATION_DETAILS = "ANNOTATION_DETAILS";
        private static final int DIAGNOSTIC_CODE_OFFSET = 3000;
        public static final int ECORE_TAGGED_VALUE = 3001;
        public static final int REDEFINES_ANNOTATION = 3002;
        public static final int SUBSETS_ANNOTATION = 3003;
        public static final int UNION_ANNOTATION = 3004;
        public static final int ANNOTATION_DETAILS = 3005;
        protected final Map eModelElementToElementMap = new LinkedHashMap();
        protected Collection ePackages = null;

        protected Model getEcorePrimitiveTypesLibrary(EModelElement eModelElement) {
            ResourceSet resourceSet;
            Resource eResource = eModelElement.eResource();
            if (eResource != null && (resourceSet = eResource.getResourceSet()) != null) {
                return (Model)UMLUtil.load((ResourceSet)resourceSet, (URI)URI.createURI((String)"pathmap://UML_LIBRARIES/EcorePrimitiveTypes.library.uml"), (EClass)UMLPackage.Literals.MODEL);
            }
            return null;
        }

        protected PrimitiveType getEcorePrimitiveType(EModelElement eModelElement, String name) {
            Model ecorePrimitiveTypesLibrary = this.getEcorePrimitiveTypesLibrary(eModelElement);
            return ecorePrimitiveTypesLibrary != null ? (PrimitiveType)ecorePrimitiveTypesLibrary.getOwnedType(name) : null;
        }

        protected Type getType(EModelElement eModelElement, EClassifier eType) {
            Type type = null;
            if (eType != null) {
                EPackage ePackage;
                String name = eType.getName();
                if (!UMLUtil.isEmpty((String)name) && eType instanceof EDataType && (ePackage = eType.getEPackage()) != null) {
                    String nsURI = ePackage.getNsURI();
                    if ("http://www.eclipse.org/emf/2003/XMLType".equals(nsURI)) {
                        String instanceClassName = eType.getInstanceClassName();
                        if ("java.math.BigDecimal".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBIG_DECIMAL.getName());
                        } else if ("java.math.BigInteger".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBIG_INTEGER.getName());
                        } else if ("boolean".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBOOLEAN.getName());
                        } else if ("java.lang.Boolean".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBOOLEAN_OBJECT.getName());
                        } else if ("byte".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBYTE.getName());
                        } else if ("byte[]".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBYTE_ARRAY.getName());
                        } else if ("java.lang.Byte".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EBYTE_OBJECT.getName());
                        } else if ("double".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EDOUBLE.getName());
                        } else if ("java.lang.Double".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EDOUBLE_OBJECT.getName());
                        } else if ("java.util.List".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EE_LIST.getName());
                        } else if ("float".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EFLOAT.getName());
                        } else if ("java.lang.Float".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EFLOAT_OBJECT.getName());
                        } else if ("int".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EINT.getName());
                        } else if ("java.lang.Integer".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EINTEGER_OBJECT.getName());
                        } else if ("java.lang.Object".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.EJAVA_OBJECT.getName());
                        } else if ("long".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.ELONG.getName());
                        } else if ("java.lang.Long".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.ELONG_OBJECT.getName());
                        } else if ("short".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.ESHORT.getName());
                        } else if ("java.lang.Short".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.ESHORT_OBJECT.getName());
                        } else if ("java.lang.String".equals(instanceClassName)) {
                            type = this.getEcorePrimitiveType(eModelElement, EcorePackage.Literals.ESTRING.getName());
                        }
                    } else if ("http://www.eclipse.org/emf/2002/Ecore".equals(nsURI)) {
                        type = this.getEcorePrimitiveType(eModelElement, name);
                    }
                }
                if (type == null) {
                    type = (Type)this.doSwitch((EObject)eType);
                }
            }
            return type;
        }

        protected Type getType(ETypedElement eTypedElement) {
            return this.getType((EModelElement)eTypedElement, eTypedElement.getEType());
        }

        public Object caseEAttribute(EAttribute eAttribute) {
            EClass eContainingClass = eAttribute.getEContainingClass();
            if (eContainingClass != null) {
                Property property = UMLFactory.eINSTANCE.createProperty();
                this.eModelElementToElementMap.put(eAttribute, property);
                Classifier classifier = (Classifier)this.doSwitch((EObject)eContainingClass);
                UMLUtil.getOwnedAttributes(classifier).add((Object)property);
                property.setName(eAttribute.getName());
                property.setIsReadOnly(!eAttribute.isChangeable());
                property.setIsDerived(eAttribute.isDerived());
                property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
                this.caseETypedElement((ETypedElement)eAttribute);
                this.defaultCase((EObject)eAttribute);
                return property;
            }
            return super.caseEAttribute(eAttribute);
        }

        public Object caseEClass(EClass eClass) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage != null) {
                Classifier classifier = eClass.isInterface() ? UMLFactory.eINSTANCE.createInterface() : UMLFactory.eINSTANCE.createClass();
                this.eModelElementToElementMap.put(eClass, classifier);
                Package package_ = (Package)this.doSwitch((EObject)ePackage);
                package_.getOwnedTypes().add((Object)classifier);
                classifier.setName(eClass.getName());
                if (!eClass.isInterface()) {
                    ((Class)classifier).setIsAbstract(eClass.isAbstract());
                }
                Iterator eSuperTypes = eClass.getESuperTypes().iterator();
                while (eSuperTypes.hasNext()) {
                    EClass eSuperType = (EClass)eSuperTypes.next();
                    if (eSuperType.isInterface() && classifier instanceof BehavioredClassifier) {
                        ((BehavioredClassifier)classifier).createInterfaceRealization(null, (Interface)this.doSwitch((EObject)eSuperType));
                        continue;
                    }
                    Classifier generalClassifier = (Classifier)this.doSwitch((EObject)eSuperType);
                    if (classifier.allParents().contains((Object)generalClassifier)) continue;
                    classifier.createGeneralization(generalClassifier);
                }
                this.defaultCase((EObject)eClass);
                return classifier;
            }
            return super.caseEClass(eClass);
        }

        public Object caseEDataType(EDataType eDataType) {
            EPackage ePackage = eDataType.getEPackage();
            if (ePackage != null) {
                PrimitiveType primitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
                this.eModelElementToElementMap.put(eDataType, primitiveType);
                Package package_ = (Package)this.doSwitch((EObject)ePackage);
                package_.getOwnedTypes().add((Object)primitiveType);
                primitiveType.setName(eDataType.getName());
                this.defaultCase((EObject)eDataType);
                return primitiveType;
            }
            return super.caseEDataType(eDataType);
        }

        public Object caseEEnum(EEnum eEnum) {
            EPackage ePackage = eEnum.getEPackage();
            if (ePackage != null) {
                Enumeration enumeration = UMLFactory.eINSTANCE.createEnumeration();
                this.eModelElementToElementMap.put(eEnum, enumeration);
                Package package_ = (Package)this.doSwitch((EObject)ePackage);
                package_.getOwnedTypes().add((Object)enumeration);
                enumeration.setName(eEnum.getName());
                this.defaultCase((EObject)eEnum);
                return enumeration;
            }
            return super.caseEEnum(eEnum);
        }

        public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
            EEnum eEnum = eEnumLiteral.getEEnum();
            if (eEnum != null) {
                EnumerationLiteral enumerationLiteral = UMLFactory.eINSTANCE.createEnumerationLiteral();
                this.eModelElementToElementMap.put(eEnumLiteral, enumerationLiteral);
                Enumeration enumeration = (Enumeration)this.doSwitch((EObject)eEnum);
                enumeration.getOwnedLiterals().add((Object)enumerationLiteral);
                enumerationLiteral.setName(eEnumLiteral.getName());
                int value = eEnumLiteral.getValue();
                if (value != eEnum.getELiterals().indexOf((Object)eEnumLiteral)) {
                    ((LiteralInteger)enumerationLiteral.createSpecification(null, null, UMLPackage.Literals.LITERAL_INTEGER)).setValue(value);
                }
                this.defaultCase((EObject)eEnumLiteral);
                return enumerationLiteral;
            }
            return super.caseEEnumLiteral(eEnumLiteral);
        }

        public Object caseEModelElement(EModelElement eModelElement) {
            return eModelElement;
        }

        public Object caseEOperation(EOperation eOperation) {
            EClass eContainingClass = eOperation.getEContainingClass();
            if (eContainingClass != null) {
                int lowerBound;
                Operation operation = UMLFactory.eINSTANCE.createOperation();
                this.eModelElementToElementMap.put(eOperation, operation);
                Classifier classifier = (Classifier)this.doSwitch((EObject)eContainingClass);
                UMLUtil.getOwnedOperations(classifier).add((Object)operation);
                operation.setName(eOperation.getName());
                EClassifier eType = eOperation.getEType();
                if (eType != null) {
                    operation.createReturnResult(null, this.getType((EModelElement)eOperation, eType));
                }
                EList raisedExceptions = operation.getRaisedExceptions();
                Iterator eExceptions = eOperation.getEExceptions().iterator();
                while (eExceptions.hasNext()) {
                    Type type = this.getType((EModelElement)eOperation, (EClassifier)eExceptions.next());
                    if (type == null) continue;
                    raisedExceptions.add((Object)type);
                }
                operation.setVisibility(VisibilityKind.PUBLIC_LITERAL);
                int upperBound = eOperation.getUpperBound();
                if (upperBound != -2 && upperBound != operation.getUpper()) {
                    operation.setUpper(upperBound);
                }
                if ((lowerBound = eOperation.getLowerBound()) != operation.getLower()) {
                    operation.setLower(lowerBound);
                }
                operation.setIsOrdered(eOperation.isOrdered());
                operation.setIsUnique(eOperation.isUnique());
                this.defaultCase((EObject)eOperation);
                return operation;
            }
            return super.caseEOperation(eOperation);
        }

        public Object caseEPackage(EPackage ePackage) {
            EPackage eSuperPackage;
            Package package_ = ePackage.getESuperPackage() == null ? UMLFactory.eINSTANCE.createModel() : UMLFactory.eINSTANCE.createPackage();
            this.eModelElementToElementMap.put(ePackage, package_);
            if (!this.ePackages.contains(ePackage) && (eSuperPackage = ePackage.getESuperPackage()) != null) {
                ((Package)this.doSwitch((EObject)eSuperPackage)).getNestedPackages().add((Object)package_);
            }
            package_.setName(ePackage.getName());
            this.defaultCase((EObject)ePackage);
            return package_;
        }

        public Object caseEParameter(EParameter eParameter) {
            EOperation eOperation = eParameter.getEOperation();
            if (eOperation != null) {
                Parameter parameter = UMLFactory.eINSTANCE.createParameter();
                this.eModelElementToElementMap.put(eParameter, parameter);
                Operation operation = (Operation)this.doSwitch((EObject)eOperation);
                operation.getOwnedParameters().add((Object)parameter);
                parameter.setName(eParameter.getName());
                this.caseETypedElement((ETypedElement)eParameter);
                this.defaultCase((EObject)eParameter);
                return parameter;
            }
            return super.caseEParameter(eParameter);
        }

        public Object caseEReference(EReference eReference) {
            EClass eContainingClass = eReference.getEContainingClass();
            if (eContainingClass != null) {
                Property property = UMLFactory.eINSTANCE.createProperty();
                this.eModelElementToElementMap.put(eReference, property);
                Classifier classifier = (Classifier)this.doSwitch((EObject)eContainingClass);
                UMLUtil.getOwnedAttributes(classifier).add((Object)property);
                property.setName(eReference.getName());
                property.setAggregation(eReference.isContainment() ? AggregationKind.COMPOSITE_LITERAL : AggregationKind.NONE_LITERAL);
                property.setIsDerived(eReference.isDerived());
                property.setIsReadOnly(!eReference.isChangeable());
                this.caseETypedElement((ETypedElement)eReference);
                EReference eOpposite = eReference.getEOpposite();
                if (eOpposite == null) {
                    Association association = (Association)((Package)this.doSwitch((EObject)eContainingClass.getEPackage())).createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
                    property.setAssociation(association);
                    association.createOwnedEnd(null, classifier);
                } else {
                    Property opposite = (Property)this.doSwitch((EObject)eOpposite);
                    if (opposite != null) {
                        Association association = opposite.getAssociation();
                        if (association == null) {
                            if (eReference.isContainer()) {
                                association = (Association)((Package)this.doSwitch((EObject)eOpposite.getEContainingClass().getEPackage())).createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
                                opposite.setAssociation(association);
                                property.setAssociation(association);
                            } else {
                                association = (Association)((Package)this.doSwitch((EObject)eContainingClass.getEPackage())).createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
                                property.setAssociation(association);
                                opposite.setAssociation(association);
                            }
                        } else {
                            property.setAssociation(association);
                        }
                    }
                }
                this.defaultCase((EObject)eReference);
                return property;
            }
            return super.caseEReference(eReference);
        }

        public Object caseETypedElement(ETypedElement eTypedElement) {
            Object element = this.eModelElementToElementMap.get(eTypedElement);
            if (element != null) {
                if (element instanceof TypedElement) {
                    ((TypedElement)element).setType(this.getType(eTypedElement));
                }
                if (element instanceof MultiplicityElement) {
                    int lowerBound;
                    MultiplicityElement multiplicityElement = (MultiplicityElement)element;
                    int upperBound = eTypedElement.getUpperBound();
                    if (upperBound != -2 && upperBound != multiplicityElement.getUpper()) {
                        multiplicityElement.setUpper(upperBound);
                    }
                    if ((lowerBound = eTypedElement.getLowerBound()) != multiplicityElement.getLower()) {
                        multiplicityElement.setLower(lowerBound);
                    }
                    multiplicityElement.setIsOrdered(eTypedElement.isOrdered());
                    multiplicityElement.setIsUnique(eTypedElement.isUnique());
                }
                return element;
            }
            return super.caseETypedElement(eTypedElement);
        }

        public Object defaultCase(EObject eObject) {
            Iterator eContents = eObject.eContents().iterator();
            while (eContents.hasNext()) {
                this.doSwitch((EObject)eContents.next());
            }
            return super.defaultCase(eObject);
        }

        public Object doSwitch(EObject eObject) {
            if (!this.eModelElementToElementMap.containsKey(eObject)) {
                super.doSwitch(eObject);
            }
            return this.eModelElementToElementMap.get(eObject);
        }

        protected Profile getEcoreProfile(EModelElement eModelElement) {
            ResourceSet resourceSet;
            Resource eResource = eModelElement.eResource();
            if (eResource != null && (resourceSet = eResource.getResourceSet()) != null) {
                return (Profile)UMLUtil.load((ResourceSet)resourceSet, (URI)URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml"), (EClass)UMLPackage.Literals.PROFILE);
            }
            return null;
        }

        protected Stereotype getEcoreStereotype(EModelElement eModelElement, String name) {
            Profile ecoreProfile = this.getEcoreProfile(eModelElement);
            return ecoreProfile != null ? ecoreProfile.getOwnedStereotype(name) : null;
        }

        protected void processEcoreTaggedValue(Element element, Stereotype stereotype, String propertyName, EModelElement eModelElement, EStructuralFeature eStructuralFeature, Map options, DiagnosticChain diagnostics, Map context) {
            Object value = null;
            if (eStructuralFeature != null) {
                value = eModelElement.eGet(eStructuralFeature);
                if (UMLUtil.safeEquals((Object)value, (Object)eStructuralFeature.getDefaultValue())) {
                    return;
                }
            } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_CONTENT_KIND) {
                Enumeration contentKindEnumeration = (Enumeration)this.getEcoreProfile(eModelElement).getOwnedType(UMLUtil.ENUMERATION__CONTENT_KIND);
                if (contentKindEnumeration != null) {
                    switch (ExtendedMetaData.INSTANCE.getContentKind((EClass)eModelElement)) {
                        case 1: {
                            value = contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__EMPTY);
                            break;
                        }
                        case 2: {
                            value = contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__SIMPLE);
                            break;
                        }
                        case 3: {
                            value = contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__MIXED);
                            break;
                        }
                        case 4: {
                            value = contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ELEMENT_ONLY);
                        }
                    }
                }
                if (value == null) {
                    return;
                }
            } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_FEATURE_KIND) {
                Enumeration featureKindEnumeration = (Enumeration)this.getEcoreProfile(eModelElement).getOwnedType(UMLUtil.ENUMERATION__FEATURE_KIND);
                if (featureKindEnumeration != null) {
                    switch (ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)eModelElement)) {
                        case 1: {
                            value = featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__SIMPLE);
                            break;
                        }
                        case 2: {
                            value = featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ATTRIBUTE);
                            break;
                        }
                        case 3: {
                            value = featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ATTRIBUTE_WILDCARD);
                            break;
                        }
                        case 4: {
                            value = featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ELEMENT);
                            break;
                        }
                        case 5: {
                            value = featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ELEMENT_WILDCARD);
                            break;
                        }
                        case 6: {
                            value = featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__GROUP);
                        }
                    }
                }
                if (value == null) {
                    return;
                }
            } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_NAME) {
                if (eModelElement instanceof EClassifier) {
                    value = ExtendedMetaData.INSTANCE.getName((EClassifier)eModelElement);
                } else if (eModelElement instanceof EStructuralFeature) {
                    value = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eModelElement);
                }
                if (UMLUtil.safeEquals((Object)value, (Object)((ENamedElement)eModelElement).getName())) {
                    return;
                }
            } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_NAMESPACE) {
                value = ExtendedMetaData.INSTANCE.getNamespace((EStructuralFeature)eModelElement);
                if (value == null) {
                    return;
                }
            } else if (propertyName == UMLUtil.TAG_DEFINITION__VISIBILITY) {
                Enumeration visibilityKindEnumeration = (Enumeration)this.getEcoreProfile(eModelElement).getOwnedType(UMLUtil.ENUMERATION__VISIBILITY_KIND);
                if (visibilityKindEnumeration != null) {
                    eStructuralFeature = (EStructuralFeature)eModelElement;
                    if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0)) {
                        value = visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__NONE);
                    } else if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1)) {
                        value = EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2) ? visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__READ_ONLY) : visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__READ_ONLY_UNSETTABLE);
                    } else if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3)) {
                        value = visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__READ_WRITE);
                    }
                }
                if (value == null) {
                    return;
                }
            }
            if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 3001, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ProcessEcoreTaggedValue_diagnostic", UMLUtil.access$4(context, element, UMLUtil.getTagDefinition(stereotype, propertyName), value)), new Object[]{element}));
                }
                UMLUtil.setTaggedValue(element, stereotype, propertyName, value);
            } else if (UMLUtil.OPTION__REPORT.equals(options.get(OPTION__ECORE_TAGGED_VALUES)) && diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 3001, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ReportEcoreTaggedValue_diagnostic", UMLUtil.access$4(context, element, UMLUtil.getTagDefinition(stereotype, propertyName), value)), new Object[]{element}));
            }
        }

        protected void processEcoreTaggedValues(Element element, EPackage ePackage, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype ePackageStereotype = this.getEcoreStereotype((EModelElement)ePackage, UMLUtil.STEREOTYPE__E_PACKAGE);
            if (ePackageStereotype != null) {
                UMLUtil.safeApplyStereotype(element, ePackageStereotype);
                this.processEcoreTaggedValue(element, ePackageStereotype, UMLUtil.TAG_DEFINITION__NS_PREFIX, (EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsPrefix(), options, diagnostics, context);
                this.processEcoreTaggedValue(element, ePackageStereotype, UMLUtil.TAG_DEFINITION__NS_URI, (EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsURI(), options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Element element, EClassifier eClassifier, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eClassifierStereotype = (Stereotype)new UMLSwitch(this, eClassifier, options, diagnostics, context){
                final /* synthetic */ Ecore2UMLConverter this$1;
                private final /* synthetic */ EClassifier val$eClassifier;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = ecore2UMLConverter;
                    this.val$eClassifier = eClassifier;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseClass(Class class_) {
                    Stereotype eClassStereotype = this.this$1.getEcoreStereotype((EModelElement)this.val$eClassifier, "EClass");
                    if (eClassStereotype != null) {
                        UMLUtil.safeApplyStereotype(class_, eClassStereotype);
                        this.this$1.processEcoreTaggedValue(class_, eClassStereotype, "xmlContentKind", (EModelElement)this.val$eClassifier, null, this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eClassStereotype;
                }

                public Object caseDataType(DataType dataType) {
                    Stereotype eDataTypeStereotype = this.this$1.getEcoreStereotype((EModelElement)this.val$eClassifier, "EDataType");
                    if (eDataTypeStereotype != null) {
                        UMLUtil.safeApplyStereotype(dataType, eDataTypeStereotype);
                    }
                    return eDataTypeStereotype;
                }

                public Object caseInterface(Interface interface_) {
                    Stereotype eClassStereotype = this.this$1.getEcoreStereotype((EModelElement)this.val$eClassifier, "EClass");
                    if (eClassStereotype != null) {
                        UMLUtil.safeApplyStereotype(interface_, eClassStereotype);
                        this.this$1.processEcoreTaggedValue(interface_, eClassStereotype, "xmlContentKind", (EModelElement)this.val$eClassifier, null, this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eClassStereotype;
                }
            }.doSwitch((EObject)element);
            if (eClassifierStereotype != null) {
                this.processEcoreTaggedValue(element, eClassifierStereotype, UMLUtil.TAG_DEFINITION__XML_NAME, (EModelElement)eClassifier, null, options, diagnostics, context);
                this.processEcoreTaggedValue(element, eClassifierStereotype, UMLUtil.TAG_DEFINITION__INSTANCE_CLASS_NAME, (EModelElement)eClassifier, (EStructuralFeature)EcorePackage.eINSTANCE.getEClassifier_InstanceClassName(), options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Element element, EStructuralFeature eStructuralFeature, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eStructuralFeatureStereotype = (Stereotype)new EcoreSwitch(this, element, options, diagnostics, context){
                final /* synthetic */ Ecore2UMLConverter this$1;
                private final /* synthetic */ Element val$element;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = ecore2UMLConverter;
                    this.val$element = element;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseEAttribute(EAttribute eAttribute) {
                    Stereotype eAttributeStereotype = this.this$1.getEcoreStereotype((EModelElement)eAttribute, "EAttribute");
                    if (eAttributeStereotype != null) {
                        UMLUtil.safeApplyStereotype(this.val$element, eAttributeStereotype);
                        this.this$1.processEcoreTaggedValue(this.val$element, eAttributeStereotype, "isID", (EModelElement)eAttribute, (EStructuralFeature)EcorePackage.eINSTANCE.getEAttribute_ID(), this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eAttributeStereotype;
                }

                public Object caseEReference(EReference eReference) {
                    Stereotype eReferenceStereotype = this.this$1.getEcoreStereotype((EModelElement)eReference, "EReference");
                    if (eReferenceStereotype != null) {
                        UMLUtil.safeApplyStereotype(this.val$element, eReferenceStereotype);
                        this.this$1.processEcoreTaggedValue(this.val$element, eReferenceStereotype, "isResolveProxies", (EModelElement)eReference, (EStructuralFeature)EcorePackage.eINSTANCE.getEReference_ResolveProxies(), this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eReferenceStereotype;
                }
            }.doSwitch((EObject)eStructuralFeature);
            if (eStructuralFeatureStereotype != null) {
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__IS_TRANSIENT, (EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Transient(), options, diagnostics, context);
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__IS_UNSETTABLE, (EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Unsettable(), options, diagnostics, context);
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__IS_VOLATILE, (EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(), options, diagnostics, context);
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__XML_FEATURE_KIND, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__XML_NAME, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__XML_NAMESPACE, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
                this.processEcoreTaggedValue(element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__VISIBILITY, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                Element element = (Element)entry.getValue();
                new EcoreSwitch(this, element, options, diagnostics, context){
                    final /* synthetic */ Ecore2UMLConverter this$1;
                    private final /* synthetic */ Element val$element;
                    private final /* synthetic */ Map val$options;
                    private final /* synthetic */ DiagnosticChain val$diagnostics;
                    private final /* synthetic */ Map val$context;
                    {
                        this.this$1 = ecore2UMLConverter;
                        this.val$element = element;
                        this.val$options = map;
                        this.val$diagnostics = diagnosticChain;
                        this.val$context = map2;
                    }

                    public Object caseEClassifier(EClassifier eClassifier) {
                        this.this$1.processEcoreTaggedValues(this.val$element, eClassifier, this.val$options, this.val$diagnostics, this.val$context);
                        return eClassifier;
                    }

                    public Object caseEDataType(EDataType eDataType) {
                        this.this$1.processEcoreTaggedValues(this.val$element, (EClassifier)eDataType, this.val$options, this.val$diagnostics, this.val$context);
                        return eDataType;
                    }

                    public Object caseEEnum(EEnum eEnum) {
                        Stereotype eEnumStereotype = this.this$1.getEcoreStereotype((EModelElement)eEnum, "EEnum");
                        if (eEnumStereotype != null) {
                            UMLUtil.safeApplyStereotype(this.val$element, eEnumStereotype);
                        }
                        return eEnum;
                    }

                    public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
                        Stereotype eEnumLiteralStereotype = this.this$1.getEcoreStereotype((EModelElement)eEnumLiteral, "EEnumLiteral");
                        if (eEnumLiteralStereotype != null) {
                            UMLUtil.safeApplyStereotype(this.val$element, eEnumLiteralStereotype);
                        }
                        return eEnumLiteral;
                    }

                    public Object caseEOperation(EOperation eOperation) {
                        Stereotype eOperationStereotype = this.this$1.getEcoreStereotype((EModelElement)eOperation, "EOperation");
                        if (eOperationStereotype != null) {
                            UMLUtil.safeApplyStereotype(this.val$element, eOperationStereotype);
                        }
                        return eOperation;
                    }

                    public Object caseEPackage(EPackage ePackage) {
                        this.this$1.processEcoreTaggedValues(this.val$element, ePackage, this.val$options, this.val$diagnostics, this.val$context);
                        return ePackage;
                    }

                    public Object caseEParameter(EParameter eParameter) {
                        Stereotype eParameterStereotype = this.this$1.getEcoreStereotype((EModelElement)eParameter, "EParameter");
                        if (eParameterStereotype != null) {
                            UMLUtil.safeApplyStereotype(this.val$element, eParameterStereotype);
                        }
                        return eParameter;
                    }

                    public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                        this.this$1.processEcoreTaggedValues(this.val$element, eStructuralFeature, this.val$options, this.val$diagnostics, this.val$context);
                        return eStructuralFeature;
                    }
                }.doSwitch((EObject)eModelElement);
            }
        }

        protected void processRedefinesAnnotations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                EAnnotation redefinesEAnnotation;
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                if (!(eModelElement instanceof ETypedElement) || (redefinesEAnnotation = UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)false)) == null) continue;
                Feature feature = (Feature)entry.getValue();
                Iterator references = redefinesEAnnotation.getReferences().iterator();
                while (references.hasNext()) {
                    Feature redefinedFeature = (Feature)this.eModelElementToElementMap.get(references.next());
                    if (redefinedFeature == null || !UMLUtil.findValidRedefinitions(feature, redefinedFeature.getName()).contains(redefinedFeature)) continue;
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__REDEFINES_ANNOTATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 3002, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ProcessRedefinesAnnotation_diagnostic", UMLUtil.access$3(context, feature, redefinedFeature)), new Object[]{feature, redefinedFeature}));
                        }
                        UMLUtil.getRedefinedFeatures(feature).add((Object)redefinedFeature);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__REDEFINES_ANNOTATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 3002, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ReportRedefinesAnnotation_diagnostic", UMLUtil.access$3(context, feature, redefinedFeature)), new Object[]{feature, redefinedFeature}));
                }
            }
        }

        protected void processSubsetsAnnotations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                EAnnotation subsetsEAnnotation;
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                if (!(eModelElement instanceof EStructuralFeature) || (subsetsEAnnotation = UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)UMLUtil.ANNOTATION__SUBSETS, (boolean)false)) == null) continue;
                Property property = (Property)entry.getValue();
                Iterator references = subsetsEAnnotation.getReferences().iterator();
                while (references.hasNext()) {
                    Property subsettedProperty = (Property)this.eModelElementToElementMap.get(references.next());
                    if (subsettedProperty == null || !UMLUtil.findValidSubsets(property, subsettedProperty.getName()).contains(subsettedProperty)) continue;
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__SUBSETS_ANNOTATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 3003, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ProcessSubsetsAnnotation_diagnostic", UMLUtil.access$3(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
                        }
                        property.getSubsettedProperties().add((Object)subsettedProperty);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__SUBSETS_ANNOTATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 3003, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ReportSubsetsAnnotation_diagnostic", UMLUtil.access$3(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
                }
            }
        }

        protected void processUnionAnnotations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                EAnnotation unionEAnnotation;
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                if (!(eModelElement instanceof EStructuralFeature) || (unionEAnnotation = UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)UMLUtil.ANNOTATION__UNION, (boolean)false)) == null) continue;
                Property property = (Property)entry.getValue();
                if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__UNION_ANNOTATIONS))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 3004, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ProcessUnionAnnotation_diagnostic", UMLUtil.access$5(context, property)), new Object[]{property}));
                    }
                    property.setIsDerivedUnion(true);
                    continue;
                }
                if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__UNION_ANNOTATIONS)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 3004, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ReportUnionAnnotation_diagnostic", UMLUtil.access$5(context, property)), new Object[]{property}));
            }
        }

        protected void processAnnotationDetails(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Element element = (Element)entry.getValue();
                if (element == null) continue;
                EModelElement eModelElement = (EModelElement)entry.getKey();
                Iterator eAnnotations = eModelElement.getEAnnotations().iterator();
                while (eAnnotations.hasNext()) {
                    EAnnotation eAnnotation = (EAnnotation)eAnnotations.next();
                    EMap details = eAnnotation.getDetails();
                    if (details.isEmpty()) continue;
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__ANNOTATION_DETAILS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 3005, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ProcessAnnotationDetails_diagnostic", UMLUtil.access$3(context, element, eAnnotation.getSource())), new Object[]{element}));
                        }
                        UMLUtil.getEAnnotation((EModelElement)element, (String)eAnnotation.getSource(), (boolean)true).getDetails().putAll(details.map());
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__ANNOTATION_DETAILS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 3005, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ReportAnnotationDetails_diagnostic", UMLUtil.access$3(context, element, eAnnotation.getSource())), new Object[]{element}));
                }
            }
        }

        protected void processOptions(Map options, DiagnosticChain diagnostics, Map context) {
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                this.processEcoreTaggedValues(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__REDEFINES_ANNOTATIONS))) {
                this.processRedefinesAnnotations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__SUBSETS_ANNOTATIONS))) {
                this.processSubsetsAnnotations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__UNION_ANNOTATIONS))) {
                this.processUnionAnnotations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__ANNOTATION_DETAILS))) {
                this.processAnnotationDetails(options, diagnostics, context);
            }
        }

        public Collection convert(Collection eObjects, Map options, DiagnosticChain diagnostics, Map context) {
            this.ePackages = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
            Iterator ep = this.ePackages.iterator();
            while (ep.hasNext()) {
                this.doSwitch((EObject)((EPackage)ep.next()));
            }
            if (options != null) {
                this.processOptions(options, diagnostics, context);
            }
            return UMLUtil.access$9(EcoreUtil.getObjectsByType(this.eModelElementToElementMap.values(), (EClassifier)UMLPackage.Literals.PACKAGE));
        }
    }

    public static class PackageMerger
    extends EcoreUtil.Copier {
        private static final boolean DEBUG = false;
        public static final String OPTION__DIFFERENT_PROPERTY_STATICITY = "DIFFERENT_PROPERTY_STATICITY";
        public static final String OPTION__DIFFERENT_PROPERTY_UNIQUENESS = "DIFFERENT_PROPERTY_UNIQUENESS";
        public static final String OPTION__REDUNDANT_GENERALIZATIONS = "REDUNDANT_GENERALIZATIONS";
        public static final String OPTION__IMPLICIT_REDEFINITIONS = "IMPLICIT_REDEFINITIONS";
        public static final String OPTION__INVALID_REDEFINITIONS = "INVALID_REDEFINITIONS";
        public static final String OPTION__INVALID_SUBSETS = "INVALID_SUBSETS";
        public static final String OPTION__EMPTY_UNIONS = "EMPTY_UNIONS";
        public static final String OPTION__ASSOCIATION_SPECIALIZATIONS = "ASSOCIATION_SPECIALIZATIONS";
        public static final String OPTION__CAPABILITIES = "CAPABILITIES";
        private static final int DIAGNOSTIC_CODE_OFFSET = 1000;
        public static final int DIFFERENT_PROPERTY_STATICITY = 1001;
        public static final int DIFFERENT_PROPERTY_UNIQUENESS = 1002;
        public static final int REDUNDANT_GENERALIZATION = 1003;
        public static final int IMPLICIT_REDEFINITION = 1004;
        public static final int INVALID_REDEFINITION = 1005;
        public static final int INVALID_SUBSET = 1006;
        public static final int EMPTY_UNION = 1007;
        public static final int ASSOCIATION_SPECIALIZATION = 1008;
        public static final int CAPABILITY = 1009;
        protected Package receivingPackage = null;
        protected Collection mergedPackages = null;
        protected final Map resultingToMergedEObjectMap = new LinkedHashMap();
        private final Map copierMap = new LinkedHashMap();

        public void clear() {
            this.copierMap.clear();
        }

        public boolean containsKey(Object key) {
            return this.copierMap.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.copierMap.containsValue(value);
        }

        public Set entrySet() {
            return this.copierMap.entrySet();
        }

        public Object get(Object key) {
            return this.copierMap.get(key);
        }

        public boolean isEmpty() {
            return this.copierMap.isEmpty();
        }

        public Set keySet() {
            return this.copierMap.keySet();
        }

        public Object put(Object key, Object value) {
            return this.copierMap.put(key, value);
        }

        public void putAll(Map t) {
            this.copierMap.putAll(t);
        }

        public Object remove(Object key) {
            return this.copierMap.remove(key);
        }

        public int size() {
            return this.copierMap.size();
        }

        public Collection values() {
            return this.copierMap.values();
        }

        protected List getMatchCandidates(EObject eObject) {
            Element baseElement = UMLUtil.getBaseElement(eObject);
            if (baseElement == null) {
                EStructuralFeature eContainingFeature = eObject.eContainingFeature();
                return eContainingFeature.isMany() ? (List<Object>)((EObject)this.get(eObject.eContainer())).eGet(eContainingFeature) : Collections.singletonList(((EObject)this.get(eObject.eContainer())).eGet(eContainingFeature));
            }
            return ((Element)this.get(baseElement)).getStereotypeApplications();
        }

        protected List getMergedEObjects(EObject resultingEObject) {
            Object mergedEObjects = this.resultingToMergedEObjectMap.get(resultingEObject);
            return mergedEObjects == null ? Collections.singletonList(resultingEObject) : (List)mergedEObjects;
        }

        protected EObject getPreviouslyMergedEObject(EObject resultingEObject) {
            List mergedEObjects = this.getMergedEObjects(resultingEObject);
            return (EObject)mergedEObjects.get(mergedEObjects.size() - 1);
        }

        protected String getResultingQName(EObject eObject) {
            StringBuffer resultingQName = this.appendResultingQName(new StringBuffer(), eObject, QualifiedTextProvider.DEFAULT);
            return resultingQName.toString();
        }

        private StringBuffer appendResultingQName(StringBuffer resultingQName, EObject eObject, QualifiedTextProvider qualifiedTextProvider) {
            EObject eContainer = (eObject = this.mergedPackages.contains(eObject) ? this.receivingPackage : eObject).eContainer();
            if (eContainer != null) {
                this.appendResultingQName(resultingQName, eContainer, qualifiedTextProvider);
                if (resultingQName.length() > 0) {
                    resultingQName.append(qualifiedTextProvider.getSeparator());
                }
            }
            return UMLUtil.access$0(eObject, qualifiedTextProvider, resultingQName);
        }

        protected void mergeAssociation_IsDerived(Association receivingAssociation, Association mergedAssociation) {
            receivingAssociation.setIsDerived(receivingAssociation.isDerived() || mergedAssociation.isDerived());
        }

        protected void mergeClassifier_IsAbstract(Classifier receivingClassifier, Classifier mergedClassifier) {
            receivingClassifier.setIsAbstract(receivingClassifier.isAbstract() && mergedClassifier.isAbstract());
        }

        protected void mergeLiteralInteger_Value(LiteralInteger receivingLiteralInteger, LiteralInteger mergedLiteralInteger) {
            receivingLiteralInteger.setValue(UMLUtil.access$1(receivingLiteralInteger.getValue(), mergedLiteralInteger.getValue()));
        }

        protected void mergeLiteralUnlimitedNatural_Value(LiteralUnlimitedNatural receivingLiteralUnlimitedNatural, LiteralUnlimitedNatural mergedLiteralUnlimitedNatural) {
            receivingLiteralUnlimitedNatural.setValue(UMLUtil.access$2(receivingLiteralUnlimitedNatural.getValue(), mergedLiteralUnlimitedNatural.getValue()));
        }

        protected void mergeMultiplicityElement_IsOrdered(MultiplicityElement receivingMultiplicityElement, MultiplicityElement mergedMultiplicityElement) {
            receivingMultiplicityElement.setIsOrdered(receivingMultiplicityElement.isOrdered() || mergedMultiplicityElement.isOrdered());
        }

        protected void mergeMultiplicityElement_IsUnique(MultiplicityElement receivingMultiplicityElement, MultiplicityElement mergedMultiplicityElement) {
            receivingMultiplicityElement.setIsUnique(receivingMultiplicityElement.isUnique() && mergedMultiplicityElement.isUnique());
        }

        protected void mergeNamedElement_Visibility(NamedElement receivingNamedElement, NamedElement mergedNamedElement) {
            if (receivingNamedElement.getVisibility() == VisibilityKind.PRIVATE_LITERAL && mergedNamedElement.getVisibility() == VisibilityKind.PRIVATE_LITERAL) {
                receivingNamedElement.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            } else if (receivingNamedElement.isSetVisibility()) {
                receivingNamedElement.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            }
        }

        protected void mergeProperty_IsDerived(Property receivingProperty, Property mergedProperty) {
            receivingProperty.setIsDerived(receivingProperty.isDerived() || mergedProperty.isDerived());
        }

        protected void mergeProperty_IsDerivedUnion(Property receivingProperty, Property mergedProperty) {
            receivingProperty.setIsDerivedUnion(receivingProperty.isDerivedUnion() || mergedProperty.isDerivedUnion());
        }

        protected void mergeStructuralFeature_IsReadOnly(StructuralFeature receivingStructuralFeature, StructuralFeature mergedStructuralFeature) {
            receivingStructuralFeature.setIsReadOnly(receivingStructuralFeature.isReadOnly() && mergedStructuralFeature.isReadOnly());
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (eObject != copyEObject) {
                if (copyEObject == this.receivingPackage) {
                    return;
                }
                if (this.resultingToMergedEObjectMap.containsKey(copyEObject)) {
                    if (eAttribute == UMLPackage.Literals.ASSOCIATION__IS_DERIVED) {
                        this.mergeAssociation_IsDerived((Association)copyEObject, (Association)eObject);
                    } else if (eAttribute == UMLPackage.Literals.CLASSIFIER__IS_ABSTRACT) {
                        this.mergeClassifier_IsAbstract((Classifier)copyEObject, (Classifier)eObject);
                    } else if (eAttribute == UMLPackage.Literals.LITERAL_INTEGER__VALUE && copyEObject.eContainingFeature() == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE) {
                        this.mergeLiteralInteger_Value((LiteralInteger)copyEObject, (LiteralInteger)eObject);
                    } else if (eAttribute == UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE && copyEObject.eContainingFeature() == UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) {
                        this.mergeLiteralUnlimitedNatural_Value((LiteralUnlimitedNatural)copyEObject, (LiteralUnlimitedNatural)eObject);
                    } else if (eAttribute == UMLPackage.Literals.MULTIPLICITY_ELEMENT__IS_ORDERED) {
                        this.mergeMultiplicityElement_IsOrdered((MultiplicityElement)copyEObject, (MultiplicityElement)eObject);
                    } else if (eAttribute == UMLPackage.Literals.MULTIPLICITY_ELEMENT__IS_UNIQUE) {
                        this.mergeMultiplicityElement_IsUnique((MultiplicityElement)copyEObject, (MultiplicityElement)eObject);
                    } else if (eAttribute == UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY) {
                        this.mergeNamedElement_Visibility((NamedElement)copyEObject, (NamedElement)eObject);
                    } else if (eAttribute == UMLPackage.Literals.PROPERTY__IS_DERIVED) {
                        this.mergeProperty_IsDerived((Property)copyEObject, (Property)eObject);
                    } else if (eAttribute == UMLPackage.Literals.PROPERTY__IS_DERIVED_UNION) {
                        this.mergeProperty_IsDerivedUnion((Property)copyEObject, (Property)eObject);
                    } else if (eAttribute == UMLPackage.Literals.STRUCTURAL_FEATURE__IS_READ_ONLY) {
                        this.mergeStructuralFeature_IsReadOnly((StructuralFeature)copyEObject, (StructuralFeature)eObject);
                    } else {
                        super.copyAttribute(eAttribute, eObject, copyEObject);
                    }
                } else {
                    super.copyAttribute(eAttribute, eObject, copyEObject);
                }
            }
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject != copyEObject) {
                if (eReference.isMany()) {
                    InternalEList targetList = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                    Iterator i = ((List)eObject.eGet((EStructuralFeature)eReference)).iterator();
                    while (i.hasNext()) {
                        EObject copyChildEObject;
                        EObject childEObject = (EObject)i.next();
                        if (childEObject == (copyChildEObject = this.copy(childEObject))) continue;
                        targetList.addUnique((Object)copyChildEObject);
                    }
                } else {
                    EObject copyChildEObject;
                    EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                    EObject eObject2 = copyChildEObject = childEObject == null ? null : this.copy(childEObject);
                    if (childEObject != copyChildEObject) {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)copyChildEObject);
                    }
                }
            }
        }

        protected void mergeTypedElement_Type(TypedElement receivingTypedElement, TypedElement mergedTypedElement) {
            Type receivingType = receivingTypedElement.getType();
            Type mergedType = mergedTypedElement.getType();
            if (receivingType != null && mergedType instanceof Classifier) {
                EList allParents = ((Classifier)mergedType).allParents();
                Iterator mergedEObjects = this.getMergedEObjects((EObject)receivingType).iterator();
                while (mergedEObjects.hasNext()) {
                    EObject mergedEObject = (EObject)mergedEObjects.next();
                    if (UMLUtil.findEObject((Collection)allParents, (UML2Util.EObjectMatcher)new ResultingQNameMatcher(mergedEObject)) == null) continue;
                    mergedType = (Type)mergedEObject;
                }
            }
            Type resultingType = mergedType == null ? null : (Type)this.get(mergedType);
            receivingTypedElement.setType(resultingType == null ? mergedType : resultingType);
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject != copyEObject && eObject.eIsSet((EStructuralFeature)eReference)) {
                if (eReference == UMLPackage.Literals.TYPED_ELEMENT__TYPE) {
                    this.mergeTypedElement_Type((TypedElement)copyEObject, (TypedElement)eObject);
                } else if (eReference.isMany()) {
                    InternalEList targetList = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                    boolean isBidirectional = eReference.getEOpposite() != null;
                    int index = 0;
                    Iterator i = ((List)eObject.eGet((EStructuralFeature)eReference)).iterator();
                    while (i.hasNext()) {
                        Object referencedEObject = i.next();
                        Object copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (isBidirectional) continue;
                            if (!targetList.contains(referencedEObject)) {
                                targetList.addUnique(index, referencedEObject);
                            }
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            int position = targetList.indexOf(copyReferencedEObject);
                            if (position == -1) {
                                targetList.addUnique(index, copyReferencedEObject);
                            } else if (index != position) {
                                targetList.move(index, copyReferencedEObject);
                            }
                        } else if (!targetList.contains(copyReferencedEObject)) {
                            targetList.addUnique(index, copyReferencedEObject);
                        }
                        ++index;
                    }
                } else {
                    super.copyReference(eReference, eObject, copyEObject);
                }
            }
        }

        protected EObject createCopy(EObject eObject) {
            return (EObject)new UMLSwitch(this){
                final /* synthetic */ PackageMerger this$1;
                {
                    this.this$1 = packageMerger;
                }

                public Object caseAssociation(Association association) {
                    Association matchingAssociation = (Association)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)association), (UML2Util.EObjectMatcher)new NameMatcher(this, this.this$1, association){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                            super($anonymous0);
                        }

                        public boolean matches(EObject otherEObject) {
                            if (super.matches(otherEObject)) {
                                otherEObject = 1.access$0(this.this$2).getPreviouslyMergedEObject(otherEObject);
                                EList memberEnds = ((Association)this.eObject).getMemberEnds();
                                EList otherMemberEnds = ((Association)otherEObject).getMemberEnds();
                                if (memberEnds.size() == otherMemberEnds.size()) {
                                    Iterator<E> i = memberEnds.iterator();
                                    while (i.hasNext()) {
                                        if (UMLUtil.findEObject((Collection)otherMemberEnds, (UML2Util.EObjectMatcher)1.access$0(this.this$2).new TypeMatcher((TypedElement)i.next())) != null) continue;
                                        return false;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return matchingAssociation == null ? super.caseAssociation(association) : matchingAssociation;
                }

                public Object caseClass(Class class_) {
                    Class matchingClass = (Class)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)class_), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(class_));
                    return matchingClass == null ? super.caseClass(class_) : matchingClass;
                }

                public Object caseComment(Comment comment) {
                    Comment matchingComment = (Comment)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)comment), (UML2Util.EObjectMatcher)this.this$1.new BodyMatcher(comment));
                    return matchingComment == null ? super.caseComment(comment) : matchingComment;
                }

                public Object caseConstraint(Constraint constraint) {
                    Constraint matchingConstraint = (Constraint)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)constraint), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(constraint));
                    return matchingConstraint == null ? super.caseConstraint(constraint) : matchingConstraint;
                }

                public Object caseDataType(DataType dataType) {
                    DataType matchingDataType = (DataType)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)dataType), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(dataType));
                    return matchingDataType == null ? super.caseDataType(dataType) : matchingDataType;
                }

                public Object caseDirectedRelationship(DirectedRelationship directedRelationship) {
                    if (this.this$1.mergedPackages.containsAll((Collection<?>)directedRelationship.getTargets())) {
                        return directedRelationship;
                    }
                    DirectedRelationship matchingDirectedRelationship = (DirectedRelationship)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)directedRelationship), (UML2Util.EObjectMatcher)new UML2Util.EClassMatcher(this, (EObject)directedRelationship){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                            super($anonymous0);
                        }

                        public boolean matches(EObject otherEObject) {
                            if (super.matches(otherEObject)) {
                                otherEObject = 1.access$0(this.this$2).getPreviouslyMergedEObject(otherEObject);
                                EList targets = ((DirectedRelationship)this.eObject).getTargets();
                                EList otherTargets = ((DirectedRelationship)otherEObject).getTargets();
                                if (targets.size() == otherTargets.size()) {
                                    Iterator<E> i = targets.iterator();
                                    while (i.hasNext()) {
                                        if (UMLUtil.findEObject((Collection)otherTargets, (UML2Util.EObjectMatcher)1.access$0(this.this$2).new ResultingQNameMatcher((EObject)i.next())) != null) continue;
                                        return false;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return matchingDirectedRelationship == null ? super.caseDirectedRelationship(directedRelationship) : matchingDirectedRelationship;
                }

                public Object caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
                    EnumerationLiteral matchingEnumerationLiteral = (EnumerationLiteral)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)enumerationLiteral), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(enumerationLiteral));
                    return matchingEnumerationLiteral == null ? super.caseEnumerationLiteral(enumerationLiteral) : matchingEnumerationLiteral;
                }

                public Object caseOperation(Operation operation) {
                    Operation matchingOperation = (Operation)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)operation), (UML2Util.EObjectMatcher)new NameMatcher(this, this.this$1, operation){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                            super($anonymous0);
                        }

                        public boolean matches(EObject otherEObject) {
                            if (super.matches(otherEObject)) {
                                otherEObject = 1.access$0(this.this$2).getPreviouslyMergedEObject(otherEObject);
                                EList ownedParameters = ((Operation)this.eObject).getOwnedParameters();
                                EList otherOwnedParameters = ((Operation)otherEObject).getOwnedParameters();
                                if (ownedParameters.size() == otherOwnedParameters.size()) {
                                    int i = 0;
                                    while (i < ownedParameters.size()) {
                                        if (!1.access$0(this.this$2).new TypeMatcher((TypedElement)ownedParameters.get(i)).matches((EObject)otherOwnedParameters.get(i))) {
                                            return false;
                                        }
                                        ++i;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return matchingOperation == null ? super.caseOperation(operation) : matchingOperation;
                }

                public Object casePackage(Package package_) {
                    Package matchingPackage = null;
                    matchingPackage = this.this$1.mergedPackages.contains(package_) ? this.this$1.receivingPackage : (Package)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)package_), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(package_));
                    return matchingPackage == null ? super.casePackage(package_) : matchingPackage;
                }

                public Object caseParameter(Parameter parameter) {
                    Parameter matchingParameter = (Parameter)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)parameter), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(parameter));
                    return matchingParameter == null ? super.caseParameter(parameter) : matchingParameter;
                }

                public Object caseProperty(Property property) {
                    Property matchingProperty = (Property)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates((EObject)property), (UML2Util.EObjectMatcher)this.this$1.new NameMatcher(property));
                    return matchingProperty == null ? super.caseProperty(property) : matchingProperty;
                }

                public Object defaultCase(EObject eObject) {
                    Element baseElement = UMLUtil.getBaseElement(eObject);
                    return baseElement == null ? PackageMerger.access$0(this.this$1, eObject) : UMLUtil.applyStereotype((Element)this.this$1.get(baseElement), PackageMerger.access$1(this.this$1, eObject.eClass()));
                }

                protected Object doSwitch(EClass theEClass, EObject theEObject) {
                    if (theEClass.eContainer() != modelPackage) {
                        EObject matchingEObject;
                        if (theEClass == EcorePackage.Literals.EANNOTATION) {
                            EAnnotation matchingEAnnotation = (EAnnotation)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates(theEObject), (UML2Util.EObjectMatcher)this.this$1.new SourceMatcher((EAnnotation)theEObject));
                            if (matchingEAnnotation != null) {
                                return matchingEAnnotation;
                            }
                        } else if (theEClass == EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY) {
                            BasicEMap.Entry matchingEntry = (BasicEMap.Entry)UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates(theEObject), (UML2Util.EObjectMatcher)this.this$1.new KeyMatcher((BasicEMap.Entry)theEObject));
                            if (matchingEntry != null) {
                                return matchingEntry;
                            }
                        } else if (UMLUtil.getStereotype(theEClass) != null && (matchingEObject = UMLUtil.findEObject((Collection)this.this$1.getMatchCandidates(theEObject), (UML2Util.EObjectMatcher)new UML2Util.EClassMatcher(theEObject))) != null) {
                            return matchingEObject;
                        }
                    }
                    return super.doSwitch(theEClass, theEObject);
                }

                static /* synthetic */ PackageMerger access$0(1 var0) {
                    return var0.this$1;
                }
            }.doSwitch(eObject);
        }

        public EObject copy(EObject eObject) {
            EObject copyEObject = super.copy(eObject);
            if (eObject != copyEObject) {
                List mergedEObjects = (List)this.resultingToMergedEObjectMap.get(copyEObject);
                if (mergedEObjects == null) {
                    mergedEObjects = new UniqueEList.FastCompare(1);
                    this.resultingToMergedEObjectMap.put(copyEObject, mergedEObjects);
                }
                mergedEObjects.add(eObject);
            }
            return copyEObject;
        }

        public Collection copyAll(Collection eObjects) {
            ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
            Iterator o = eObjects.iterator();
            while (o.hasNext()) {
                EObject eObject = (EObject)o.next();
                result.add(this.copy(eObject));
                TreeIterator eAllContents = eObject.eAllContents();
                while (eAllContents.hasNext()) {
                    EObject childEObject = (EObject)eAllContents.next();
                    if (!(childEObject instanceof Element)) continue;
                    result.addAll(super.copyAll((Collection)((Element)childEObject).getStereotypeApplications()));
                }
            }
            return result;
        }

        protected Collection getAllMergedPackages(Package package_) {
            return this.getAllMergedPackages(package_, (Collection)new UniqueEList.FastCompare());
        }

        private Collection getAllMergedPackages(Package package_, Collection allMergedPackages) {
            Iterator packageMerges = package_.getPackageMerges().iterator();
            while (packageMerges.hasNext()) {
                Package mergedPackage = ((PackageMerge)packageMerges.next()).getMergedPackage();
                if (mergedPackage == null) continue;
                this.getAllMergedPackages(mergedPackage, allMergedPackages);
                allMergedPackages.add(mergedPackage);
            }
            return allMergedPackages;
        }

        protected void processDifferentPropertyStaticity(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.resultingToMergedEObjectMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                if (!(key instanceof Property)) continue;
                Property property = (Property)key;
                Iterator mergedProperties = ((List)entry.getValue()).iterator();
                while (mergedProperties.hasNext()) {
                    Property mergedProperty = (Property)mergedProperties.next();
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DIFFERENT_PROPERTY_STATICITY)) || diagnostics == null || property.isStatic() == mergedProperty.isStatic()) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 1001, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportDifferentPropertyStaticity_diagnostic", UMLUtil.access$3(context, property, mergedProperty)), new Object[]{property, mergedProperty}));
                }
            }
        }

        protected void processDifferentPropertyUniqueness(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.resultingToMergedEObjectMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                if (!(key instanceof Property)) continue;
                Property property = (Property)key;
                Iterator mergedProperties = ((List)entry.getValue()).iterator();
                while (mergedProperties.hasNext()) {
                    Property mergedProperty = (Property)mergedProperties.next();
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DIFFERENT_PROPERTY_UNIQUENESS)) || diagnostics == null || property.isUnique() == mergedProperty.isUnique()) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 1002, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportDifferentPropertyUniqueness_diagnostic", UMLUtil.access$3(context, property, mergedProperty)), new Object[]{property, mergedProperty}));
                }
            }
        }

        protected void processImplicitRedefinitions(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Feature)) continue;
                Feature redefiningFeature = (Feature)resultingEObject;
                EList redefinedFeatures = UMLUtil.getRedefinedFeatures(redefiningFeature);
                Iterator validRedefinitions = UMLUtil.findValidRedefinitions(redefiningFeature, redefiningFeature.getName()).iterator();
                while (validRedefinitions.hasNext()) {
                    Feature redefinedFeature = (Feature)validRedefinitions.next();
                    if (redefinedFeatures.contains(redefinedFeature)) continue;
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__IMPLICIT_REDEFINITIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1004, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ProcessImplicitFeatureRedefinition_diagnostic", UMLUtil.access$3(context, redefiningFeature, redefinedFeature)), new Object[]{redefiningFeature, redefinedFeature}));
                        }
                        redefinedFeatures.add(redefinedFeature);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__IMPLICIT_REDEFINITIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1004, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportImplicitFeatureRedefinition_diagnostic", UMLUtil.access$3(context, redefiningFeature, redefinedFeature)), new Object[]{redefiningFeature, redefinedFeature}));
                }
            }
        }

        protected void processInvalidRedefinitions(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Feature)) continue;
                Feature redefiningFeature = (Feature)resultingEObject;
                EList redefinedFeatures = UMLUtil.getRedefinedFeatures(redefiningFeature);
                Iterator i = new ArrayList(redefinedFeatures).iterator();
                while (i.hasNext()) {
                    Collection validRedefinitions;
                    Feature redefinedFeature = (Feature)i.next();
                    if (!UMLUtil.isRedefinitionValid(redefiningFeature, redefinedFeature)) {
                        if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__INVALID_REDEFINITIONS)) || UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__INVALID_REDEFINITIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1005, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_DiscardInvalidFeatureRedefinition_diagnostic", UMLUtil.access$3(context, redefiningFeature, redefinedFeature)), new Object[]{redefiningFeature, redefinedFeature}));
                            }
                            redefinedFeatures.remove(redefinedFeature);
                        } else if (UMLUtil.OPTION__REPORT.equals(options.get(OPTION__INVALID_REDEFINITIONS)) && diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1005, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportInvalidFeatureRedefinition_diagnostic", UMLUtil.access$3(context, redefiningFeature, redefinedFeature)), new Object[]{redefiningFeature, redefinedFeature}));
                        }
                    }
                    if (!UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__INVALID_REDEFINITIONS)) || (validRedefinitions = UMLUtil.findValidRedefinitions(redefiningFeature, redefinedFeature.getName())).isEmpty()) continue;
                    Iterator j = validRedefinitions.iterator();
                    while (j.hasNext()) {
                        Feature validRedefinition = (Feature)j.next();
                        if (redefinedFeatures.contains(validRedefinition)) continue;
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1005, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ProcessInvalidRedefinition_diagnostic", UMLUtil.access$4(context, redefiningFeature, redefinedFeature, validRedefinition)), new Object[]{redefiningFeature, validRedefinition}));
                        }
                        redefinedFeatures.add(validRedefinition);
                    }
                    if (validRedefinitions.contains(redefinedFeature)) continue;
                    redefinedFeatures.remove(redefinedFeature);
                }
            }
        }

        protected void processInvalidSubsets(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Property)) continue;
                Property subsettingProperty = (Property)resultingEObject;
                EList subsettedProperties = subsettingProperty.getSubsettedProperties();
                Iterator i = new ArrayList(subsettedProperties).iterator();
                while (i.hasNext()) {
                    Collection validSubsets;
                    Property subsettedProperty = (Property)i.next();
                    if (!UMLUtil.isSubsetValid(subsettingProperty, subsettedProperty)) {
                        if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__INVALID_SUBSETS)) || UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__INVALID_SUBSETS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1006, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_DiscardInvalidSubset_diagnostic", UMLUtil.access$3(context, subsettingProperty, subsettedProperty)), new Object[]{subsettingProperty, subsettedProperty}));
                            }
                            subsettedProperties.remove(subsettedProperty);
                        } else if (UMLUtil.OPTION__REPORT.equals(options.get(OPTION__INVALID_SUBSETS)) && diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1006, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportInvalidSubset_diagnostic", UMLUtil.access$3(context, subsettingProperty, subsettedProperty)), new Object[]{subsettingProperty, subsettedProperty}));
                        }
                    }
                    if (!UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__INVALID_SUBSETS)) || (validSubsets = UMLUtil.findValidSubsets(subsettingProperty, subsettedProperty.getName())).isEmpty()) continue;
                    Iterator j = validSubsets.iterator();
                    while (j.hasNext()) {
                        Property validSubset = (Property)j.next();
                        if (subsettedProperties.contains(validSubset)) continue;
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1006, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ProcessInvalidSubset_diagnostic", UMLUtil.access$4(context, subsettingProperty, subsettedProperty, validSubset)), new Object[]{subsettingProperty, validSubset}));
                        }
                        subsettedProperties.add(validSubset);
                    }
                    if (validSubsets.contains(subsettedProperty)) continue;
                    subsettedProperties.remove(subsettedProperty);
                }
            }
        }

        protected void processEmptyUnions(Map options, DiagnosticChain diagnostics, Map context) {
            LinkedHashMap<Property, UniqueEList.FastCompare> unionToSubsettingPropertyMap = new LinkedHashMap<Property, UniqueEList.FastCompare>();
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Property)) continue;
                Property property = (Property)resultingEObject;
                if (property.isDerivedUnion() && !unionToSubsettingPropertyMap.containsKey(property)) {
                    unionToSubsettingPropertyMap.put(property, new UniqueEList.FastCompare());
                }
                Iterator subsettedProperties = property.getSubsettedProperties().iterator();
                while (subsettedProperties.hasNext()) {
                    Property subsettedProperty = (Property)subsettedProperties.next();
                    if (!subsettedProperty.isDerivedUnion()) continue;
                    List subsettingProperties = (List)unionToSubsettingPropertyMap.get(subsettedProperty);
                    if (subsettingProperties == null) {
                        subsettingProperties = new UniqueEList.FastCompare();
                        unionToSubsettingPropertyMap.put(subsettedProperty, (UniqueEList.FastCompare)subsettingProperties);
                    }
                    subsettingProperties.add(property);
                }
            }
            Iterator entries = unionToSubsettingPropertyMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!((List)entry.getValue()).isEmpty()) continue;
                Property unionProperty = (Property)entry.getKey();
                if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__EMPTY_UNIONS))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1007, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ProcessEmptyUnion_diagnostic", UMLUtil.access$5(context, unionProperty)), new Object[]{unionProperty}));
                    }
                    unionProperty.setIsDerivedUnion(false);
                    continue;
                }
                if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__EMPTY_UNIONS)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1007, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportEmptyUnion_diagnostic", UMLUtil.access$5(context, unionProperty)), new Object[]{unionProperty}));
            }
        }

        protected void processRedundantGeneralizations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Classifier)) continue;
                Classifier classifier = (Classifier)resultingEObject;
                EList generalizations = classifier.getGeneralizations();
                Iterator i = new ArrayList(generalizations).iterator();
                block1: while (i.hasNext()) {
                    Classifier general = ((Generalization)i.next()).getGeneral();
                    if (general == null) continue;
                    EList generalAllParents = general.allParents();
                    Iterator j = generalizations.iterator();
                    while (j.hasNext()) {
                        Generalization otherGeneralization = (Generalization)j.next();
                        Classifier otherGeneral = otherGeneralization.getGeneral();
                        if (general == otherGeneral || !generalAllParents.contains((Object)otherGeneral) || otherGeneralization.hasKeyword("extend")) continue;
                        if (UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__REDUNDANT_GENERALIZATIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1003, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_DiscardRedundantGeneralization_diagnostic", UMLUtil.access$4(context, classifier, otherGeneral, general)), new Object[]{classifier, otherGeneral}));
                            }
                            j.remove();
                            continue block1;
                        }
                        if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__REDUNDANT_GENERALIZATIONS)) || diagnostics == null) continue block1;
                        diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1003, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportRedundantGeneralization_diagnostic", UMLUtil.access$4(context, classifier, otherGeneral, general)), new Object[]{classifier, otherGeneral}));
                        continue block1;
                    }
                }
            }
        }

        protected void processAssociationSpecializations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.resultingToMergedEObjectMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EObject resultingEObject = (EObject)entry.getKey();
                if (!(resultingEObject instanceof Association)) continue;
                Association association = (Association)resultingEObject;
                UniqueEList.FastCompare generalAssociations = new UniqueEList.FastCompare();
                Iterator memberEnds = association.getMemberEnds().iterator();
                while (memberEnds.hasNext()) {
                    Property memberEnd = (Property)memberEnds.next();
                    Iterator redefinedProperties = memberEnd.getRedefinedProperties().iterator();
                    while (redefinedProperties.hasNext()) {
                        Association redefinedAssociation = ((Property)redefinedProperties.next()).getAssociation();
                        if (redefinedAssociation == null) continue;
                        generalAssociations.add(redefinedAssociation);
                    }
                    Iterator subsettedProperties = memberEnd.getSubsettedProperties().iterator();
                    while (subsettedProperties.hasNext()) {
                        Association subsettedAssociation = ((Property)subsettedProperties.next()).getAssociation();
                        if (subsettedAssociation == null) continue;
                        generalAssociations.add(subsettedAssociation);
                    }
                }
                Iterator i = generalAssociations.iterator();
                while (i.hasNext()) {
                    Association generalAssocation = (Association)i.next();
                    if (association.allParents().contains((Object)generalAssocation)) continue;
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__ASSOCIATION_SPECIALIZATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1008, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ProcessAssociationSpecialization_diagnostic", UMLUtil.access$3(context, association, generalAssocation)), new Object[]{association, generalAssocation}));
                        }
                        association.createGeneralization(generalAssocation);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__ASSOCIATION_SPECIALIZATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1008, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportAssociationSpecialization_diagnostic", UMLUtil.access$3(context, association, generalAssocation)), new Object[]{association, generalAssocation}));
                }
            }
        }

        protected void processCapabilities(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.resultingToMergedEObjectMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EObject resultingEObject = (EObject)entry.getKey();
                if (!(resultingEObject instanceof RedefinableElement)) continue;
                Package resultingPackage = ((RedefinableElement)resultingEObject).getNearestPackage();
                Iterator mergedEObjects = ((List)entry.getValue()).iterator();
                while (mergedEObjects.hasNext()) {
                    Package mergedPackage = ((Element)mergedEObjects.next()).getNearestPackage();
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__CAPABILITIES))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 1009, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ProcessCapability_diagnostic", UMLUtil.access$3(context, resultingEObject, mergedPackage)), new Object[]{resultingEObject, mergedPackage}));
                        }
                        UMLUtil.getEAnnotation((EModelElement)UMLUtil.getEAnnotation((EModelElement)resultingPackage, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true), (String)mergedPackage.getQualifiedName(), (boolean)true).getReferences().add((Object)resultingEObject);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__CAPABILITIES)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1009, UMLPlugin.INSTANCE.getString("_UI_PackageMerger_ReportCapability_diagnostic", UMLUtil.access$3(context, resultingEObject, mergedPackage)), new Object[]{resultingEObject, mergedPackage}));
                }
            }
        }

        protected void processOptions(Map options, DiagnosticChain diagnostics, Map context) {
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DIFFERENT_PROPERTY_STATICITY))) {
                this.processDifferentPropertyStaticity(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DIFFERENT_PROPERTY_UNIQUENESS))) {
                this.processDifferentPropertyUniqueness(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__IMPLICIT_REDEFINITIONS))) {
                this.processImplicitRedefinitions(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__INVALID_REDEFINITIONS))) {
                this.processInvalidRedefinitions(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__INVALID_SUBSETS))) {
                this.processInvalidSubsets(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__EMPTY_UNIONS))) {
                this.processEmptyUnions(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__ASSOCIATION_SPECIALIZATIONS))) {
                this.processAssociationSpecializations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__REDUNDANT_GENERALIZATIONS))) {
                this.processRedundantGeneralizations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__CAPABILITIES))) {
                this.processCapabilities(options, diagnostics, context);
            }
        }

        public void merge(Package package_, Map options, DiagnosticChain diagnostics, Map context) {
            this.receivingPackage = package_;
            this.mergedPackages = this.getAllMergedPackages(package_);
            this.copyAll(this.mergedPackages);
            this.copyReferences();
            this.receivingPackage.getPackageMerges().clear();
            if (options != null) {
                this.processOptions(options, diagnostics, context);
            }
        }

        static /* synthetic */ EObject access$0(PackageMerger packageMerger, EObject eObject) {
            return super.createCopy(eObject);
        }

        static /* synthetic */ EClass access$1(PackageMerger packageMerger, EClass eClass) {
            return packageMerger.getTarget(eClass);
        }

        protected class BodyMatcher
        extends UML2Util.EStructuralFeatureMatcher {
            protected BodyMatcher(Comment comment) {
                super((EObject)comment, (EStructuralFeature)UMLPackage.Literals.COMMENT__BODY);
            }
        }

        protected class KeyMatcher
        extends UML2Util.EClassMatcher {
            protected KeyMatcher(BasicEMap.Entry entry) {
                super((EObject)entry);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && UMLUtil.safeEquals((Object)((BasicEMap.Entry)this.eObject).getKey(), (Object)((BasicEMap.Entry)otherEObject).getKey());
            }
        }

        protected class NameMatcher
        extends UML2Util.EStructuralFeatureMatcher {
            protected NameMatcher(NamedElement namedElement) {
                super((EObject)namedElement, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__NAME);
            }
        }

        protected class ResultingQNameMatcher
        extends UML2Util.EClassMatcher {
            protected ResultingQNameMatcher(EObject eObject) {
                super(eObject);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && UMLUtil.safeEquals((Object)PackageMerger.this.getResultingQName(this.eObject), (Object)PackageMerger.this.getResultingQName(otherEObject));
            }
        }

        protected class SourceMatcher
        extends UML2Util.EStructuralFeatureMatcher {
            protected SourceMatcher(EAnnotation eAnnotation) {
                super((EObject)eAnnotation, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__SOURCE);
            }
        }

        protected class StringValueMatcher
        extends UML2Util.EClassMatcher {
            protected StringValueMatcher(ValueSpecification valueSpecification) {
                super((EObject)valueSpecification);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && UMLUtil.safeEquals((Object)((ValueSpecification)this.eObject).stringValue(), (Object)((ValueSpecification)otherEObject).stringValue());
            }
        }

        protected class TypeMatcher
        extends NameMatcher {
            protected TypeMatcher(TypedElement typedElement) {
                super(typedElement);
            }

            public boolean matches(EObject otherEObject) {
                if (super.matches(otherEObject)) {
                    Type otherType;
                    Type type = ((TypedElement)this.eObject).getType();
                    return new ResultingQNameMatcher((EObject)type).matches((EObject)(otherType = ((TypedElement)otherEObject).getType())) || type instanceof Classifier && otherType instanceof Classifier && (UMLUtil.findEObject((Collection)((Classifier)type).allParents(), (UML2Util.EObjectMatcher)new ResultingQNameMatcher((EObject)otherType)) != null || UMLUtil.findEObject((Collection)((Classifier)otherType).allParents(), (UML2Util.EObjectMatcher)new ResultingQNameMatcher((EObject)type)) != null);
                }
                return false;
            }
        }
    }

    public static class Profile2EPackageConverter
    extends UML2EcoreConverter {
        public Object caseComment(Comment comment) {
            return null;
        }

        public Object casePackage(Package package_) {
            if (this.packages.contains(package_)) {
                return super.casePackage(package_);
            }
            Object ePackage = this.doSwitch((EObject)((Profile)this.packages.iterator().next()));
            this.elementToEModelElementMap.put(package_, ePackage);
            return ePackage;
        }

        public Object caseProfile(Profile profile) {
            EPackage ePackage = (EPackage)this.casePackage(profile);
            if (this.packages.contains(profile)) {
                CharSequence nsURI;
                String profileName = ePackage.getName();
                ePackage.setNsPrefix(profileName);
                Package nestingPackage = profile.getNestingPackage();
                String profileParentQualifiedName = nestingPackage == null ? "" : UMLUtil.getQualifiedName(nestingPackage, ".");
                String version = String.valueOf(0);
                EPackage definition = profile.getDefinition();
                if (definition != null) {
                    try {
                        nsURI = definition.getNsURI();
                        int lastIndex = ((String)nsURI).lastIndexOf(47);
                        if (lastIndex > 7) {
                            version = String.valueOf(Integer.parseInt(((String)nsURI).substring(lastIndex + 1)) + 1);
                        } else {
                            String nsPrefix = definition.getNsPrefix();
                            version = String.valueOf(Integer.parseInt(nsPrefix.substring(nsPrefix.lastIndexOf(95) + 1)) + 1);
                        }
                    }
                    catch (Exception exception) {}
                }
                nsURI = new StringBuffer("http://");
                ((StringBuffer)nsURI).append(profileParentQualifiedName);
                ((StringBuffer)nsURI).append("/schemas/");
                ((StringBuffer)nsURI).append(profileName);
                ((StringBuffer)nsURI).append('/');
                ((StringBuffer)nsURI).append(EcoreUtil.generateUUID());
                ((StringBuffer)nsURI).append('/');
                ((StringBuffer)nsURI).append(version);
                ePackage.setNsURI(((StringBuffer)nsURI).toString());
            }
            return ePackage;
        }

        protected EClassifier getEType(Type type) {
            EClassifier eType;
            Class class_;
            if (type instanceof Class && (class_ = (Class)type).isMetaclass() && (eType = UMLUtil.getEClassifier(class_)) != null) {
                return eType;
            }
            return super.getEType(type);
        }

        protected void processEcoreTaggedValues(EPackage ePackage, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            if (this.packages.contains(element)) {
                super.processEcoreTaggedValues(ePackage, element, options, diagnostics, context);
            }
        }

        protected void setName(ENamedElement eNamedElement, NamedElement namedElement) {
            new UMLSwitch(this, eNamedElement){
                final /* synthetic */ Profile2EPackageConverter this$1;
                private final /* synthetic */ ENamedElement val$eNamedElement;
                {
                    this.this$1 = profile2EPackageConverter;
                    this.val$eNamedElement = eNamedElement;
                }

                public Object caseClassifier(Classifier classifier) {
                    this.this$1.setName(this.val$eNamedElement, this.this$1.packages.contains(classifier.getPackage()) ? classifier.getName() : UMLUtil.getQualifiedName(classifier, "_"), true);
                    return classifier;
                }

                public Object caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
                    this.this$1.setName(this.val$eNamedElement, enumerationLiteral.getName(), false);
                    return enumerationLiteral;
                }

                public Object caseNamedElement(NamedElement namedElement) {
                    this.this$1.setName(this.val$eNamedElement, namedElement.getName(), true);
                    return namedElement;
                }
            }.doSwitch((EObject)namedElement);
        }

        public Object doSwitch(EObject eObject) {
            EList references;
            Object eModelElement = super.doSwitch(eObject);
            if (eModelElement instanceof EClassifier && (references = UMLUtil.getEAnnotation((EModelElement)((EClassifier)eModelElement), (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getReferences()).isEmpty()) {
                references.add((Object)eObject);
            }
            return eModelElement;
        }
    }

    public static class QualifiedTextProvider
    extends UML2Util.QualifiedTextProvider {
        public static final QualifiedTextProvider DEFAULT = new QualifiedTextProvider();

        public String getText(EObject eObject) {
            return eObject instanceof NamedElement ? ((NamedElement)eObject).getName() : super.getText(eObject);
        }

        public String getSeparator() {
            return "::";
        }
    }

    public static class UML2EcoreConverter
    extends UMLSwitch
    implements UML2Util.Converter {
        private static final boolean DEBUG = false;
        public static final String OPTION__ECORE_TAGGED_VALUES = "ECORE_TAGGED_VALUES";
        public static final String OPTION__REDEFINING_OPERATIONS = "REDEFINING_OPERATIONS";
        public static final String OPTION__REDEFINING_PROPERTIES = "REDEFINING_PROPERTIES";
        public static final String OPTION__SUBSETTING_PROPERTIES = "SUBSETTING_PROPERTIES";
        public static final String OPTION__UNION_PROPERTIES = "UNION_PROPERTIES";
        public static final String OPTION__DERIVED_FEATURES = "DERIVED_FEATURES";
        public static final String OPTION__DUPLICATE_OPERATIONS = "DUPLICATE_OPERATIONS";
        public static final String OPTION__DUPLICATE_OPERATION_INHERITANCE = "DUPLICATE_OPERATION_INHERITANCE";
        public static final String OPTION__DUPLICATE_FEATURES = "DUPLICATE_FEATURES";
        public static final String OPTION__DUPLICATE_FEATURE_INHERITANCE = "DUPLICATE_FEATURE_INHERITANCE";
        public static final String OPTION__SUPER_CLASS_ORDER = "SUPER_CLASS_ORDER";
        public static final String OPTION__ANNOTATION_DETAILS = "ANNOTATION_DETAILS";
        private static final int DIAGNOSTIC_CODE_OFFSET = 2000;
        public static final int ECORE_TAGGED_VALUE = 2001;
        public static final int REDEFINING_OPERATION = 2002;
        public static final int REDEFINING_PROPERTY = 2003;
        public static final int SUBSETTING_PROPERTY = 2004;
        public static final int UNION_PROPERTY = 2005;
        public static final int DERIVED_FEATURE = 2006;
        public static final int DUPLICATE_OPERATION = 2007;
        public static final int DUPLICATE_OPERATION_INHERITANCE = 2008;
        public static final int DUPLICATE_FEATURE = 2009;
        public static final int DUPLICATE_FEATURE_INHERITANCE = 2010;
        public static final int SUPER_CLASS_ORDER = 2011;
        public static final int ANNOTATION_DETAILS = 2012;
        protected final Map elementToEModelElementMap = new LinkedHashMap();
        protected Collection packages = null;

        protected void setName(ENamedElement eNamedElement, String name, boolean validate) {
            eNamedElement.setName(validate ? UMLUtil.getValidJavaIdentifier((String)name) : name);
        }

        protected void setName(ENamedElement eNamedElement, NamedElement namedElement) {
            this.setName(eNamedElement, namedElement.getName(), true);
        }

        protected EClassifier getEType(Type type) {
            EDataType eType = null;
            if (type != null) {
                Object eObject;
                String qualifiedName = type.getQualifiedName();
                if (!UMLUtil.isEmpty((String)qualifiedName) && type instanceof PrimitiveType) {
                    if ("UMLPrimitiveTypes::Boolean".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEBoolean();
                    } else if ("UMLPrimitiveTypes::Integer".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEInt();
                    } else if ("UMLPrimitiveTypes::String".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEString();
                    } else if ("UMLPrimitiveTypes::UnlimitedNatural".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEInt();
                    } else if ("JavaPrimitiveTypes::boolean".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEBoolean();
                    } else if ("JavaPrimitiveTypes::byte".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEByte();
                    } else if ("JavaPrimitiveTypes::char".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEChar();
                    } else if ("JavaPrimitiveTypes::double".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEDouble();
                    } else if ("JavaPrimitiveTypes::float".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEFloat();
                    } else if ("JavaPrimitiveTypes::int".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEInt();
                    } else if ("JavaPrimitiveTypes::long".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getELong();
                    } else if ("JavaPrimitiveTypes::short".equals(qualifiedName)) {
                        eType = EcorePackage.eINSTANCE.getEShort();
                    } else if (qualifiedName.startsWith("EcorePrimitiveTypes::")) {
                        eType = EcorePackage.eINSTANCE.getEClassifier(type.getName());
                    }
                }
                if (eType == null && (eObject = this.doSwitch((EObject)type)) instanceof EClassifier) {
                    eType = (EClassifier)eObject;
                }
            }
            return eType;
        }

        protected EClassifier getEType(TypedElement typedElement) {
            return this.getEType(typedElement.getType());
        }

        protected Stereotype getAppliedEcoreStereotype(Element element, String name) {
            return element.getAppliedStereotype("Ecore::" + name);
        }

        public Object caseClass(Class class_) {
            Package package_ = class_.getNearestPackage();
            if (package_ != null) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                this.elementToEModelElementMap.put(class_, eClass);
                EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
                ePackage.getEClassifiers().add((Object)eClass);
                this.setName((ENamedElement)eClass, class_);
                eClass.setAbstract(class_.isAbstract());
                this.defaultCase((EObject)class_);
                return eClass;
            }
            return super.caseClass(class_);
        }

        public Object caseComment(Comment comment) {
            Iterator annotatedElements = comment.getAnnotatedElements().iterator();
            while (annotatedElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)this.doSwitch((EObject)((Element)annotatedElements.next()));
                if (eModelElement == null) continue;
                UMLUtil.access$6(eModelElement, comment.getBody());
            }
            return super.caseComment(comment);
        }

        public Object caseConstraint(Constraint constraint) {
            EModelElement eModelElement;
            Namespace context = constraint.getContext();
            if (context != null && (eModelElement = (EModelElement)this.doSwitch((EObject)context)) != null) {
                String name;
                ValueSpecification specification = constraint.getSpecification();
                if (eModelElement instanceof EClassifier && !UMLUtil.isEmpty((String)(name = constraint.getName()))) {
                    if (eModelElement instanceof EClass) {
                        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
                        this.elementToEModelElementMap.put(constraint, eOperation);
                        ((EClass)eModelElement).getEOperations().add((Object)eOperation);
                        this.setName((ENamedElement)eOperation, name, true);
                        eOperation.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
                        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                        eOperation.getEParameters().add((Object)eParameter);
                        this.setName((ENamedElement)eParameter, "diagnostics", false);
                        eParameter.setEType((EClassifier)EcorePackage.eINSTANCE.getEDiagnosticChain());
                        eParameter = EcoreFactory.eINSTANCE.createEParameter();
                        eOperation.getEParameters().add((Object)eParameter);
                        this.setName((ENamedElement)eParameter, "context", false);
                        eParameter.setEType((EClassifier)EcorePackage.eINSTANCE.getEMap());
                        this.defaultCase((EObject)constraint);
                        eModelElement = eOperation;
                    } else {
                        UMLUtil.access$7(eModelElement, name);
                    }
                }
                if (specification != null) {
                    UMLUtil.access$6(eModelElement, specification.stringValue());
                }
                return eModelElement;
            }
            return super.caseConstraint(constraint);
        }

        public Object caseEModelElement(EModelElement eModelElement) {
            return eModelElement;
        }

        public Object caseEnumeration(Enumeration enumeration) {
            Package package_ = enumeration.getNearestPackage();
            if (package_ != null) {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                this.elementToEModelElementMap.put(enumeration, eEnum);
                EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
                ePackage.getEClassifiers().add((Object)eEnum);
                this.setName((ENamedElement)eEnum, enumeration);
                this.defaultCase((EObject)enumeration);
                return eEnum;
            }
            return super.caseEnumeration(enumeration);
        }

        public Object caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
            Enumeration enumeration = enumerationLiteral.getEnumeration();
            if (enumeration != null) {
                EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                this.elementToEModelElementMap.put(enumerationLiteral, eEnumLiteral);
                EEnum eEnum = (EEnum)this.doSwitch((EObject)enumeration);
                eEnum.getELiterals().add((Object)eEnumLiteral);
                this.setName((ENamedElement)eEnumLiteral, enumerationLiteral);
                int value = enumeration.getOwnedLiterals().indexOf((Object)enumerationLiteral);
                ValueSpecification specification = enumerationLiteral.getSpecification();
                if (specification != null) {
                    try {
                        value = specification.integerValue();
                    }
                    catch (Exception exception) {}
                }
                eEnumLiteral.setValue(value);
                this.defaultCase((EObject)enumerationLiteral);
                return eEnumLiteral;
            }
            return super.caseEnumerationLiteral(enumerationLiteral);
        }

        public Object caseGeneralization(Generalization generalization) {
            EClassifier specificEClassifier;
            Classifier specific = generalization.getSpecific();
            if (specific != null && (specificEClassifier = (EClassifier)this.doSwitch((EObject)specific)) instanceof EClass) {
                EClass generalEClass;
                EClassifier generalEClassifier;
                EClass specificEClass = (EClass)specificEClassifier;
                Classifier general = generalization.getGeneral();
                if (general != null && (generalEClassifier = (EClassifier)this.doSwitch((EObject)general)) instanceof EClass && !specificEClass.isSuperTypeOf(generalEClass = (EClass)generalEClassifier)) {
                    specificEClass.getESuperTypes().add((Object)generalEClass);
                }
            }
            return super.caseGeneralization(generalization);
        }

        public Object caseInterfaceRealization(InterfaceRealization interfaceRealization) {
            EClassifier implementingEClassifier;
            BehavioredClassifier implementingClassifier = interfaceRealization.getImplementingClassifier();
            if (implementingClassifier != null && (implementingEClassifier = (EClassifier)this.doSwitch((EObject)implementingClassifier)) instanceof EClass) {
                EClass contractEClass;
                EClass implementingEClass = (EClass)implementingEClassifier;
                Interface contract = interfaceRealization.getContract();
                if (contract != null && (contractEClass = (EClass)this.doSwitch((EObject)contract)) != null) {
                    implementingEClass.getESuperTypes().add((Object)contractEClass);
                }
            }
            return super.caseInterfaceRealization(interfaceRealization);
        }

        public Object caseInterface(Interface interface_) {
            Package package_ = interface_.getNearestPackage();
            if (package_ != null) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                this.elementToEModelElementMap.put(interface_, eClass);
                EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
                ePackage.getEClassifiers().add((Object)eClass);
                this.setName((ENamedElement)eClass, interface_);
                eClass.setAbstract(true);
                eClass.setInterface(true);
                this.defaultCase((EObject)interface_);
                return eClass;
            }
            return super.caseInterface(interface_);
        }

        public Object caseMultiplicityElement(MultiplicityElement multiplicityElement) {
            Object eModelElement = this.elementToEModelElementMap.get(multiplicityElement);
            if (eModelElement instanceof ETypedElement) {
                ETypedElement eTypedElement = (ETypedElement)eModelElement;
                int upper = multiplicityElement.getUpper();
                if (eTypedElement.getUpperBound() != upper) {
                    eTypedElement.setUpperBound(upper);
                }
                int lower = multiplicityElement.getLower();
                if (eTypedElement.getLowerBound() != lower) {
                    eTypedElement.setLowerBound(lower);
                }
                eTypedElement.setOrdered(multiplicityElement.isOrdered());
                eTypedElement.setUnique(multiplicityElement.isUnique());
                return eTypedElement;
            }
            return super.caseMultiplicityElement(multiplicityElement);
        }

        public Object caseOperation(Operation operation) {
            Namespace namespace = operation.getNamespace();
            if (namespace instanceof Class || namespace instanceof Interface) {
                EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
                this.elementToEModelElementMap.put(operation, eOperation);
                EClass eClass = (EClass)this.doSwitch((EObject)namespace);
                eClass.getEOperations().add((Object)eOperation);
                this.setName((ENamedElement)eOperation, operation);
                EList eExceptions = eOperation.getEExceptions();
                Iterator raisedExceptions = operation.getRaisedExceptions().iterator();
                while (raisedExceptions.hasNext()) {
                    EClassifier eType = this.getEType((Type)raisedExceptions.next());
                    if (eType == null) continue;
                    eExceptions.add((Object)eType);
                }
                eOperation.setEType(this.getEType(operation.getType()));
                int upper = operation.getUpper();
                if (eOperation.getUpperBound() != upper) {
                    eOperation.setUpperBound(upper);
                }
                int lower = operation.getLower();
                if (eOperation.getLowerBound() != lower) {
                    eOperation.setLowerBound(lower);
                }
                eOperation.setOrdered(operation.isOrdered());
                eOperation.setUnique(operation.isUnique());
                this.defaultCase((EObject)operation);
                return eOperation;
            }
            return super.caseOperation(operation);
        }

        public Object casePackage(Package package_) {
            Package nestingPackage;
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.elementToEModelElementMap.put(package_, ePackage);
            if (!this.packages.contains(package_) && (nestingPackage = package_.getNestingPackage()) != null) {
                ((EPackage)this.doSwitch((EObject)nestingPackage)).getESubpackages().add((Object)ePackage);
            }
            this.setName((ENamedElement)ePackage, package_);
            if (UMLUtil.isEmpty((String)ePackage.getNsPrefix())) {
                EPackage eSuperPackage = ePackage.getESuperPackage();
                ePackage.setNsPrefix(String.valueOf(eSuperPackage == null ? "" : String.valueOf(eSuperPackage.getNsPrefix()) + '.') + ePackage.getName());
            }
            if (UMLUtil.isEmpty((String)ePackage.getNsURI())) {
                ePackage.setNsURI("http:///" + ePackage.getNsPrefix().replace('.', '/') + ".ecore");
            }
            this.defaultCase((EObject)package_);
            return ePackage;
        }

        public Object caseParameter(Parameter parameter) {
            Operation operation = parameter.getOperation();
            if (operation != null && parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) {
                EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                this.elementToEModelElementMap.put(parameter, eParameter);
                EOperation eOperation = (EOperation)this.doSwitch((EObject)operation);
                eOperation.getEParameters().add((Object)eParameter);
                this.setName((ENamedElement)eParameter, parameter);
                this.caseTypedElement(parameter);
                this.caseMultiplicityElement(parameter);
                this.defaultCase((EObject)parameter);
                return eParameter;
            }
            return super.caseParameter(parameter);
        }

        public Object casePrimitiveType(PrimitiveType primitiveType) {
            Package package_ = primitiveType.getNearestPackage();
            if (package_ != null) {
                EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                this.elementToEModelElementMap.put(primitiveType, eDataType);
                EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
                ePackage.getEClassifiers().add((Object)eDataType);
                this.setName((ENamedElement)eDataType, primitiveType);
                eDataType.setInstanceClassName(eDataType.getName());
                this.defaultCase((EObject)primitiveType);
                return eDataType;
            }
            return super.casePrimitiveType(primitiveType);
        }

        public Object caseProperty(Property property) {
            Namespace namespace = property.getNamespace();
            if (namespace instanceof Class || namespace instanceof Interface) {
                EReference eOpposite;
                EAttribute eStructuralFeature = null;
                if (property.getType() instanceof DataType) {
                    EAttribute eAttribute = eStructuralFeature = EcoreFactory.eINSTANCE.createEAttribute();
                    this.elementToEModelElementMap.put(property, eAttribute);
                    String default_ = property.getDefault();
                    if (default_ != null) {
                        eAttribute.setDefaultValueLiteral(default_);
                    }
                } else {
                    eStructuralFeature = EcoreFactory.eINSTANCE.createEReference();
                    EReference eReference = eStructuralFeature;
                    this.elementToEModelElementMap.put(property, eStructuralFeature);
                    eReference.setContainment(property.isComposite());
                }
                EClass eClass = (EClass)this.doSwitch((EObject)namespace);
                eClass.getEStructuralFeatures().add((Object)eStructuralFeature);
                this.setName((ENamedElement)eStructuralFeature, property);
                eStructuralFeature.setChangeable(!property.isReadOnly());
                eStructuralFeature.setDerived(property.isDerived());
                Property opposite = property.getOpposite();
                if (opposite != null && (eOpposite = (EReference)this.doSwitch((EObject)opposite)) != null) {
                    if (property.isDerived() && !eOpposite.isDerived()) {
                        eOpposite.setDerived(true);
                    }
                    ((EReference)eStructuralFeature).setEOpposite(eOpposite);
                }
                this.caseTypedElement(property);
                this.caseMultiplicityElement(property);
                this.defaultCase((EObject)property);
                return eStructuralFeature;
            }
            return super.caseProperty(property);
        }

        public Object caseTypedElement(TypedElement typedElement) {
            Object eModelElement = this.elementToEModelElementMap.get(typedElement);
            if (eModelElement instanceof ETypedElement) {
                ETypedElement eTypedElement = (ETypedElement)eModelElement;
                eTypedElement.setEType(this.getEType(typedElement));
                return eTypedElement;
            }
            return super.caseTypedElement(typedElement);
        }

        public Object defaultCase(EObject eObject) {
            Iterator eContents = eObject.eContents().iterator();
            while (eContents.hasNext()) {
                this.doSwitch((EObject)eContents.next());
            }
            return super.defaultCase(eObject);
        }

        public Object doSwitch(EObject eObject) {
            if (!this.elementToEModelElementMap.containsKey(eObject)) {
                super.doSwitch(eObject);
            }
            return this.elementToEModelElementMap.get(eObject);
        }

        protected void processEcoreTaggedValue(EModelElement eModelElement, EStructuralFeature eStructuralFeature, Element element, Stereotype stereotype, String propertyName, Map options, DiagnosticChain diagnostics, Map context) {
            if (element.hasValue(stereotype, propertyName)) {
                Object value = element.getValue(stereotype, propertyName);
                if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2001, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessEcoreTaggedValue_diagnostic", UMLUtil.access$4(context, eModelElement, UMLUtil.getTagDefinition(stereotype, propertyName), value)), new Object[]{eModelElement}));
                    }
                    if (eStructuralFeature != null) {
                        eModelElement.eSet(eStructuralFeature, eStructuralFeature == EcorePackage.Literals.ENAMED_ELEMENT__NAME ? UMLUtil.getValidJavaIdentifier((String)((String)value)) : value);
                    } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_CONTENT_KIND) {
                        Enumeration contentKindEnumeration = ((EnumerationLiteral)value).getEnumeration();
                        if (value == contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__EMPTY)) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 1);
                        } else if (value == contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__SIMPLE)) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 2);
                        } else if (value == contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__MIXED)) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 3);
                        } else if (value == contentKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ELEMENT_ONLY)) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 4);
                        }
                    } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_FEATURE_KIND) {
                        Enumeration featureKindEnumeration = ((EnumerationLiteral)value).getEnumeration();
                        if (value == featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__SIMPLE)) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 1);
                        } else if (value == featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ATTRIBUTE)) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 2);
                        } else if (value == featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ATTRIBUTE_WILDCARD)) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 3);
                        } else if (value == featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ELEMENT)) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 4);
                        } else if (value == featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__ELEMENT_WILDCARD)) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 5);
                        } else if (value == featureKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__GROUP)) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 6);
                        }
                    } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_NAME) {
                        if (eModelElement instanceof EClassifier) {
                            ExtendedMetaData.INSTANCE.setName((EClassifier)eModelElement, (String)value);
                        } else if (eModelElement instanceof EStructuralFeature) {
                            ExtendedMetaData.INSTANCE.setName((EStructuralFeature)eModelElement, (String)value);
                        }
                    } else if (propertyName == UMLUtil.TAG_DEFINITION__XML_NAMESPACE) {
                        ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)eModelElement, (String)value);
                    } else if (propertyName == UMLUtil.TAG_DEFINITION__VISIBILITY) {
                        eStructuralFeature = (EStructuralFeature)eModelElement;
                        boolean isChangeable = eStructuralFeature.isChangeable();
                        boolean isMany = eStructuralFeature.isMany();
                        boolean isUnsettable = eStructuralFeature.isUnsettable();
                        Enumeration visibilityKindEnumeration = ((EnumerationLiteral)value).getEnumeration();
                        if (value == visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__NONE)) {
                            EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0, (boolean)true);
                            if (isChangeable && !isMany) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                            }
                            if (isUnsettable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                                if (isChangeable) {
                                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                                }
                            }
                        } else if (value == visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__READ_ONLY)) {
                            if (!isMany && isChangeable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                            }
                            if (isUnsettable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                                if (isChangeable) {
                                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                                }
                            }
                        } else if (value == visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__READ_WRITE)) {
                            if (isUnsettable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                                if (isChangeable) {
                                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                                }
                            }
                        } else if (value == visibilityKindEnumeration.getOwnedLiteral(UMLUtil.ENUMERATION_LITERAL__READ_ONLY_UNSETTABLE)) {
                            if (!isMany && isChangeable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                            }
                            if (isUnsettable && isChangeable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                            }
                        }
                    }
                } else if (UMLUtil.OPTION__REPORT.equals(options.get(OPTION__ECORE_TAGGED_VALUES)) && diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2001, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportEcoreTaggedValue_diagnostic", UMLUtil.access$4(context, eModelElement, UMLUtil.getTagDefinition(stereotype, propertyName), value)), new Object[]{eModelElement}));
                }
            }
        }

        protected void processEcoreTaggedValues(EClassifier eClassifier, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eClassifierStereotype = (Stereotype)new EcoreSwitch(this, element, options, diagnostics, context){
                final /* synthetic */ UML2EcoreConverter this$1;
                private final /* synthetic */ Element val$element;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = uML2EcoreConverter;
                    this.val$element = element;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseEClass(EClass eClass) {
                    Stereotype eClassStereotype = this.this$1.getAppliedEcoreStereotype(this.val$element, "EClass");
                    if (eClassStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eClass, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$element, eClassStereotype, "className", this.val$options, this.val$diagnostics, this.val$context);
                        this.this$1.processEcoreTaggedValue((EModelElement)eClass, null, this.val$element, eClassStereotype, "xmlContentKind", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eClassStereotype;
                }

                public Object caseEDataType(EDataType eDataType) {
                    Stereotype eDataTypeStereotype = this.this$1.getAppliedEcoreStereotype(this.val$element, "EDataType");
                    if (eDataTypeStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eDataType, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$element, eDataTypeStereotype, "dataTypeName", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eDataTypeStereotype;
                }
            }.doSwitch((EObject)eClassifier);
            if (eClassifierStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eClassifier, null, element, eClassifierStereotype, UMLUtil.TAG_DEFINITION__XML_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eClassifier, (EStructuralFeature)EcorePackage.eINSTANCE.getEClassifier_InstanceClassName(), element, eClassifierStereotype, UMLUtil.TAG_DEFINITION__INSTANCE_CLASS_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EEnum eEnum, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eEnumStereotype = this.getAppliedEcoreStereotype(element, UMLUtil.STEREOTYPE__E_ENUM);
            if (eEnumStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eEnum, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), element, eEnumStereotype, UMLUtil.TAG_DEFINITION__ENUM_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eEnum, null, element, eEnumStereotype, UMLUtil.TAG_DEFINITION__XML_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EEnumLiteral eEnumLiteral, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eEnumLiteralStereotype = this.getAppliedEcoreStereotype(element, UMLUtil.STEREOTYPE__E_ENUM_LITERAL);
            if (eEnumLiteralStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eEnumLiteral, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), element, eEnumLiteralStereotype, UMLUtil.TAG_DEFINITION__ENUM_LITERAL_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EOperation eOperation, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eOperationStereotype = this.getAppliedEcoreStereotype(element, UMLUtil.STEREOTYPE__E_OPERATION);
            if (eOperationStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eOperation, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), element, eOperationStereotype, UMLUtil.TAG_DEFINITION__OPERATION_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EPackage ePackage, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype ePackageStereotype = this.getAppliedEcoreStereotype(element, UMLUtil.STEREOTYPE__E_PACKAGE);
            if (ePackageStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), element, ePackageStereotype, UMLUtil.TAG_DEFINITION__PACKAGE_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsPrefix(), element, ePackageStereotype, UMLUtil.TAG_DEFINITION__NS_PREFIX, options, diagnostics, context);
                if (UMLUtil.isEmpty((String)ePackage.getNsPrefix())) {
                    this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsPrefix(), element, ePackageStereotype, UMLUtil.TAG_DEFINITION__BASE_PACKAGE, options, diagnostics, context);
                    String nsPrefix = ePackage.getNsPrefix();
                    if (!UMLUtil.isEmpty((String)nsPrefix)) {
                        ePackage.setNsPrefix(String.valueOf(nsPrefix) + '.' + ePackage.getName());
                    }
                }
                this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsURI(), element, ePackageStereotype, UMLUtil.TAG_DEFINITION__NS_URI, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EParameter eParameter, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eParameterStereotype = this.getAppliedEcoreStereotype(element, UMLUtil.STEREOTYPE__E_PARAMETER);
            if (eParameterStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eParameter, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), element, eParameterStereotype, UMLUtil.TAG_DEFINITION__PARAMETER_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EStructuralFeature eStructuralFeature, Element element, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eStructuralFeatureStereotype = (Stereotype)new EcoreSwitch(this, element, options, diagnostics, context){
                final /* synthetic */ UML2EcoreConverter this$1;
                private final /* synthetic */ Element val$element;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = uML2EcoreConverter;
                    this.val$element = element;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseEAttribute(EAttribute eAttribute) {
                    Stereotype eAttributeStereotype = this.this$1.getAppliedEcoreStereotype(this.val$element, "EAttribute");
                    if (eAttributeStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eAttribute, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$element, eAttributeStereotype, "attributeName", this.val$options, this.val$diagnostics, this.val$context);
                        this.this$1.processEcoreTaggedValue((EModelElement)eAttribute, (EStructuralFeature)EcorePackage.eINSTANCE.getEAttribute_ID(), this.val$element, eAttributeStereotype, "isID", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eAttributeStereotype;
                }

                public Object caseEReference(EReference eReference) {
                    Stereotype eReferenceStereotype = this.this$1.getAppliedEcoreStereotype(this.val$element, "EReference");
                    if (eReferenceStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eReference, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$element, eReferenceStereotype, "referenceName", this.val$options, this.val$diagnostics, this.val$context);
                        this.this$1.processEcoreTaggedValue((EModelElement)eReference, (EStructuralFeature)EcorePackage.eINSTANCE.getEReference_ResolveProxies(), this.val$element, eReferenceStereotype, "isResolveProxies", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eReferenceStereotype;
                }
            }.doSwitch((EObject)eStructuralFeature);
            if (eStructuralFeatureStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Transient(), element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__IS_TRANSIENT, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Unsettable(), element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__IS_UNSETTABLE, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(), element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__IS_VOLATILE, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__XML_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__XML_NAMESPACE, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__XML_FEATURE_KIND, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, element, eStructuralFeatureStereotype, UMLUtil.TAG_DEFINITION__VISIBILITY, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                new EcoreSwitch(this, entry, options, diagnostics, context){
                    final /* synthetic */ UML2EcoreConverter this$1;
                    private final /* synthetic */ Map.Entry val$entry;
                    private final /* synthetic */ Map val$options;
                    private final /* synthetic */ DiagnosticChain val$diagnostics;
                    private final /* synthetic */ Map val$context;
                    {
                        this.this$1 = uML2EcoreConverter;
                        this.val$entry = entry;
                        this.val$options = map;
                        this.val$diagnostics = diagnosticChain;
                        this.val$context = map2;
                    }

                    public Object caseEClassifier(EClassifier eClassifier) {
                        this.this$1.processEcoreTaggedValues(eClassifier, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eClassifier;
                    }

                    public Object caseEEnum(EEnum eEnum) {
                        this.this$1.processEcoreTaggedValues(eEnum, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eEnum;
                    }

                    public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
                        this.this$1.processEcoreTaggedValues(eEnumLiteral, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eEnumLiteral;
                    }

                    public Object caseEOperation(EOperation eOperation) {
                        this.this$1.processEcoreTaggedValues(eOperation, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eOperation;
                    }

                    public Object caseEPackage(EPackage ePackage) {
                        this.this$1.processEcoreTaggedValues(ePackage, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return ePackage;
                    }

                    public Object caseEParameter(EParameter eParameter) {
                        this.this$1.processEcoreTaggedValues(eParameter, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eParameter;
                    }

                    public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                        this.this$1.processEcoreTaggedValues(eStructuralFeature, (Element)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eStructuralFeature;
                    }
                }.doSwitch((EObject)eModelElement);
            }
        }

        protected void processRedefiningOperations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Element element = (Element)entry.getKey();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EOperation) || !(element instanceof Operation)) continue;
                Operation operation = (Operation)element;
                Iterator redefinedOperations = operation.getRedefinedOperations().iterator();
                while (redefinedOperations.hasNext()) {
                    Operation redefinedOperation = (Operation)redefinedOperations.next();
                    EOperation eOperation = (EOperation)this.elementToEModelElementMap.get(redefinedOperation);
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__REDEFINING_OPERATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2002, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessRedefiningOperation_diagnostic", UMLUtil.access$3(context, eModelElement, eOperation)), new Object[]{eModelElement, eOperation}));
                        }
                        UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)true).getReferences().add((Object)eOperation);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__REDEFINING_OPERATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2002, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportRedefiningOperation_diagnostic", UMLUtil.access$3(context, eModelElement, eOperation)), new Object[]{eModelElement, eOperation}));
                }
            }
        }

        protected void processRedefiningProperties(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Element element = (Element)entry.getKey();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EStructuralFeature) || !(element instanceof Property)) continue;
                Property property = (Property)element;
                Iterator redefinedProperties = property.getRedefinedProperties().iterator();
                while (redefinedProperties.hasNext()) {
                    Property redefinedProperty = (Property)redefinedProperties.next();
                    if (redefinedProperty.getOwningAssociation() != null) continue;
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)this.elementToEModelElementMap.get(redefinedProperty);
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__REDEFINING_PROPERTIES))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2003, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessRedefiningProperty_diagnostic", UMLUtil.access$3(context, eModelElement, eStructuralFeature)), new Object[]{eModelElement, eStructuralFeature}));
                        }
                        UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)true).getReferences().add((Object)eStructuralFeature);
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__REDEFINING_PROPERTIES)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2003, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportRedefiningProperty_diagnostic", UMLUtil.access$3(context, eModelElement, eStructuralFeature)), new Object[]{eModelElement, eStructuralFeature}));
                }
            }
        }

        protected boolean isCompositeSubset(Property property) {
            Iterator subsettedProperties = property.getSubsettedProperties().iterator();
            while (subsettedProperties.hasNext()) {
                Property subsettedProperty = (Property)subsettedProperties.next();
                if (!subsettedProperty.isComposite() && !this.isCompositeSubset(subsettedProperty)) continue;
                return true;
            }
            return false;
        }

        protected void processSubsettingProperties(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Element element = (Element)entry.getKey();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EStructuralFeature) || !(element instanceof Property)) continue;
                Property property = (Property)element;
                Iterator subsettedProperties = property.getSubsettedProperties().iterator();
                while (subsettedProperties.hasNext()) {
                    Property subsettedProperty = (Property)subsettedProperties.next();
                    if (subsettedProperty.getOwningAssociation() != null) continue;
                    EStructuralFeature subsettedEStructuralFeature = (EStructuralFeature)this.elementToEModelElementMap.get(subsettedProperty);
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__SUBSETTING_PROPERTIES))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2004, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessSubsettingProperty_diagnostic", UMLUtil.access$3(context, eModelElement, subsettedEStructuralFeature)), new Object[]{eModelElement, subsettedEStructuralFeature}));
                        }
                        if (!subsettedEStructuralFeature.isDerived() && subsettedEStructuralFeature instanceof EReference) {
                            EReference subsettedEReference = (EReference)subsettedEStructuralFeature;
                            EReference eReference = (EReference)eModelElement;
                            if (subsettedEReference.isContainment() || this.isCompositeSubset(subsettedProperty)) {
                                eReference.setContainment(false);
                            }
                            if (!eReference.isContainment()) {
                                eReference.setResolveProxies(subsettedEReference.isResolveProxies());
                            }
                        }
                        UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)UMLUtil.ANNOTATION__SUBSETS, (boolean)true).getReferences().add(this.elementToEModelElementMap.get(subsettedProperty));
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__SUBSETTING_PROPERTIES)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2004, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportSubsettingProperty_diagnostic", UMLUtil.access$3(context, eModelElement, subsettedEStructuralFeature)), new Object[]{eModelElement, subsettedEStructuralFeature}));
                }
            }
        }

        protected void processUnionProperties(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Element element = (Element)entry.getKey();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EStructuralFeature) || !(element instanceof Property) || !((Property)element).isDerivedUnion()) continue;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eModelElement;
                if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__UNION_PROPERTIES))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2005, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessUnionProperty_diagnostic", UMLUtil.access$5(context, eStructuralFeature)), new Object[]{eStructuralFeature}));
                    }
                    UMLUtil.getEAnnotation((EModelElement)eStructuralFeature, (String)UMLUtil.ANNOTATION__UNION, (boolean)true);
                    eStructuralFeature.setChangeable(false);
                    eStructuralFeature.setVolatile(true);
                    continue;
                }
                if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__UNION_PROPERTIES)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2005, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportUnionProperty_diagnostic", UMLUtil.access$5(context, eModelElement)), new Object[]{eModelElement}));
            }
        }

        protected void processDerivedFeatures(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EStructuralFeature.Internal eStructuralFeature;
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EStructuralFeature) || !(eStructuralFeature = (EStructuralFeature.Internal)eModelElement).isDerived() || !eStructuralFeature.isContainment() && eStructuralFeature.isVolatile()) continue;
                if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__DERIVED_FEATURES))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2006, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessDerivedFeature_diagnostic", UMLUtil.access$5(context, eStructuralFeature)), new Object[]{eStructuralFeature}));
                    }
                    if (eStructuralFeature instanceof EReference) {
                        ((EReference)eStructuralFeature).setContainment(false);
                    }
                    eStructuralFeature.setVolatile(true);
                    continue;
                }
                if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DERIVED_FEATURES)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2006, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportDerivedFeature_diagnostic", UMLUtil.access$5(context, eStructuralFeature)), new Object[]{eStructuralFeature}));
            }
        }

        protected void ensureConformity(ETypedElement eTypedElement, ETypedElement otherETypedElement) {
            boolean otherIsMany;
            boolean isMany;
            if (eTypedElement.isRequired() != otherETypedElement.isRequired()) {
                int lowerBound = eTypedElement.getLowerBound();
                int otherLowerBound = otherETypedElement.getLowerBound();
                int lesserLowerBound = UMLUtil.access$1(otherLowerBound, lowerBound);
                if (lesserLowerBound != otherLowerBound) {
                    otherETypedElement.setLowerBound(lesserLowerBound);
                }
                if (lesserLowerBound != lowerBound) {
                    eTypedElement.setLowerBound(lesserLowerBound);
                }
            }
            if ((isMany = eTypedElement.isMany()) != (otherIsMany = otherETypedElement.isMany())) {
                int upperBound = eTypedElement.getUpperBound();
                int otherUpperBound = otherETypedElement.getUpperBound();
                int greaterUpperBound = UMLUtil.access$2(otherUpperBound, upperBound);
                if (greaterUpperBound != otherUpperBound) {
                    otherETypedElement.setUpperBound(greaterUpperBound);
                }
                if (greaterUpperBound != upperBound) {
                    eTypedElement.setUpperBound(greaterUpperBound);
                }
            }
            if (!isMany && !otherIsMany) {
                EClassifier eType = eTypedElement.getEType();
                EClassifier otherEType = otherETypedElement.getEType();
                EClassifier commonEType = UMLUtil.access$8(otherEType, eType);
                if (commonEType != otherEType) {
                    otherETypedElement.setEType(commonEType);
                }
                if (commonEType != eType) {
                    eTypedElement.setEType(commonEType);
                }
            }
            eTypedElement.setOrdered(otherETypedElement.isOrdered());
            eTypedElement.setUnique(otherETypedElement.isUnique());
        }

        protected void qualifyName(ENamedElement eNamedElement) {
            EObject eContainer = eNamedElement.eContainer();
            if (eContainer instanceof ENamedElement) {
                String qualifiedName = String.valueOf(((ENamedElement)eContainer).getName()) + '_' + eNamedElement.getName();
                eNamedElement.setName(qualifiedName);
            }
        }

        protected void processDuplicateOperations(Map options, DiagnosticChain diagnostics, Map context) {
            UniqueEList.FastCompare operationsToDuplicate = new UniqueEList.FastCompare();
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass)) continue;
                EClass eClass = (EClass)eModelElement;
                Iterator eOperations = eClass.getEOperations().iterator();
                block1: while (eOperations.hasNext()) {
                    EOperation eOperation = (EOperation)eOperations.next();
                    Iterator eAllOperations = eClass.getEAllOperations().iterator();
                    while (eAllOperations.hasNext()) {
                        EOperation eAllOperation = (EOperation)eAllOperations.next();
                        if (eAllOperation == eOperation) continue block1;
                        if (!new SignatureMatcher(eOperation).matches((EObject)eAllOperation)) continue;
                        if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_OPERATIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2007, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessDuplicateOperation_diagnostic", UMLUtil.access$3(context, eOperation, eAllOperation)), new Object[]{eClass, eAllOperation}));
                            }
                            operationsToDuplicate.add(eOperation);
                            this.ensureConformity((ETypedElement)eOperation, (ETypedElement)eAllOperation);
                            EList redefinedOperations = UMLUtil.getEAnnotation((EModelElement)eOperation, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)true).getReferences();
                            if (redefinedOperations.contains(eAllOperation)) continue;
                            redefinedOperations.add(eAllOperation);
                            continue;
                        }
                        if (UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_OPERATIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2007, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_DiscardDuplicateOperation_diagnostic", UMLUtil.access$3(context, eOperation, eAllOperation)), new Object[]{eClass, eAllOperation}));
                            }
                            eOperations.remove();
                            continue block1;
                        }
                        if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_OPERATIONS)) || diagnostics == null) continue;
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 2007, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportDuplicateOperation_diagnostic", UMLUtil.access$3(context, eOperation, eAllOperation)), new Object[]{eOperation, eAllOperation}));
                    }
                }
            }
            Iterator eOperations = operationsToDuplicate.iterator();
            while (eOperations.hasNext()) {
                EOperation eOperation = (EOperation)eOperations.next();
                UMLUtil.getEAnnotation((EModelElement)eOperation.getEContainingClass(), (String)UMLUtil.ANNOTATION__DUPLICATES, (boolean)true).getContents().add((Object)eOperation);
            }
        }

        protected void processDuplicateOperationInheritance(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EClass eClass;
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass) || (eClass = (EClass)eModelElement).getESuperTypes().size() <= 1) continue;
                Iterator eSuperTypes = eClass.getESuperTypes().iterator();
                eSuperTypes.next();
                block1: while (eSuperTypes.hasNext()) {
                    EClass mixinEClass = (EClass)eSuperTypes.next();
                    Iterator mixinEOperations = mixinEClass.getEAllOperations().iterator();
                    block2: while (mixinEOperations.hasNext()) {
                        EOperation mixinEOperation = (EOperation)mixinEOperations.next();
                        Iterator eOperations = eClass.getEAllOperations().iterator();
                        while (eOperations.hasNext()) {
                            EOperation eOperation = (EOperation)eOperations.next();
                            if (eOperation == mixinEOperation) continue block2;
                            if (!new SignatureMatcher(mixinEOperation).matches((EObject)eOperation)) continue;
                            if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2008, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessDuplicateOperationInheritance_diagnostic", UMLUtil.access$4(context, eClass, eOperation, mixinEOperation)), new Object[]{eClass, eOperation, mixinEOperation}));
                                }
                                this.qualifyName((ENamedElement)mixinEOperation);
                                EList redefinedOperations = UMLUtil.getEAnnotation((EModelElement)mixinEOperation, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)true).getReferences();
                                if (redefinedOperations.contains(eOperation)) continue;
                                redefinedOperations.add(eOperation);
                                continue;
                            }
                            if (UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2008, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_DiscardDuplicateOperationInheritance_diagnostic", UMLUtil.access$4(context, eClass, eOperation, mixinEOperation)), new Object[]{eClass, eOperation, mixinEOperation}));
                                }
                                eSuperTypes.remove();
                                continue block1;
                            }
                            if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE)) || diagnostics == null) continue;
                            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 2008, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportDuplicateOperationInheritance_diagnostic", UMLUtil.access$4(context, eClass, eOperation, mixinEOperation)), new Object[]{eClass, eOperation, mixinEOperation}));
                        }
                    }
                }
            }
        }

        protected void processDuplicateFeatures(Map options, DiagnosticChain diagnostics, Map context) {
            EStructuralFeature.Internal eStructuralFeature;
            UniqueEList.FastCompare featuresToDuplicate = new UniqueEList.FastCompare();
            UniqueEList.FastCompare featuresToRemove = new UniqueEList.FastCompare();
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass)) continue;
                EClass eClass = (EClass)eModelElement;
                Iterator eStructuralFeatures = eClass.getEStructuralFeatures().iterator();
                block1: while (eStructuralFeatures.hasNext()) {
                    EStructuralFeature.Internal eStructuralFeature2 = (EStructuralFeature.Internal)eStructuralFeatures.next();
                    Iterator eAllStructuralFeatures = eClass.getEAllStructuralFeatures().iterator();
                    while (eAllStructuralFeatures.hasNext()) {
                        EStructuralFeature eAllStructuralFeature = (EStructuralFeature)eAllStructuralFeatures.next();
                        if (eAllStructuralFeature == eStructuralFeature2) continue block1;
                        if (!new NameMatcher((ENamedElement)eStructuralFeature2).matches((EObject)eAllStructuralFeature)) continue;
                        if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_FEATURES))) {
                            EList redefinedFeatures;
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2009, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessDuplicateFeature_diagnostic", UMLUtil.access$3(context, eStructuralFeature2, eAllStructuralFeature)), new Object[]{eStructuralFeature2, eAllStructuralFeature}));
                            }
                            if (!featuresToDuplicate.contains(eStructuralFeature2)) {
                                EStructuralFeature.Internal duplicateEStructuralFeature = eAllStructuralFeature.isDerived() && !eStructuralFeature2.isDerived() ? eAllStructuralFeature : eStructuralFeature2;
                                featuresToDuplicate.add(duplicateEStructuralFeature);
                                this.ensureConformity((ETypedElement)eStructuralFeature2, (ETypedElement)eAllStructuralFeature);
                            }
                            if ((redefinedFeatures = UMLUtil.getEAnnotation((EModelElement)eStructuralFeature2, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)true).getReferences()).contains((Object)eAllStructuralFeature)) continue;
                            redefinedFeatures.add((Object)eAllStructuralFeature);
                            continue;
                        }
                        if (UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_FEATURES))) {
                            EReference eOpposite;
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2009, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_DiscardDuplicateFeature_diagnostic", UMLUtil.access$3(context, eStructuralFeature2, eAllStructuralFeature)), new Object[]{eClass, eAllStructuralFeature}));
                            }
                            if ((eOpposite = eStructuralFeature2.getEOpposite()) != null) {
                                featuresToRemove.add(eOpposite);
                            }
                            eStructuralFeatures.remove();
                            continue block1;
                        }
                        if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_FEATURES)) || diagnostics == null) continue;
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 2009, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportDuplicateFeature_diagnostic", UMLUtil.access$3(context, eStructuralFeature2, eAllStructuralFeature)), new Object[]{eStructuralFeature2, eAllStructuralFeature}));
                    }
                }
            }
            Iterator eStructuralFeatures = featuresToDuplicate.iterator();
            while (eStructuralFeatures.hasNext()) {
                eStructuralFeature = (EStructuralFeature.Internal)eStructuralFeatures.next();
                UMLUtil.getEAnnotation((EModelElement)eStructuralFeature.getEContainingClass(), (String)UMLUtil.ANNOTATION__DUPLICATES, (boolean)true).getContents().add((Object)eStructuralFeature);
                EReference eOpposite = eStructuralFeature.getEOpposite();
                if (eOpposite == null || featuresToDuplicate.contains(eOpposite)) continue;
                eOpposite.setEOpposite(null);
                if (eStructuralFeature.isContainment()) {
                    eOpposite.setChangeable(false);
                    eOpposite.setTransient(true);
                }
                eOpposite.setVolatile(true);
            }
            eStructuralFeatures = featuresToRemove.iterator();
            while (eStructuralFeatures.hasNext()) {
                eStructuralFeature = (EStructuralFeature)eStructuralFeatures.next();
                EClass eContainingClass = eStructuralFeature.getEContainingClass();
                if (eContainingClass == null) continue;
                eContainingClass.getEStructuralFeatures().remove((Object)eStructuralFeature);
            }
        }

        protected void processDuplicateFeatureInheritance(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EClass eClass;
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass) || (eClass = (EClass)eModelElement).getESuperTypes().size() <= 1) continue;
                Iterator eSuperTypes = eClass.getESuperTypes().iterator();
                eSuperTypes.next();
                block1: while (eSuperTypes.hasNext()) {
                    EClass mixinEClass = (EClass)eSuperTypes.next();
                    Iterator mixinEStructuralFeatures = mixinEClass.getEAllStructuralFeatures().iterator();
                    block2: while (mixinEStructuralFeatures.hasNext()) {
                        EStructuralFeature mixinEStructuralFeature = (EStructuralFeature)mixinEStructuralFeatures.next();
                        Iterator eStructuralFeatures = eClass.getEAllStructuralFeatures().iterator();
                        while (eStructuralFeatures.hasNext()) {
                            EStructuralFeature eStructuralFeature = (EStructuralFeature)eStructuralFeatures.next();
                            if (eStructuralFeature == mixinEStructuralFeature) continue block2;
                            if (!new NameMatcher((ENamedElement)mixinEStructuralFeature).matches((EObject)eStructuralFeature)) continue;
                            if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2010, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessDuplicateFeatureInheritance_diagnostic", UMLUtil.access$4(context, eClass, eStructuralFeature, mixinEStructuralFeature)), new Object[]{eClass, eStructuralFeature, mixinEStructuralFeature}));
                                }
                                this.qualifyName((ENamedElement)mixinEStructuralFeature);
                                EList redefinedFeatures = UMLUtil.getEAnnotation((EModelElement)mixinEStructuralFeature, (String)UMLUtil.ANNOTATION__REDEFINES, (boolean)true).getReferences();
                                if (redefinedFeatures.contains((Object)eStructuralFeature)) continue;
                                redefinedFeatures.add((Object)eStructuralFeature);
                                continue;
                            }
                            if (UMLUtil.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2010, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_DiscardDuplicateFeatureInheritance_diagnostic", UMLUtil.access$4(context, eClass, eStructuralFeature, mixinEStructuralFeature)), new Object[]{eClass, eStructuralFeature, mixinEStructuralFeature}));
                                }
                                eSuperTypes.remove();
                                continue block1;
                            }
                            if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE)) || diagnostics == null) continue;
                            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 2010, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportDuplicateFeatureInheritance_diagnostic", UMLUtil.access$4(context, eClass, eStructuralFeature, mixinEStructuralFeature)), new Object[]{eClass, eStructuralFeature, mixinEStructuralFeature}));
                        }
                    }
                }
            }
        }

        protected void processSuperClassOrder(Map options, DiagnosticChain diagnostics, Map context) {
            Comparator eClassComparator = new Comparator(this){
                final /* synthetic */ UML2EcoreConverter this$1;
                {
                    this.this$1 = uML2EcoreConverter;
                }

                public int compare(Object object, Object otherObject) {
                    int otherEAllStructuralFeaturesSize;
                    EClass eClass = (EClass)object;
                    EClass otherEClass = (EClass)otherObject;
                    int eAllStructuralFeaturesSize = eClass.getEAllStructuralFeatures().size();
                    return eAllStructuralFeaturesSize < (otherEAllStructuralFeaturesSize = otherEClass.getEAllStructuralFeatures().size()) ? 1 : (otherEAllStructuralFeaturesSize < eAllStructuralFeaturesSize ? -1 : eClass.getName().compareTo(otherEClass.getName()));
                }
            };
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof Classifier) || !(value instanceof EClass)) continue;
                EClass eClass = (EClass)value;
                EList eSuperTypes = eClass.getESuperTypes();
                ArrayList<EModelElement> extendSuperClasses = new ArrayList<EModelElement>();
                ArrayList<EModelElement> unspecifiedSuperClasses = new ArrayList<EModelElement>();
                ArrayList<EModelElement> mixinSuperClasses = new ArrayList<EModelElement>();
                Iterator generalizations = ((Classifier)key).getGeneralizations().iterator();
                while (generalizations.hasNext()) {
                    EModelElement eModelElement;
                    Generalization generalization = (Generalization)generalizations.next();
                    Classifier general = generalization.getGeneral();
                    if (general == null || !eSuperTypes.contains((Object)(eModelElement = (EModelElement)this.elementToEModelElementMap.get(general)))) continue;
                    if (generalization.hasKeyword("extend")) {
                        extendSuperClasses.add(eModelElement);
                        continue;
                    }
                    if (generalization.hasKeyword("mixin")) {
                        mixinSuperClasses.add(eModelElement);
                        continue;
                    }
                    unspecifiedSuperClasses.add(eModelElement);
                }
                Collections.sort(extendSuperClasses, eClassComparator);
                Collections.sort(unspecifiedSuperClasses, eClassComparator);
                Collections.sort(mixinSuperClasses, eClassComparator);
                UniqueEList.FastCompare superClasses = new UniqueEList.FastCompare(extendSuperClasses);
                superClasses.addAll(unspecifiedSuperClasses);
                superClasses.addAll(mixinSuperClasses);
                if (superClasses.equals(eSuperTypes)) continue;
                if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__SUPER_CLASS_ORDER))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2011, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessSuperClassOrder_diagnostic", UMLUtil.access$5(context, eClass)), new Object[]{eClass}));
                    }
                    ListIterator sc = superClasses.listIterator();
                    while (sc.hasNext()) {
                        Object superClass = sc.next();
                        eSuperTypes.move(sc.previousIndex(), superClass);
                    }
                }
                if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__SUPER_CLASS_ORDER)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2011, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportSuperClassOrder_diagnostic", UMLUtil.access$5(context, eClass)), new Object[]{eClass}));
            }
        }

        protected void processAnnotationDetails(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (eModelElement == null) continue;
                Element element = (Element)entry.getKey();
                Iterator eAnnotations = element.getEAnnotations().iterator();
                while (eAnnotations.hasNext()) {
                    EAnnotation eAnnotation = (EAnnotation)eAnnotations.next();
                    EMap details = eAnnotation.getDetails();
                    if (details.isEmpty()) continue;
                    if (UMLUtil.OPTION__PROCESS.equals(options.get(OPTION__ANNOTATION_DETAILS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 2012, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ProcessAnnotationDetails_diagnostic", UMLUtil.access$3(context, eModelElement, eAnnotation.getSource())), new Object[]{eModelElement}));
                        }
                        UMLUtil.getEAnnotation((EModelElement)eModelElement, (String)eAnnotation.getSource(), (boolean)true).getDetails().putAll(details.map());
                        continue;
                    }
                    if (!UMLUtil.OPTION__REPORT.equals(options.get(OPTION__ANNOTATION_DETAILS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2012, UMLPlugin.INSTANCE.getString("_UI_UML2EcoreConverter_ReportAnnotationDetails_diagnostic", UMLUtil.access$3(context, eModelElement, eAnnotation.getSource())), new Object[]{eModelElement}));
                }
            }
        }

        protected void processOptions(Map options, DiagnosticChain diagnostics, Map context) {
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                this.processEcoreTaggedValues(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__REDEFINING_OPERATIONS))) {
                this.processRedefiningOperations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__REDEFINING_PROPERTIES))) {
                this.processRedefiningProperties(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__SUBSETTING_PROPERTIES))) {
                this.processSubsettingProperties(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DERIVED_FEATURES))) {
                this.processDerivedFeatures(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__UNION_PROPERTIES))) {
                this.processUnionProperties(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_OPERATIONS))) {
                this.processDuplicateOperations(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE))) {
                this.processDuplicateOperationInheritance(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_FEATURES))) {
                this.processDuplicateFeatures(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE))) {
                this.processDuplicateFeatureInheritance(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__SUPER_CLASS_ORDER))) {
                this.processSuperClassOrder(options, diagnostics, context);
            }
            if (!UMLUtil.OPTION__IGNORE.equals(options.get(OPTION__ANNOTATION_DETAILS))) {
                this.processAnnotationDetails(options, diagnostics, context);
            }
        }

        public Collection convert(Collection eObjects, Map options, DiagnosticChain diagnostics, Map context) {
            this.packages = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)UMLPackage.Literals.PACKAGE);
            Iterator p = this.packages.iterator();
            while (p.hasNext()) {
                this.doSwitch((EObject)((Package)p.next()));
            }
            if (options != null) {
                this.processOptions(options, diagnostics, context);
            }
            return UMLUtil.access$9(EcoreUtil.getObjectsByType(this.elementToEModelElementMap.values(), (EClassifier)EcorePackage.Literals.EPACKAGE));
        }

        protected class ETypeMatcher
        extends NameMatcher {
            protected ETypeMatcher(ETypedElement eTypedElement) {
                super((ENamedElement)eTypedElement);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && UMLUtil.safeEquals((Object)((ETypedElement)this.eObject).getEType(), (Object)((ETypedElement)otherEObject).getEType());
            }
        }

        protected class NameMatcher
        extends UML2Util.EStructuralFeatureMatcher {
            protected NameMatcher(ENamedElement eNamedElement) {
                super((EObject)eNamedElement, (EStructuralFeature)EcorePackage.Literals.ENAMED_ELEMENT__NAME);
            }
        }

        protected class SignatureMatcher
        extends ETypeMatcher {
            protected SignatureMatcher(EOperation eOperation) {
                super((ETypedElement)eOperation);
            }

            public boolean matches(EObject otherEObject) {
                EList otherEParameters;
                EList eParameters;
                int eParametersSize;
                if (super.matches(otherEObject) && (eParametersSize = (eParameters = ((EOperation)this.eObject).getEParameters()).size()) == (otherEParameters = ((EOperation)otherEObject).getEParameters()).size()) {
                    int i = 0;
                    while (i < eParametersSize) {
                        if (!new ETypeMatcher((ETypedElement)eParameters.get(i)).matches((EObject)otherEParameters.get(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

