/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.parser;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.diagram.common.parser.ElementProvider;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLPackage;

public class SubmachineStateParser
implements IParser {
    private static final String NAME_SUBMACHINE_SEPARATOR = ":";
    private ElementProvider elementProvider;

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject instanceof State) {
            String submachineName;
            StringBuffer printStringBuffer = new StringBuffer(20);
            State state = (State)eObject;
            printStringBuffer.append(state.getName());
            StateMachine submachine = state.getSubmachine();
            if (submachine != null && (submachineName = submachine.getName()) != null && submachineName.length() > 0) {
                printStringBuffer.append(':');
                printStringBuffer.append(submachineName);
            }
            return printStringBuffer.toString();
        }
        return "";
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            Object feature = ((Notification)event).getFeature();
            return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getState_Submachine().equals(feature);
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        ICommand setSubmachineCommand;
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        int equalityPosition = newString.indexOf(NAME_SUBMACHINE_SEPARATOR);
        if (equalityPosition == -1) {
            return this.getSetNameCommand(element, newString);
        }
        String name = newString.substring(0, equalityPosition);
        String submachine = newString.substring(equalityPosition + 1);
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
        command.compose((IUndoableOperation)this.getSetNameCommand(element, name));
        if (submachine != null && (setSubmachineCommand = this.getSetSubmachineCommand(element, submachine)) != null) {
            command.compose((IUndoableOperation)setSubmachineCommand);
        }
        return command;
    }

    private ICommand getSetNameCommand(EObject element, String name) {
        SetRequest request = new SetRequest(element, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)name);
        return new SetValueCommand(request);
    }

    private ICommand getSetSubmachineCommand(EObject element, String submachine) {
        StateMachine submachineElement = (StateMachine)this.getElementProvider().findElement(element, submachine);
        if (submachineElement == null) {
            return null;
        }
        SetRequest request = new SetRequest(element, (EStructuralFeature)UMLPackage.eINSTANCE.getState_Submachine(), (Object)submachineElement);
        return new SetValueCommand(request);
    }

    private ElementProvider getElementProvider() {
        if (this.elementProvider == null) {
            this.elementProvider = new StateMachineProvider();
        }
        return this.elementProvider;
    }

    private static class StateMachineProvider
    extends ElementProvider {
        private StateMachineProvider() {
        }

        protected boolean isSuitable(Object object) {
            return object instanceof StateMachine;
        }
    }
}

