/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import java.awt.Point;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReceiveMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmReshapable;

public abstract class LMMessage
implements LmReshapable {
    private Color myHasColorBeforeViolated;
    private final AbsLink myGdeLink;
    private boolean myMessageIsCrossFramed;
    private boolean myMessageIsCrossFramedCalculated = false;

    public LMMessage(AbsLink gdeLink) {
        this.myGdeLink = gdeLink;
    }

    abstract LMReceiveMessageEnd getReceiveMessageEnd();

    abstract LMSendMessageEnd getSendMessageEnd();

    abstract void resetReceiveMessageEnd();

    abstract void resetSendMessageEnd();

    AbsLink getGdeLink() {
        return this.myGdeLink;
    }

    abstract boolean isFromSendToReceive();

    public abstract void layoutHorizontally(boolean var1);

    abstract void becomeLayoutConstraint(boolean var1);

    abstract boolean isLayoutConstraint();

    public void setJustReshaped(JustReshapedState justReshapedState) {
        this.getSendMessageEnd().messageIsJustReshaped(this, justReshapedState);
        this.getReceiveMessageEnd().messageIsJustReshaped(this, justReshapedState);
    }

    abstract void setLMMessageEndVerticalPosition(int var1, boolean var2, int var3);

    int getLMMessageEndVerticalPosition(boolean sourceNotDestination) {
        Point[] linkPoints = this.getGdeLink().getLinkPoints();
        if (linkPoints.length < 1) {
            throw new RuntimeException("Bad link positions");
        }
        if (sourceNotDestination) {
            return linkPoints[0].y;
        }
        return linkPoints[linkPoints.length - 1].y;
    }

    protected boolean calculateIsMessageViolated() {
        if (!this.myMessageIsCrossFramedCalculated) {
            LMFrame destinationFrame;
            LMFrame sourceFrame = LMMessage.getMessageEndFrame(this.getSendMessageEnd());
            this.myMessageIsCrossFramed = sourceFrame != (destinationFrame = LMMessage.getMessageEndFrame(this.getReceiveMessageEnd()));
            this.myMessageIsCrossFramedCalculated = true;
        }
        return this.myMessageIsCrossFramed;
    }

    protected void sourceOrDestinationChanged() {
        this.myMessageIsCrossFramedCalculated = false;
    }

    protected void updateMessageViolationState() {
        boolean violated = this.calculateIsMessageViolated();
        if (this.myHasColorBeforeViolated == null && violated) {
            this.myHasColorBeforeViolated = this.getGdeLink().getForeground();
            this.getGdeLink().setForeground(Color.RED);
        } else if (this.myHasColorBeforeViolated != null && !violated) {
            this.getGdeLink().setForeground(this.myHasColorBeforeViolated);
            this.myHasColorBeforeViolated = null;
        }
    }

    private static LMFrame getMessageEndFrame(LMMessageEnd messageEnd) {
        if (messageEnd == null) {
            return null;
        }
        return messageEnd.getContainingFrame();
    }
}

