/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.notation.View;

public class UmlDiagramEditPart
extends DiagramEditPart {
    public UmlDiagramEditPart(View diagramView) {
        super(diagramView);
    }

    protected IFigure createFigure() {
        return new DiagramEditPartFigure();
    }

    protected class DiagramEditPartFigure
    extends BorderItemsAwareFreeFormLayer {
        public DiagramEditPartFigure() {
            this.setLayoutManager((LayoutManager)new FreeformLayout());
            this.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
            this.addLayoutListener((LayoutListener)new PageBreaksLayoutListener());
            this.setBorder((Border)new MarginBorder(20));
        }

        public boolean containsPoint(int x, int y) {
            return this.getBounds().contains(x, y);
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (!this.isEnabled()) {
                return null;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (search.prune((IFigure)this)) {
                return null;
            }
            IFigure child = this.findDescendantAtExcluding(x, y, search);
            if (child != null) {
                return child;
            }
            if (search.accept((IFigure)this)) {
                return this;
            }
            return null;
        }

        public void validate() {
            super.validate();
            boolean shouldUpdatePageBreakLocation = false;
            if (shouldUpdatePageBreakLocation) {
                shouldUpdatePageBreakLocation = false;
                UmlDiagramEditPart.this.updatePageBreaksLocation();
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.pushState();
            graphics.setLineStyle(3);
            graphics.setForegroundColor(ColorConstants.red);
            graphics.setBackgroundColor(ColorConstants.blue);
            Rectangle bounds = this.getBounds();
            graphics.drawRectangle(bounds.x + 3, bounds.y + 3, bounds.width - 4, bounds.height - 4);
            graphics.popState();
        }
    }

    private class PageBreaksLayoutListener
    extends LayoutListener.Stub {
        private PageBreaksLayoutListener() {
        }

        public void postLayout(IFigure container) {
            super.postLayout(container);
            UmlDiagramEditPart.this.updatePageBreaksLocation();
        }
    }
}

