/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLDataRange.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>OWL Data Range</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLDataRange#getOWLDataRangeoneOf <em>OWLDataRangeoneOf</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLDataRange#getDatatype <em>datatype</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLDataRange()
 * @model
 * @generated
 */
public interface OWLDataRange extends RDFSClass, Universe {
	/**
	 * Returns the value of the '<em><b>OWLDataRangeoneOf</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OWL Data Rangeone Of</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLDataRangeoneOf</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLDataRange_OWLDataRangeOneOf()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFSLiteral" required="true"
	 * @generated
	 */
	EList getOWLDataRangeOneOf();

	/**
	 * Returns the value of the '<em><b>datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Datatype</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>datatype</em>' reference.
	 * @see #setDatatype(RDFSDatatype)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLDataRange_Datatype()
	 * @model required="true"
	 * @generated
	 */
	RDFSDatatype getDatatype();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLDataRange#getDatatype <em>datatype</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>datatype</em>' reference.
	 * @see #getDatatype()
	 * @generated
	 */
	void setDatatype(RDFSDatatype value);

} // OWLDataRange
