/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.NoteFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;

public class CommentFigureBase
extends NoteFigure {
    private static final Color CORNER_COLOR = new Color(null, 234, 234, 247);
    private WrappingLabel myBody = new WrappingLabel();

    public CommentFigureBase() {
        this(100, 65, new Insets());
    }

    public CommentFigureBase(int width, int height, Insets insets) {
        super(width, height, insets);
        this.myBody.setBorder((Border)new MarginBorder(4, 4, 4, 4));
        this.myBody.setTextPlacement(16);
        this.myBody.setTextAlignment(8);
        this.myBody.setIconAlignment(8);
        this.add((IFigure)this.myBody);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.pushState();
        Rectangle r = this.getBounds();
        PointList corner = new PointList();
        corner.addPoint(r.x + r.width - this.getClipWidthCopy(), r.y);
        corner.addPoint(r.x + r.width - this.getClipWidthCopy(), r.y + this.getClipHeightCopy());
        corner.addPoint(r.x + r.width, r.y + this.getClipHeightCopy());
        g.setBackgroundColor(CORNER_COLOR);
        g.fillPolygon(corner);
        g.popState();
    }

    private int getClipHeightCopy() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(12);
    }

    private int getClipWidthCopy() {
        return this.getClipHeightCopy() + MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
    }

    public WrappingLabel getBodyLabel() {
        return this.myBody;
    }

    protected void setTextLabelWrap(boolean wrap) {
        this.getBodyLabel().setTextWrap(wrap);
    }
}

