/**
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation, Zeligsoft Inc., Borland Software Corp., and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Lexer and Parser refactoring to support extensibility and flexible error handling
*   Borland - Bug 242880
*   
* </copyright>
*
* $Id: OCLLexerprs.java,v 1.3 2009/02/12 00:04:09 cdamus Exp $
*/

package org.eclipse.ocl.parser;

/**
 * @noextend This class is not intended to be subclassed by clients.
 */
public class OCLLexerprs implements lpg.lpgjavaruntime.ParseTable, OCLLexersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,1,3,3,3,1,1,1,1,1,
            5,1,1,1,1,1,1,1,1,1,
            1,2,2,2,1,1,1,1,2,1,
            1,1,2,1,1,2,4,1,2,1,
            1,1,2,2,3,2,2,0,1,2,
            2,2,1,2,1,2,3,2,3,3,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,2,3,1,1,1,1,
            1,2,1,2,2,2,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,2,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            2,2,1,2,1,2,0,1,3,3,
            3,3,3,3,3,4,4,3,3
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,
            23,24,25,25,25,29,29,29,29,30,
            30,28,28,7,7,39,39,32,15,15,
            15,11,11,11,11,11,2,2,2,2,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,4,4,4,4,
            4,4,4,4,4,4,4,4,4,4,
            4,4,4,4,4,4,4,4,4,4,
            4,4,1,1,1,1,1,1,1,1,
            1,1,41,41,41,41,41,41,41,41,
            42,42,42,42,42,42,42,42,42,42,
            42,42,40,40,43,43,43,17,17,44,
            44,31,31,13,13,13,13,13,34,34,
            34,34,34,34,34,34,34,34,34,34,
            34,34,34,34,34,34,34,34,34,34,
            34,34,34,34,34,34,34,34,19,19,
            19,19,19,19,19,19,19,19,19,19,
            19,19,19,19,19,19,19,19,19,19,
            19,19,19,19,19,19,19,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,5,5,20,20,8,8,35,
            35,35,35,9,16,16,16,16,33,33,
            33,33,33,33,33,33,36,36,36,36,
            21,21,21,21,21,10,10,10,10,10,
            10,6,22,37,37,12,12,14,14,18,
            26,26,26,26,26,26,26,26,26,27,
            988,486,485,485,485,1426,2,339,1333,326,
            1377,487,1380,493,1082,326,1366,54,488,1427,
            43,162,318,322,6,7,8,9,478,1320,
            54,320,315,309,490,490,490,490,490,490,
            1314,490,490,490,44,392,318,405,309,490,
            490,490,490,490,490,1087,490,490,490,1384,
            392,1385,430,406,409,409,409,409,409,409,
            1165,409,409,409,1243,409,891,424,424,424,
            424,424,600,296,296,296,296,296,296,1428,
            296,296,296,1388,54,100,424,424,424,697,
            296,296,296,296,296,296,1313,296,296,296,
            304,1404,54,424,794,294,294,294,294,294,
            1083,1,47,47,47,47,503,263,263,263,
            263,263,47,1316,294,294,294,47,1166,431,
            47,1091,403,498,498,498,1344,421,403,1355,
            467,473,1430,421,498,1386,467,1415,54,498,
            1429,263,263,103,45,45,45,45,205,52,
            52,52,52,1317,45,1431,1432,1433,1434,45,
            1378,515,45,1170,165,164,164,164,1245,165,
            164,164,164,515,515,515,515,515,515,515,
            515,52,52,515,515
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,0,
            100,101,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,102,100,101,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,0,0,0,0,103,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,0,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,0,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,0,0,
            0,0,0,0,97,98,0,100,101,102,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,0,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,75,67,68,69,
            70,71,76,73,0,0,0,77,78,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,102,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,71,0,0,73,0,
            0,0,0,74,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,0,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            68,69,0,0,0,0,0,0,74,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,0,1,2,3,4,5,6,7,
            8,9,10,0,1,2,3,4,5,6,
            7,8,9,10,0,1,2,3,4,5,
            6,7,8,9,10,0,1,2,3,4,
            5,6,7,8,9,10,0,0,66,0,
            67,66,66,0,0,0,67,0,1,2,
            3,4,5,6,7,8,9,10,15,15,
            15,69,70,0,1,2,3,4,5,6,
            7,8,9,10,0,1,2,3,4,5,
            6,7,8,9,10,0,0,0,0,0,
            0,0,0,0,0,0,11,12,0,13,
            11,14,0,15,0,0,0,0,72,0,
            0,68,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,97,98,0,100,101,99,102,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,99,
            99,99,99,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            515,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,562,
            562,473,562,562,562,562,562,562,561,562,
            562,562,562,562,562,562,562,562,562,562,
            562,562,562,562,562,562,562,562,562,515,
            562,562,515,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,560,560,565,560,560,560,560,560,560,
            526,560,560,560,560,560,560,560,560,560,
            560,560,560,560,560,560,560,560,560,560,
            560,520,560,560,10,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,567,567,567,567,567,567,567,
            567,567,567,48,515,515,515,567,297,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,416,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,490,490,490,490,490,490,
            490,490,490,490,436,515,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,443,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,409,409,409,409,409,409,409,409,409,
            409,436,515,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,778,
            778,778,778,778,778,778,778,778,778,298,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,416,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,436,515,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,483,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,436,515,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,814,809,809,809,
            809,809,809,809,809,809,809,809,809,809,
            809,809,809,809,809,809,809,809,809,448,
            515,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,515,424,424,424,424,424,424,
            424,424,424,424,424,424,424,424,424,424,
            424,424,424,424,424,424,448,515,486,486,
            486,486,486,486,486,486,486,486,485,485,
            485,485,536,485,485,485,485,485,485,485,
            485,485,485,485,485,485,485,485,485,485,
            485,485,485,485,485,485,485,485,485,485,
            485,485,485,485,485,485,485,485,485,485,
            485,485,485,485,485,485,485,485,485,485,
            485,485,485,373,350,371,384,528,530,487,
            386,515,324,365,369,380,545,329,343,549,
            542,543,540,541,555,546,532,533,515,515,
            515,38,515,515,487,487,32,487,487,358,
            515,403,403,403,403,403,403,403,403,403,
            403,498,498,498,498,515,498,498,498,498,
            498,498,498,498,498,498,498,498,498,498,
            498,498,498,498,498,498,498,498,498,498,
            498,498,498,498,498,498,498,498,498,498,
            498,498,498,498,498,498,498,498,498,498,
            498,498,498,498,498,498,554,824,465,817,
            816,818,548,386,16,515,515,470,819,1,
            680,680,680,680,680,680,680,680,680,680,
            679,679,679,679,519,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,420,515,515,807,515,
            515,515,14,681,300,680,680,680,680,680,
            680,680,680,680,680,679,679,679,679,515,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            679,679,679,679,679,679,679,679,679,679,
            544,566,515,35,515,291,3,515,681,6,
            569,569,569,569,569,569,569,569,569,569,
            318,318,515,326,326,326,326,326,326,326,
            326,326,326,515,421,421,421,421,421,421,
            421,421,421,421,515,467,467,467,467,467,
            467,467,467,467,467,58,569,569,569,569,
            569,569,569,569,569,569,12,295,806,515,
            551,806,806,20,19,308,451,57,569,569,
            569,569,569,569,569,569,569,569,538,537,
            822,459,456,60,569,569,569,569,569,569,
            569,569,569,569,59,569,569,569,569,569,
            569,569,569,569,569,7,515,515,305,515,
            163,53,161,167,515,515,318,318,515,399,
            552,462,515,821,515,515,515,515,677,515,
            515,539,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,677,677,515,677,677,514,298,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,1,
            6,12,1
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int getErrorSymbol() { return 0; }
    public final int getScopeUbound() { return 0; }
    public final int getScopeSize() { return 0; }
    public final int getMaxNameLength() { return 0; }

    public final static int
           NUM_STATES        = 50,
           NT_OFFSET         = 103,
           LA_STATE_OFFSET   = 824,
           MAX_LA            = 1,
           NUM_RULES         = 309,
           NUM_NONTERMINALS  = 44,
           NUM_SYMBOLS       = 147,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 310,
           IDENTIFIER_SYMBOL = 0,
           EOFT_SYMBOL       = 99,
           EOLT_SYMBOL       = 104,
           ACCEPT_ACTION     = 514,
           ERROR_ACTION      = 515;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
