/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.impl.EDataTypeImpl;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.internal.parser.CompatibilityParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.PrimitiveType;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public abstract class PrimitiveTypeImpl
extends EDataTypeImpl
implements PrimitiveType {
    public static final String copyright = "";

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        switch (opcode) {
            case 1: 
            case 3: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier argType = arg.getType();
                return TypeUtil.commonSuperType(argType, (EClassifier)this);
            }
            case 4: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier argType = arg.getType();
                TypeUtil.commonSuperType(argType, (EClassifier)this);
                return Types.OCL_REAL;
            }
            case 2: {
                if (args == null || args.size() == 0) {
                    return this;
                }
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier argType = arg.getType();
                return TypeUtil.commonSuperType(argType, (EClassifier)this);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 25: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return Types.OCL_BOOLEAN;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                return this;
            }
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                return Types.OCL_INTEGER;
            }
            case 24: {
                return Types.OCL_REAL;
            }
            case 28: 
            case 29: {
                return Types.OCL_STRING;
            }
        }
        return AnyTypeImpl.getResultType(ownerType, opcode, args);
    }

    public int getRelationshipTo(EClassifier type) {
        if (this == type) {
            return 1;
        }
        if (this == Types.OCL_INTEGER && type == Types.OCL_REAL) {
            return 2;
        }
        if (type == Types.OCL_INTEGER && this == Types.OCL_REAL) {
            return 4;
        }
        return 8;
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (this == type) {
            return this;
        }
        if (this == Types.OCL_INTEGER && type == Types.OCL_REAL) {
            return Types.OCL_REAL;
        }
        if (type == Types.OCL_INTEGER && this == Types.OCL_REAL) {
            return Types.OCL_REAL;
        }
        String message = OCLMessages.bind((String)OCLMessages.TypeMismatch_ERROR_, (Object)this.getName(), (Object)TypeUtil.getName((ENamedElement)type));
        CompatibilityParser.ERR(message);
        return null;
    }

    public int getOperationCodeFor(String operName) {
        return PrimitiveTypeImpl.getOperationCode(operName);
    }

    public static int getOperationCode(String operName) {
        if (operName.equals("+")) {
            return 1;
        }
        if (operName.equals("-")) {
            return 2;
        }
        if (operName.equals("*")) {
            return 3;
        }
        if (operName.equals("/")) {
            return 4;
        }
        if (operName.equals("not")) {
            return 11;
        }
        if (operName.equals("and")) {
            return 10;
        }
        if (operName.equals("or")) {
            return 12;
        }
        if (operName.equals("xor")) {
            return 25;
        }
        if (operName.equals("implies")) {
            return 13;
        }
        if (operName.equals("abs")) {
            return 15;
        }
        if (operName.equals("floor")) {
            return 26;
        }
        if (operName.equals("round")) {
            return 27;
        }
        if (operName.equals("max")) {
            return 18;
        }
        if (operName.equals("min")) {
            return 19;
        }
        if (operName.equals("div")) {
            return 16;
        }
        if (operName.equals("mod")) {
            return 17;
        }
        if (operName.equals("substring")) {
            return 22;
        }
        if (operName.equals("size")) {
            return 20;
        }
        if (operName.equals("concat")) {
            return 21;
        }
        if (operName.equals("toInteger")) {
            return 23;
        }
        if (operName.equals("toReal")) {
            return 24;
        }
        if (operName.equals("toLower")) {
            return 28;
        }
        if (operName.equals("toUpper")) {
            return 29;
        }
        return AnyTypeImpl.getOperationCode(operName);
    }

    public String getOperationNameFor(int opcode) {
        return PrimitiveTypeImpl.getOperationName(opcode);
    }

    public static String getOperationName(int opcode) {
        switch (opcode) {
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "*";
            }
            case 4: {
                return "/";
            }
            case 11: {
                return "not";
            }
            case 10: {
                return "and";
            }
            case 12: {
                return "or";
            }
            case 25: {
                return "xor";
            }
            case 13: {
                return "implies";
            }
            case 15: {
                return "abs";
            }
            case 26: {
                return "floor";
            }
            case 27: {
                return "round";
            }
            case 18: {
                return "max";
            }
            case 19: {
                return "min";
            }
            case 16: {
                return "div";
            }
            case 17: {
                return "mod";
            }
            case 22: {
                return "substring";
            }
            case 20: {
                return "size";
            }
            case 21: {
                return "concat";
            }
            case 23: {
                return "toInteger";
            }
            case 24: {
                return "toReal";
            }
            case 28: {
                return "toLower";
            }
            case 29: {
                return "toUpper";
            }
        }
        return AnyTypeImpl.getOperationName(opcode);
    }

    protected PrimitiveTypeImpl() {
    }

    protected PrimitiveTypeImpl(String name) {
        this.setName(name);
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.PRIMITIVE_TYPE;
    }

    public EList getOperations() {
        throw new UnsupportedOperationException();
    }
}

