/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tooltip;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.tooltip.AbstractTooltipProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class ResourceAttachmentChangeTooltipProvider
extends AbstractTooltipProvider<ResourceAttachmentChange> {
    public ResourceAttachmentChangeTooltipProvider(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.labelProvider = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    @Override
    public String getTooltip(MergeMode mode) throws IllegalArgumentException {
        String tooltip;
        ResourceAttachmentChange diff = (ResourceAttachmentChange)this.target;
        boolean isFromLeft = this.isFromLeft(diff);
        switch (diff.getKind()) {
            case ADD: {
                tooltip = this.addResourceAttachmentChangeTooltip(mode, diff, isFromLeft);
                break;
            }
            case DELETE: {
                tooltip = this.deleteResourceAttachmentChangeTooltip(mode, diff, isFromLeft);
                break;
            }
            case MOVE: {
                tooltip = this.setResourceLocationChangeTooltip(mode, diff, isFromLeft);
                break;
            }
            case CHANGE: {
                tooltip = this.setResourceLocationChangeTooltip(mode, diff, isFromLeft);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return tooltip;
    }

    private String addResourceAttachmentChangeTooltip(MergeMode mode, ResourceAttachmentChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        EObject left = diff.getMatch().getLeft();
        EObject right = diff.getMatch().getRight();
        EObject origin = diff.getMatch().getOrigin();
        String leftUri = this.getResourceUri(left);
        String rightUri = this.getResourceUri(right);
        String originUri = this.getResourceUri(origin);
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String effectiveLeft = this.getDirectionalValue(mirrored, leftUri, rightUri);
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.rac.control.left.leftToRight", value, effectiveLeft) : EMFCompareEditMessages.getString("ContextualTooltip.rac.control.right.leftToRight", value, effectiveLeft);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String effectiveRight = this.getDirectionalValue(mirrored, rightUri, leftUri);
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.rac.control.left.rightToLeft", value, effectiveRight) : EMFCompareEditMessages.getString("ContextualTooltip.rac.control.right.rightToLeft", value, effectiveRight);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.control.left.accept"), value, leftUri);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.control.right.accept"), value, rightUri);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    if (originUri.isEmpty()) {
                        originUri = leftUri;
                    }
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.control.left.reject"), value, originUri);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                if (originUri.isEmpty()) {
                    originUri = rightUri;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.control.right.reject"), value, originUri);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    private String deleteResourceAttachmentChangeTooltip(MergeMode mode, ResourceAttachmentChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        EObject left = diff.getMatch().getLeft();
        EObject right = diff.getMatch().getRight();
        EObject origin = diff.getMatch().getOrigin();
        String leftUri = this.getResourceUri(left);
        String rightUri = this.getResourceUri(right);
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String effectiveLeft = this.getDirectionalValue(mirrored, leftUri, rightUri);
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.rac.uncontrol.left.leftToRight", value, effectiveLeft) : EMFCompareEditMessages.getString("ContextualTooltip.rac.uncontrol.right.leftToRight", value, effectiveLeft);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String effectiveRight = this.getDirectionalValue(mirrored, rightUri, leftUri);
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.rac.uncontrol.left.rightToLeft", value, effectiveRight) : EMFCompareEditMessages.getString("ContextualTooltip.rac.uncontrol.right.rightToLeft", value, effectiveRight);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.uncontrol.left.accept"), value, leftUri);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.uncontrol.right.accept"), value, rightUri);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                String originUri = this.getResourceUri(origin);
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    if (originUri.isEmpty()) {
                        originUri = rightUri;
                    }
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.uncontrol.left.reject"), value, originUri);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                if (originUri.isEmpty()) {
                    originUri = leftUri;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rac.uncontrol.right.reject"), value, originUri);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    private String getResourceUri(EObject o) {
        URI uri;
        Resource resource;
        if (o != null && (resource = o.eResource()) != null && (uri = resource.getURI()) != null) {
            return uri.toString();
        }
        return "";
    }
}

