/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import java.util.Properties;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryElement;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizard;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.handlers.AbstractBaseHandler;

public class RepositoryCheckoutHandlerQuick
extends AbstractBaseHandler<CDORepositoryElement> {
    public RepositoryCheckoutHandlerQuick() {
        super(CDORepositoryElement.class, Boolean.valueOf(false));
    }

    protected void doExecute(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        RepositoryCheckoutHandlerQuick.checkout((CDORepositoryElement)this.elements.get(0), "online-transactional");
    }

    public static CDOCheckout checkout(CDORepositoryElement repositoryElement, String type) {
        CDORepository repository = repositoryElement.getRepository();
        String readOnly = ("online-historical".equals(type) ? Boolean.TRUE : Boolean.FALSE).toString();
        String label = String.valueOf(StringUtil.capAll((String)type.replace('-', ' '))) + " Checkout";
        Properties properties = new Properties();
        properties.setProperty("type", type);
        properties.setProperty("label", CDOExplorerUtil.getCheckoutManager().getUniqueLabel(label));
        properties.setProperty("repository", repository.getID());
        properties.setProperty("branchID", Integer.toString(repositoryElement.getBranchID()));
        properties.setProperty("timeStamp", Long.toString(repositoryElement.getTimeStamp()));
        properties.setProperty("readOnly", readOnly);
        properties.setProperty("rootID", CDOExplorerUtil.getCDOIDString((CDOID)repositoryElement.getObjectID()));
        CDOCheckout checkout = CDOExplorerUtil.getCheckoutManager().addCheckout(properties);
        checkout.open();
        CheckoutWizard.showInProjectExplorer(checkout);
        return checkout;
    }

    public static CDOCheckout checkout(CDORepository repository, String type) {
        CDORepositoryElement repositoryElement = (CDORepositoryElement)AdapterUtil.adapt((Object)repository, CDORepositoryElement.class);
        return RepositoryCheckoutHandlerQuick.checkout(repositoryElement, type);
    }
}

