/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.layer.NatLayerPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NatGridLayerPainter
extends NatLayerPainter {
    private final Color gridColor;
    private int defaultRowHeight = 0;

    public NatGridLayerPainter(NatTable natTable) {
        this(natTable, GUIHelper.COLOR_GRAY);
    }

    public NatGridLayerPainter(NatTable natTable, Color gridColor) {
        super(natTable);
        this.gridColor = gridColor;
    }

    public NatGridLayerPainter(NatTable natTable, int defaultRowHeight) {
        this(natTable, GUIHelper.COLOR_GRAY, defaultRowHeight);
    }

    public NatGridLayerPainter(NatTable natTable, Color gridColor, int defaultRowHeight) {
        super(natTable);
        this.gridColor = gridColor;
        this.setDefaultRowHeight(defaultRowHeight);
    }

    @Override
    protected void paintBackground(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        super.paintBackground(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        Color gColor = configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR, "NORMAL", new String[0]);
        gc.setForeground(gColor != null ? gColor : this.gridColor);
        this.drawHorizontalLines(natLayer, gc, rectangle);
        this.drawVerticalLines(natLayer, gc, rectangle);
    }

    private void drawHorizontalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int endX = rectangle.x + rectangle.width;
        int rowPositionByY = natLayer.getRowPositionByY(rectangle.y + rectangle.height);
        int maxRowPosition = rowPositionByY > 0 ? Math.min(natLayer.getRowCount(), rowPositionByY) : natLayer.getRowCount();
        int y = 0;
        int rowPosition = natLayer.getRowPositionByY(rectangle.y);
        while (rowPosition < maxRowPosition) {
            y = natLayer.getStartYOfRowPosition(rowPosition) + natLayer.getRowHeightByPosition(rowPosition) - 1;
            gc.drawLine(rectangle.x, y, endX, y);
            ++rowPosition;
        }
        if (this.defaultRowHeight > 0) {
            int endY = rectangle.y + rectangle.height;
            while (y < endY) {
                gc.drawLine(rectangle.x, y += this.defaultRowHeight, endX, y);
            }
        }
    }

    private void drawVerticalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int endY = rectangle.y + rectangle.height;
        int columnPositionByX = natLayer.getColumnPositionByX(rectangle.x + rectangle.width);
        int maxColumnPosition = columnPositionByX > 0 ? Math.min(natLayer.getColumnCount(), columnPositionByX) : natLayer.getColumnCount();
        int columnPosition = natLayer.getColumnPositionByX(rectangle.x);
        while (columnPosition < maxColumnPosition) {
            int x = natLayer.getStartXOfColumnPosition(columnPosition) + natLayer.getColumnWidthByPosition(columnPosition) - 1;
            gc.drawLine(x, rectangle.y, x, endY);
            ++columnPosition;
        }
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = GUIHelper.convertVerticalPixelToDpi(defaultRowHeight);
    }
}

