/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.adapters;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;

public abstract class ResourceSetRootsAdapter
extends EContentAdapter {
    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.doNotify(msg);
            }
        }
        super.notifyChanged(msg);
    }

    protected void setTarget(ResourceSet target) {
        ResourceSet resourceSet;
        if (target instanceof ResourceSet && !(resourceSet = target).eAdapters().contains((Object)this)) {
            this.addAdapter((Notifier)resourceSet);
        }
        super.setTarget(target);
    }

    protected void setTarget(Resource target) {
    }

    protected void setTarget(EObject target) {
    }

    protected void unsetTarget(EObject target) {
    }

    protected void unsetTarget(Resource target) {
    }

    protected void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
    }

    protected void removeAdapter(Notifier notifier) {
        super.removeAdapter(notifier);
    }

    protected void unsetTarget(ResourceSet target) {
        if (target != null) {
            this.removeAdapter((Notifier)target);
        }
        super.unsetTarget(target);
    }

    protected void handleContainment(Notification notification) {
        if (notification.getEventType() == 3 || notification.getEventType() == 5) {
            if (notification.getNotifier() == this.getTarget()) {
                super.handleContainment(notification);
            }
        } else {
            super.handleContainment(notification);
        }
    }

    protected abstract void doNotify(Notification var1);

    public static abstract class Transactional
    extends ResourceSetRootsAdapter
    implements ResourceSetListener {
        private final boolean isPrecommit;
        private final NotificationFilter filter = NotificationFilter.NOT_TOUCH.and(this.createFilter());

        public Transactional() {
            this(false);
        }

        public Transactional(boolean isPrecommit) {
            this.isPrecommit = isPrecommit;
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return this.isPrecommit;
        }

        public boolean isPostcommitOnly() {
            return !this.isPrecommit;
        }

        protected NotificationFilter createFilter() {
            return NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0).or(NotificationFilter.createFeatureFilter(Resource.class, (int)2));
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            this.handleResourceSetChangeEvent(event);
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            this.handleResourceSetChangeEvent(event);
            return null;
        }

        protected void handleResourceSetChangeEvent(ResourceSetChangeEvent event) {
            for (Notification next : event.getNotifications()) {
                this.doNotify(next);
            }
        }

        @Override
        protected void doNotify(Notification msg) {
        }

        public final void setTarget(Notifier newTarget) {
        }

        public final void unsetTarget(Notifier oldTarget) {
        }

        @Override
        protected final void addAdapter(Notifier notifier) {
        }

        @Override
        protected final void removeAdapter(Notifier notifier) {
        }
    }
}

