/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.view.CDOViewSetPackageRegistryImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.WrappedException;

public class CDOViewSetImpl
extends NotifierImpl
implements InternalCDOViewSet {
    public static final String KEY_VIEW_URI = "org.eclipse.emf.cdo.viewURI";
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    private Map<URI, InternalCDOView> mapOfViews = new HashMap<URI, InternalCDOView>();
    private CDOResourceFactory resourceFactory;
    private CDOViewSetPackageRegistryImpl packageRegistry;
    private ResourceSet resourceSet;
    private ThreadLocal<Boolean> ignoreNotifications = new InheritableThreadLocal<Boolean>();

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public EPackage.Registry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public CDOResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOView[] getViews() {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new CDOView[this.views.size()]);
        }
    }

    @Override
    @Deprecated
    public InternalCDOView resolveView(String repositoryUUID) {
        return this.resolveView("cdo://" + repositoryUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOView resolveView(URI viewURI) {
        InternalCDOView view;
        block7: {
            view = null;
            Set<InternalCDOView> set = this.views;
            synchronized (set) {
                block6: {
                    view = this.mapOfViews.get(viewURI);
                    if (view != null) break block7;
                    if (viewURI != null) {
                        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewSetImpl.0"), viewURI));
                    }
                    if (this.mapOfViews.size() == 1) {
                        return this.views.iterator().next();
                    }
                    if (this.mapOfViews.size() != 0) break block6;
                    return null;
                }
                throw new IllegalStateException(Messages.getString("CDOViewSetImpl.1"));
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView getView(String repositoryUUID) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.mapOfViews.get(repositoryUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(InternalCDOView view) {
        URI viewURI = this.getViewURI(view);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            CDOView lookupView = this.mapOfViews.get(viewURI);
            if (lookupView != null) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("CDOViewSetImpl.2"), viewURI));
            }
            this.views.add(view);
            this.mapOfViews.put(viewURI, view);
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(3, null, (Object)view);
            this.eNotify((Notification)notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(InternalCDOView view) {
        ArrayList<Resource> resToRemove = new ArrayList<Resource>();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            if (this.views.remove(view)) {
                URI viewURI = this.getViewURI(view);
                this.mapOfViews.remove(viewURI);
                for (Resource resource : this.getResourceSet().getResources()) {
                    CDOResource cdoRes;
                    if (!(resource instanceof CDOResource) || (cdoRes = (CDOResource)resource).cdoView() != view) continue;
                    resToRemove.add(resource);
                }
            }
        }
        this.getResourceSet().getResources().removeAll(resToRemove);
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(4, (Object)view, null);
            this.eNotify((Notification)notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapView(InternalCDOView view) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            Iterator<Map.Entry<URI, InternalCDOView>> it = this.mapOfViews.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<URI, InternalCDOView> entry = it.next();
                if (entry.getValue() != view) continue;
                it.remove();
                break;
            }
            URI viewURI = this.getViewURI(view);
            this.mapOfViews.put(viewURI, view);
        }
    }

    public Notifier getTarget() {
        return this.resourceSet;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget == this.resourceSet) {
            return;
        }
        if (newTarget == null && this.resourceSet != null) {
            if (!this.resourceSet.getResources().isEmpty()) {
                if (!this.resourceSet.eAdapters().contains((Object)this)) {
                    this.resourceSet.eAdapters().add((Object)this);
                }
                throw new IllegalArgumentException(Messages.getString("CDOViewSetImpl.5"));
            }
            if (this.getViews().length > 0) {
                if (!this.resourceSet.eAdapters().contains((Object)this)) {
                    this.resourceSet.eAdapters().add((Object)this);
                }
                throw new IllegalArgumentException(Messages.getString("CDOViewSetImpl.6"));
            }
        } else {
            if (!this.isAdapterForType(newTarget)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewSetImpl.3"), newTarget));
            }
            if (this.resourceSet != null) {
                throw new IllegalStateException(Messages.getString("CDOViewSetImpl.4"));
            }
        }
        this.resourceSet = (ResourceSet)newTarget;
        if (this.resourceSet != null) {
            EPackage.Registry oldPackageRegistry = this.resourceSet.getPackageRegistry();
            this.packageRegistry = new CDOViewSetPackageRegistryImpl(this, oldPackageRegistry);
            this.resourceSet.setPackageRegistry((EPackage.Registry)this.packageRegistry);
            Map map = this.resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap();
            Resource.Factory resourceFactory = (Resource.Factory)map.get("cdo");
            if (resourceFactory instanceof CDOResourceFactory) {
                this.resourceFactory = (CDOResourceFactory)resourceFactory;
            } else if (resourceFactory == null) {
                this.resourceFactory = CDOResourceFactory.INSTANCE;
                map.put("cdo", this.resourceFactory);
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    @Override
    public synchronized <V> V executeWithoutNotificationHandling(Callable<V> callable) {
        Boolean wasIgnore = this.ignoreNotifications.get();
        try {
            this.ignoreNotifications.set(true);
            V v = callable.call();
            return v;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        finally {
            if (wasIgnore == null) {
                this.ignoreNotifications.remove();
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.ignoreNotifications.get() == null) {
            switch (notification.getEventType()) {
                case 6: {
                    this.deregisterResources((List)notification.getOldValue());
                    break;
                }
                case 4: {
                    this.deregisterResources(Collections.singleton(notification.getOldValue()));
                }
            }
        }
    }

    private void deregisterResources(Collection<?> potentialResources) {
        ArrayList<CDOResource> allDirtyResources = new ArrayList<CDOResource>();
        try {
            Map<CDOView, List<CDOResource>> resourcesPerView = this.getResourcesPerView(potentialResources);
            for (Map.Entry<CDOView, List<CDOResource>> entry : resourcesPerView.entrySet()) {
                List<CDOResource> dirtyResources;
                InternalCDOView view = (InternalCDOView)entry.getKey();
                List<CDOResource> resources = entry.getValue();
                if (view.isDirty() && !(dirtyResources = this.getDirtyResources(resources)).isEmpty()) {
                    allDirtyResources.addAll(dirtyResources);
                    this.resourceSet.getResources().addAll(resources);
                    continue;
                }
                for (CDOResource resource : resources) {
                    InternalCDOObject internalResource = (InternalCDOObject)((Object)resource);
                    view.deregisterObject(internalResource);
                    internalResource.cdoInternalSetState(CDOState.INVALID);
                }
            }
        }
        finally {
            int size = allDirtyResources.size();
            if (size == 1) {
                throw new CDOException("Attempt to remove a dirty resource from a resource set: " + allDirtyResources.get(0));
            }
            if (size > 1) {
                throw new CDOException("Attempt to remove dirty resources from a resource set: " + allDirtyResources);
            }
        }
    }

    private List<CDOResource> getDirtyResources(List<CDOResource> resources) {
        ArrayList<CDOResource> dirtyResources = new ArrayList<CDOResource>();
        for (CDOResource resource : resources) {
            switch (resource.cdoState()) {
                case NEW: 
                case DIRTY: 
                case CONFLICT: 
                case INVALID_CONFLICT: {
                    dirtyResources.addAll(resources);
                }
            }
        }
        return dirtyResources;
    }

    private Map<CDOView, List<CDOResource>> getResourcesPerView(Collection<?> potentialResources) {
        HashMap<CDOView, List<CDOResource>> resourcesPerView = new HashMap<CDOView, List<CDOResource>>();
        for (Object potentialResource : potentialResources) {
            CDOResource resource;
            CDOView view;
            if (!(potentialResource instanceof CDOResource) || !this.views.contains(view = (resource = (CDOResource)potentialResource).cdoView())) continue;
            ArrayList<CDOResource> resources = (ArrayList<CDOResource>)resourcesPerView.get(view);
            if (resources == null) {
                resources = new ArrayList<CDOResource>();
                resourcesPerView.put(view, resources);
            }
            resources.add(resource);
        }
        return resourcesPerView;
    }

    private URI getViewURI(InternalCDOView view) {
        URI viewURI;
        Object value = view.properties().get((Object)KEY_VIEW_URI);
        if (value instanceof String) {
            return URI.createURI((String)((String)value));
        }
        CDOViewProvider provider = view.getProvider();
        if (provider instanceof CDOViewProvider.CDOViewProvider2 && (viewURI = ((CDOViewProvider.CDOViewProvider2)provider).getViewURI(view)) != null) {
            return viewURI;
        }
        String uuid = view.getSession().getRepositoryInfo().getUUID();
        return URI.createURI((String)("cdo://" + uuid));
    }
}

