/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.Dictionary;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.federated.LocalHelpScope;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.ISearchScopeFactory;
import org.eclipse.jface.preference.IPreferenceStore;

public class LocalSearchScopeFactory
implements ISearchScopeFactory {
    public static final String P_WORKING_SET = "workingSet";
    public static final String P_CAPABILITY_FILTERING = "capabilityFiltering";

    @Override
    public ISearchScope createSearchScope(IPreferenceStore store, String engineId, Dictionary<String, Object> parameters) {
        String name = store.getString(String.valueOf(engineId) + "." + P_WORKING_SET);
        WorkingSet workingSet = null;
        if (name != null) {
            workingSet = BaseHelpSystem.getWorkingSetManager().getWorkingSet(name);
        }
        boolean capabilityFiltering = store.getBoolean(String.valueOf(engineId) + "." + P_CAPABILITY_FILTERING);
        return new LocalHelpScope(workingSet, capabilityFiltering);
    }
}

