/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

import org.eclipse.core.runtime.Assert;

import org.eclipse.jface.viewers.CheckboxTableViewer;

import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;

class PullPushCheckboxTableViewer extends CheckboxTableViewer{
	public PullPushCheckboxTableViewer(Table table) {
		super(table);
	}

	/*
	 * @see org.eclipse.jface.viewers.StructuredViewer#doUpdateItem(org.eclipse.swt.widgets.Widget, java.lang.Object, boolean)
	 */
	@Override
	protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
		super.doUpdateItem(widget, element, fullMap);
		if (! (widget instanceof TableItem))
			return;
		TableItem item= (TableItem)widget;
		IMemberActionInfo info= (IMemberActionInfo)element;
		item.setChecked(PullPushCheckboxTableViewer.getCheckState(info));
		Assert.isTrue(item.getChecked() == PullPushCheckboxTableViewer.getCheckState(info));
	}

	/*
	 * @see org.eclipse.jface.viewers.Viewer#inputChanged(java.lang.Object, java.lang.Object)
	 */
	@Override
	protected void inputChanged(Object input, Object oldInput) {
		super.inputChanged(input, oldInput);
		// XXX workaround for http://bugs.eclipse.org/bugs/show_bug.cgi?id=9390
		setCheckState((IMemberActionInfo[])input);
	}

	private void setCheckState(IMemberActionInfo[] infos) {
		if (infos == null)
			return;
		for (IMemberActionInfo info : infos) {
			setChecked(info, PullPushCheckboxTableViewer.getCheckState(info));
		}
	}

	private static boolean getCheckState(IMemberActionInfo info) {
		return info.isActive();
	}

	/*
	 * @see org.eclipse.jface.viewers.Viewer#refresh()
	 */
	@Override
	public void refresh() {
		int topIndex = getTable().getTopIndex();
		super.refresh();
		// XXX workaround for http://bugs.eclipse.org/bugs/show_bug.cgi?id=9390
		setCheckState((IMemberActionInfo[])getInput());
		if (topIndex < getTable().getItemCount())
			getTable().setTopIndex(topIndex); //see bug 31645
	}
}
