/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: ColorConverter.java 1358252 2012-07-06 15:03:16Z mehdi $ */

package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;

/**
 * Utility for implementing a color conversion scheme.
 */
public interface ColorConverter {

    /**
     * @param color to convert
     * @return converted color
     */
    Color convert(Color color);
}
