/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.papyrus.infra.internationalization.utils.ResourceBundleAndURI;
import org.osgi.framework.Bundle;

public class PropertiesFilesUtils {
    protected static final URIConverter DEFAULT_URI_CONVERTER = new ExtensibleURIConverterImpl();
    protected static final Map<URI, Map<Locale, ResourceBundleAndURI>> RESOURCE_BUNDLES = Collections.synchronizedMap(new WeakHashMap());
    public static final String EMPTY_STRING = "";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String URI_SCHEME_PLATFORM = "platform";
    public static final String URI_SEGMENT_PLUGIN = "plugin";
    public static final String URI_SEGMENT_RESOURCE = "resource";
    public static final String PROPERTIES_FILE_EXTENSION = "properties";

    protected static List<URI> getResourceBundleURIs(URI baseURI, Locale locale, String initialBaseSegment) {
        String baseSegment = initialBaseSegment;
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        String language = locale.getLanguage();
        if (language.length() > 0) {
            baseSegment = String.valueOf(baseSegment) + '_' + language;
            resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
            String country = locale.getCountry();
            if (country.length() > 0) {
                baseSegment = String.valueOf(baseSegment) + '_' + country;
                resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
                String variant = locale.getVariant();
                if (variant.length() > 0) {
                    baseSegment = String.valueOf(baseSegment) + '_' + variant;
                    resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
                }
            }
        }
        return resourceBundleURIs;
    }

    protected static List<URI> getResourceBundleURIs(URI uri, Locale locale) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        URI baseURI = uri.trimSegments(1);
        String baseSegment = uri.trimFileExtension().lastSegment();
        if (baseSegment != null) {
            resourceBundleURIs.add(baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
            if (locale != null && !locale.toString().isEmpty()) {
                resourceBundleURIs.addAll(0, PropertiesFilesUtils.getResourceBundleURIs(baseURI, locale, baseSegment));
            }
        }
        return resourceBundleURIs;
    }

    public static ResourceBundleAndURI getResourceBundle(EObject eObject, boolean localize) {
        return PropertiesFilesUtils.getResourceBundle(eObject, localize ? Locale.getDefault() : null);
    }

    public static ResourceBundleAndURI getResourceBundle(EObject eObject, Locale locale) {
        Resource resource = eObject.eResource();
        if (resource != null) {
            return PropertiesFilesUtils.getResourceBundle(resource.getURI(), locale);
        }
        return null;
    }

    public static ResourceBundleAndURI getResourceBundle(URI uri, boolean localize) {
        return PropertiesFilesUtils.getResourceBundle(uri, localize ? Locale.getDefault() : null);
    }

    public static ResourceBundleAndURI getResourceBundle(URI uri, Locale locale) {
        if (uri != null) {
            Map<Locale, ResourceBundleAndURI> resourceBundles = RESOURCE_BUNDLES.get(uri);
            if (resourceBundles == null) {
                resourceBundles = Collections.synchronizedMap(new HashMap());
                RESOURCE_BUNDLES.put(uri, resourceBundles);
            }
            if (!resourceBundles.containsKey(locale)) {
                URIConverter uriConverter = DEFAULT_URI_CONVERTER;
                List<URI> resourceBundleURIs = PropertiesFilesUtils.getResourceBundleURIs(uri, locale);
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    Bundle[] fragments;
                    Bundle bundle;
                    URI normalizedURI = uriConverter.normalize(uri);
                    int segmentCount = normalizedURI.segmentCount();
                    if (URI_SCHEME_PLATFORM.equals(normalizedURI.scheme()) && segmentCount > 2 && URI_SEGMENT_PLUGIN.equals(normalizedURI.segment(0)) && (bundle = Platform.getBundle((String)normalizedURI.segment(1))) != null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
                        String[] trailingSegments = normalizedURI.segmentsList().subList(2, segmentCount).toArray(new String[0]);
                        int f = 0;
                        while (f < fragments.length) {
                            resourceBundleURIs.addAll(0, PropertiesFilesUtils.getResourceBundleURIs(normalizedURI.trimSegments(segmentCount - 1).appendSegment(fragments[f].getSymbolicName()).appendSegments(trailingSegments), locale));
                            ++f;
                        }
                    }
                }
                PropertyResourceBundle resourceBundle = null;
                ResourceBundleAndURI resourceBundleAndURI = null;
                Iterator<URI> rbu = resourceBundleURIs.iterator();
                while (rbu.hasNext()) {
                    try {
                        URI nextURI = rbu.next();
                        try (InputStream inputStream = uriConverter.createInputStream(nextURI);){
                            resourceBundle = new PropertyResourceBundle(inputStream);
                            resourceBundleAndURI = new ResourceBundleAndURI(resourceBundle, nextURI);
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                resourceBundles.put(locale, resourceBundleAndURI);
            }
            return resourceBundles.get(locale);
        }
        return null;
    }

    public static URI getResourceBundleURIFromResourceURI(URI resourceURI, boolean localize) {
        return PropertiesFilesUtils.getResourceBundleURIFromResourceURI(resourceURI, localize ? Locale.getDefault() : null);
    }

    public static URI getResourceBundleURIFromResourceURI(URI resourceURI, Locale locale) {
        Map<Locale, ResourceBundleAndURI> resourceBundlesUrisUsed;
        URI resultURI = null;
        if (resourceURI != null && (resourceBundlesUrisUsed = RESOURCE_BUNDLES.get(resourceURI)) != null && resourceBundlesUrisUsed.containsKey(locale)) {
            resultURI = resourceBundlesUrisUsed.get(locale).getUri();
        }
        return resultURI != null ? resultURI : resourceURI;
    }

    public static String getString(EObject eObject, String key, String defaultString, boolean localize) {
        String string = defaultString;
        if (eObject != null) {
            try {
                ResourceBundleAndURI resourceBundleAndURI = PropertiesFilesUtils.getResourceBundle(eObject, localize);
                if (resourceBundleAndURI != null) {
                    string = resourceBundleAndURI.getResourceBundle().getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void removeResourceBundle(URI uri) {
        if (RESOURCE_BUNDLES.containsKey(uri)) {
            RESOURCE_BUNDLES.remove(uri);
        }
    }
}

