/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleWithStoreObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomDoubleStyleWithStoreObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomIntStyleWithStoreObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.RulersUnitStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.LineStyleLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.UnitsLabelProvider;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElement;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;

public class RulerAndGridModelElement
extends AbstractModelElement {
    protected Diagram diagram;
    protected IPreferenceStore store;
    protected EditingDomain domain;

    public RulerAndGridModelElement(Diagram view, EditingDomain domain, DataContextElement context, IPreferenceStore preferenceStore) {
        this.diagram = view;
        this.domain = domain;
        this.store = preferenceStore;
    }

    public void dispose() {
        super.dispose();
        this.diagram = null;
        this.store = null;
    }

    protected IObservable doGetObservable(String propertyPath) {
        CustomBooleanStyleWithStoreObservableValue observable = null;
        if ("grid.isDisplayingGrid".equals(propertyPath)) {
            observable = new CustomBooleanStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.viewgrid", this.store);
        }
        if ("rulers.isDisplayingRulers".equals(propertyPath)) {
            observable = new CustomBooleanStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.viewrulers", this.store);
        }
        if ("grid.isInFront".equals(propertyPath)) {
            observable = new CustomBooleanStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.gridlevel", this.store);
        }
        if ("grid.color".equals(propertyPath)) {
            observable = new CustomIntStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.gridlinecolor", this.store);
        }
        if ("grid.style".equals(propertyPath)) {
            observable = new CustomIntStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.gridlinestyle", this.store);
        }
        if ("grid.spacing".equals(propertyPath)) {
            observable = new CustomDoubleStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.gridspacing", this.store);
        }
        if ("grid.isSnapToGrid".equals(propertyPath)) {
            observable = new CustomBooleanStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.snaptogrid", this.store);
        }
        if ("grid.isSnapToShapes".equals(propertyPath)) {
            observable = new CustomBooleanStyleWithStoreObservableValue((View)this.diagram, this.domain, "rulergrid.snaptogeometry", this.store);
        }
        if ("rulers.units".equals(propertyPath)) {
            observable = new RulersUnitStyleObservableValue((View)this.diagram, this.domain, this.store);
        }
        return observable;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if ("grid.style".equals(propertyPath)) {
            return new StaticContentProvider(new Object[]{2, 4, 5, 3, 1, 6});
        }
        if ("rulers.units".equals(propertyPath)) {
            return new StaticContentProvider(new Object[]{0, 1, 2});
        }
        return super.getContentProvider(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if ("grid.style".equals(propertyPath)) {
            return new LineStyleLabelProvider();
        }
        if ("rulers.units".equals(propertyPath)) {
            return new UnitsLabelProvider();
        }
        return null;
    }

    public boolean isMandatory(String propertyPath) {
        return "grid.style".equals(propertyPath) || "rulers.units".equals(propertyPath);
    }

    public boolean forceRefresh(String propertyPath) {
        return true;
    }
}

