/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.assistant.commands.internal;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.requirements.sysml14.common.Utils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class RequirementCreateCommand
extends RecordingCommand {
    protected Element owner;
    private String id;
    private String text;

    public RequirementCreateCommand(TransactionalEditingDomain domain, Element owner, String id, String text) {
        super(domain, "PapyrusReqSysMLRequirementCreateCommand");
        this.owner = owner;
        this.id = id;
        this.text = text;
    }

    protected static void createRequirement(Package owner, String id, String text) {
        Class requirement = owner.createOwnedClass("tmpName", false);
        Stereotype reqStereotype = requirement.getApplicableStereotype("SysML::Requirements::Requirement");
        requirement.applyStereotype(reqStereotype);
        if (id == null) {
            id = Utils.getNewRequirementID((Element)owner);
        }
        requirement.setName(id);
        requirement.setValue(reqStereotype, "id", (Object)id);
        if (text != null) {
            requirement.setValue(reqStereotype, "text", (Object)text);
        }
    }

    protected void doExecute() {
        if (this.owner instanceof Package) {
            RequirementCreateCommand.createRequirement((Package)this.owner, this.id, this.text);
        } else if (this.owner.getNearestPackage() != null) {
            RequirementCreateCommand.createRequirement(this.owner.getNearestPackage(), this.id, this.text);
        }
    }
}

