/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementandprocessconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AgreementStatusKind implements Enumerator
{
    SUBMITTED(0, "Submitted", "Submitted"),
    TO_BE_REFINED(1, "ToBeRefined", "ToBeRefined"),
    ACCEPTED(2, "Accepted", "Accepted"),
    DRAFT(3, "Draft", "Draft"),
    REJECTED(4, "Rejected", "Rejected");

    public static final int SUBMITTED_VALUE = 0;
    public static final int TO_BE_REFINED_VALUE = 1;
    public static final int ACCEPTED_VALUE = 2;
    public static final int DRAFT_VALUE = 3;
    public static final int REJECTED_VALUE = 4;
    private static final AgreementStatusKind[] VALUES_ARRAY;
    public static final List<AgreementStatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AgreementStatusKind[]{SUBMITTED, TO_BE_REFINED, ACCEPTED, DRAFT, REJECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AgreementStatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AgreementStatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AgreementStatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AgreementStatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AgreementStatusKind get(int value) {
        switch (value) {
            case 0: {
                return SUBMITTED;
            }
            case 1: {
                return TO_BE_REFINED;
            }
            case 2: {
                return ACCEPTED;
            }
            case 3: {
                return DRAFT;
            }
            case 4: {
                return REJECTED;
            }
        }
        return null;
    }

    private AgreementStatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

