/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.view;

import java.util.ArrayList;
import org.eclipse.papyrus.metrics.extensionpoints.helpers.Result;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class BasicMetricsView
extends ViewPart {
    private ArrayList<Result> measuresResults = null;
    private static Table table;

    public void createPartControl(Composite parent) {
        this.setTitleToolTip("Metrics");
        table = new Table(parent, 4);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 16384);
        TableColumn column2 = new TableColumn(table, 16384);
        TableColumn column3 = new TableColumn(table, 16384);
        TableColumn column4 = new TableColumn(table, 16384);
        column1.setWidth(300);
        column1.setText("Measure Name");
        column2.setWidth(150);
        column2.setText("Measure Value");
        column3.setWidth(200);
        column3.setText("Type of element measured");
        column4.setWidth(250);
        column4.setText("Name of element measured");
        this.clearTable();
        if (this.getResults() != null) {
            for (Result line : this.getResults()) {
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{line.getMeasure().getName(), line.getValue().toString(), line.getMeasurand().eClass().getName(), BasicMetricsView.getMeasurandName(line.getMeasurand())});
            }
        }
    }

    public void setFocus() {
        table.setFocus();
    }

    public void updateInformation(ArrayList<Result> measuresResults) {
        this.measuresResults = measuresResults;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BasicMetricsView.this.clearTable();
                if (BasicMetricsView.this.getResults() != null) {
                    for (Result line : BasicMetricsView.this.getResults()) {
                        TableItem item = new TableItem(table, 0);
                        item.setText(new String[]{line.getMeasure().getName(), line.getValue().toString(), line.getMeasurand().eClass().getName(), BasicMetricsView.getMeasurandName(line.getMeasurand())});
                    }
                }
            }
        });
    }

    public ArrayList<Result> getResults() {
        return this.measuresResults;
    }

    protected void clearTable() {
        table.removeAll();
    }

    public static String getMeasurandName(Element measurand) {
        return measurand instanceof NamedElement ? ((NamedElement)measurand).getQualifiedName() : measurand;
    }
}

