/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.papyrus.iotml.software.artefact.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ArtefactFactoryImpl extends EFactoryImpl implements ArtefactFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ArtefactFactory init() {
		try {
			ArtefactFactory theArtefactFactory = (ArtefactFactory)EPackage.Registry.INSTANCE.getEFactory(ArtefactPackage.eNS_URI);
			if (theArtefactFactory != null) {
				return theArtefactFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ArtefactFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArtefactFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ArtefactPackage.PROPERTY_ACCESS: return createPropertyAccess();
			case ArtefactPackage.DIGITAL_ARTEFACT: return createDigitalArtefact();
			case ArtefactPackage.VIRTUAL_ENTITY: return createVirtualEntity();
			case ArtefactPackage.PROVIDE_SERVICE: return createProvideService();
			case ArtefactPackage.PROVIDE_RESOURCE: return createProvideResource();
			case ArtefactPackage.SERVICE_DESCRIPTION: return createServiceDescription();
			case ArtefactPackage.SERVICE: return createService();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PropertyAccess createPropertyAccess() {
		PropertyAccessImpl propertyAccess = new PropertyAccessImpl();
		return propertyAccess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DigitalArtefact createDigitalArtefact() {
		DigitalArtefactImpl digitalArtefact = new DigitalArtefactImpl();
		return digitalArtefact;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VirtualEntity createVirtualEntity() {
		VirtualEntityImpl virtualEntity = new VirtualEntityImpl();
		return virtualEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProvideService createProvideService() {
		ProvideServiceImpl provideService = new ProvideServiceImpl();
		return provideService;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProvideResource createProvideResource() {
		ProvideResourceImpl provideResource = new ProvideResourceImpl();
		return provideResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceDescription createServiceDescription() {
		ServiceDescriptionImpl serviceDescription = new ServiceDescriptionImpl();
		return serviceDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Service createService() {
		ServiceImpl service = new ServiceImpl();
		return service;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArtefactPackage getArtefactPackage() {
		return (ArtefactPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ArtefactPackage getPackage() {
		return ArtefactPackage.eINSTANCE;
	}

} //ArtefactFactoryImpl
