/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.xpath.inspector.InspectorManager;
import org.osgi.framework.Bundle;

public final class ModelInspectorsManager
implements IRegistryChangeListener {
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "modelInspectors";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.modelInspectors";
    private final Map tagLibraries = new HashMap();
    private static final String E_INSPECTOR = "inspector";
    private static final String A_INSPECTOR_CLASS = "class";
    private static final String E_INSPECTS = "inspects";
    private static final String A_INSPECTS_CLASS = "class";

    public void startup() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.addConfigElements(configElements);
        reg.addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(EXTENSION_POINT_ID);
        int i = 0;
        while (i < deltas.length) {
            IExtension ext = deltas[i].getExtension();
            if (deltas[i].getKind() == 1) {
                this.addConfigElements(ext.getConfigurationElements());
            } else {
                this.removeConfigElements(ext.getConfigurationElements());
            }
            ++i;
        }
    }

    public void shutdown() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        this.tagLibraries.clear();
    }

    private void addConfigElements(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            if (E_INSPECTOR.equals(configElements[i].getName())) {
                String contributorId = configElements[i].getDeclaringExtension().getNamespace();
                Bundle bundle = Platform.getBundle((String)contributorId);
                String inspectorClassName = configElements[i].getAttribute("class");
                IConfigurationElement[] children = configElements[i].getChildren(E_INSPECTS);
                ArrayList<String> inspectables = new ArrayList<String>(children.length);
                int j = 0;
                while (j < children.length) {
                    String inspectableClassName = children[j].getAttribute("class");
                    inspectables.add(inspectableClassName);
                    ++j;
                }
                try {
                    Class inspectorClass = bundle.loadClass(inspectorClassName);
                    String[] inspectableClasses = inspectables.toArray(new String[inspectables.size()]);
                    InspectorManager.getInstance().registerInspector(inspectableClasses, inspectorClass);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void removeConfigElements(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            if (E_INSPECTOR.equals(configElements[i].getName())) {
                String inspectorClassName = configElements[i].getAttribute("class");
                IConfigurationElement[] children = configElements[i].getChildren(E_INSPECTS);
                ArrayList<String> inspectables = new ArrayList<String>(children.length);
                int j = 0;
                while (j < children.length) {
                    String inspectableClassName = children[j].getAttribute("class");
                    inspectables.add(inspectableClassName);
                    ++j;
                }
                String[] inspectableClasses = inspectables.toArray(new String[inspectables.size()]);
                InspectorManager.getInstance().unregisterInspector(inspectableClasses, inspectorClassName);
            }
            ++i;
        }
    }
}

