/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xpand2.ast.TextStatement;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputImpl
implements Output {
    private boolean automaticHyphenation = false;
    protected Stack<FileHandle> fileHandles = new Stack();
    private final Map<String, Outlet> outlets = new HashMap<String, Outlet>();
    private boolean deleteLine = false;
    private static final Pattern p = Pattern.compile("(.+)://(.+)");
    private final Stack<SyntaxElement> s = new Stack();

    public void setAutomaticHyphens(boolean automaticHyphenation) {
        this.automaticHyphenation = automaticHyphenation;
    }

    @Override
    public void addOutlet(Outlet outlet) {
        if (this.outlets.containsKey(outlet.getName())) {
            if (outlet.getName() == null) {
                throw new IllegalArgumentException("A default outlet is already registered!");
            }
            throw new IllegalArgumentException("An outlet with name " + outlet.getName() + " is already registered!");
        }
        this.outlets.put(outlet.getName(), outlet);
    }

    @Override
    public Outlet getOutlet(String name) {
        return this.outlets.get(name);
    }

    protected FileHandle current() {
        return this.fileHandles.isEmpty() ? null : this.fileHandles.peek();
    }

    public FileHandle current__testONLY() {
        return this.current();
    }

    @Override
    public void write(String bytes) {
        if (this.current() != null) {
            if (this.deleteLine) {
                String temp = this.trimUntilNewline(bytes);
                this.removeWSAfterLastNewline(this.current().getBuffer());
                ((StringBuffer)this.current().getBuffer()).append(temp);
            } else {
                ((StringBuffer)this.current().getBuffer()).append(bytes);
            }
        }
        this.deleteLine = false;
    }

    public void removeWSAfterLastNewline(CharSequence cs) {
        StringBuffer buffer = (StringBuffer)cs;
        int i = buffer.length();
        boolean wsOnly = true;
        while (i > 0 && wsOnly) {
            char c = buffer.charAt(i - 1);
            wsOnly = Character.isWhitespace(c);
            if (wsOnly && this.isNewLine(c)) {
                buffer.delete(i, buffer.length());
                return;
            }
            --i;
        }
    }

    protected boolean isNewLine(char c) {
        return c == '\n' || c == '\r';
    }

    public String trimUntilNewline(String bytes) {
        int i = 0;
        boolean wsOnly = true;
        while (i < bytes.length() && wsOnly) {
            char c = bytes.charAt(i);
            wsOnly = Character.isWhitespace(c);
            if (wsOnly && this.isNewLine(c)) {
                if (c == '\r' && i + 1 < bytes.length() && bytes.charAt(i + 1) == '\n') {
                    ++i;
                }
                return bytes.substring(i + 1);
            }
            ++i;
        }
        return bytes;
    }

    public static Pair<Outlet, String> resolveOutlet(Map<String, Outlet> allOutlets, String path, String outletName) {
        Outlet o;
        Matcher m;
        if (outletName == null && (m = p.matcher(path)).matches()) {
            outletName = m.group(1);
            path = m.group(2);
        }
        if ((o = allOutlets.get(outletName)) == null) {
            if (outletName == null) {
                throw new IllegalArgumentException("No default outlet was configured!");
            }
            throw new IllegalArgumentException("No outlet with the name " + outletName + " could be found!");
        }
        return new Pair((Object)o, (Object)path);
    }

    @Override
    public void openFile(String path, String outletName) {
        Pair<Outlet, String> raw = OutputImpl.resolveOutlet(this.outlets, path, outletName);
        Outlet actualOutlet = (Outlet)raw.getFirst();
        String actualPath = (String)raw.getSecond();
        this.fileHandles.push(actualOutlet.createFileHandle(actualPath));
    }

    @Override
    public void closeFile() {
        FileHandle fi = this.fileHandles.pop();
        fi.writeAndClose();
    }

    @Override
    public void pushStatement(SyntaxElement stmt, XpandExecutionContext ctx) {
        if (stmt instanceof TextStatement) {
            this.deleteLine = ((TextStatement)stmt).isDeleteLine();
            if (this.automaticHyphenation) {
                this.deleteLine = true;
            }
        }
        this.s.push(stmt);
    }

    @Override
    public SyntaxElement popStatement() {
        SyntaxElement se = this.s.pop();
        return se;
    }
}

