/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.workspace.WsFolderAction;
import org.eclipse.jet.taglib.AbstractContainerTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;

public class FolderTag
extends AbstractContainerTag {
    private static final String PATH__ATTR = "path";
    private boolean containerPushed = false;

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        IFolder folder;
        Path path = new Path(this.getAttribute(PATH__ATTR));
        WorkspaceContextExtender wsExtender = WorkspaceContextExtender.getInstance(context);
        if (path.isAbsolute() || !wsExtender.existsContainer()) {
            try {
                folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
            }
            catch (IllegalArgumentException e) {
                throw new JET2TagException(e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            folder = wsExtender.getContainer().getFolder((IPath)path);
        }
        wsExtender.addAction(new WsFolderAction(context.getTemplatePath(), td, folder));
        wsExtender.pushContainer((IContainer)folder);
        this.containerPushed = true;
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        WorkspaceContextExtender wsExtender = WorkspaceContextExtender.getInstance(context);
        if (this.containerPushed) {
            wsExtender.popContainer();
        }
    }
}

