/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.StringTokenizer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.exceptions.MissingRequiredAttributeException;
import org.eclipse.jet.internal.exceptions.NoMatchingNodeException;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public class DumpTag
extends AbstractEmptyTag {
    private static final String NL = System.getProperty("line.separator");
    private String _select = null;
    private Object resolved_node;
    private String _format = null;
    private String _entities = null;

    public void doAction(TagInfo tagInfo, JET2Context context, JET2Writer out) throws JET2TagException {
        XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);
        this._select = this.getAttribute("select");
        if (this._select == null) {
            throw new MissingRequiredAttributeException("select");
        }
        this.resolved_node = xpathContext.resolveSingle(xpathContext.currentXPathContextObject(), this._select);
        if (this.resolved_node == null) {
            throw new NoMatchingNodeException(this._select);
        }
        this._format = this.getAttribute("format");
        this._entities = this.getAttribute("entities");
        boolean format = false;
        if ("true".equalsIgnoreCase(this._format)) {
            format = true;
        }
        if ("yes".equalsIgnoreCase(this._format)) {
            format = true;
        }
        boolean entities = false;
        if ("true".equalsIgnoreCase(this._entities)) {
            entities = true;
        }
        if ("yes".equalsIgnoreCase(this._entities)) {
            entities = true;
        }
        StringBuffer buffer = new StringBuffer();
        this.dump2(this.resolved_node, format, entities, 1, context, buffer);
        out.write(buffer.toString());
    }

    private void dump2(Object node, boolean format, boolean entities, int indent, JET2Context context, StringBuffer out) {
        block7: {
            INodeInspector.NodeKind nodeKind;
            XPathContextExtender xpc;
            block9: {
                block8: {
                    block6: {
                        xpc = XPathContextExtender.getInstance(context);
                        INodeInspector inspector = InspectorManager.getInstance().getInspector(node);
                        if (inspector == null) {
                            return;
                        }
                        nodeKind = inspector.getNodeKind(node);
                        if (nodeKind != INodeInspector.NodeKind.ELEMENT) break block6;
                        out.append("<");
                        String tagName = inspector.nameOf(node);
                        out.append(tagName);
                        Object[] attrs = xpc.resolve(node, "attribute::*");
                        int i = 0;
                        while (attrs != null && i < attrs.length) {
                            out.append(" ");
                            out.append(xpc.resolveAsString(attrs[i], "name()"));
                            out.append("=");
                            out.append(this.useRightQuotes(xpc.resolveAsString(attrs[i], "string()")));
                            ++i;
                        }
                        Object[] children = xpc.resolve(node, "child::node()");
                        if (children != null && children.length > 0) {
                            out.append(">");
                            this.writeChildren(children, format, entities, indent, context, out);
                            out.append("</");
                            out.append(tagName);
                            out.append(">");
                        } else {
                            out.append("/>");
                        }
                        break block7;
                    }
                    if (nodeKind != INodeInspector.NodeKind.TEXT) break block8;
                    String buffer = xpc.resolveAsString(node, "string()");
                    if (entities) {
                        buffer = this.insertEntities(buffer);
                    }
                    out.append(buffer);
                    break block7;
                }
                if (nodeKind != INodeInspector.NodeKind.COMMENT) break block9;
                out.append("<!--");
                out.append(xpc.resolveAsString(node, "string()"));
                out.append("-->");
                break block7;
            }
            if (nodeKind != INodeInspector.NodeKind.ROOT) break block7;
            Object[] children = xpc.resolve(node, "child::node()");
            if (children != null) {
                this.writeChildren(children, format, entities, 0, context, out);
            }
        }
    }

    private void writeChildren(Object[] children, boolean format, boolean entities, int indent, JET2Context context, StringBuffer out) {
        boolean textEncountered = false;
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                INodeInspector childInspector = InspectorManager.getInstance().getInspector(children[i]);
                boolean bl = textEncountered = textEncountered || childInspector.getNodeKind(children[i]) == INodeInspector.NodeKind.TEXT;
                if (!textEncountered && format) {
                    out.append(NL);
                    this.indent(out, indent);
                }
                this.dump2(children[i], format, entities, indent + 1, context, out);
            }
            ++i;
        }
        if (!textEncountered && format) {
            out.append(NL);
            this.indent(out, indent - 1);
        }
    }

    private void indent(StringBuffer out, int indent) {
        int j = 0;
        while (j < indent) {
            out.append("    ");
            ++j;
        }
    }

    public void dump(Object node, boolean format, boolean entities, int indent, JET2Context context, JET2Writer out) {
        IElementInspector elementInspector;
        boolean written = false;
        boolean writeKids = false;
        INodeInspector inspector = InspectorManager.getInstance().getInspector(node);
        if (inspector == null) {
            return;
        }
        if (inspector.getNodeKind(node) == INodeInspector.NodeKind.ELEMENT) {
            elementInspector = (IElementInspector)inspector;
            out.write("<" + inspector.nameOf(node));
            Object[] attr = elementInspector.getAttributes(node);
            int i = 0;
            while (i < attr.length) {
                INodeInspector ei = InspectorManager.getInstance().getInspector(attr[i]);
                String key = ei.nameOf(attr[i]);
                String value = ei.stringValueOf(attr[i]);
                out.write(" " + key + "=" + this.useRightQuotes(value));
                ++i;
            }
            boolean staticEncountered = false;
            Object[] kid = elementInspector.getChildren(node);
            if (kid.length > 0) {
                out.write(">");
                int index = 0;
                while (index < kid.length) {
                    INodeInspector kidInspector = InspectorManager.getInstance().getInspector(kid[index]);
                    if (kidInspector.getNodeKind(kid[index]) == INodeInspector.NodeKind.ELEMENT) {
                        if (!staticEncountered && format) {
                            out.write(NL);
                            int i2 = 0;
                            while (i2 < indent) {
                                out.write("    ");
                                ++i2;
                            }
                            staticEncountered = false;
                        }
                    } else {
                        staticEncountered = true;
                    }
                    this.dump(kid[index], format, entities, indent + 1, context, out);
                    ++index;
                }
                if (!staticEncountered && format) {
                    out.write(NL);
                    int i3 = 1;
                    while (i3 < indent) {
                        out.write("    ");
                        ++i3;
                    }
                    staticEncountered = false;
                }
                out.write("</" + inspector.nameOf(node) + ">");
            } else {
                out.write("/>");
            }
            written = true;
        }
        if (inspector.getNodeKind(node) == INodeInspector.NodeKind.TEXT) {
            String buffer = inspector.stringValueOf(node);
            if (entities) {
                buffer = this.insertEntities(buffer);
            }
            out.write(buffer);
            written = true;
        }
        if (inspector.getNodeKind(node) == INodeInspector.NodeKind.ROOT) {
            written = true;
            writeKids = true;
        }
        if (!written) {
            System.out.println("Did not write type " + inspector.getNodeKind(node));
        }
        if (writeKids) {
            elementInspector = (IElementInspector)inspector;
            Object[] kid = elementInspector.getChildren(node);
            int index = 0;
            while (index < kid.length) {
                this.dump(kid[index], format, entities, indent + 1, context, out);
                ++index;
            }
        }
    }

    private String useRightQuotes(String string) {
        if (string.indexOf("\"") > -1) {
            return "'" + string + "'";
        }
        return "\"" + string + "\"";
    }

    private String insertEntities(String string) {
        StringBuffer sb = new StringBuffer(string.length() * 2);
        StringTokenizer st = new StringTokenizer(string, "<>&'\"", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("<")) {
                token = "&lt;";
            }
            if (token.equals(">")) {
                token = "&gt;";
            }
            if (token.equals("&")) {
                token = "&amp;";
            }
            if (token.equals("'")) {
                token = "&apos;";
            }
            if (token.equals("\"")) {
                token = "&quot;";
            }
            sb.append(token);
        }
        String buffer = sb.toString();
        return buffer;
    }
}

