/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.model.mtl.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMtlResourceImpl
extends XMIResourceImpl {
    private static final String POSITIONS_ANNOTATION_NAME = "positions";

    public EMtlResourceImpl(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
        EAnnotation positions = this.getPositions(false);
        if (positions != null) {
            this.restorePositions(positions);
            this.getContents().remove((Object)positions);
        }
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        EAnnotation positions = this.getPositions(true);
        this.savePositions(positions);
        try {
            super.doSave(outputStream, options);
        }
        finally {
            this.getContents().remove((Object)positions);
        }
    }

    private void savePositions(EAnnotation positions) {
        for (EObject content : this.getContents()) {
            if (!(content instanceof Module)) continue;
            Module eModule = (Module)content;
            TreeIterator eAllContents = eModule.eAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof ASTNode)) continue;
                int start = ((ASTNode)eObject).getStartPosition();
                int end = ((ASTNode)eObject).getEndPosition();
                this.savePosition(positions, (ASTNode)eObject, start, end);
            }
        }
    }

    private void savePosition(EAnnotation positions, ASTNode node, int start, int end) {
        EAnnotation position = EcoreFactory.eINSTANCE.createEAnnotation();
        position.setSource("positions." + positions.getEAnnotations().size());
        position.getReferences().add((Object)node);
        position.getDetails().put((Object)"start", (Object)String.valueOf(start));
        position.getDetails().put((Object)"end", (Object)String.valueOf(end));
        positions.getEAnnotations().add((Object)position);
    }

    private void restorePositions(EAnnotation positions) {
        for (EAnnotation position : positions.getEAnnotations()) {
            ASTNode node = (ASTNode)position.getReferences().get(0);
            if (node.getStartPosition() != -1 || node.getEndPosition() != -1) continue;
            int start = Integer.parseInt((String)position.getDetails().get((Object)"start"));
            int end = Integer.parseInt((String)position.getDetails().get((Object)"end"));
            node.setStartPosition(start);
            node.setEndPosition(end);
        }
    }

    private EAnnotation getPositions(boolean create) {
        EAnnotation positions = null;
        Iterator contents = this.getContents().iterator();
        while (positions == null && contents.hasNext()) {
            EObject content = (EObject)contents.next();
            if (!(content instanceof EAnnotation) || !POSITIONS_ANNOTATION_NAME.equals(((EAnnotation)content).getSource())) continue;
            positions = (EAnnotation)content;
        }
        if (positions == null && create) {
            positions = EcoreFactory.eINSTANCE.createEAnnotation();
            positions.setSource(POSITIONS_ANNOTATION_NAME);
            this.getContents().add((Object)positions);
        }
        return positions;
    }
}

