/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.overrides;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.ColorManager;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.IAcceleoColorConstants;
import org.eclipse.acceleo.internal.ide.ui.views.overrides.ModuleProjectHandler;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class OverridesBrowserTemplateLabelProvider
extends AdapterFactoryLabelProvider {
    private ColorManager manager = new ColorManager();

    public OverridesBrowserTemplateLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Color getBackground(Object object) {
        if (object instanceof ModuleProjectHandler && !((ModuleProjectHandler)object).isResolved()) {
            return this.manager.getColor(IAcceleoColorConstants.TEMPLATE);
        }
        return super.getBackground(object);
    }

    public void dispose() {
        super.dispose();
        this.manager.dispose();
    }

    public String getText(Object object) {
        String result;
        if (object == null) {
            result = "";
        } else if (object instanceof String) {
            result = (String)object;
        } else if (object instanceof ModuleProjectHandler) {
            result = ((ModuleProjectHandler)object).getName();
        } else if (object instanceof Module) {
            result = ((Module)object).getName();
        } else if (object instanceof ModuleElement) {
            ModuleElement element = (ModuleElement)object;
            StringBuilder signature = new StringBuilder();
            signature.append(element.getName());
            if (element instanceof Template) {
                signature.append('(');
                boolean first = true;
                for (Variable iVariable : ((Template)element).getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        signature.append(',');
                    }
                    if (iVariable.getType() == null) continue;
                    signature.append(((EClassifier)iVariable.getType()).getName());
                }
                signature.append(')');
            } else if (element instanceof Macro) {
                signature.append('(');
                boolean first = true;
                for (Variable iVariable : ((Macro)element).getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        signature.append(',');
                    }
                    if (iVariable.getType() == null) continue;
                    signature.append(((EClassifier)iVariable.getType()).getName());
                }
                signature.append(')');
            } else if (element instanceof Query) {
                signature.append('(');
                boolean first = true;
                for (Variable iVariable : ((Query)element).getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        signature.append(',');
                    }
                    if (iVariable.getType() == null) continue;
                    signature.append(((EClassifier)iVariable.getType()).getName());
                }
                signature.append(')');
            }
            result = signature.toString();
        } else {
            result = super.getText(object);
        }
        return result;
    }

    public Image getImage(Object object) {
        Image result = object instanceof ModuleProjectHandler ? (((ModuleProjectHandler)object).isResolved() ? AcceleoUIActivator.getDefault().getImage("icons/overrides/AcceleoProjectResolved.gif") : AcceleoUIActivator.getDefault().getImage("icons/overrides/AcceleoProjectNotResolved.gif")) : (object instanceof Module ? AcceleoUIActivator.getDefault().getImage("icons/overrides/Module.gif") : (object instanceof ModuleElement ? this.getModuleElementImage((ModuleElement)object) : super.getImage(object)));
        return result;
    }

    private Image getModuleElementImage(ModuleElement eModuleElement) {
        if (eModuleElement instanceof Template) {
            boolean isMain = false;
            TreeIterator iChildren = ((Template)eModuleElement).eAllContents();
            while (!isMain && iChildren.hasNext()) {
                EObject iChild = (EObject)iChildren.next();
                if (!(iChild instanceof Comment) || ((Comment)iChild).getBody() == null || ((Comment)iChild).getBody().indexOf("@main") <= -1) continue;
                isMain = true;
            }
            if (isMain) {
                return AcceleoUIActivator.getDefault().getImage("icons/overrides/Template_main.gif");
            }
        }
        return AcceleoUIActivator.getDefault().getImage("icons/overrides/" + eModuleElement.eClass().getName() + ".gif");
    }
}

