/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix.AbstractCreateModuleElementResolution;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.JavaServicesUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoCreateJavaServiceWrapperResolutionAfterLastMember
extends AbstractCreateModuleElementResolution {
    public String getDescription() {
        return AcceleoUIMessages.getString("AcceleoCreateJavaServiceWrapperResolutionAfterLastMember.Description");
    }

    public Image getImage() {
        return AcceleoUIActivator.getDefault().getImage("icons/quickfix/QuickFixCreateQuery.gif");
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoCreateJavaServiceWrapperResolutionAfterLastMember.Label");
    }

    @Override
    protected void append(StringBuilder newText, String name, String paramType, String paramName) {
        try {
            for (IFile javaFile : this.getProjectJavaFiles()) {
                this.createJavaWrappers(newText, javaFile, name);
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
    }

    private List<IFile> getProjectJavaFiles() throws CoreException {
        AcceleoEditor editor;
        IFile mtlFile;
        ArrayList<IFile> javaFiles = new ArrayList<IFile>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor && (mtlFile = (editor = (AcceleoEditor)window.getActivePage().getActiveEditor()).getFile()) != null) {
            IProject project = mtlFile.getProject();
            this.members(javaFiles, (IContainer)project, "java");
        }
        return javaFiles;
    }

    private void members(List<IFile> filesOutput, IContainer container, String extension) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                    filesOutput.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.members(filesOutput, (IContainer)resource, extension);
                }
                ++i;
            }
        }
    }

    private void createJavaWrappers(StringBuilder buffer, IFile javaFile, String serviceName) {
        IJavaElement javaElement = JavaCore.create((IFile)javaFile);
        if (javaElement instanceof ICompilationUnit) {
            IType[] types;
            ICompilationUnit classFile = (ICompilationUnit)javaElement;
            try {
                types = classFile.getTypes();
            }
            catch (JavaModelException javaModelException) {
                types = new IType[]{};
            }
            int i = 0;
            while (i < types.length) {
                block17: {
                    String typeQualifiedName = types[i].getFullyQualifiedName();
                    AcceleoWorkspaceUtil.INSTANCE.addWorkspaceContribution(javaFile.getProject());
                    try {
                        try {
                            boolean browseFile;
                            Class javaClass = AcceleoWorkspaceUtil.INSTANCE.getClass(typeQualifiedName, false);
                            if (javaClass != null) {
                                try {
                                    javaClass.getMethod("main", String[].class);
                                    browseFile = false;
                                }
                                catch (SecurityException securityException) {
                                    browseFile = false;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    browseFile = true;
                                }
                            } else {
                                browseFile = false;
                            }
                            if (browseFile) {
                                Method[] javaMethods = javaClass.getDeclaredMethods();
                                int j = 0;
                                while (j < javaMethods.length) {
                                    Method javaMethod = javaMethods[j];
                                    if (javaMethod.getName() != null && javaMethod.getName().toLowerCase().startsWith(serviceName.toLowerCase())) {
                                        buffer.append(JavaServicesUtils.createQuery(javaMethod));
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (NoClassDefFoundError e) {
                            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            AcceleoWorkspaceUtil.INSTANCE.reset();
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        AcceleoWorkspaceUtil.INSTANCE.reset();
                        throw throwable;
                    }
                    AcceleoWorkspaceUtil.INSTANCE.reset();
                }
                ++i;
            }
        }
    }
}

