/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FileTreeContentProvider
implements ITreeContentProvider {
    private boolean showClosedProjects;
    private String filterExtension;

    public FileTreeContentProvider(boolean showClosedProjects, String filterExtension) {
        this.showClosedProjects = showClosedProjects;
        this.filterExtension = filterExtension;
    }

    public FileTreeContentProvider(boolean showClosedProjects) {
        this(showClosedProjects, null);
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IContainer container;
        Object[] res = new Object[]{};
        if (element instanceof IWorkspace) {
            IProject[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            if (this.showClosedProjects) {
                res = allProjects;
            } else {
                ArrayList<IProject> accessibleProjects = new ArrayList<IProject>();
                int i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                res = accessibleProjects.toArray();
            }
        } else if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (!(members[i].isDerived() || members[i].getName().startsWith(".") || this.filterExtension != null && !(members[i] instanceof IContainer))) {
                        children.add(members[i]);
                    } else if (!members[i].isDerived() && !members[i].getName().startsWith(".") && this.filterExtension.equals(members[i].getFullPath().getFileExtension())) {
                        children.add(members[i]);
                    }
                    ++i;
                }
                res = children.toArray();
            }
            catch (CoreException coreException) {}
        }
        return res;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

