/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.strategy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.generation.strategy.AbstractGenerationStrategy;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.generation.writers.AcceleoFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStrategy
extends AbstractGenerationStrategy {
    protected final List<Future<Object>> lostCreationTasks = new ArrayList<Future<Object>>();
    protected final ExecutorService lostCreatorsPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    @Override
    public void awaitCompletion() throws InterruptedException {
        for (Future<Object> task : new ArrayList<Future<Object>>(this.lostCreationTasks)) {
            while (!task.isDone() && !task.isCancelled()) {
                try {
                    task.get();
                }
                catch (ExecutionException e) {
                    AcceleoEnginePlugin.log(e, true);
                }
            }
            this.lostCreationTasks.remove(task);
        }
        super.awaitCompletion();
    }

    @Override
    public Map<String, StringWriter> createLostFile(String originalPath, Map<String, String> lostCode) {
        LostFileCreator fileCreator = new LostFileCreator(originalPath, lostCode);
        this.lostCreationTasks.add(this.lostCreatorsPool.submit(fileCreator));
        return null;
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags) throws IOException {
        return this.createWriterFor(file, previous, appendMode, hasJMergeTags, null);
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags, String charset) throws IOException {
        AcceleoFileWriter writer;
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FolderCreationError", file.getParentFile()));
        }
        if (file.isDirectory()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FileNameIsDirectory", file.getParentFile()));
        }
        boolean fileExisted = file.exists();
        if (!hasJMergeTags || appendMode) {
            if (charset != null) {
                if (Charset.isSupported(charset)) {
                    writer = new AcceleoFileWriter(file, appendMode, charset);
                } else {
                    String message = AcceleoEngineMessages.getString("AcceleoGenerationStrategy.UnsupportedCharset", charset);
                    AcceleoEnginePlugin.log(message, false);
                    writer = new AcceleoFileWriter(file, appendMode);
                }
            } else {
                writer = new AcceleoFileWriter(file, appendMode);
            }
            if (appendMode && fileExisted) {
                writer.append(LINE_SEPARATOR);
            }
        } else {
            writer = new AcceleoFileWriter(file.getPath());
        }
        return writer;
    }

    @Override
    public void dispose() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException interruptedException) {}
        this.lostCreationTasks.clear();
        super.dispose();
    }

    @Override
    public void flushWriter(String filePath, Writer writer) throws IOException {
        writer.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class LostFileCreator
    implements Callable<Object> {
        private final Map<String, String> lostAreas;
        private final String originalPath;

        LostFileCreator(String originalPath, Map<String, String> lostAreas) {
            this.originalPath = originalPath;
            this.lostAreas = lostAreas;
        }

        @Override
        public Object call() {
            block13: {
                StringBuilder lostContent = new StringBuilder();
                for (String lostAreaContent : this.lostAreas.values()) {
                    lostContent.append(lostAreaContent);
                    lostContent.append(LINE_SEPARATOR);
                }
                Writer writer = null;
                try {
                    try {
                        File lostFile = new File(this.originalPath.concat(".lost"));
                        writer = new BufferedWriter(new FileWriter(lostFile, true));
                        writer.append(LINE_SEPARATOR).append(Calendar.getInstance().getTime().toString()).append(LINE_SEPARATOR);
                        writer.append("================================================================================");
                        writer.append(LINE_SEPARATOR);
                        writer.append(lostContent);
                    }
                    catch (IOException iOException) {
                        String errorMessage = AcceleoEngineMessages.getString("AcceleoEvaluationContext.LostContent", this.originalPath, lostContent);
                        AcceleoEnginePlugin.log(errorMessage, false);
                        if (writer == null) break block13;
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            AcceleoEnginePlugin.log(e, false);
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            AcceleoEnginePlugin.log(e, false);
                        }
                    }
                }
            }
            return null;
        }
    }
}

