/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.Collection;
import java.util.List;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public class StringFunction
implements XPathFunction,
XPathFunctionWithContext {
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("string", null, new StringFunction(), 0, 1);
    private Context context;

    public Object evaluate(List args) {
        if (args == null || args.size() > 1) {
            throw new IllegalArgumentException();
        }
        Object arg = args.size() == 0 ? this.context.getContextNode() : args.get(0);
        return StringFunction.evaluate(arg);
    }

    public static String evaluate(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).toString();
        }
        if (object instanceof Double) {
            Double dbl = (Double)object;
            if (dbl.isNaN()) {
                return "NaN";
            }
            if (dbl.compareTo(new Double(0.0)) == 0 || dbl.compareTo(new Double(-0.0)) == 0) {
                return "0";
            }
            if (dbl == Double.POSITIVE_INFINITY) {
                return "Infinity";
            }
            if (dbl == Double.NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            if (dbl == Math.rint(dbl)) {
                return String.valueOf(dbl.longValue());
            }
            return dbl.toString();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.size() == 0) {
                return "";
            }
            return StringFunction.evaluate(collection.iterator().next());
        }
        INodeInspector inspector = InspectorManager.getInstance().getInspector(object);
        if (inspector != null) {
            return inspector.stringValueOf(object);
        }
        return object.toString();
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

