/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.taglib.java.Messages;
import org.eclipse.jet.taglib.AbstractFunctionTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JavaFormatTag
extends AbstractFunctionTag {
    public static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/javatag")) != false;

    public String doFunction(TagInfo td, JET2Context context, String bodyContent) throws JET2TagException {
        try {
            String snippetKindString = this.getAttribute("kind");
            String projectName = this.getAttribute("project");
            int snippetKind = this.getSnippetKind(snippetKindString, context);
            Map options = this.getJavaCoreOptions(projectName, context);
            String result = this.invokeJavaFormatterOn(bodyContent, options, snippetKind, context);
            return result;
        }
        catch (JET2TagException j2tex) {
            throw j2tex;
        }
        catch (Exception e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    private int getSnippetKind(String snippetKindString, JET2Context context) {
        if (DEBUG) {
            System.out.println("JavaFormatTag.getSnippetKind - value specified=" + snippetKindString);
        }
        if ("K_COMPILATION_UNIT".equals(snippetKindString)) {
            return 4104;
        }
        if ("K_CLASS_BODY_DECLARATIONS".equals(snippetKindString)) {
            return 4;
        }
        if ("K_EXPRESSION".equals(snippetKindString)) {
            return 1;
        }
        if ("K_STATEMENTS".equals(snippetKindString)) {
            return 2;
        }
        if (DEBUG) {
            System.out.println("JavaFormatTag.getSnippetKind - Falling back to K_UNKNOWN");
        }
        return 4096;
    }

    private Map getJavaCoreOptions(String projectName, JET2Context context) throws CoreException {
        IWorkspaceRoot wsroot;
        IProject project;
        if (DEBUG) {
            System.out.println("JavaFormatTag.getJavaCoreOptions - project specified=" + projectName);
        }
        Map options = null;
        if (projectName != null && (project = (wsroot = ResourcesPlugin.getWorkspace().getRoot()).getProject(projectName)).isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (DEBUG) {
                System.out.println("JavaFormatTag.getJavaCoreOptions - using Options from java project " + projectName);
            }
            options = javaProject.getOptions(true);
        }
        if (options == null) {
            if (DEBUG) {
                System.out.println("JavaFormatTag.getJavaCoreOptions - Falling back to generic JavaCore options");
            }
            options = JavaCore.getOptions();
        }
        return options;
    }

    private String invokeJavaFormatterOn(String bodyContent, Map options, int snippetKind, JET2Context context) throws MalformedTreeException, BadLocationException {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options, (int)ToolFactory.M_FORMAT_EXISTING);
        TextEdit textEdit = codeFormatter.format(snippetKind, bodyContent, 0, bodyContent.length(), 0, null);
        if (textEdit == null) {
            context.logError(Messages.JavaFormatTag_CouldNotFormat);
            return bodyContent;
        }
        Document document = new Document(bodyContent);
        textEdit.apply((IDocument)document);
        String result = document.get();
        return result;
    }
}

