/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;

public final class FileContent {
    private FileContent() {
    }

    public static StringBuffer getFileContent(File file) {
        String encoding;
        StringBuffer buffer = FileContent.getEncodedFileContent(file, null);
        if (file.getName() != null && file.getName().endsWith("mtl") && (encoding = FileContent.getEncoding(buffer)) != null) {
            buffer = FileContent.getEncodedFileContent(file, encoding);
        }
        return buffer;
    }

    private static StringBuffer getEncodedFileContent(File file, String encodingCode) {
        StringBuffer buffer = new StringBuffer();
        try {
            FileInputStream input = new FileInputStream(file);
            InputStreamReader reader = encodingCode != null ? new InputStreamReader((InputStream)input, encodingCode) : new InputStreamReader(input);
            try {
                int size = 0;
                char[] buff = new char[512];
                while ((size = reader.read(buff)) >= 0) {
                    buffer.append(buff, 0, size);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return buffer;
    }

    public static String getEncoding(StringBuffer buffer) {
        Sequence bSequence = new Sequence("[", "comment", "encoding", "=");
        Region b = bSequence.search(buffer);
        if (b.e() != -1) {
            int bEncoding = b.e();
            while (bEncoding < buffer.length() && Character.isWhitespace(buffer.charAt(bEncoding))) {
                ++bEncoding;
            }
            if (bEncoding < buffer.length() && (buffer.charAt(bEncoding) == '-' || Character.isJavaIdentifierStart(buffer.charAt(bEncoding)))) {
                int eEncoding = bEncoding + 1;
                while (eEncoding < buffer.length() && (buffer.charAt(eEncoding) == '-' || Character.isJavaIdentifierPart(buffer.charAt(eEncoding)))) {
                    ++eEncoding;
                }
                return buffer.substring(bEncoding, eEncoding).trim();
            }
        }
        return null;
    }

    public static int columnNumber(StringBuffer buffer, int index) {
        if (buffer != null && index < buffer.length()) {
            int column = 1;
            int i = index - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\n') break;
                ++column;
                --i;
            }
            return column;
        }
        return 0;
    }

    public static int lineNumber(StringBuffer buffer, int index) {
        if (buffer != null && index < buffer.length()) {
            int line = 1;
            int i = index - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\n') {
                    ++line;
                }
                --i;
            }
            return line;
        }
        return 0;
    }
}

