/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.IAcceleoParserProblemsConstants;
import org.eclipse.acceleo.internal.parser.ast.CST2ASTConverter;
import org.eclipse.acceleo.internal.parser.cst.utils.ParserUtils;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.TemplateExpression;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CST2ASTConverterWithResolver
extends CST2ASTConverter {
    private static final String UNAVAILABLE_CLAUSE_KEY = "CST2ASTConverterWithResolver.UnavailableClause";
    private int resolveBeginPosition = -1;
    private int resolveEndPosition = -1;

    public void resolveAST(org.eclipse.acceleo.parser.cst.Module rootCST) {
        this.resolveAST(rootCST, -1, -1);
    }

    public synchronized void resolveAST(org.eclipse.acceleo.parser.cst.Module rootCST, int beginPosition, int endPosition) {
        if (rootCST != null) {
            this.resolveBeginPosition = beginPosition;
            this.resolveEndPosition = endPosition;
            this.transformStepResolve(rootCST);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void transformStepResolve(org.eclipse.acceleo.parser.cst.Module iModule) {
        oModule = this.factory.getOrCreateModule(iModule);
        if (iModule != null && oModule != null && this.factory.getOCL() != null) {
            for (org.eclipse.acceleo.parser.cst.TypedModel iNext : iModule.getInput()) {
                this.transformStepResolveAddEPackage(iNext);
            }
            try {
                for (ModuleImportsValue ioNext : iModule.getImports()) {
                    oImportedModule = this.getModule(oModule.eResource(), ioNext.getName());
                    if (oImportedModule == null) {
                        this.log(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.MissingModule", new Object[]{ioNext.getName()}), ioNext.getStartPosition(), ioNext.getEndPosition());
                        continue;
                    }
                    oModule.getImports().add((Object)oImportedModule);
                }
                for (ModuleExtendsValue ioNext : iModule.getExtends()) {
                    oExtendedModule = this.getModule(oModule.eResource(), ioNext.getName());
                    if (oExtendedModule == null) {
                        this.log(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.MissingModule", new Object[]{ioNext.getName()}), ioNext.getStartPosition(), ioNext.getEndPosition());
                        continue;
                    }
                    oModule.getExtends().add((Object)oExtendedModule);
                    if (!this.isRecursiveExtends(oModule, oExtendedModule)) continue;
                    this.log(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.RecursiveModuleExtends", new Object[]{oModule.getName(), oExtendedModule.getName()}), ioNext.getStartPosition(), ioNext.getEndPosition());
                }
                this.factory.getOCL().addRecursivelyBehavioralFeaturesToScope(oModule);
                try {
                    this.transformStepResolveOwnedModuleElement(iModule);
                }
                catch (Throwable var6_7) {
                    this.factory.getOCL().removeRecursivelyBehavioralFeaturesToScope(oModule);
                    throw var6_7;
                }
                this.factory.getOCL().removeRecursivelyBehavioralFeaturesToScope(oModule);
            }
            finally {
                ** for (iNext : iModule.getInput())
            }
lbl-1000:
            // 1 sources

            {
                this.transformStepResolveRemoveEPackage(iNext);
                continue;
            }
        }
lbl38:
        // 3 sources

    }

    private boolean isRecursiveExtends(Module module, Module extendedModule) {
        boolean res = false;
        if (module != null && extendedModule != null) {
            if (module == extendedModule) {
                res = true;
            } else {
                for (Module extended : extendedModule.getExtends()) {
                    if (!this.isRecursiveExtends(module, extended)) continue;
                    res = true;
                    break;
                }
            }
        }
        return res;
    }

    private Module getModule(Resource oResource, String fullModuleName) {
        if (oResource != null && fullModuleName != null) {
            for (Resource otherResource : oResource.getResourceSet().getResources()) {
                Module otherModule;
                if (otherResource.getContents().size() <= 0 || !(otherResource.getContents().get(0) instanceof Module) || !fullModuleName.equals((otherModule = (Module)otherResource.getContents().get(0)).getNsURI()) && !fullModuleName.equals(otherModule.getName())) continue;
                return otherModule;
            }
        }
        return null;
    }

    private Module getModule(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof Module) {
                return (Module)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    private void transformStepResolveAddEPackage(org.eclipse.acceleo.parser.cst.TypedModel iTypedModel) {
        TypedModel oTypedModel = this.factory.getOrCreateTypedModel(iTypedModel);
        if (oTypedModel != null) {
            for (EPackage oNext : oTypedModel.getTakesTypesFrom()) {
                this.factory.getOCL().addMetamodel(oNext);
            }
        }
    }

    private void transformStepResolveRemoveEPackage(org.eclipse.acceleo.parser.cst.TypedModel iTypedModel) {
        TypedModel oTypedModel = this.factory.getOrCreateTypedModel(iTypedModel);
        if (oTypedModel != null) {
            for (EPackage oNext : oTypedModel.getTakesTypesFrom()) {
                this.factory.getOCL().removeMetamodel(oNext);
            }
        }
    }

    private void transformStepResolve(Template iTemplate) {
        org.eclipse.acceleo.model.mtl.Template oTemplate = this.factory.getOrCreateTemplate(iTemplate);
        if (iTemplate != null && oTemplate != null) {
            ArrayList<EClassifier> paramTypes = new ArrayList<EClassifier>();
            Iterator iParameterIt = iTemplate.getParameter().iterator();
            Variable oFirst = null;
            while (iParameterIt.hasNext()) {
                org.eclipse.acceleo.parser.cst.Variable iNext = (org.eclipse.acceleo.parser.cst.Variable)iParameterIt.next();
                if (iNext == null) continue;
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oFirst == null) {
                    oFirst = oNext;
                }
                this.transformStepResolveAddVariable(iNext);
                paramTypes.add((EClassifier)oNext.getType());
            }
            for (TemplateOverridesValue ioNext : iTemplate.getOverrides()) {
                List<org.eclipse.acceleo.model.mtl.Template> oOverrides = this.getExtendedTemplatesNamed(this.getModule((EObject)oTemplate), ioNext.getName(), paramTypes);
                if (oOverrides.size() == 0) {
                    this.log(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.MissingTemplate", ioNext.getName()), ioNext.getStartPosition(), ioNext.getEndPosition());
                    continue;
                }
                oTemplate.getOverrides().addAll(oOverrides);
            }
            if (oFirst != null && oFirst.getType() != null) {
                this.factory.getOCL().pushContext((EClassifier)oFirst.getType());
            }
            try {
                ModelExpression iGuard = iTemplate.getGuard();
                org.eclipse.ocl.ecore.OCLExpression oGuard = this.factory.getOrCreateOCLExpression(iGuard);
                if (oGuard != null) {
                    oTemplate.setGuard(oGuard);
                }
                this.transformStepResolve(iGuard);
                this.factory.getOCL().pushContext(this.getOCL().getStringType());
                try {
                    ModelExpression iPost = iTemplate.getPost();
                    org.eclipse.ocl.ecore.OCLExpression oPost = this.factory.getOrCreateOCLExpression(iPost);
                    if (oPost != null) {
                        oTemplate.setPost(oPost);
                    }
                    this.transformStepResolve(iPost);
                }
                finally {
                    this.factory.getOCL().popContext();
                }
                InitSection iInit = iTemplate.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iTemplate);
                this.transformStepResolveRemoveVariables(iInit);
                for (org.eclipse.acceleo.parser.cst.Variable iNext : iTemplate.getParameter()) {
                    this.transformStepResolveRemoveVariable(iNext);
                }
            }
            finally {
                if (oFirst != null && oFirst.getType() != null) {
                    this.factory.getOCL().popContext();
                }
            }
        }
    }

    private List<org.eclipse.acceleo.model.mtl.Template> getExtendedTemplatesNamed(Module oModule, String name, List<EClassifier> paramTypes) {
        ArrayList<org.eclipse.acceleo.model.mtl.Template> result = new ArrayList<org.eclipse.acceleo.model.mtl.Template>();
        if (oModule != null) {
            result.addAll(this.getProtectedTemplatesNamed(oModule, name, paramTypes));
            ArrayList<Module> allExtends = new ArrayList<Module>();
            this.computeAllExtends(allExtends, oModule);
            for (Module oOtherModule : allExtends) {
                result.addAll(this.getProtectedTemplatesNamed(oOtherModule, name, paramTypes));
            }
        }
        return result;
    }

    private List<org.eclipse.acceleo.model.mtl.Template> getProtectedTemplatesNamed(Module oModule, String name, List<EClassifier> paramTypes) {
        ArrayList<org.eclipse.acceleo.model.mtl.Template> result = new ArrayList<org.eclipse.acceleo.model.mtl.Template>();
        TreeIterator itObjects = oModule.eAllContents();
        while (itObjects.hasNext()) {
            org.eclipse.acceleo.model.mtl.Template otherTemplate;
            EObject eObject = (EObject)itObjects.next();
            if (!(eObject instanceof org.eclipse.acceleo.model.mtl.Template) || !name.equals((otherTemplate = (org.eclipse.acceleo.model.mtl.Template)eObject).getName()) || paramTypes.size() != otherTemplate.getParameter().size() || otherTemplate.getVisibility().getValue() < 1) continue;
            boolean parameterMatches = true;
            Iterator<EClassifier> itTypes = paramTypes.iterator();
            Iterator itParameters = otherTemplate.getParameter().iterator();
            while (parameterMatches && itParameters.hasNext()) {
                EClassifier eParameterType = (EClassifier)((Variable)itParameters.next()).getType();
                EClassifier type = itTypes.next();
                if (eParameterType instanceof EClass && type instanceof EClass) {
                    parameterMatches = eParameterType == type || this.isSubTypeOf((EClass)eParameterType, (EClass)type);
                    continue;
                }
                boolean bl = parameterMatches = eParameterType == type || eParameterType != null && eParameterType.equals(type);
            }
            if (!parameterMatches) continue;
            result.add(otherTemplate);
        }
        return result;
    }

    private void computeAllExtends(List<Module> allExtends, Module oModule) {
        ArrayList<Module> toBrowse = new ArrayList<Module>();
        for (Module oOtherModule : oModule.getExtends()) {
            if (allExtends.contains(oOtherModule)) continue;
            allExtends.add(oOtherModule);
            toBrowse.add(oOtherModule);
        }
        for (Module oOtherModule : toBrowse) {
            this.computeAllExtends(allExtends, oOtherModule);
        }
    }

    private void transformStepResolveAddVariable(org.eclipse.acceleo.parser.cst.Variable iVariable) {
        Variable oVariable = this.factory.getOrCreateVariable(iVariable);
        if (iVariable != null && oVariable != null) {
            ModelExpression iInitExpression = iVariable.getInitExpression();
            org.eclipse.ocl.ecore.OCLExpression oInitExpression = this.factory.getOrCreateOCLExpression(iInitExpression);
            if (oInitExpression != null) {
                oVariable.setInitExpression((OCLExpression)oInitExpression);
            }
            this.transformStepResolve(iInitExpression);
            this.factory.getOCL().addVariableToScope(oVariable);
            if (!ParserUtils.isIdentifier(iVariable.getName())) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + iVariable.getName(), iVariable.getStartPosition(), iVariable.getEndPosition());
            }
            if (oVariable.getType() == null || oVariable.getType() == this.factory.getOCL().getInvalidType()) {
                EClassifier eClassifier = this.factory.getOCL().lookupClassifier(iVariable.getType());
                if (eClassifier != null) {
                    oVariable.setType((Object)eClassifier);
                } else {
                    this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TYPE_NOT_VALID) + iVariable.getType(), iVariable.getStartPosition(), iVariable.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolveRemoveVariable(org.eclipse.acceleo.parser.cst.Variable iVariable) {
        Variable oVariable = this.factory.getOrCreateVariable(iVariable);
        if (iVariable != null && oVariable != null) {
            this.factory.getOCL().removeVariableFromScope(oVariable);
        }
    }

    private synchronized void transformStepResolve(ModelExpression iModelExpression) {
        if (!this.isValidRegion(iModelExpression)) {
            return;
        }
        org.eclipse.ocl.ecore.OCLExpression oOCLExpression = this.factory.getOrCreateOCLExpression(iModelExpression);
        if (iModelExpression != null && oOCLExpression != null) {
            ModelExpression iAfter;
            ModelExpression iEach;
            ModelExpression iBefore;
            TemplateExpression oTemplateExpression;
            if (oOCLExpression.eContainer() == null && (oTemplateExpression = this.factory.getTemporaryTemplateExpression(iModelExpression)) != null) {
                EcoreUtil.replace((EObject)oTemplateExpression, (EObject)oOCLExpression);
            }
            if (oOCLExpression instanceof TemplateInvocation) {
                TemplateInvocation oTemplateInvocation = (TemplateInvocation)oOCLExpression;
                this.transformStepResolveSuperTemplateInvocation(iModelExpression, oTemplateInvocation);
            }
            if ((iBefore = iModelExpression.getBefore()) != null) {
                if (oOCLExpression instanceof TemplateInvocation) {
                    org.eclipse.ocl.ecore.OCLExpression oBefore = this.factory.getOrCreateOCLExpression(iBefore);
                    ((TemplateInvocation)oOCLExpression).setBefore(oBefore);
                    this.transformStepResolve(iBefore);
                } else {
                    this.log(AcceleoParserMessages.getString(UNAVAILABLE_CLAUSE_KEY, "before"), iBefore.getStartPosition(), iBefore.getEndPosition());
                }
            }
            if ((iEach = iModelExpression.getEach()) != null) {
                if (oOCLExpression instanceof TemplateInvocation) {
                    org.eclipse.ocl.ecore.OCLExpression oEach = this.factory.getOrCreateOCLExpression(iEach);
                    ((TemplateInvocation)oOCLExpression).setEach(oEach);
                    this.transformStepResolve(iEach);
                } else {
                    this.log(AcceleoParserMessages.getString(UNAVAILABLE_CLAUSE_KEY, "separator"), iEach.getStartPosition(), iEach.getEndPosition());
                }
            }
            if ((iAfter = iModelExpression.getAfter()) != null) {
                if (oOCLExpression instanceof TemplateInvocation) {
                    org.eclipse.ocl.ecore.OCLExpression oAfter = this.factory.getOrCreateOCLExpression(iAfter);
                    ((TemplateInvocation)oOCLExpression).setAfter(oAfter);
                    this.transformStepResolve(iAfter);
                } else {
                    this.log(AcceleoParserMessages.getString(UNAVAILABLE_CLAUSE_KEY, "after"), iAfter.getStartPosition(), iAfter.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolveSuperTemplateInvocation(ModelExpression iModelExpression, TemplateInvocation oTemplateInvocation) {
        if (oTemplateInvocation.isSuper() && oTemplateInvocation.getDefinition() == null) {
            org.eclipse.acceleo.model.mtl.Template oTemplate = this.getTemplate((EObject)oTemplateInvocation);
            if (oTemplate != null && oTemplate.getOverrides().size() == 0) {
                this.log(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.InvalidClause", "super", "overrides"), iModelExpression.getStartPosition(), iModelExpression.getEndPosition());
            } else {
                oTemplateInvocation.setDefinition(oTemplate);
            }
        }
    }

    private org.eclipse.acceleo.model.mtl.Template getTemplate(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof org.eclipse.acceleo.model.mtl.Template) {
                return (org.eclipse.acceleo.model.mtl.Template)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    private void transformStepResolve(TextExpression iTextExpression) {
    }

    private void transformStepResolve(Block iBlock) {
        org.eclipse.acceleo.model.mtl.Block oBlock = this.factory.getOrCreateBlock(iBlock);
        if (iBlock != null && oBlock != null) {
            InitSection iInit = iBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolveAddVariables(InitSection iInitSection) {
        org.eclipse.acceleo.model.mtl.InitSection oInitSection = this.factory.getOrCreateInitSection(iInitSection);
        if (iInitSection != null && oInitSection != null) {
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iInitSection.getVariable()) {
                this.transformStepResolveAddVariable(iNext);
            }
        }
    }

    private void transformStepResolveRemoveVariables(InitSection iInitSection) {
        org.eclipse.acceleo.model.mtl.InitSection oInitSection = this.factory.getOrCreateInitSection(iInitSection);
        if (iInitSection != null && oInitSection != null) {
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iInitSection.getVariable()) {
                this.transformStepResolveRemoveVariable(iNext);
            }
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.ProtectedAreaBlock iProtectedAreaBlock) {
        ProtectedAreaBlock oProtectedAreaBlock = this.factory.getOrCreateProtectedAreaBlock(iProtectedAreaBlock);
        if (iProtectedAreaBlock != null && oProtectedAreaBlock != null) {
            ModelExpression iMarker = iProtectedAreaBlock.getMarker();
            org.eclipse.ocl.ecore.OCLExpression oMarker = this.factory.getOrCreateOCLExpression(iMarker);
            if (oMarker != null) {
                oProtectedAreaBlock.setMarker(oMarker);
            }
            this.transformStepResolve(iMarker);
            InitSection iInit = iProtectedAreaBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iProtectedAreaBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.ForBlock iForBlock) {
        ForBlock oForBlock = this.factory.getOrCreateForBlock(iForBlock);
        if (iForBlock != null && oForBlock != null) {
            ModelExpression iIterSet = iForBlock.getIterSet();
            org.eclipse.ocl.ecore.OCLExpression oIterSet = this.factory.getOrCreateOCLExpression(iIterSet);
            if (oIterSet != null) {
                oForBlock.setIterSet(oIterSet);
            }
            this.transformStepResolve(iIterSet);
            ModelExpression iBefore = iForBlock.getBefore();
            org.eclipse.ocl.ecore.OCLExpression oBefore = this.factory.getOrCreateOCLExpression(iBefore);
            if (oBefore != null) {
                oForBlock.setBefore(oBefore);
            }
            this.transformStepResolve(iBefore);
            ModelExpression iEach = iForBlock.getEach();
            org.eclipse.ocl.ecore.OCLExpression oEach = this.factory.getOrCreateOCLExpression(iEach);
            if (oEach != null) {
                oForBlock.setEach(oEach);
            }
            this.transformStepResolve(iEach);
            ModelExpression iAfter = iForBlock.getAfter();
            org.eclipse.ocl.ecore.OCLExpression oAfter = this.factory.getOrCreateOCLExpression(iAfter);
            if (oAfter != null) {
                oForBlock.setAfter(oAfter);
            }
            this.transformStepResolve(iAfter);
            org.eclipse.acceleo.parser.cst.Variable iLoopVariable = iForBlock.getLoopVariable();
            Variable oLoopVariable = iLoopVariable != null ? this.factory.getOrCreateVariable(iLoopVariable) : null;
            EClassifier context = null;
            if (iLoopVariable != null && oLoopVariable != null) {
                this.transformStepResolveAddVariable(iLoopVariable);
                context = (EClassifier)oLoopVariable.getType();
            } else if (oIterSet != null && (context = oIterSet.getEType()) instanceof CollectionType) {
                context = (EClassifier)((CollectionType)context).getElementType();
            }
            if (context != null) {
                this.factory.getOCL().pushContext(context);
            }
            Variable iterationCount = EcoreFactory.eINSTANCE.createVariable();
            iterationCount.setName("i");
            iterationCount.setType((Object)this.factory.getOCL().getIntegerType());
            this.factory.getOCL().addVariableToScope(iterationCount);
            try {
                ModelExpression iGuard = iForBlock.getGuard();
                org.eclipse.ocl.ecore.OCLExpression oGuard = this.factory.getOrCreateOCLExpression(iGuard);
                if (oGuard != null) {
                    oForBlock.setGuard(oGuard);
                }
                this.transformStepResolve(iGuard);
                InitSection iInit = iForBlock.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iForBlock);
                this.transformStepResolveRemoveVariables(iInit);
            }
            finally {
                if (iLoopVariable != null && oLoopVariable != null) {
                    this.transformStepResolveRemoveVariable(iLoopVariable);
                }
                if (context != null) {
                    this.factory.getOCL().popContext();
                }
                this.factory.getOCL().removeVariableFromScope(iterationCount);
            }
        }
    }

    private void transformStepResolve(IfBlock iIfBlock) {
        org.eclipse.acceleo.model.mtl.IfBlock oIfBlock = this.factory.getOrCreateIfBlock(iIfBlock);
        if (iIfBlock != null && oIfBlock != null) {
            ModelExpression iIfExpr = iIfBlock.getIfExpr();
            org.eclipse.ocl.ecore.OCLExpression oIfExpr = this.factory.getOrCreateOCLExpression(iIfExpr);
            if (oIfExpr != null) {
                oIfBlock.setIfExpr(oIfExpr);
            }
            this.transformStepResolve(iIfExpr);
            InitSection iInit = iIfBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iIfBlock);
            this.transformStepResolveRemoveVariables(iInit);
            for (IfBlock iNext : iIfBlock.getElseIf()) {
                this.transformStepResolve(iNext);
            }
            Block iElse = iIfBlock.getElse();
            if (iElse instanceof Template) {
                this.transformStepResolve((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                this.transformStepResolve((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                this.transformStepResolve((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                this.transformStepResolve((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                this.transformStepResolve(iElse);
            }
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.LetBlock iLetBlock) {
        LetBlock oLetBlock = this.factory.getOrCreateLetBlock(iLetBlock);
        if (iLetBlock != null && oLetBlock != null) {
            org.eclipse.acceleo.parser.cst.Variable iLetVariable = iLetBlock.getLetVariable();
            Variable oLetVariable = iLetVariable != null ? this.factory.getOrCreateVariable(iLetVariable) : null;
            OCLExpression saveInitExpression = null;
            if (iLetVariable != null && oLetVariable != null) {
                this.transformStepResolveAddVariable(iLetVariable);
                saveInitExpression = oLetVariable.getInitExpression();
                if (saveInitExpression != null) {
                    oLetVariable.setInitExpression(null);
                }
                this.factory.getOCL().pushContext((EClassifier)oLetVariable.getType());
            }
            try {
                InitSection iInit = iLetBlock.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iLetBlock);
                this.transformStepResolveRemoveVariables(iInit);
            }
            finally {
                if (iLetVariable != null && oLetVariable != null) {
                    this.transformStepResolveRemoveVariable(iLetVariable);
                    if (saveInitExpression != null) {
                        oLetVariable.setInitExpression(saveInitExpression);
                    }
                    this.factory.getOCL().popContext();
                }
            }
            Block iElse = iLetBlock.getElse();
            if (iElse instanceof Template) {
                this.transformStepResolve((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                this.transformStepResolve((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                this.transformStepResolve((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                this.transformStepResolve((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                this.transformStepResolve(iElse);
            }
            for (org.eclipse.acceleo.parser.cst.LetBlock iNext : iLetBlock.getElseLet()) {
                this.transformStepResolve(iNext);
            }
        }
    }

    private void transformStepResolve(FileBlock iFileBlock) {
        org.eclipse.acceleo.model.mtl.FileBlock oFileBlock = this.factory.getOrCreateFileBlock(iFileBlock);
        if (iFileBlock != null && oFileBlock != null) {
            ModelExpression iFileUrl = iFileBlock.getFileUrl();
            org.eclipse.ocl.ecore.OCLExpression oFileUrl = this.factory.getOrCreateOCLExpression(iFileUrl);
            if (oFileUrl != null) {
                oFileBlock.setFileUrl(oFileUrl);
                if (oFileUrl.getEType() != null && !oFileUrl.getEType().equals(this.getOCL().getStringType())) {
                    this.log(AcceleoParserMessages.getString("IAcceleoParserProblemsConstants.InvalidUrlType", oFileUrl.getEType().getName()), oFileUrl.getStartPosition(), oFileUrl.getEndPosition());
                }
            }
            this.transformStepResolve(iFileUrl);
            ModelExpression iFileCharset = iFileBlock.getCharset();
            org.eclipse.ocl.ecore.OCLExpression oFileCharset = this.factory.getOrCreateOCLExpression(iFileCharset);
            if (oFileCharset != null) {
                oFileBlock.setCharset(oFileCharset);
            }
            this.transformStepResolve(iFileCharset);
            InitSection iInit = iFileBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iFileBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolve(TraceBlock iTraceBlock) {
        org.eclipse.acceleo.model.mtl.TraceBlock oTraceBlock = this.factory.getOrCreateTraceBlock(iTraceBlock);
        if (iTraceBlock != null && oTraceBlock != null) {
            ModelExpression iModelElement = iTraceBlock.getModelElement();
            org.eclipse.ocl.ecore.OCLExpression oModelElement = this.factory.getOrCreateOCLExpression(iModelElement);
            if (oModelElement != null) {
                oTraceBlock.setModelElement(oModelElement);
            }
            this.transformStepResolve(iModelElement);
            InitSection iInit = iTraceBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iTraceBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.Macro iMacro) {
        Macro oMacro = this.factory.getOrCreateMacro(iMacro);
        if (iMacro != null && oMacro != null) {
            Iterator iParameterIt = iMacro.getParameter().iterator();
            Variable oFirst = null;
            while (iParameterIt.hasNext()) {
                org.eclipse.acceleo.parser.cst.Variable iNext = (org.eclipse.acceleo.parser.cst.Variable)iParameterIt.next();
                if (oFirst == null && iNext != null) {
                    oFirst = this.factory.getOrCreateVariable(iNext);
                }
                this.transformStepResolveAddVariable(iNext);
            }
            if (oFirst != null && oFirst.getType() != null) {
                this.factory.getOCL().pushContext((EClassifier)oFirst.getType());
            }
            try {
                InitSection iInit = iMacro.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iMacro);
                for (org.eclipse.acceleo.parser.cst.Variable iNext : iMacro.getParameter()) {
                    this.transformStepResolveRemoveVariable(iNext);
                }
                this.transformStepResolveRemoveVariables(iInit);
            }
            finally {
                if (oFirst != null && oFirst.getType() != null) {
                    this.factory.getOCL().popContext();
                }
            }
            if (oMacro.getType() == null || oMacro.getType() == this.factory.getOCL().getInvalidType()) {
                EClassifier eClassifier = this.factory.getOCL().lookupClassifier(iMacro.getType());
                if (eClassifier != null) {
                    oMacro.setType(eClassifier);
                } else {
                    this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TYPE_NOT_VALID) + iMacro.getType(), iMacro.getStartPosition(), iMacro.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.Query iQuery) {
        Query oQuery = this.factory.getOrCreateQuery(iQuery);
        if (iQuery != null && oQuery != null) {
            Iterator iParameterIt = iQuery.getParameter().iterator();
            Variable oFirst = null;
            while (iParameterIt.hasNext()) {
                org.eclipse.acceleo.parser.cst.Variable iNext = (org.eclipse.acceleo.parser.cst.Variable)iParameterIt.next();
                if (oFirst == null && iNext != null) {
                    oFirst = this.factory.getOrCreateVariable(iNext);
                }
                this.transformStepResolveAddVariable(iNext);
            }
            if (oFirst != null && oFirst.getType() != null) {
                this.factory.getOCL().pushContext((EClassifier)oFirst.getType());
            }
            try {
                ModelExpression iExpression = iQuery.getExpression();
                org.eclipse.ocl.ecore.OCLExpression oExpression = this.factory.getOrCreateOCLExpression(iExpression);
                if (oExpression != null) {
                    oQuery.setExpression(oExpression);
                }
                this.transformStepResolve(iExpression);
                for (org.eclipse.acceleo.parser.cst.Variable iNext : iQuery.getParameter()) {
                    this.transformStepResolveRemoveVariable(iNext);
                }
            }
            finally {
                if (oFirst != null && oFirst.getType() != null) {
                    this.factory.getOCL().popContext();
                }
            }
            if (oQuery.getType() == null || oQuery.getType() == this.factory.getOCL().getInvalidType()) {
                EClassifier eClassifier = this.factory.getOCL().lookupClassifier(iQuery.getType());
                if (eClassifier != null) {
                    oQuery.setType(eClassifier);
                } else {
                    this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TYPE_NOT_VALID) + iQuery.getType(), iQuery.getStartPosition(), iQuery.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolveOwnedModuleElement(org.eclipse.acceleo.parser.cst.Module iModule) {
        if (!this.isCanceled) {
            for (ModuleElement iNext : iModule.getOwnedModuleElement()) {
                if (!this.isValidRegion(iNext)) continue;
                if (iNext instanceof Template) {
                    this.transformStepResolve((Template)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (!(iNext instanceof org.eclipse.acceleo.parser.cst.Query)) continue;
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.Query)iNext);
            }
        }
    }

    private void transformStepResolveBody(Block iBlock) {
        if (!this.isCanceled) {
            for (org.eclipse.acceleo.parser.cst.TemplateExpression iNext : iBlock.getBody()) {
                if (!this.isValidRegion(iNext)) continue;
                if (iNext instanceof Template) {
                    this.transformStepResolve((Template)iNext);
                    continue;
                }
                if (iNext instanceof ModelExpression) {
                    this.transformStepResolve((ModelExpression)iNext);
                    continue;
                }
                if (iNext instanceof TextExpression) {
                    this.transformStepResolve((TextExpression)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.ForBlock)iNext);
                    continue;
                }
                if (iNext instanceof IfBlock) {
                    this.transformStepResolve((IfBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.LetBlock)iNext);
                    continue;
                }
                if (iNext instanceof FileBlock) {
                    this.transformStepResolve((FileBlock)iNext);
                    continue;
                }
                if (iNext instanceof TraceBlock) {
                    this.transformStepResolve((TraceBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (iNext instanceof Block) {
                    this.transformStepResolve((Block)iNext);
                    continue;
                }
                if (iNext instanceof Comment) continue;
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID) + ' ' + iNext.getClass().getName(), iNext.getStartPosition(), iNext.getEndPosition());
            }
        }
    }

    private boolean isValidRegion(CSTNode iNext) {
        if (iNext != null) {
            return !(this.resolveBeginPosition != -1 && this.resolveBeginPosition < iNext.getStartPosition() || this.resolveEndPosition != -1 && this.resolveEndPosition > iNext.getEndPosition());
        }
        return false;
    }

    private boolean isSubTypeOf(EClass superType, EClass eClass) {
        for (EClass candidate : eClass.getEAllSuperTypes()) {
            if (candidate != superType) continue;
            return true;
        }
        return false;
    }
}

