/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.gmf.codegen.gmfgen.GenPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenPropertyTabFilter;
import org.eclipse.gmf.codegen.gmfgen.GenStandardPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GeneratedType;
import org.eclipse.gmf.codegen.gmfgen.TypeTabFilter;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.runtime.notation.View;

public class PropertySheetHandler {
    protected static final String APPEARANCE = "appearance";
    protected static final String DIAGRAM = "diagram";
    protected static final String ADVANCED = "advanced";
    protected static final String DOMAIN = "domain";
    private GenPropertySheet myPropertySheet;

    public void initialize(GenPropertySheet propertySheet) {
        assert (propertySheet != null);
        this.myPropertySheet = propertySheet;
    }

    public void process(CanvasMapping canvas) {
        this.addStandardTabs();
        this.addCustomTabs(canvas);
    }

    protected void addStandardTabs() {
        GenStandardPropertyTab t1 = GMFGenFactory.eINSTANCE.createGenStandardPropertyTab();
        t1.setID(APPEARANCE);
        this.addTab((GenPropertyTab)t1);
        t1 = GMFGenFactory.eINSTANCE.createGenStandardPropertyTab();
        t1.setID(DIAGRAM);
        this.addTab((GenPropertyTab)t1);
    }

    protected void addCustomTabs(CanvasMapping canvas) {
        if (!PropertySheetHandler.hasDomainModel(canvas)) {
            return;
        }
        GenCustomPropertyTab t1 = GMFGenFactory.eINSTANCE.createGenCustomPropertyTab();
        t1.setID(DOMAIN);
        t1.setLabel("Core");
        TypeTabFilter f = GMFGenFactory.eINSTANCE.createTypeTabFilter();
        f.getTypes().add((Object)View.class.getName());
        f.getTypes().add((Object)"org.eclipse.gef.EditPart");
        if (this.myPropertySheet.getEditorGen().getNavigator() != null) {
            f.getGeneratedTypes().add((Object)GeneratedType.ABSTRACT_NAVIGATOR_ITEM_LITERAL);
        }
        t1.setFilter((GenPropertyTabFilter)f);
        this.addTab((GenPropertyTab)t1);
    }

    private void addTab(GenPropertyTab tab) {
        this.myPropertySheet.getTabs().add((Object)tab);
    }

    private static boolean hasDomainModel(CanvasMapping canvas) {
        return canvas.getDomainModel() != null;
    }
}

