/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DiagramUtil {
    public static void openDiagramEditor(Diagram diagram) {
        EditorService.getInstance().openEditor((IEditorInput)new DiagramEditorInput(diagram));
    }

    public static IDiagramWorkbenchPart getOpenedDiagramEditor(Diagram diagram, IWorkbenchWindow window) {
        if (diagram == null) {
            throw new NullPointerException("Argument 'diagram' is null");
        }
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        List editors = EditorService.getInstance().getRegisteredEditorParts();
        Iterator j = editors.iterator();
        while (j.hasNext()) {
            IDiagramWorkbenchPart de;
            IEditorPart editor = (IEditorPart)j.next();
            if (editor.getEditorSite().getWorkbenchWindow() != window || !(editor instanceof IDiagramWorkbenchPart) || (de = (IDiagramWorkbenchPart)editor).getDiagram() != diagram) continue;
            return de;
        }
        return null;
    }
}

