/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.gmf.internal.common.codegen.GeneratorBaseMessages;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class GeneratorBase
implements Runnable {
    private JControlModel myJControlModel;
    private CodeFormatter myCodeFormatter;
    private IProgressMonitor myProgress = new NullProgressMonitor();
    private IPackageFragmentRoot myDestRoot;
    private IProject myDestProject;
    private final List myExceptions;
    private IStatus myRunStatus = Status.CANCEL_STATUS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.common.codegen.GeneratorBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected abstract URL getJMergeControlFile();

    protected abstract void customRun() throws InterruptedException, UnexpectedBehaviourException;

    protected abstract void setupProgressMonitor();

    public GeneratorBase() {
        this.myExceptions = new LinkedList();
    }

    public void run(IProgressMonitor progress) throws InterruptedException {
        this.setProgressMonitor(progress);
        this.doRun();
    }

    public void run() {
        this.clearExceptionsList();
        try {
            this.doRun();
        }
        catch (InterruptedException ex) {
            this.myRunStatus = new Status(8, "org.eclipse.gmf.common", 0, GeneratorBaseMessages.interrupted, (Throwable)ex);
        }
    }

    public IStatus getRunStatus() {
        return this.myRunStatus;
    }

    public void setProgressMonitor(IProgressMonitor progress) {
        this.myProgress = progress;
    }

    protected final void handleException(CoreException ex) {
        this.handleException(ex.getStatus());
    }

    protected final void handleException(IStatus status) {
        this.myExceptions.add(status);
    }

    protected final void handleException(Throwable ex) {
        this.handleException(GeneratorBase.newStatus(ex));
    }

    protected void handleUnexpected(UnexpectedBehaviourException ex) {
        this.handleException(ex);
    }

    protected static IStatus newStatus(Throwable ex) {
        return GeneratorBase.newStatus(4, ex);
    }

    protected static IStatus newStatus(int severity, Throwable ex) {
        return new Status(severity, "org.eclipse.gmf.common", 0, ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), ex);
    }

    protected final IProject getDestProject() {
        return this.myDestProject;
    }

    protected final IProgressMonitor getProgress() {
        return this.myProgress;
    }

    protected final void setupProgressMonitor(String task, int total) {
        if (this.myProgress == null) {
            this.myProgress = new NullProgressMonitor();
            return;
        }
        this.myProgress.beginTask(task, total);
    }

    protected final IProgressMonitor getNextStepMonitor() throws InterruptedException {
        if (this.myProgress.isCanceled()) {
            throw new InterruptedException();
        }
        return new SubProgressMonitor(this.myProgress, 1);
    }

    protected final void initializeEditorProject(String pluginId, IPath projectLocation) throws UnexpectedBehaviourException, InterruptedException {
        this.initializeEditorProject(pluginId, projectLocation, Collections.EMPTY_LIST);
    }

    protected final void initializeEditorProject(String pluginId, IPath projectLocation, List referencedProjects) throws UnexpectedBehaviourException, InterruptedException {
        this.myDestProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        Path srcPath = new Path(String.valueOf('/') + this.myDestProject.getName() + "/src");
        int style = Generator.EMF_PLUGIN_PROJECT_STYLE;
        List pluginVariables = null;
        IProgressMonitor pm = this.getNextStepMonitor();
        Generator.createEMFProject((IPath)srcPath, (IPath)projectLocation, (List)referencedProjects, (IProgressMonitor)pm, (int)style, pluginVariables);
        try {
            this.myDestRoot = JavaCore.create((IProject)this.myDestProject).findPackageFragmentRoot((IPath)srcPath);
        }
        catch (JavaModelException ex) {
            throw new UnexpectedBehaviourException(ex.getMessage());
        }
        if (this.myDestRoot == null) {
            throw new UnexpectedBehaviourException("no source root can be found");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doGenerateFile(TextEmitter emitter, IPath filePath, Object[] param) throws InterruptedException {
        if (!$assertionsDisabled && this.myDestProject.getName().equals(filePath.segment(0))) {
            throw new AssertionError();
        }
        IProgressMonitor pm = this.getNextStepMonitor();
        try {
            try {
                String charset;
                this.myProgress.subTask(filePath.lastSegment());
                pm.beginTask(null, 4);
                IPath containerPath = this.myDestProject.getFullPath().append(filePath.removeLastSegments(1));
                CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)containerPath, (boolean)false, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                String genText = emitter.generate((IProgressMonitor)new SubProgressMonitor(pm, 1), param);
                IFile f = this.myDestProject.getFile(filePath);
                boolean propertyFile = "properties".equals(filePath.getFileExtension());
                String string = charset = propertyFile ? "ISO-8859-1" : "UTF-8";
                if (propertyFile) {
                    genText = GeneratorBase.escapeUnicode(genText);
                }
                if (f.exists()) {
                    if (!this.contains(f, new ByteArrayInputStream(genText.getBytes(charset)))) {
                        f.setContents((InputStream)new ByteArrayInputStream(genText.getBytes(charset)), true, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    } else {
                        pm.worked(1);
                    }
                } else {
                    f.create((InputStream)new ByteArrayInputStream(genText.getBytes(charset)), true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                f.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (InvocationTargetException ex) {
                this.handleException(ex.getCause());
            }
            catch (UnexpectedBehaviourException ex) {
                this.handleUnexpected(ex);
            }
            catch (CoreException ex) {
                this.handleException(ex);
            }
            catch (UnsupportedEncodingException ex) {
                this.handleException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        pm.done();
    }

    private static String escapeUnicode(String text) {
        StringBuffer result = new StringBuffer(text.length());
        int i = 0;
        int size = text.length();
        while (i < size) {
            char character = text.charAt(i);
            if (character > '\u00ff') {
                result.append("\\u");
                String hex = Integer.toString(character, 16);
                int j = hex.length();
                while (j < 4) {
                    result.append("0");
                    ++j;
                }
                result.append(hex);
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    protected final IPath guessNewProjectLocation(Path examplaryProjectPath, String newProjectName) {
        URI locationURI;
        block12: {
            block11: {
                IProject p;
                block10: {
                    block9: {
                        block8: {
                            if (!$assertionsDisabled && newProjectName == null) {
                                throw new AssertionError();
                            }
                            try {
                                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName).exists()) break block8;
                                return null;
                            }
                            catch (CoreException ex) {
                                this.handleException(GeneratorBase.newStatus(2, ex));
                                return null;
                            }
                        }
                        if (examplaryProjectPath != null && examplaryProjectPath.isAbsolute()) break block9;
                        return null;
                    }
                    p = ResourcesPlugin.getWorkspace().getRoot().getProject(examplaryProjectPath.segment(0));
                    if (p.exists()) break block10;
                    return null;
                }
                locationURI = p.getDescription().getLocationURI();
                if (locationURI != null) break block11;
                return null;
            }
            if (locationURI.getScheme() == null || "file".equals(locationURI.getScheme())) break block12;
            return null;
        }
        return new Path(locationURI.getSchemeSpecificPart()).removeLastSegments(1).append(newProjectName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean contains(IFile f, InputStream is) {
        int ic;
        int fc;
        block10: {
            fc = 0;
            ic = 0;
            InputStream fs = null;
            try {
                try {
                    fs = f.getContents(true);
                    while ((fc = fs.read()) == (ic = is.read()) && fc >= 0) {
                    }
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (fs == null) throw throwable;
                try {
                    fs.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (fs == null) break block10;
            }
            try {}
            catch (IOException iOException) {}
            fs.close();
        }
        if (fc >= 0) return false;
        if (ic >= 0) return false;
        return true;
    }

    protected final void doGenerateJavaClass(TextEmitter emitter, String qualifiedClassName, Object[] input) throws InterruptedException {
        this.doGenerateJavaClass(emitter, CodeGenUtil.getPackageName((String)qualifiedClassName), CodeGenUtil.getSimpleClassName((String)qualifiedClassName), input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doGenerateJavaClass(TextEmitter emitter, String packageName, String className, Object[] input) throws InterruptedException {
        IProgressMonitor pm = this.getNextStepMonitor();
        try {
            block9: {
                try {
                    this.myProgress.subTask(className);
                    pm.beginTask(null, 4);
                    String genText = emitter.generate((IProgressMonitor)new SubProgressMonitor(pm, 1), input);
                    IPackageFragment pf = this.myDestRoot.createPackageFragment(packageName, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    ICompilationUnit cu = pf.getCompilationUnit(String.valueOf(className) + ".java");
                    genText = this.mergeJavaCode(genText, cu, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    genText = this.formatCode(genText);
                    if (!cu.exists() || !genText.equals(cu.getSource())) {
                        pf.createCompilationUnit(cu.getElementName(), genText, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        break block9;
                    }
                    pm.worked(1);
                }
                catch (NullPointerException ex) {
                    this.handleException(ex);
                }
                catch (InvocationTargetException ex) {
                    this.handleException(ex.getCause());
                }
                catch (UnexpectedBehaviourException ex) {
                    this.handleUnexpected(ex);
                }
                catch (CoreException ex) {
                    this.handleException(ex);
                }
            }
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doGenerateBinaryFile(BinaryEmitter emitter, Path outputPath, Object[] params) throws InterruptedException, UnexpectedBehaviourException {
        IProgressMonitor pm = this.getNextStepMonitor();
        this.myProgress.subTask(outputPath.lastSegment());
        IFile f = this.getDestProject().getFile((IPath)outputPath);
        if (f.exists()) {
            return;
        }
        try {
            try {
                pm.beginTask(null, 4);
                IPath containerPath = this.getDestProject().getFullPath().append(outputPath.removeLastSegments(1));
                CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)containerPath, (boolean)false, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                byte[] contents = emitter.generate((IProgressMonitor)new SubProgressMonitor(pm, 1), params);
                f.create((InputStream)new ByteArrayInputStream(contents), true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                f.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (InvocationTargetException ex) {
                this.handleException(ex.getCause());
            }
            catch (CoreException ex) {
                this.handleException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        pm.done();
    }

    protected final String mergeJavaCode(String generatedText, ICompilationUnit oldCU, IProgressMonitor pm) throws JavaModelException {
        block3: {
            String string;
            pm.beginTask(GeneratorBaseMessages.merge, 1);
            try {
                if (oldCU == null || !oldCU.exists() || this.getJControlModel() == null) break block3;
                JMerger jMerge = new JMerger(this.getJControlModel());
                jMerge.setSourceCompilationUnit(jMerge.createCompilationUnitForContents(generatedText));
                jMerge.setTargetCompilationUnit(jMerge.createCompilationUnitForContents(oldCU.getSource()));
                jMerge.merge();
                string = jMerge.getTargetCompilationUnitContents();
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return string;
        }
        String string = generatedText;
        Object var5_8 = null;
        pm.done();
        return string;
    }

    protected final String formatCode(String text) {
        Document doc = new Document(text);
        TextEdit edit = this.getCodeFormatter().format(8, doc.get(), 0, doc.get().length(), 0, null);
        try {
            if (edit != null) {
                edit.apply((IDocument)doc);
                text = doc.get();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return text;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRun() throws InterruptedException {
        try {
            try {
                this.setupProgressMonitor();
                this.customRun();
                this.myRunStatus = this.getExceptionsStatus();
            }
            catch (NullPointerException ex) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("java.lang.NullPointerException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$1 = clazz2;
                }
                this.myRunStatus = new Status(4, "org.eclipse.gmf.common", 0, clazz.getName(), (Throwable)ex);
            }
            catch (UnexpectedBehaviourException ex) {
                this.myRunStatus = new Status(4, "org.eclipse.gmf.common", 0, GeneratorBaseMessages.unexpected, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.getProgress().done();
            this.clearExceptionsList();
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        this.getProgress().done();
        this.clearExceptionsList();
    }

    private JControlModel getJControlModel() {
        URL controlFile;
        if (this.myJControlModel == null && (controlFile = this.getJMergeControlFile()) != null) {
            this.myJControlModel = new JControlModel();
            this.myJControlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
            if (!this.myJControlModel.canMerge()) {
                throw new IllegalStateException("Can not initialize JControlModel");
            }
        }
        return this.myJControlModel;
    }

    private CodeFormatter getCodeFormatter() {
        if (this.myCodeFormatter == null) {
            this.myCodeFormatter = ToolFactory.createCodeFormatter(null);
        }
        return this.myCodeFormatter;
    }

    private final void clearExceptionsList() {
        this.myExceptions.clear();
    }

    private final IStatus getExceptionsStatus() {
        if (this.myExceptions == null || this.myExceptions.isEmpty()) {
            return Status.OK_STATUS;
        }
        IStatus[] s = this.myExceptions.toArray(new IStatus[this.myExceptions.size()]);
        return new MultiStatus("org.eclipse.gmf.common", 0, s, GeneratorBaseMessages.problems, null);
    }
}

