/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import junit.framework.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RTSetup;
import org.eclipse.gmf.tests.setup.RTSource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public abstract class GeneratedCanvasTest
extends ConfiguredTestCase {
    private GeneratorConfiguration.ViewerConfiguration myViewerConfiguration;
    private Composite myParentShell;
    private Bundle myGenProject;
    private RTSource myRTSource;

    public GeneratedCanvasTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myGenProject = this.getSetup().getGenProject().getBundle();
        this.myRTSource = this.createCanvasInstance();
        this.myViewerConfiguration = this.createViewerConfiguration(this.myRTSource.getCanvas());
    }

    protected final RTSource getCanvasInstance() {
        return this.myRTSource;
    }

    protected RTSource createCanvasInstance() throws Exception {
        return new RTSetup().init(this.getSetup().getGenProject().getBundle(), this.getSetup().getGenModel());
    }

    protected final EditPart getDiagramEditPart() {
        return this.myViewerConfiguration.getViewer().getContents();
    }

    public GeneratorConfiguration.ViewerConfiguration getViewerConfiguration() {
        return this.myViewerConfiguration;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node createNode(GenCommonBase nodeType, View notationContainer) {
        final Object[] newObjHolder = new Object[1];
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (msg.getEventType() == 3) {
                    newObjHolder[0] = msg.getNewValue();
                }
            }

            public boolean isAdapterForType(Object type) {
                return true;
            }
        };
        Command cmd = this.getViewerConfiguration().getCreateNodeCommand(notationContainer, nodeType);
        Assert.assertNotNull((String)"No command is available for request", (Object)cmd);
        notationContainer.eAdapters().add((Object)adapter);
        try {
            try {
                this.execute(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Node creation failure: " + e.getLocalizedMessage()));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            notationContainer.eAdapters().remove((Object)adapter);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        notationContainer.eAdapters().remove((Object)adapter);
        GeneratedCanvasTest.assertTrue((String)"Faile to create notation model Node", (boolean)(newObjHolder[0] instanceof Node));
        return (Node)newObjHolder[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Edge createLink(GenLink linkType, View source, View target) {
        Diagram diagram;
        AdapterImpl adapter;
        Object[] newObjHolder;
        block7: {
            block6: {
                newObjHolder = new Object[1];
                adapter = new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        super.notifyChanged(msg);
                        if (msg.getEventType() == 3 && msg.getNewValue() instanceof Edge) {
                            newObjHolder[0] = msg.getNewValue();
                        }
                    }

                    public boolean isAdapterForType(Object type) {
                        return true;
                    }
                };
                diagram = this.getDiagram();
                diagram.eAdapters().add((Object)adapter);
                try {
                    try {
                        Command targetCmd;
                        block9: {
                            block8: {
                                targetCmd = this.getViewerConfiguration().getCreateLinkCommand(source, target, (GenCommonBase)linkType);
                                if (targetCmd == null) break block8;
                                if (targetCmd.canExecute()) break block9;
                            }
                            Object var8_9 = null;
                            break block6;
                        }
                        this.execute(targetCmd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)("Edge creation failure: " + e.getLocalizedMessage()));
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    diagram.eAdapters().remove((Object)adapter);
                    throw throwable;
                }
            }
            diagram.eAdapters().remove((Object)adapter);
            return null;
        }
        Object var8_11 = null;
        diagram.eAdapters().remove((Object)adapter);
        GeneratedCanvasTest.assertTrue((String)"Faile to create notation model Edge", (boolean)(newObjHolder[0] instanceof Edge));
        return (Edge)newObjHolder[0];
    }

    protected Diagram getDiagram() {
        return (Diagram)this.getDiagramEditPart().getModel();
    }

    protected void tearDown() throws Exception {
        if (this.myParentShell != null) {
            this.myParentShell.dispose();
            this.myParentShell = null;
            this.myViewerConfiguration.dispose();
        }
        super.tearDown();
    }

    protected final EditPart findEditPart(View notationElement) {
        return this.myViewerConfiguration.findEditPart(notationElement);
    }

    protected final Class loadGeneratedClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.myGenProject.loadClass(qualifiedClassName);
    }

    protected final void execute(Command cmd) {
        this.getCommandStack().execute(cmd);
    }

    protected final CommandStack getCommandStack() {
        return this.myViewerConfiguration.getViewer().getEditDomain().getCommandStack();
    }

    protected GeneratorConfiguration.ViewerConfiguration createViewerConfiguration(Diagram canvas) throws Exception {
        this.myParentShell = new Shell(0);
        return this.getSetup().getGeneratorConfiguration().createViewerConfiguration(this.myParentShell, this.getSetup(), canvas);
    }
}

