/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xtend;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.util.ClassLoadContext;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;
import org.eclipse.gmf.tests.expression.ast.ATypeModel;
import org.eclipse.gmf.tests.xtend.AbstractXtendTest;
import org.eclipse.gmf.tests.xtend.Helper;

public class ExtensionAnalyzationTest
extends AbstractXtendTest {
    private Set<AnalysationIssue> issues;
    private ExecutionContextImpl ec;

    protected void setUp() throws Exception {
        this.ec = new ExecutionContextImpl(null, new EPackage[0]);
        this.ec.setContextClassLoader((ClassLoadContext)new ClassLoadContext.Naive(new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()}));
        this.issues = new HashSet<AnalysationIssue>();
    }

    private void dumpIssues() {
        for (AnalysationIssue element : this.issues) {
            System.out.println(String.valueOf(element.getType().toString()) + " - " + element.getMessage());
        }
    }

    public void testNonStaticJavaExtension() {
        ExtensionFile file = this.parse("String nonStaticHelper(String str) :JAVA " + Helper.class.getName() + ".nonStaticHelper(java.lang.String) ; \n");
        file.analyze((ExecutionContext)this.ec, this.issues);
        this.dumpIssues();
        ExtensionAnalyzationTest.assertEquals((int)1, (int)this.issues.size());
        ExtensionAnalyzationTest.assertEquals((Object)AnalysationIssue.Type.FEATURE_NOT_FOUND, (Object)this.issues.iterator().next().getType());
    }

    public void testNonStaticJavaExtensionWithSlot() {
        ExtensionFile file = this.parse("String nonStaticHelperWithSlot(String str) :JAVA [instanceSlot]" + Helper.class.getName() + ".nonStaticHelper(java.lang.String) ; \n");
        file.analyze((ExecutionContext)this.ec, this.issues);
        this.dumpIssues();
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
    }

    public void testStaticJavaExtension() {
        ExtensionFile file = this.parse("String toUpperCase(String str) : JAVA " + Helper.class.getName() + ".toUpperCase(java.lang.String) ; \n");
        file.analyze((ExecutionContext)this.ec, this.issues);
        this.dumpIssues();
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
    }

    public void testNonExistentJavaMethod() {
        ExtensionFile file = this.parse("String nonExistentMethod(String str) :JAVA " + Helper.class.getName() + ".nonExistentMethod(java.lang.String) ; \n");
        file.analyze((ExecutionContext)this.ec, this.issues);
        this.dumpIssues();
        ExtensionAnalyzationTest.assertEquals((int)1, (int)this.issues.size());
        ExtensionAnalyzationTest.assertEquals((Object)AnalysationIssue.Type.FEATURE_NOT_FOUND, (Object)this.issues.iterator().next().getType());
    }

    public final void testExpressionExtension() {
        ExtensionFile file = this.parse("String plainExtension() : 'zzz' ;\n/* \n * Meine Funktion \n */ \nmyExtension(Object val) : {val}; \n");
        file.analyze((ExecutionContext)this.ec, this.issues);
        this.dumpIssues();
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        ExpressionExtensionStatement ext = (ExpressionExtensionStatement)file.getExtensions().get(1);
        ExtensionAnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()), (Object)ext.getReturnType(new EClassifier[]{EcorePackage.eINSTANCE.getEBoolean()}, (ExecutionContext)this.ec, new HashSet()));
        ExtensionAnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEString()), (Object)ext.getReturnType(new EClassifier[]{EcorePackage.eINSTANCE.getEString()}, (ExecutionContext)this.ec, new HashSet()));
        ExtensionAnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject()), (Object)ext.getReturnType(new EClassifier[]{EcorePackage.eINSTANCE.getEJavaObject()}, (ExecutionContext)this.ec, new HashSet()));
    }

    public final void testRecursionWithoutType() {
        ExtensionFile file = this.parse("recExtension(Integer i) : i==0 ? {i} : recExtension(i-1).add(i) ; \n");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        ExpressionExtensionStatement ext = (ExpressionExtensionStatement)file.getExtensions().get(0);
        EClassifier result = ext.getReturnType(new EClassifier[]{EcorePackage.eINSTANCE.getEInt()}, (ExecutionContext)this.ec, new HashSet());
        ExtensionAnalyzationTest.assertNull((Object)result);
    }

    public final void testRecursionWithType() {
        ExtensionFile file = this.parse("List[Integer] recExtension(Integer i) : i==0 ? {i} : recExtension(i-1).add(i) ; \n");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        ExpressionExtensionStatement ext = (ExpressionExtensionStatement)file.getExtensions().get(0);
        EClassifier result = ext.getReturnType(new EClassifier[]{EcorePackage.eINSTANCE.getEInt()}, (ExecutionContext)this.ec, new HashSet());
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        ExtensionAnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEInt()), (Object)result);
    }

    public final void testMemberPosition() {
        ExtensionFile file = this.parse("ext1(String txt) : 'test'+txt ;ext2(String txt) : txt.ext1() ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Extension ext = this.ec.getExtension("ext2", new EClassifier[]{EcorePackage.eINSTANCE.getEString()});
        EClassifier evalResult = ext.getReturnType(new EClassifier[]{EcorePackage.eINSTANCE.getEString()}, (ExecutionContext)this.ec, new HashSet());
        ExtensionAnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)evalResult);
    }

    public final void testDuplicateParameterNames1() {
        ExtensionFile file = this.parse("ext1(String txt, String txt) : 'test'+txt ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        file.analyze((ExecutionContext)this.ec, this.issues);
        ExtensionAnalyzationTest.assertEquals((int)1, (int)this.issues.size());
    }

    public final void testDuplicateParameterNames2() {
        ExtensionFile file = this.parse("ext1(String txt, String txt2) : 'test'+txt ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        file.analyze((ExecutionContext)this.ec, this.issues);
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
    }

    public final void testThisParameterName() {
        ExtensionFile file = this.parse("ext1(String this, String txt2) : 'test'+length() ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        file.analyze((ExecutionContext)this.ec, this.issues);
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
    }

    public final void testCreateExtension() {
        ExtensionFile file = this.parse("create List[String] l test(String s) : l.add(s) ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        file.analyze((ExecutionContext)this.ec, this.issues);
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        Extension ext = (Extension)file.getExtensions().get(0);
        ExtensionAnalyzationTest.assertEquals((String)"List", (String)ext.getReturnType(null, (ExecutionContext)this.ec, null).eClass().getName());
    }

    public final void testCreateExtension1() {
        ExtensionFile file = this.parse("create List[String] test(String s) : add(s) ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        file.analyze((ExecutionContext)this.ec, this.issues);
        ExtensionAnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        Extension ext = (Extension)file.getExtensions().get(0);
        ExtensionAnalyzationTest.assertEquals((String)"List", (String)ext.getReturnType(null, (ExecutionContext)this.ec, null).eClass().getName());
    }

    public final void testAmbigous() {
        ATypeModel aType = new ATypeModel();
        ExtensionFile file = this.parse("import '" + aType.getMetaType().getEPackage().getName() + "';" + "doStuff(" + aType.getMetaType().getName() + " this) : true; " + "doStuff(" + aType.getMetaTypeC().getName() + " this) : false;" + "bla(" + aType.getMetaTypeB().getName() + " this) : this.doStuff();");
        ExecutionContext ctx = aType.newContext((ResourceMarker)file);
        for (Extension x : file.getExtensions()) {
            x.analyze(ctx, this.issues);
        }
        System.out.println(this.issues);
        ExtensionAnalyzationTest.assertEquals((int)1, (int)this.issues.size());
    }
}

