/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.parts;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.parts.GraphicalNodeEditPolicyTests;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.PresentationTestFixture;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;

public class GraphicalNodeEditPolicyTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.parts.GraphicalNodeEditPolicyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite s = new TestSuite((Class)clazz);
        return s;
    }

    public GraphicalNodeEditPolicyTests() {
        super("GraphicalNodeEditPolicy Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new PresentationTestFixture();
    }

    protected PresentationTestFixture getFixture() {
        return (PresentationTestFixture)this.testFixture;
    }

    public void testCustomPrompt() throws Exception {
        NoteEditPart sourceEP = this.getFixture().createNote();
        NoteEditPart targetEP = this.getFixture().createNote();
        sourceEP.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new NoteGraphicalNodeEditPolicy());
        targetEP.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new NoteGraphicalNodeEditPolicy());
        ConnectionHandle handle = new ConnectionHandle((IGraphicalEditPart)sourceEP, ConnectionHandle.HandleDirection.OUTGOING, "the tooltip");
        ConnectionHandleTool tool = new ConnectionHandleTool(handle);
        CreateConnectionRequest request = (CreateConnectionRequest)tool.createTargetRequest();
        request.setTargetEditPart((EditPart)sourceEP);
        request.setType((Object)"connection start");
        sourceEP.getCommand((Request)request);
        request.setSourceEditPart((EditPart)sourceEP);
        request.setTargetEditPart((EditPart)targetEP);
        request.setType((Object)"connection end");
        targetEP.getCommand((Request)request).execute();
        GraphicalNodeEditPolicyTests.assertEquals((int)1, (int)this.getDiagramEditPart().getConnections().size());
        NoteAttachmentEditPart noteAttachmentEP = (NoteAttachmentEditPart)this.getDiagramEditPart().getConnections().get(0);
        GraphicalNodeEditPolicyTests.assertEquals((Object)sourceEP, (Object)noteAttachmentEP.getSource());
        GraphicalNodeEditPolicyTests.assertEquals((Object)targetEP, (Object)noteAttachmentEP.getTarget());
        GraphicalNodeEditPolicyTests.assertTrue((boolean)FigureUtilities.integerToColor((Integer)((Integer)ViewUtil.getStructuralFeatureValue((View)noteAttachmentEP.getNotationView(), (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor()))).equals((Object)NoteGraphicalNodeEditPolicy.USER_CHOICE.color));
        noteAttachmentEP.getCommand((Request)new GroupRequest((Object)"delete")).execute();
        GraphicalNodeEditPolicyTests.assertEquals((int)0, (int)this.getDiagramEditPart().getConnections().size());
        handle = new ConnectionHandle((IGraphicalEditPart)targetEP, ConnectionHandle.HandleDirection.INCOMING, "the tooltip");
        tool = new ConnectionHandleTool(handle);
        request = (CreateConnectionRequest)tool.createTargetRequest();
        request.setTargetEditPart((EditPart)targetEP);
        request.setType((Object)"connection start");
        targetEP.getCommand((Request)request);
        request.setSourceEditPart((EditPart)targetEP);
        request.setTargetEditPart((EditPart)sourceEP);
        request.setType((Object)"connection end");
        sourceEP.getCommand((Request)request).execute();
        GraphicalNodeEditPolicyTests.assertEquals((int)1, (int)this.getDiagramEditPart().getConnections().size());
        noteAttachmentEP = (NoteAttachmentEditPart)this.getDiagramEditPart().getConnections().get(0);
        GraphicalNodeEditPolicyTests.assertEquals((Object)sourceEP, (Object)noteAttachmentEP.getSource());
        GraphicalNodeEditPolicyTests.assertEquals((Object)targetEP, (Object)noteAttachmentEP.getTarget());
        GraphicalNodeEditPolicyTests.assertTrue((boolean)FigureUtilities.integerToColor((Integer)((Integer)ViewUtil.getStructuralFeatureValue((View)noteAttachmentEP.getNotationView(), (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor()))).equals((Object)NoteGraphicalNodeEditPolicy.USER_CHOICE.color));
    }

    static class NoteGraphicalNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        static NoteAttachmentDescriptor USER_CHOICE = new NoteAttachmentDescriptor(ColorConstants.red);

        NoteGraphicalNodeEditPolicy() {
        }

        protected List getConnectionMenuContent(CreateConnectionRequest request) {
            List content = super.getConnectionMenuContent(request);
            if (content.contains(DiagramNotationType.NOTE_ATTACHMENT)) {
                content.add(new NoteAttachmentDescriptor(ColorConstants.blue));
                content.add(USER_CHOICE);
                content.add(new NoteAttachmentDescriptor(ColorConstants.yellow));
            }
            return content;
        }

        protected Command getConnectionCompleteCommand(Object connectionType, CreateConnectionRequest request) {
            if (connectionType instanceof NoteAttachmentDescriptor) {
                CompoundCommand cc = new CompoundCommand("Create Note Attachment");
                cc.add(super.getConnectionCompleteCommand((Object)DiagramNotationType.NOTE_ATTACHMENT, request));
                if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                    cc.add((Command)new ICommandProxy((ICommand)new SetPropertyCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), (IAdaptable)((CreateConnectionViewRequest)((CreateUnspecifiedTypeConnectionRequest)request).getRequestForType((IElementType)DiagramNotationType.NOTE_ATTACHMENT)).getConnectionViewDescriptor(), Properties.ID_LINECOLOR, Properties.ID_LINECOLOR, (Object)FigureUtilities.colorToInteger((Color)((NoteAttachmentDescriptor)connectionType).color))));
                }
                return cc.unwrap();
            }
            return super.getConnectionCompleteCommand(connectionType, request);
        }

        protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
            class TestablePromptAndCreateConnectionCommand
            extends GraphicalNodeEditPolicy.PromptAndCreateConnectionCommand {
                final /* synthetic */ NoteGraphicalNodeEditPolicy this$1;

                TestablePromptAndCreateConnectionCommand(NoteGraphicalNodeEditPolicy noteGraphicalNodeEditPolicy, List theContent, CreateConnectionRequest theRequest) {
                    this.this$1 = noteGraphicalNodeEditPolicy;
                    super((GraphicalNodeEditPolicy)noteGraphicalNodeEditPolicy, theContent, theRequest);
                    this.setPopupMenu(new TestablePromptAndCreateConnectionCommand.TestablePopupMenu(this, theContent, this.getLabelProvider()));
                }

                protected ILabelProvider getLabelProvider() {
                    return new CreateOrSelectElementCommand.LabelProvider(this){
                        final /* synthetic */ TestablePromptAndCreateConnectionCommand this$2;
                        {
                            this.this$2 = testablePromptAndCreateConnectionCommand;
                        }

                        public String getText(Object object) {
                            if (object instanceof NoteAttachmentDescriptor) {
                                return "Create a note attachment colored " + ((NoteAttachmentDescriptor)object).color;
                            }
                            return super.getText(object);
                        }
                    };
                }
            }
            return new TestablePromptAndCreateConnectionCommand(this, content, request);
        }

        static class NoteAttachmentDescriptor {
            Color color;

            NoteAttachmentDescriptor(Color color) {
                this.color = color;
            }
        }
    }

    class ConnectionHandleTool
    extends org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool {
        public ConnectionHandleTool(ConnectionHandle connectorHandle) {
            super(connectorHandle);
        }

        public Request createTargetRequest() {
            return super.createTargetRequest();
        }

        protected PreferencesHint getPreferencesHint() {
            return PreferencesHint.USE_DEFAULTS;
        }
    }
}

